(function($) {
  Drupal.behaviors.chosen = {
    attach: function(context, settings) {
      settings.chosen = settings.chosen || Drupal.settings.chosen;
      var minWidth = settings.chosen.minimum_width;
      var minOptionsSingle = settings.chosen.minimum_single;
      var minOptionsMultiple = settings.chosen.minimum_multiple;
      var minOptions;
      // Define options.
      var multiple = Drupal.settings.chosen.multiple;
      var maxSelectedOptions = Drupal.settings.chosen.max_selected_options;
      var options = {};

      // Prepare selector and add unwantend selectors.
      var selector = settings.chosen.selector;
      selector = selector + ', .tabledrag-hide select'

      $(selector, context)
        .not('#field-ui-field-overview-form select, #field-ui-display-overview-form select') //disable chosen on field ui
        .each(function() {
          var name = $(this).attr('name');
          options = {};
          options.disable_search = Drupal.settings.chosen.disable_search;
          options.disable_search_threshold = settings.chosen.disable_search_threshold;
          options.search_contains = settings.chosen.search_contains;
          options.placeholder_text_multiple = settings.chosen.placeholder_text_multiple;
          options.placeholder_text_single = settings.chosen.placeholder_text_single;
          options.no_results_text = settings.chosen.no_results_text;
          options.inherit_select_classes = true;

          minOptions = minOptionsSingle;
          if (multiple[name] !== false) {
            minOptions = minOptionsMultiple;
          }

          if (maxSelectedOptions[name] !== false) {
           options.max_selected_options = maxSelectedOptions[name];
          }

          if ($(this).find('option').size() >= minOptions || minOptions == 'Always Apply') {
            options = $.extend(options, {
              width: (($(this).width() < minWidth) ? minWidth : $(this).width()) + 'px'
            });
            $(this).chosen(options);
          }
      });

      // Enable chosen for widgets.
      $('select.chosen-widget', context).each(function() {
        options = $.extend(options, {
          width: (($(this).width() < minWidth) ? minWidth : $(this).width()) + 'px'
        });
        $(this).chosen(options);
      });
    }
  };
})(jQuery);
