-- phpMyAdmin SQL Dump
-- version 4.0.4
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Dec 15, 2013 at 06:24 AM
-- Server version: 5.6.12-log
-- PHP Version: 5.4.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `zircon`
--
CREATE DATABASE IF NOT EXISTS `zircon` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;
USE `zircon`;

-- --------------------------------------------------------

--
-- Table structure for table `accesslog`
--

CREATE TABLE IF NOT EXISTS `accesslog` (
  `aid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique accesslog ID.',
  `sid` varchar(128) NOT NULL DEFAULT '' COMMENT 'Browser session ID of user that visited page.',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title of page visited.',
  `path` varchar(255) DEFAULT NULL COMMENT 'Internal path to page visited (relative to Drupal root.)',
  `url` text COMMENT 'Referrer URI.',
  `hostname` varchar(128) DEFAULT NULL COMMENT 'Hostname of user that visited the page.',
  `uid` int(10) unsigned DEFAULT '0' COMMENT 'User users.uid that visited the page.',
  `timer` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Time in milliseconds that the page took to load.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Timestamp of when the page was visited.',
  PRIMARY KEY (`aid`),
  KEY `accesslog_timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores site access information for statistics.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `actions`
--

CREATE TABLE IF NOT EXISTS `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';

--
-- Dumping data for table `actions`
--

INSERT INTO `actions` (`aid`, `type`, `callback`, `parameters`, `label`) VALUES
('comment_publish_action', 'comment', 'comment_publish_action', '', 'Publish comment'),
('comment_save_action', 'comment', 'comment_save_action', '', 'Save comment'),
('comment_unpublish_action', 'comment', 'comment_unpublish_action', '', 'Unpublish comment'),
('node_make_sticky_action', 'node', 'node_make_sticky_action', '', 'Make content sticky'),
('node_make_unsticky_action', 'node', 'node_make_unsticky_action', '', 'Make content unsticky'),
('node_promote_action', 'node', 'node_promote_action', '', 'Promote content to front page'),
('node_publish_action', 'node', 'node_publish_action', '', 'Publish content'),
('node_save_action', 'node', 'node_save_action', '', 'Save content'),
('node_unpromote_action', 'node', 'node_unpromote_action', '', 'Remove content from front page'),
('node_unpublish_action', 'node', 'node_unpublish_action', '', 'Unpublish content'),
('pathauto_node_update_action', 'node', 'pathauto_node_update_action', '', 'Update node alias'),
('pathauto_taxonomy_term_update_action', 'taxonomy_term', 'pathauto_taxonomy_term_update_action', '', 'Update taxonomy term alias'),
('pathauto_user_update_action', 'user', 'pathauto_user_update_action', '', 'Update user alias'),
('system_block_ip_action', 'user', 'system_block_ip_action', '', 'Ban IP address of current user'),
('user_block_user_action', 'user', 'user_block_user_action', '', 'Block current user');

-- --------------------------------------------------------

--
-- Table structure for table `aggregator_category`
--

CREATE TABLE IF NOT EXISTS `aggregator_category` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique aggregator category ID.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Title of the category.',
  `description` longtext NOT NULL COMMENT 'Description of the category',
  `block` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The number of recent items to show within the category block.',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores categories for aggregator feeds and feed items.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `aggregator_category_feed`
--

CREATE TABLE IF NOT EXISTS `aggregator_category_feed` (
  `fid` int(11) NOT NULL DEFAULT '0' COMMENT 'The feed’s aggregator_feed.fid.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The aggregator_category.cid to which the feed is being assigned.',
  PRIMARY KEY (`cid`,`fid`),
  KEY `fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Bridge table; maps feeds to categories.';

-- --------------------------------------------------------

--
-- Table structure for table `aggregator_category_item`
--

CREATE TABLE IF NOT EXISTS `aggregator_category_item` (
  `iid` int(11) NOT NULL DEFAULT '0' COMMENT 'The feed item’s aggregator_item.iid.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The aggregator_category.cid to which the feed item is being assigned.',
  PRIMARY KEY (`cid`,`iid`),
  KEY `iid` (`iid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Bridge table; maps feed items to categories.';

-- --------------------------------------------------------

--
-- Table structure for table `aggregator_feed`
--

CREATE TABLE IF NOT EXISTS `aggregator_feed` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique feed ID.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Title of the feed.',
  `url` text NOT NULL COMMENT 'URL to the feed.',
  `refresh` int(11) NOT NULL DEFAULT '0' COMMENT 'How often to check for new feed items, in seconds.',
  `checked` int(11) NOT NULL DEFAULT '0' COMMENT 'Last time feed was checked for new items, as Unix timestamp.',
  `queued` int(11) NOT NULL DEFAULT '0' COMMENT 'Time when this feed was queued for refresh, 0 if not queued.',
  `link` text NOT NULL COMMENT 'The parent website of the feed; comes from the <link> element in the feed.',
  `description` longtext NOT NULL COMMENT 'The parent website’s description; comes from the <description> element in the feed.',
  `image` longtext NOT NULL COMMENT 'An image representing the feed.',
  `hash` varchar(64) NOT NULL DEFAULT '' COMMENT 'Calculated hash of the feed data, used for validating cache.',
  `etag` varchar(255) NOT NULL DEFAULT '' COMMENT 'Entity tag HTTP response header, used for validating cache.',
  `modified` int(11) NOT NULL DEFAULT '0' COMMENT 'When the feed was last modified, as a Unix timestamp.',
  `block` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Number of items to display in the feed’s block.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `title` (`title`),
  KEY `queued` (`queued`),
  KEY `url` (`url`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores feeds to be parsed by the aggregator.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `aggregator_item`
--

CREATE TABLE IF NOT EXISTS `aggregator_item` (
  `iid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique ID for feed item.',
  `fid` int(11) NOT NULL DEFAULT '0' COMMENT 'The aggregator_feed.fid to which this item belongs.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Title of the feed item.',
  `link` text NOT NULL COMMENT 'Link to the feed item.',
  `author` varchar(255) NOT NULL DEFAULT '' COMMENT 'Author of the feed item.',
  `description` longtext NOT NULL COMMENT 'Body of the feed item.',
  `timestamp` int(11) DEFAULT NULL COMMENT 'Posted date of the feed item, as a Unix timestamp.',
  `guid` text NOT NULL COMMENT 'Unique identifier for the feed item.',
  PRIMARY KEY (`iid`),
  KEY `fid` (`fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the individual items imported from feeds.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `authmap`
--

CREATE TABLE IF NOT EXISTS `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `batch`
--

CREATE TABLE IF NOT EXISTS `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';

-- --------------------------------------------------------

--
-- Table structure for table `block`
--

CREATE TABLE IF NOT EXISTS `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...' AUTO_INCREMENT=233 ;

--
-- Dumping data for table `block`
--

INSERT INTO `block` (`bid`, `module`, `delta`, `theme`, `status`, `weight`, `region`, `custom`, `visibility`, `pages`, `title`, `cache`) VALUES
(1, 'system', 'main', 'bartik', 1, 0, 'content', 0, 0, '', '', -1),
(2, 'search', 'form', 'bartik', 1, -1, 'sidebar_first', 0, 0, '', '', -1),
(3, 'node', 'recent', 'seven', 1, 10, 'dashboard_main', 0, 0, '', '', -1),
(4, 'user', 'login', 'bartik', 1, 0, 'sidebar_first', 0, 1, '<front>', '', -1),
(5, 'system', 'navigation', 'bartik', 1, 0, 'sidebar_first', 0, 0, 'categories', '', -1),
(6, 'system', 'powered-by', 'bartik', 1, 10, 'footer', 0, 0, '', '', -1),
(7, 'system', 'help', 'bartik', 1, 0, 'help', 0, 0, '', '', -1),
(8, 'system', 'main', 'seven', 1, 0, 'content', 0, 0, '', '', -1),
(9, 'system', 'help', 'seven', 1, 0, 'help', 0, 0, '', '', -1),
(10, 'user', 'login', 'seven', 1, 10, 'content', 0, 1, '<front>', '', -1),
(11, 'user', 'new', 'seven', 1, 0, 'dashboard_sidebar', 0, 0, 'categories\r\nforum', '', -1),
(12, 'search', 'form', 'seven', 1, -10, 'dashboard_sidebar', 0, 0, '', '', -1),
(13, 'comment', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(14, 'node', 'syndicate', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(15, 'node', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(16, 'shortcut', 'shortcuts', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(17, 'system', 'management', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(18, 'system', 'user-menu', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', -1),
(19, 'system', 'main-menu', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nforum', 'Main Menu', -1),
(20, 'user', 'new', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', 1),
(21, 'user', 'online', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', -1),
(22, 'comment', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(23, 'node', 'syndicate', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(24, 'shortcut', 'shortcuts', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(25, 'system', 'powered-by', 'seven', 0, 10, '-1', 0, 0, '', '', -1),
(26, 'system', 'navigation', 'seven', 0, 0, '-1', 0, 0, 'categories', '', -1),
(27, 'system', 'management', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(28, 'system', 'user-menu', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', -1),
(29, 'system', 'main-menu', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nforum', 'Main Menu', -1),
(30, 'user', 'online', 'seven', 1, 0, 'dashboard_inactive', 0, 0, 'categories\r\nforum', '', -1),
(31, 'comment', 'recent', 'tb_simply', 0, -9, '-1', 0, 0, '', '', 1),
(32, 'node', 'recent', 'tb_simply', 1, -8, 'sidebar_first', 0, 0, '', '', 1),
(33, 'node', 'syndicate', 'tb_simply', 0, -4, '-1', 0, 0, '', '', -1),
(34, 'search', 'form', 'tb_simply', 1, -1, 'header', 0, 0, '', '', -1),
(35, 'shortcut', 'shortcuts', 'tb_simply', 0, -8, '-1', 0, 0, '', '', -1),
(36, 'system', 'help', 'tb_simply', 1, 0, 'help', 0, 0, '', '', -1),
(37, 'system', 'main', 'tb_simply', 1, 0, 'content', 0, 0, '', '', -1),
(38, 'system', 'main-menu', 'tb_simply', 1, -13, 'sidebar_first', 0, 0, 'categories\r\nforum', 'Main Menu', -1),
(39, 'system', 'management', 'tb_simply', 0, -12, '-1', 0, 0, '', '', -1),
(40, 'system', 'navigation', 'tb_simply', 1, -12, 'sidebar_first', 0, 0, 'categories', '', -1),
(41, 'system', 'powered-by', 'tb_simply', 0, -13, '-1', 0, 0, '', '', -1),
(42, 'system', 'user-menu', 'tb_simply', 1, -10, 'sidebar_first', 0, 0, 'categories\r\nforum', '', -1),
(43, 'user', 'login', 'tb_simply', 1, -11, 'sidebar_first', 0, 1, '<front>', '', -1),
(44, 'user', 'new', 'tb_simply', 1, -6, 'sidebar_first', 0, 0, 'categories\r\nforum', '', 1),
(45, 'user', 'online', 'tb_simply', 1, -5, 'sidebar_first', 0, 0, 'categories\r\nforum', '', -1),
(46, 'blog', 'recent', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(48, 'poll', 'recent', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', 1),
(49, 'superfish', '1', 'bartik', 0, 0, '-1', 0, 1, 'superfish-menu', '', -1),
(50, 'superfish', '2', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(51, 'superfish', '3', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(52, 'superfish', '4', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(53, 'forum', 'active', 'bartik', 0, 0, '-1', 0, 0, '', '', -2),
(54, 'forum', 'new', 'bartik', 0, 0, '-1', 0, 0, '', '', -2),
(55, 'blog', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', 1),
(57, 'poll', 'recent', 'seven', 1, 0, 'dashboard_inactive', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', 1),
(58, 'superfish', '1', 'seven', 0, 0, '-1', 0, 1, 'superfish-menu', '', -1),
(59, 'superfish', '2', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(60, 'superfish', '3', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(61, 'superfish', '4', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(62, 'forum', 'active', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', -2),
(63, 'forum', 'new', 'seven', 1, 0, 'dashboard_inactive', 0, 0, '', '', -2),
(64, 'blog', 'recent', 'tb_simply', 0, -10, '-1', 0, 0, '', '', 1),
(66, 'poll', 'recent', 'tb_simply', 1, -7, 'sidebar_first', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', 1),
(67, 'superfish', '1', 'tb_simply', 1, 0, 'menu_bar', 0, 1, 'superfish-menu', '', -1),
(68, 'superfish', '2', 'tb_simply', 0, -7, '-1', 0, 0, '', '', -1),
(69, 'superfish', '3', 'tb_simply', 0, -6, '-1', 0, 0, '', '', -1),
(70, 'superfish', '4', 'tb_simply', 0, -5, '-1', 0, 0, '', '', -1),
(71, 'forum', 'active', 'tb_simply', 0, -14, '-1', 0, 0, '', '', -2),
(72, 'forum', 'new', 'tb_simply', 0, -11, '-1', 0, 0, '', '', -2),
(73, 'views', 'Slideshow-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(74, 'quicktabs', 'quicktabs', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '<none>', -1),
(75, 'quicktabs', 'quicktabs', 'tb_simply', 1, -9, 'sidebar_first', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '<none>', 1),
(76, 'views', 'Slideshow-block', 'tb_simply', 1, 0, 'slideshow', 0, 1, '<front>', '<none>', -1),
(77, 'views', 'Slideshow-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(78, 'block', '1', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(79, 'block', '1', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(80, 'block', '1', 'tb_simply', 1, -13, 'footer', 0, 0, '', '', -1),
(81, 'menu', 'menu-footer-menu', 'bartik', 0, 0, '-1', 0, 0, '', '<none>', -1),
(82, 'quicktabs', 'quicktabs', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '<none>', -1),
(83, 'menu', 'menu-footer-menu', 'seven', 0, 0, '-1', 0, 0, '', '<none>', -1),
(84, 'menu', 'menu-footer-menu', 'tb_simply', 1, -14, 'footer', 0, 0, '', '<none>', -1),
(85, 'block', '1', 'zircon', 1, -13, 'footer', 0, 0, '', '', -1),
(86, 'blog', 'recent', 'zircon', 0, -17, '-1', 0, 0, '', '', 1),
(87, 'comment', 'recent', 'zircon', 0, -16, '-1', 0, 0, '', '', 1),
(88, 'forum', 'active', 'zircon', 0, -28, '-1', 0, 0, '', '', -2),
(89, 'forum', 'new', 'zircon', 0, -19, '-1', 0, 0, '', '', -2),
(91, 'menu', 'menu-footer-menu', 'zircon', 1, -14, 'footer', 0, 0, '', '<none>', -1),
(92, 'node', 'recent', 'zircon', 0, -15, '-1', 0, 0, '', '', 1),
(93, 'node', 'syndicate', 'zircon', 0, -10, '-1', 0, 0, '', '', -1),
(94, 'poll', 'recent', 'zircon', 1, -21, 'sidebar_second', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', 1),
(95, 'quicktabs', 'quicktabs', 'zircon', 1, -22, 'sidebar_second', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker\r\nsitemap\r\ntracker/*\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '<none>', -1),
(96, 'search', 'form', 'zircon', 1, 0, 'header', 0, 0, '', '', -1),
(97, 'shortcut', 'shortcuts', 'zircon', 0, -14, '-1', 0, 0, '', '', -1),
(98, 'superfish', '1', 'zircon', 1, -12, 'menu_bar', 0, 1, 'superfish-menu', '', -1),
(99, 'superfish', '2', 'zircon', 0, -13, '-1', 0, 0, '', '', -1),
(100, 'superfish', '3', 'zircon', 0, -12, '-1', 0, 0, '', '', -1),
(101, 'superfish', '4', 'zircon', 0, -11, '-1', 0, 0, '', '', -1),
(102, 'system', 'help', 'zircon', 1, 0, 'help', 0, 0, '', '', -1),
(103, 'system', 'main', 'zircon', 1, 0, 'content', 0, 0, '', '', -1),
(104, 'system', 'main-menu', 'zircon', 1, -28, 'sidebar_first', 0, 0, 'categories\r\nforum', 'Main Menu', -1),
(105, 'system', 'management', 'zircon', 0, -20, '-1', 0, 0, '', '', -1),
(106, 'system', 'navigation', 'zircon', 0, -27, '-1', 0, 0, 'categories', '', -1),
(107, 'system', 'powered-by', 'zircon', 0, -18, '-1', 0, 0, '', '', -1),
(108, 'system', 'user-menu', 'zircon', 1, -25, 'sidebar_first', 0, 0, 'categories\r\nforum', '', -1),
(109, 'user', 'login', 'zircon', 1, -26, 'sidebar_first', 0, 1, '<front>', '', -1),
(110, 'user', 'new', 'zircon', 1, -22, 'sidebar_first', 0, 0, 'categories\r\nforum', '', 1),
(111, 'user', 'online', 'zircon', 1, -23, 'sidebar_first', 0, 0, 'categories\r\nforum', '', -1),
(112, 'views', 'Slideshow-block', 'zircon', 1, 0, 'slideshow', 0, 1, '<front>', '<none>', -1),
(113, 'easy_social', 'easy_social_block_1', 'bartik', 0, 0, '-1', 0, 0, '', '', 4),
(114, 'easy_social', 'easy_social_block_1', 'seven', 0, 0, '-1', 0, 0, '', '', 4),
(115, 'easy_social', 'easy_social_block_1', 'zircon', 0, -25, '-1', 0, 0, '', '', 4),
(116, 'views', 'image_carousel-block', 'zircon', 1, 0, 'panel_second_1', 0, 0, '', '<none>', -1),
(117, 'block', '2', 'bartik', 0, 0, '-1', 0, 0, '', 'Useful links', -1),
(118, 'block', '2', 'seven', 0, 0, '-1', 0, 0, '', 'Useful links', -1),
(119, 'block', '2', 'zircon', 1, 0, 'panel_third_1', 0, 0, '', 'Useful links', -1),
(120, 'block', '3', 'bartik', 0, 0, '-1', 0, 0, '', 'Location', -1),
(121, 'block', '3', 'seven', 0, 0, '-1', 0, 0, '', 'Location', -1),
(122, 'block', '3', 'zircon', 1, -19, 'panel_third_2', 0, 0, '', 'Location', -1),
(123, 'block', '4', 'bartik', 0, 0, '-1', 0, 0, '', 'Contact', -1),
(124, 'block', '4', 'seven', 0, 0, '-1', 0, 0, '', 'Contact', -1),
(125, 'block', '4', 'zircon', 1, -24, 'panel_third_3', 0, 0, '', 'Contact', -1),
(126, 'views', 'image_carousel-block', 'bartik', 0, 0, '-1', 0, 0, '', '<none>', -1),
(127, 'views', 'image_carousel-block', 'seven', 0, 0, '-1', 0, 0, '', '<none>', -1),
(128, 'block', '5', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker/*\r\ntracker\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', -1),
(129, 'block', '5', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker/*\r\ntracker\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', -1),
(130, 'block', '5', 'zircon', 1, -24, 'sidebar_second', 0, 0, 'categories\r\nproduct/*\r\nforum\r\nforum/*\r\nabout-us\r\ntracker/*\r\ntracker\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', '', -1),
(134, 'site_map', 'syndicate', 'bartik', 0, 0, '-1', 0, 0, '', '', 1),
(135, 'site_map', 'syndicate', 'seven', 0, 0, '-1', 0, 0, '', '', 1),
(136, 'site_map', 'syndicate', 'zircon', 0, -9, '-1', 0, 0, '', '', 1),
(137, 'menu', 'devel', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(138, 'devel', 'execute_php', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(139, 'devel', 'switch_user', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(140, 'menu', 'devel', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(141, 'devel', 'execute_php', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(142, 'devel', 'switch_user', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(143, 'menu', 'devel', 'zircon', 0, -26, '-1', 0, 0, '', '', -1),
(144, 'devel', 'execute_php', 'zircon', 0, -20, '-1', 0, 0, '', '', -1),
(145, 'devel', 'switch_user', 'zircon', 0, -7, '-1', 0, 0, '', '', -1),
(146, 'easy_social', 'easy_social_block_2', 'zircon', 0, -24, '-1', 0, 0, '', '', 4),
(147, 'easy_social', 'easy_social_block_2', 'bartik', 0, 0, '-1', 0, 0, '', '', 4),
(148, 'easy_social', 'easy_social_block_2', 'seven', 0, 0, '-1', 0, 0, '', '', 4),
(149, 'widgets', 's_socialmedia_profile-default', 'zircon', 0, -5, '-1', 0, 0, '', '', -1),
(150, 'widgets', 's_socialmedia_share-default', 'zircon', 0, -3, '-1', 0, 0, '', '', -1),
(151, 'widgets', 's_socialmedia_profile-urls', 'zircon', 0, -4, '-1', 0, 0, '', '', -1),
(152, 'widgets', 's_socialmedia_profile-buttons', 'zircon', 0, -6, '-1', 0, 0, '', '', -1),
(153, 'widgets', 's_addthis-share', 'zircon', 0, -7, '-1', 0, 0, '', '', -1),
(154, 'widgets', 's_facebook-like-box', 'zircon', 0, -24, '-1', 0, 0, 'categories', '', -1),
(155, 'widgets', 's_twitter-profile-widget', 'zircon', 1, -24, 'sidebar_first', 0, 0, 'categories\r\nforum', '', -1),
(156, 'widgets', 's_socialmedia_profile-default', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(157, 'widgets', 's_socialmedia_share-default', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(158, 'widgets', 's_socialmedia_profile-urls', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(159, 'widgets', 's_socialmedia_profile-buttons', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(160, 'widgets', 's_addthis-share', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(161, 'widgets', 's_facebook-like-box', 'bartik', 0, 0, '-1', 0, 0, 'categories', '', -1),
(162, 'widgets', 's_twitter-profile-widget', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', -1),
(163, 'widgets', 's_socialmedia_profile-default', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(164, 'widgets', 's_socialmedia_share-default', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(165, 'widgets', 's_socialmedia_profile-urls', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(166, 'widgets', 's_socialmedia_profile-buttons', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(167, 'widgets', 's_addthis-share', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(168, 'widgets', 's_facebook-like-box', 'seven', 0, 0, '-1', 0, 0, 'categories', '', -1),
(169, 'widgets', 's_twitter-profile-widget', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nforum', '', -1),
(170, 'views', 'vertical_carousel-block', 'zircon', 1, -23, 'sidebar_second', 0, 0, 'categories\r\nproduct/*\r\nforum/*\r\nforum\r\nabout-us\r\ntracker\r\ntracker/*\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', 'OUR PRODUCTS', -1),
(171, 'views', 'vertical_carousel-block', 'bartik', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum/*\r\nforum\r\nabout-us\r\ntracker\r\ntracker/*\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', 'OUR PRODUCTS', -1),
(172, 'views', 'vertical_carousel-block', 'seven', 0, 0, '-1', 0, 0, 'categories\r\nproduct/*\r\nforum/*\r\nforum\r\nabout-us\r\ntracker\r\ntracker/*\r\nsitemap\r\nuser\r\nuser/*\r\nusers\r\nusers/*\r\nfilter/tips\r\nnode/*/track\r\nnode/*/votes\r\nblog/*\r\narticle/*\r\npoll/*\r\nnode/*/results', 'OUR PRODUCTS', -1),
(173, 'block', '7', 'bartik', 0, 0, '-1', 0, 1, '<front>', 'Living room', -1),
(174, 'block', '7', 'seven', 0, 0, '-1', 0, 1, '<front>', 'Living room', -1),
(175, 'block', '7', 'zircon', 0, -21, '-1', 0, 1, '<front>', 'Living room', -1),
(176, 'block', '8', 'bartik', 0, 0, '-1', 0, 1, '<front>', 'Bedroom', -1),
(177, 'block', '8', 'seven', 0, 0, '-1', 0, 1, '<front>', 'Bedroom', -1),
(178, 'block', '8', 'zircon', 0, -27, '-1', 0, 1, '<front>', 'Bedroom', -1),
(179, 'block', '9', 'bartik', 0, 0, '-1', 0, 1, '<front>', 'Home Office', -1),
(180, 'block', '9', 'seven', 0, 0, '-1', 0, 1, '<front>', 'Home Office', -1),
(181, 'block', '9', 'zircon', 0, -23, '-1', 0, 1, '<front>', 'Home Office', -1),
(182, 'block', '10', 'bartik', 0, 0, '-1', 0, 1, '<front>', 'Kitchen room', -1),
(183, 'block', '10', 'seven', 0, 0, '-1', 0, 1, '<front>', 'Kitchen room', -1),
(184, 'block', '10', 'zircon', 0, -22, '-1', 0, 1, '<front>', 'Kitchen room', -1),
(185, 'views', 'service-block', 'zircon', 1, -5, 'panel_first_1', 0, 1, '<front>', '<none>', -1),
(186, 'views', 'service-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(187, 'views', 'service-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(188, 'views', 'view_panel_2-block', 'zircon', 1, 0, 'panel_first_2', 0, 1, '<front>', '<none>', -1),
(189, 'views', 'view_panel_3-block', 'zircon', 1, -5, 'panel_first_3', 0, 1, '<front>', '<none>', -1),
(190, 'views', 'view_panel_4-block', 'zircon', 1, -5, 'panel_first_4', 0, 1, '<front>', '<none>', -1),
(191, 'views', 'view_panel_2-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(192, 'views', 'view_panel_2-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '<none>', -1),
(193, 'views', 'view_panel_3-block', 'bartik', 0, 0, '-1', 0, 0, '<front>', '', -1),
(194, 'views', 'view_panel_3-block', 'seven', 0, 0, '-1', 0, 0, '<front>', '', -1),
(195, 'views', 'view_panel_4-block', 'bartik', 0, 0, '-1', 0, 0, '<front>', '', -1),
(196, 'views', 'view_panel_4-block', 'seven', 0, 0, '-1', 0, 0, '<front>', '', -1),
(197, 'views', 'latest_articles-block', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(198, 'views', 'latest_articles-block', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(199, 'views', 'latest_articles-block', 'zircon', 0, -8, '-1', 0, 0, '', '', -1),
(203, 'newsletter', 'newsletter_subscribe', 'bartik', 0, 0, '-1', 0, 0, '', 'Newsletters', 1),
(204, 'newsletter', 'newsletter_subscribe', 'seven', 0, 0, '-1', 0, 0, '', 'Newsletters', 1),
(205, 'newsletter', 'newsletter_subscribe', 'zircon', 1, -28, 'panel_third_4', 0, 0, '', 'Newsletters', 1),
(206, 'views', 'sidebar_view-block', 'zircon', 0, -28, '-1', 0, 1, '<front>', '', -1),
(207, 'views', 'sidebar_view-block', 'bartik', 0, 0, '-1', 0, 1, '<front>', '', -1),
(208, 'views', 'sidebar_view-block', 'seven', 0, 0, '-1', 0, 1, '<front>', '', -1),
(209, 'tb_megamenu', 'devel', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(210, 'tb_megamenu', 'main-menu', 'bartik', 0, 0, '-1', 0, 0, 'superfish-menu', '', -1),
(211, 'tb_megamenu', 'management', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(212, 'tb_megamenu', 'menu-footer-menu', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(213, 'tb_megamenu', 'navigation', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(214, 'tb_megamenu', 'user-menu', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(215, 'tb_megamenu', 'devel', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(216, 'tb_megamenu', 'main-menu', 'seven', 0, 0, '-1', 0, 0, 'superfish-menu', '', -1),
(217, 'tb_megamenu', 'management', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(218, 'tb_megamenu', 'menu-footer-menu', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(219, 'tb_megamenu', 'navigation', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(220, 'tb_megamenu', 'user-menu', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(221, 'tb_megamenu', 'devel', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(222, 'tb_megamenu', 'main-menu', 'zircon', 1, 0, 'menu_bar', 0, 0, 'superfish-menu', '', -1),
(223, 'tb_megamenu', 'management', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(224, 'tb_megamenu', 'menu-footer-menu', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(225, 'tb_megamenu', 'navigation', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(226, 'tb_megamenu', 'user-menu', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(227, 'views', 'w-block', 'zircon', 0, 0, '-1', 0, 0, '', '', -1),
(228, 'views', 'w-block', 'bartik', 0, 0, '-1', 0, 0, '', '', -1),
(229, 'views', 'w-block', 'seven', 0, 0, '-1', 0, 0, '', '', -1),
(230, 'block', '11', 'bartik', 0, 0, '-1', 0, 0, '', 'Demo Block', -1),
(231, 'block', '11', 'seven', 0, 0, '-1', 0, 0, '', 'Demo Block', -1),
(232, 'block', '11', 'zircon', 0, 0, '-1', 0, 0, '', 'Demo Block', -1);

-- --------------------------------------------------------

--
-- Table structure for table `blocked_ips`
--

CREATE TABLE IF NOT EXISTS `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `block_custom`
--

CREATE TABLE IF NOT EXISTS `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.' AUTO_INCREMENT=12 ;

--
-- Dumping data for table `block_custom`
--

INSERT INTO `block_custom` (`bid`, `body`, `info`, `format`) VALUES
(1, '<div class="tb-copyright">\r\nCopyright © 2012 Zircon All Rights Reserved. Designed by <a href="http://www.weebpal.com">weebpal.com</a>. Powered by Drupal\r\n</div>', 'Zircon Copyright Notice Block. Ussuallly locate in footer.', 'full_html'),
(2, '<ul>\r\n<li><a href="http://www.drupal.org" title="Drupal">Drupal</a></li>\r\n<li><a href="http://www.google.com" title="Google">Google</a></li>\r\n<li><a href="http://www.facebook.com" title="Facebook">Facebook</a></li>\r\n<li><a href="http://www.twitter.com" title="Twiiter">Twitter</a></li>\r\n<li><a href="http://www.weebpal.com" title="WeebPal">WeebPal</a></li>\r\n</ul>', 'Useful links', 'full_html'),
(3, '<h4>US</h4>\r\n<p>7801 NW 15 Street Ste #CO32314 <br />Doral, Florida 33126</p>\r\n<h4>Australia</h4>\r\n<p>GPO Box 4245, Sydney, NSW</p>', 'Location', 'full_html'),
(4, '<p>Give us a call at<span class="telephone-number">+00 123 456 789</span></p>\r\n<p>Email us at<span class="email-address"><a href="mailto:support@weebpal.com">support@weebpal.com</a></span></p>\r\n', 'Contact', 'full_html'),
(5, '<p>Going to bed at night saying we’ve done something wonderful… that’s what matters to me.</p>\r\n<p class="author"><strong>John Doe,</strong> <a href="#" title="Gamer" target="_blank">Gamer</a></p>', 'Quote block', 'full_html'),
(7, '<p><a href="#"><img src="sites/default/files/field/image/demo-7.jpg" alt="" /></a></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>', 'Living room', 'full_html'),
(8, '<p><a href="#"><img src="sites/default/files/field/image/demo-7.jpg" alt="" /></a></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>', 'Bedroom', 'full_html'),
(9, '<p><a href="#"><img src="sites/default/files/field/image/demo-7.jpg" alt="" /></a></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>', 'Home Office', 'full_html'),
(10, '<p><a href="#"><img src="sites/default/files/field/image/demo-7.jpg" alt="" /></a></p>\r\n<p>Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.</p>', 'Kitchen room', 'full_html'),
(11, 'Morbi vitae ipsum metus. In nunc erat, fringilla non sapien vel, tempus consectetur arcu. Donec molestie ullamcorper metus in suscipit. Nullam eu scelerisque elit, quis lobortis odio. Quisque tristique sem et feugiat pharetra? ', 'Demo block', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `block_node_type`
--

CREATE TABLE IF NOT EXISTS `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';

-- --------------------------------------------------------

--
-- Table structure for table `block_role`
--

CREATE TABLE IF NOT EXISTS `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE IF NOT EXISTS `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_block`
--

CREATE TABLE IF NOT EXISTS `cache_block` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Block module to store already built...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_bootstrap`
--

CREATE TABLE IF NOT EXISTS `cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for data required to bootstrap Drupal, may be...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_field`
--

CREATE TABLE IF NOT EXISTS `cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_filter`
--

CREATE TABLE IF NOT EXISTS `cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Filter module to store already...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_form`
--

CREATE TABLE IF NOT EXISTS `cache_form` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the form system to store recently built...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_image`
--

CREATE TABLE IF NOT EXISTS `cache_image` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about image...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_libraries`
--

CREATE TABLE IF NOT EXISTS `cache_libraries` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table to store library information.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_menu`
--

CREATE TABLE IF NOT EXISTS `cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the menu system to store router...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_page`
--

CREATE TABLE IF NOT EXISTS `cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store compressed pages for anonymous...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_path`
--

CREATE TABLE IF NOT EXISTS `cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for path alias lookup.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_token`
--

CREATE TABLE IF NOT EXISTS `cache_token` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for token information.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_update`
--

CREATE TABLE IF NOT EXISTS `cache_update` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Update module to store information...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_variable`
--

CREATE TABLE IF NOT EXISTS `cache_variable` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for variables.';

-- --------------------------------------------------------

--
-- Table structure for table `cache_views`
--

CREATE TABLE IF NOT EXISTS `cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_views_data`
--

CREATE TABLE IF NOT EXISTS `cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for views to store pre-rendered queries,...';

-- --------------------------------------------------------

--
-- Table structure for table `cache_widgets`
--

CREATE TABLE IF NOT EXISTS `cache_widgets` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about widgets...';

-- --------------------------------------------------------

--
-- Table structure for table `comment`
--

CREATE TABLE IF NOT EXISTS `comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The vancode representation of the comment’s place in a thread.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s e-mail address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_language` (`nid`,`language`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores comments and associated data.' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `comment`
--

INSERT INTO `comment` (`cid`, `pid`, `nid`, `uid`, `subject`, `hostname`, `created`, `changed`, `status`, `thread`, `name`, `mail`, `homepage`, `language`) VALUES
(1, 0, 21, 1, 'Validate! Always. Validate XHTML 1.0 Strict.', '127.0.0.1', 1326766619, 1326766619, 1, '01/', 'admin', '', '', 'und'),
(2, 1, 21, 1, 'Please ensure that you''ve', '127.0.0.1', 1326766651, 1326766651, 1, '01.00/', 'admin', '', '', 'und'),
(3, 0, 1, 1, 'Non ornare Curabitur auctor ', '127.0.0.1', 1330821144, 1330821142, 1, '01/', 'admin', '', '', 'und'),
(4, 0, 1, 1, 'Lacus orci feugiat rhoncus ', '127.0.0.1', 1330821306, 1330821303, 1, '02/', 'admin', '', '', 'und'),
(5, 3, 1, 1, 'Lorem Cum lorem ac', '127.0.0.1', 1331348602, 1331348600, 1, '01.00/', 'admin', '', '', 'und');

-- --------------------------------------------------------

--
-- Table structure for table `contact`
--

CREATE TABLE IF NOT EXISTS `contact` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique category ID.',
  `category` varchar(255) NOT NULL DEFAULT '' COMMENT 'Category name.',
  `recipients` longtext NOT NULL COMMENT 'Comma-separated list of recipient e-mail addresses.',
  `reply` longtext NOT NULL COMMENT 'Text of the auto-reply message.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The category’s weight.',
  `selected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether or not category is selected by default. (1 = Yes, 0 = No)',
  PRIMARY KEY (`cid`),
  UNIQUE KEY `category` (`category`),
  KEY `list` (`weight`,`category`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contact form category settings.' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `contact`
--

INSERT INTO `contact` (`cid`, `category`, `recipients`, `reply`, `weight`, `selected`) VALUES
(1, 'Website feedback', 'you@yourdomain.com', '', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `ctools_css_cache`
--

CREATE TABLE IF NOT EXISTS `ctools_css_cache` (
  `cid` varchar(128) NOT NULL COMMENT 'The CSS ID this cache object belongs to.',
  `filename` varchar(255) DEFAULT NULL COMMENT 'The filename this CSS is stored in.',
  `css` longtext COMMENT 'CSS being stored.',
  `filter` tinyint(4) DEFAULT NULL COMMENT 'Whether or not this CSS needs to be filtered.',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store CSS that must be non-volatile.';

-- --------------------------------------------------------

--
-- Table structure for table `ctools_object_cache`
--

CREATE TABLE IF NOT EXISTS `ctools_object_cache` (
  `sid` varchar(64) NOT NULL COMMENT 'The session ID this cache object belongs to.',
  `name` varchar(128) NOT NULL COMMENT 'The name of the object this cache is attached to.',
  `obj` varchar(32) NOT NULL COMMENT 'The type of the object this cache is attached to; this essentially represents the owner so that several sub-systems can use this cache.',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The time this cache was created or updated.',
  `data` longblob COMMENT 'Serialized data being stored.',
  PRIMARY KEY (`sid`,`obj`,`name`),
  KEY `updated` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store objects that are being...';

-- --------------------------------------------------------

--
-- Table structure for table `date_formats`
--

CREATE TABLE IF NOT EXISTS `date_formats` (
  `dfid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The date format identifier.',
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this format can be modified.',
  PRIMARY KEY (`dfid`),
  UNIQUE KEY `formats` (`format`,`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats.' AUTO_INCREMENT=36 ;

--
-- Dumping data for table `date_formats`
--

INSERT INTO `date_formats` (`dfid`, `format`, `type`, `locked`) VALUES
(1, 'Y-m-d H:i', 'short', 1),
(2, 'm/d/Y - H:i', 'short', 1),
(3, 'd/m/Y - H:i', 'short', 1),
(4, 'Y/m/d - H:i', 'short', 1),
(5, 'd.m.Y - H:i', 'short', 1),
(6, 'm/d/Y - g:ia', 'short', 1),
(7, 'd/m/Y - g:ia', 'short', 1),
(8, 'Y/m/d - g:ia', 'short', 1),
(9, 'M j Y - H:i', 'short', 1),
(10, 'j M Y - H:i', 'short', 1),
(11, 'Y M j - H:i', 'short', 1),
(12, 'M j Y - g:ia', 'short', 1),
(13, 'j M Y - g:ia', 'short', 1),
(14, 'Y M j - g:ia', 'short', 1),
(15, 'D, Y-m-d H:i', 'medium', 1),
(16, 'D, m/d/Y - H:i', 'medium', 1),
(17, 'D, d/m/Y - H:i', 'medium', 1),
(18, 'D, Y/m/d - H:i', 'medium', 1),
(19, 'F j, Y - H:i', 'medium', 1),
(20, 'j F, Y - H:i', 'medium', 1),
(21, 'Y, F j - H:i', 'medium', 1),
(22, 'D, m/d/Y - g:ia', 'medium', 1),
(23, 'D, d/m/Y - g:ia', 'medium', 1),
(24, 'D, Y/m/d - g:ia', 'medium', 1),
(25, 'F j, Y - g:ia', 'medium', 1),
(26, 'j F Y - g:ia', 'medium', 1),
(27, 'Y, F j - g:ia', 'medium', 1),
(28, 'j. F Y - G:i', 'medium', 1),
(29, 'l, F j, Y - H:i', 'long', 1),
(30, 'l, j F, Y - H:i', 'long', 1),
(31, 'l, Y,  F j - H:i', 'long', 1),
(32, 'l, F j, Y - g:ia', 'long', 1),
(33, 'l, j F Y - g:ia', 'long', 1),
(34, 'l, Y,  F j - g:ia', 'long', 1),
(35, 'l, j. F Y - G:i', 'long', 1);

-- --------------------------------------------------------

--
-- Table structure for table `date_format_locale`
--

CREATE TABLE IF NOT EXISTS `date_format_locale` (
  `format` varchar(100) NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `language` varchar(12) NOT NULL COMMENT 'A languages.language for this format to be used with.',
  PRIMARY KEY (`type`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats for each locale.';

-- --------------------------------------------------------

--
-- Table structure for table `date_format_type`
--

CREATE TABLE IF NOT EXISTS `date_format_type` (
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `title` varchar(255) NOT NULL COMMENT 'The human readable name of the format type.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this is a system provided format.',
  PRIMARY KEY (`type`),
  KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date format types.';

--
-- Dumping data for table `date_format_type`
--

INSERT INTO `date_format_type` (`type`, `title`, `locked`) VALUES
('long', 'Long', 1),
('medium', 'Medium', 1),
('short', 'Short', 1);

-- --------------------------------------------------------

--
-- Table structure for table `field_config`
--

CREATE TABLE IF NOT EXISTS `field_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field',
  `field_name` varchar(32) NOT NULL COMMENT 'The name of this field. Non-deleted field names are unique, but multiple deleted fields can have the same name.',
  `type` varchar(128) NOT NULL COMMENT 'The type of this field.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the field type.',
  `active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the field type is enabled.',
  `storage_type` varchar(128) NOT NULL COMMENT 'The storage backend for the field.',
  `storage_module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the storage backend.',
  `storage_active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the storage backend is enabled.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '@TODO',
  `data` longblob NOT NULL COMMENT 'Serialized data containing the field properties that do not warrant a dedicated column.',
  `cardinality` tinyint(4) NOT NULL DEFAULT '0',
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name` (`field_name`),
  KEY `active` (`active`),
  KEY `storage_active` (`storage_active`),
  KEY `deleted` (`deleted`),
  KEY `module` (`module`),
  KEY `storage_module` (`storage_module`),
  KEY `type` (`type`),
  KEY `storage_type` (`storage_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Dumping data for table `field_config`
--

INSERT INTO `field_config` (`id`, `field_name`, `type`, `module`, `active`, `storage_type`, `storage_module`, `storage_active`, `locked`, `data`, `cardinality`, `translatable`, `deleted`) VALUES
(1, 'comment_body', 'text_long', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a373a22636f6d6d656e74223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(2, 'body', 'text_with_summary', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a313a7b693a303b733a343a226e6f6465223b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(3, 'field_tags', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a343a2274616773223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(4, 'field_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a373a22696e6465786573223b613a313a7b733a333a22666964223b613a313a7b693a303b733a333a22666964223b7d7d733a383a2273657474696e6773223b613a323a7b733a31303a227572695f736368656d65223b733a363a227075626c6963223b733a31333a2264656661756c745f696d616765223b623a303b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a31323a22666f726569676e206b657973223b613a313a7b733a333a22666964223b613a323a7b733a353a227461626c65223b733a31323a2266696c655f6d616e61676564223b733a373a22636f6c756d6e73223b613a313a7b733a333a22666964223b733a333a22666964223b7d7d7d7d, 1, 0, 0),
(5, 'taxonomy_forums', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a363a22666f72756d73223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, 1, 0, 0),
(6, 'field_slideshow', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(7, 'field_category', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a383a2261727469636c6573223b733a363a22706172656e74223b733a313a2230223b7d7d7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32353a226669656c645f646174615f6669656c645f63617465676f7279223b613a313a7b733a333a22746964223b733a31383a226669656c645f63617465676f72795f746964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32393a226669656c645f7265766973696f6e5f6669656c645f63617465676f7279223b613a313a7b733a333a22746964223b733a31383a226669656c645f63617465676f72795f746964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d733a323a226964223b733a313a2237223b7d, 1, 0, 0),
(8, 'field_img', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a323a7b733a31303a227572695f736368656d65223b733a363a227075626c6963223b733a31333a2264656661756c745f696d616765223b693a303b7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32303a226669656c645f646174615f6669656c645f696d67223b613a353a7b733a333a22666964223b733a31333a226669656c645f696d675f666964223b733a333a22616c74223b733a31333a226669656c645f696d675f616c74223b733a353a227469746c65223b733a31353a226669656c645f696d675f7469746c65223b733a353a227769647468223b733a31353a226669656c645f696d675f7769647468223b733a363a22686569676874223b733a31363a226669656c645f696d675f686569676874223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a32343a226669656c645f7265766973696f6e5f6669656c645f696d67223b613a353a7b733a333a22666964223b733a31333a226669656c645f696d675f666964223b733a333a22616c74223b733a31333a226669656c645f696d675f616c74223b733a353a227469746c65223b733a31353a226669656c645f696d675f7469746c65223b733a353a227769647468223b733a31353a226669656c645f696d675f7769647468223b733a363a22686569676874223b733a31363a226669656c645f696d675f686569676874223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22666964223b613a323a7b733a353a227461626c65223b733a31323a2266696c655f6d616e61676564223b733a373a22636f6c756d6e73223b613a313a7b733a333a22666964223b733a333a22666964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22666964223b613a313a7b693a303b733a333a22666964223b7d7d733a323a226964223b733a313a2238223b7d, 1, 0, 0),
(9, 'field_blog_img', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(10, 'field_blog_tags', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a343a2274616773223b733a363a22706172656e74223b733a313a2230223b7d7d7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a32363a226669656c645f646174615f6669656c645f626c6f675f74616773223b613a313a7b733a333a22746964223b733a31393a226669656c645f626c6f675f746167735f746964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33303a226669656c645f7265766973696f6e5f6669656c645f626c6f675f74616773223b613a313a7b733a333a22746964223b733a31393a226669656c645f626c6f675f746167735f746964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d733a323a226964223b733a323a223130223b7d, -1, 0, 0),
(11, 'field_category_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(12, 'field_product_image', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, -1, 0, 0),
(14, 'field_product_category', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a31323a227472616e736c617461626c65223b733a313a2230223b733a31323a22656e746974795f7479706573223b613a303a7b7d733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a31303a2263617465676f72696573223b733a363a22706172656e74223b733a313a2230223b7d7d7d733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a33333a226669656c645f646174615f6669656c645f70726f647563745f63617465676f7279223b613a313a7b733a333a22746964223b733a32363a226669656c645f70726f647563745f63617465676f72795f746964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33373a226669656c645f7265766973696f6e5f6669656c645f70726f647563745f63617465676f7279223b613a313a7b733a333a22746964223b733a32363a226669656c645f70726f647563745f63617465676f72795f746964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d733a323a226964223b733a323a223134223b7d, 1, 0, 0),
(15, 'field_product_thumb', 'image', 'image', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 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, 1, 0, 0),
(16, 'field_categories', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a31303a2263617465676f72696573223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(17, 'field_forums', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a363a22666f72756d73223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(18, 'field_articles', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a383a2261727469636c6573223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(19, 'field_newsletter_categories', 'taxonomy_term_reference', 'taxonomy', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a383a2273657474696e6773223b613a313a7b733a31343a22616c6c6f7765645f76616c756573223b613a313a7b693a303b613a323a7b733a31303a22766f636162756c617279223b733a32313a226e6577736c65747465725f63617465676f72696573223b733a363a22706172656e74223b693a303b7d7d7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a333a22746964223b613a323a7b733a353a227461626c65223b733a31383a227461786f6e6f6d795f7465726d5f64617461223b733a373a22636f6c756d6e73223b613a313a7b733a333a22746964223b733a333a22746964223b7d7d7d733a373a22696e6465786573223b613a313a7b733a333a22746964223b613a313a7b693a303b733a333a22746964223b7d7d7d, -1, 0, 0),
(20, 'field_newsletter_list', 'entityreference', 'entityreference', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a383a2273657474696e6773223b613a343a7b733a31313a227461726765745f74797065223b733a31353a226e6577736c65747465725f6c697374223b733a373a2268616e646c6572223b733a343a2262617365223b733a31363a2268616e646c65725f73657474696e6773223b613a323a7b733a31343a227461726765745f62756e646c6573223b613a303a7b7d733a343a22736f7274223b613a313a7b733a343a2274797065223b733a343a226e6f6e65223b7d7d733a31343a2268616e646c65725f7375626d6974223b733a31343a224368616e67652068616e646c6572223b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a33323a226669656c645f646174615f6669656c645f6e6577736c65747465725f6c697374223b613a313a7b733a393a227461726765745f6964223b733a33313a226669656c645f6e6577736c65747465725f6c6973745f7461726765745f6964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a33363a226669656c645f7265766973696f6e5f6669656c645f6e6577736c65747465725f6c697374223b613a313a7b733a393a227461726765745f6964223b733a33313a226669656c645f6e6577736c65747465725f6c6973745f7461726765745f6964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a393a227461726765745f6964223b613a313a7b693a303b733a393a227461726765745f6964223b7d7d733a323a226964223b733a323a223230223b7d, -1, 0, 0),
(21, 'field_newsletter_template', 'entityreference', 'entityreference', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a373a7b733a383a2273657474696e6773223b613a343a7b733a31313a227461726765745f74797065223b733a31393a226e6577736c65747465725f74656d706c617465223b733a373a2268616e646c6572223b733a343a2262617365223b733a31363a2268616e646c65725f73657474696e6773223b613a323a7b733a31343a227461726765745f62756e646c6573223b613a303a7b7d733a343a22736f7274223b613a313a7b733a343a2274797065223b733a343a226e6f6e65223b7d7d733a31343a2268616e646c65725f7375626d6974223b733a31343a224368616e67652068616e646c6572223b7d733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b733a313a2230223b733a373a2273746f72616765223b613a353a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b733a313a2231223b733a373a2264657461696c73223b613a313a7b733a333a2273716c223b613a323a7b733a31383a224649454c445f4c4f41445f43555252454e54223b613a313a7b733a33363a226669656c645f646174615f6669656c645f6e6577736c65747465725f74656d706c617465223b613a313a7b733a393a227461726765745f6964223b733a33353a226669656c645f6e6577736c65747465725f74656d706c6174655f7461726765745f6964223b7d7d733a31393a224649454c445f4c4f41445f5245564953494f4e223b613a313a7b733a34303a226669656c645f7265766973696f6e5f6669656c645f6e6577736c65747465725f74656d706c617465223b613a313a7b733a393a227461726765745f6964223b733a33353a226669656c645f6e6577736c65747465725f74656d706c6174655f7461726765745f6964223b7d7d7d7d7d733a31323a22666f726569676e206b657973223b613a303a7b7d733a373a22696e6465786573223b613a313a7b733a393a227461726765745f6964223b613a313a7b693a303b733a393a227461726765745f6964223b7d7d733a323a226964223b733a323a223231223b7d, 1, 0, 0),
(22, 'field_list_description', 'text', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a313a7b733a31303a226d61785f6c656e677468223b693a3235353b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0),
(23, 'field_newsletter_body', 'text_with_summary', 'text', 1, 'field_sql_storage', 'field_sql_storage', 1, 0, 0x613a363a7b733a31323a22656e746974795f7479706573223b613a303a7b7d733a31323a227472616e736c617461626c65223b623a303b733a383a2273657474696e6773223b613a303a7b7d733a373a2273746f72616765223b613a343a7b733a343a2274797065223b733a31373a226669656c645f73716c5f73746f72616765223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a31373a226669656c645f73716c5f73746f72616765223b733a363a22616374697665223b693a313b7d733a31323a22666f726569676e206b657973223b613a313a7b733a363a22666f726d6174223b613a323a7b733a353a227461626c65223b733a31333a2266696c7465725f666f726d6174223b733a373a22636f6c756d6e73223b613a313a7b733a363a22666f726d6174223b733a363a22666f726d6174223b7d7d7d733a373a22696e6465786573223b613a313a7b733a363a22666f726d6174223b613a313a7b693a303b733a363a22666f726d6174223b7d7d7d, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `field_config_instance`
--

CREATE TABLE IF NOT EXISTS `field_config_instance` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field instance',
  `field_id` int(11) NOT NULL COMMENT 'The identifier of the field attached by this instance',
  `field_name` varchar(32) NOT NULL DEFAULT '',
  `entity_type` varchar(32) NOT NULL DEFAULT '',
  `bundle` varchar(128) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name_bundle` (`field_name`,`entity_type`,`bundle`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=35 ;

--
-- Dumping data for table `field_config_instance`
--

INSERT INTO `field_config_instance` (`id`, `field_id`, `field_name`, `entity_type`, `bundle`, `data`, `deleted`) VALUES
(1, 1, 'comment_body', 'comment', 'comment_node_page', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(2, 2, 'body', 'node', 'page', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a222d34223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(3, 1, 'comment_body', 'comment', 'comment_node_article', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(4, 2, 'body', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a323a222d34223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(5, 3, 'field_tags', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a31313a226465736372697074696f6e223b733a36333a22456e746572206120636f6d6d612d736570617261746564206c697374206f6620776f72647320746f20646573637269626520796f757220636f6e74656e742e223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a363a22776569676874223b733a323a222d34223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2234223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a303b7d, 0),
(6, 4, 'field_image', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a31313a226465736372697074696f6e223b733a34303a2255706c6f616420616e20696d61676520746f20676f207769746820746869732061727469636c652e223b733a383a227265717569726564223b623a303b733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a31313a226669656c642f696d616765223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b623a313b733a31313a227469746c655f6669656c64223b733a303a22223b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d733a363a22776569676874223b733a323a222d31223b733a363a226d6f64756c65223b733a353a22696d616765223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d7d, 0),
(7, 1, 'comment_body', 'comment', 'comment_node_blog', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(8, 2, 'body', 'node', 'blog', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a313a2231223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(9, 5, 'taxonomy_forums', 'node', 'forum', 0x613a363a7b733a353a226c6162656c223b733a363a22466f72756d73223b733a383a227265717569726564223b623a313b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a323a223130223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a323a223130223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(10, 1, 'comment_body', 'comment', 'comment_node_forum', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(11, 1, 'comment_body', 'comment', 'comment_node_poll', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(12, 2, 'body', 'node', 'forum', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a323a223131223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a323a223131223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(13, 6, 'field_slideshow', 'node', 'article', 0x613a363a7b733a353a226c6162656c223b733a31353a22536c69646573686f7720496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223331223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a22736c69646573686f77223b7d7d733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a31353a226669656c642f736c69646573686f77223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a313b733a31313a227469746c655f6669656c64223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2234223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a32343a22496d61676520666f7220536c69646573686f77206f6e6c79223b7d, 0),
(14, 7, 'field_category', 'node', 'article', 0x613a373a7b733a353a226c6162656c223b733a383a2243617465676f7279223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223332223b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a303a7b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a32303a225365742041727469636c652043617465676f7279223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(15, 8, 'field_img', 'node', 'page', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223331223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a31313a226669656c642f696d616765223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a313b733a31313a227469746c655f6669656c64223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a303a22223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a34333a2255706c6f616420616e20696d61676520746f20676f2077697468207468697320626173696320706167652e223b7d, 0),
(16, 9, 'field_blog_img', 'node', 'blog', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a31313a226669656c642f696d616765223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(17, 10, 'field_blog_tags', 'node', 'blog', 0x613a373a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2232223b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22616374697665223b693a303b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(18, 11, 'field_category_image', 'taxonomy_term', 'categories', 0x613a363a7b733a353a226c6162656c223b733a353a22496d616765223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a323a223331223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a32303a226669656c642f696d6167652f7365727669636573223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(19, 1, 'comment_body', 'comment', 'comment_node_product', 0x613a363a7b733a353a226c6162656c223b733a373a22436f6d6d656e74223b733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a383a227265717569726564223b623a313b733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b693a303b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a363a22776964676574223b613a343a7b733a343a2274797065223b733a31333a22746578745f7465787461726561223b733a383a2273657474696e6773223b613a313a7b733a343a22726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(20, 2, 'body', 'node', 'product', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b733a313a2232223b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a363a22776569676874223b733a313a2231223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(21, 12, 'field_product_image', 'node', 'product', 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, 0),
(23, 14, 'field_product_category', 'node', 'product', 0x613a373a7b733a353a226c6162656c223b733a383a2243617465676f7279223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2235223b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a363a226d6f64756c65223b733a373a226f7074696f6e73223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a303a7b7d7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a363a22776569676874223b733a313a2232223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a363a22746561736572223b613a343a7b733a353a226c6162656c223b733a363a22696e6c696e65223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d7d733a383a227265717569726564223b693a313b733a31313a226465736372697074696f6e223b733a303a22223b733a31333a2264656661756c745f76616c7565223b4e3b7d, 0),
(24, 15, 'field_product_thumb', 'node', 'product', 0x613a363a7b733a353a226c6162656c223b733a353a225468756d62223b733a363a22776964676574223b613a353a7b733a363a22776569676874223b733a313a2233223b733a343a2274797065223b733a31313a22696d6167655f696d616765223b733a363a226d6f64756c65223b733a353a22696d616765223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a323a7b733a31383a2270726f67726573735f696e64696361746f72223b733a383a227468726f62626572223b733a31393a22707265766965775f696d6167655f7374796c65223b733a393a227468756d626e61696c223b7d7d733a383a2273657474696e6773223b613a383a7b733a31343a2266696c655f6469726563746f7279223b733a31383a226669656c642f696d6167652f7468756d6273223b733a31353a2266696c655f657874656e73696f6e73223b733a31363a22706e6720676966206a7067206a706567223b733a31323a226d61785f66696c6573697a65223b733a303a22223b733a31343a226d61785f7265736f6c7574696f6e223b733a303a22223b733a31343a226d696e5f7265736f6c7574696f6e223b733a303a22223b733a393a22616c745f6669656c64223b693a303b733a31313a227469746c655f6669656c64223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a343a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a363a2268696464656e223b733a363a22776569676874223b733a313a2233223b733a383a2273657474696e6773223b613a303a7b7d7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a353a22696d616765223b733a363a22776569676874223b733a313a2230223b733a383a2273657474696e6773223b613a323a7b733a31313a22696d6167655f7374796c65223b733a363a226d656469756d223b733a31303a22696d6167655f6c696e6b223b733a373a22636f6e74656e74223b7d733a363a226d6f64756c65223b733a353a22696d616765223b7d7d733a383a227265717569726564223b693a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(25, 16, 'field_categories', 'newsletter_template', 'newsletter_template', 0x613a363a7b733a353a226c6162656c223b733a31303a2243617465676f72696573223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(26, 17, 'field_forums', 'newsletter_template', 'newsletter_template', 0x613a363a7b733a353a226c6162656c223b733a363a22466f72756d73223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(27, 18, 'field_articles', 'newsletter_template', 'newsletter_template', 0x613a363a7b733a353a226c6162656c223b733a383a2241727469636c6573223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22776569676874223b693a323b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(28, 3, 'field_tags', 'newsletter_template', 'newsletter_template', 0x613a363a7b733a353a226c6162656c223b733a343a2254616773223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22776569676874223b693a333b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(29, 19, 'field_newsletter_categories', 'newsletter_list', 'newsletter_list', 0x613a363a7b733a353a226c6162656c223b733a383a2243617465676f7279223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a32313a227461786f6e6f6d795f6175746f636f6d706c657465223b733a383a2273657474696e6773223b613a323a7b733a343a2273697a65223b693a36303b733a31373a226175746f636f6d706c6574655f70617468223b733a32313a227461786f6e6f6d792f6175746f636f6d706c657465223b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b7d733a383a2273657474696e6773223b613a313a7b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32383a227461786f6e6f6d795f7465726d5f7265666572656e63655f6c696e6b223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a383a227461786f6e6f6d79223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(30, 22, 'field_list_description', 'newsletter_list', 'newsletter_list', 0x613a363a7b733a353a226c6162656c223b733a31313a224465736372697074696f6e223b733a363a22776964676574223b613a343a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a22746578745f746578746669656c64223b733a383a2273657474696e6773223b613a313a7b733a343a2273697a65223b693a36303b7d733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a323a7b733a31353a22746578745f70726f63657373696e67223b693a303b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a313b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(31, 20, 'field_newsletter_list', 'newsletter_subscriber', 'newsletter_subscriber', 0x613a363a7b733a353a226c6162656c223b733a353a224c69737473223b733a383a227265717569726564223b623a313b733a363a22776964676574223b613a353a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31353a226f7074696f6e735f627574746f6e73223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a343a7b733a31313a227461726765745f74797065223b733a31353a226e6577736c65747465725f6c697374223b733a373a2268616e646c6572223b733a343a2262617365223b733a31363a2268616e646c65725f73657474696e6773223b613a313a7b733a31343a227461726765745f62756e646c6573223b613a313a7b693a303b733a31353a226e6577736c65747465725f6c697374223b7d7d733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22656e746974797265666572656e63655f6c6162656c223b733a383a2273657474696e6773223b613a313a7b733a343a226c696e6b223b623a303b7d733a363a226d6f64756c65223b733a31353a22656e746974797265666572656e6365223b733a363a22776569676874223b693a303b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(32, 21, 'field_newsletter_template', 'newsletter_list', 'newsletter_list', 0x613a363a7b733a353a226c6162656c223b733a383a2254656d706c617465223b733a383a227265717569726564223b623a313b733a363a22776964676574223b613a353a7b733a363a22776569676874223b693a303b733a343a2274797065223b733a31343a226f7074696f6e735f73656c656374223b733a363a22616374697665223b693a313b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a373a226f7074696f6e73223b7d733a383a2273657474696e6773223b613a343a7b733a31313a227461726765745f74797065223b733a31393a226e6577736c65747465725f74656d706c617465223b733a373a2268616e646c6572223b733a343a2262617365223b733a31363a2268616e646c65725f73657474696e6773223b613a313a7b733a31343a227461726765745f62756e646c6573223b613a313a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b7d7d733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a313a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a353a2261626f7665223b733a343a2274797065223b733a32313a22656e746974797265666572656e63655f6c6162656c223b733a383a2273657474696e6773223b613a313a7b733a343a226c696e6b223b623a303b7d733a363a226d6f64756c65223b733a31353a22656e746974797265666572656e6365223b733a363a22776569676874223b693a323b7d7d733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(33, 23, 'field_newsletter_body', 'newsletter_template', 'newsletter_template', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b693a313b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a343b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0),
(34, 23, 'field_newsletter_body', 'newsletter_newsletter', 'newsletter_newsletter', 0x613a363a7b733a353a226c6162656c223b733a343a22426f6479223b733a363a22776964676574223b613a343a7b733a343a2274797065223b733a32363a22746578745f74657874617265615f776974685f73756d6d617279223b733a383a2273657474696e6773223b613a323a7b733a343a22726f7773223b693a32303b733a31323a2273756d6d6172795f726f7773223b693a353b7d733a363a22776569676874223b693a303b733a363a226d6f64756c65223b733a343a2274657874223b7d733a383a2273657474696e6773223b613a333a7b733a31353a22646973706c61795f73756d6d617279223b623a313b733a31353a22746578745f70726f63657373696e67223b693a313b733a31383a22757365725f72656769737465725f666f726d223b623a303b7d733a373a22646973706c6179223b613a323a7b733a373a2264656661756c74223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a31323a22746578745f64656661756c74223b733a383a2273657474696e6773223b613a303a7b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d733a363a22746561736572223b613a353a7b733a353a226c6162656c223b733a363a2268696464656e223b733a343a2274797065223b733a32333a22746578745f73756d6d6172795f6f725f7472696d6d6564223b733a383a2273657474696e6773223b613a313a7b733a31313a227472696d5f6c656e677468223b693a3630303b7d733a363a226d6f64756c65223b733a343a2274657874223b733a363a22776569676874223b693a303b7d7d733a383a227265717569726564223b623a303b733a31313a226465736372697074696f6e223b733a303a22223b7d, 0);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_body`
--

CREATE TABLE IF NOT EXISTS `field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 2 (body)';

--
-- Dumping data for table `field_data_body`
--

INSERT INTO `field_data_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 2, 2, 'und', 0, 'With this book you will learn how to maximize and optimize your Drupal 6 framework using best practice performance solutions and tools.  The book covers how to vastly improve performance through upgrades, caching, configuring and optimization using core and contributed modules.\r\n\r\nAs a reader of drupal.org, you can receive a 15% discount (see below) and benefit the Drupal Association!\r\n\r\n<h2>Some of what you will learn</h2>\r\n\r\n<ul>\r\n<li> Upgrade your Drupal 5 site to Drupal 6 using best practice upgrade paths</li>\r\n<li> Back up and maintain your Drupal 6 site using core and contributed modules and utilities</li>\r\n\r\n<li> Configure the Drupal core and contributed modules for high traffic</li>\r\n<li> Run core Drupal page compression, CSS and JS compression, and use Drupal page caching</li>\r\n<li> Run scheduled cron tasks to perform crucial garbage-collection processes</li>\r\n<li> Use the Development (Devel) module to monitor page loads and queries</li>\r\n<li> Use the Boost module for anonymous page caching, tweak Boost settings, and use Boost blocks and advanced Boost settings to monitor site performance</li>\r\n<li> Install and use Memcache API and Integration module, and Authcache and Advanced Cached modules to enhance and monitor site performance</li>\r\n\r\n<li> Configure a Drupal multisite environment for best performance</li>\r\n</ul>\r\n<h2>About the Book</h2>\r\n\r\nDrupal is one of the most respected and widely used open source content management frameworks.  Small, medium, and large-scale websites are built using Drupal and the framework supports e-commerce, CRM, multisite and web service integrations.\r\n\r\nOnce you get your Drupal site installed and up and running, you will be concerned with site performance and how fast you can make your Drupal site run.  This book will focus on implementing performance modules and solutions to help speed up your Drupal website.\r\n\r\nWe will look at introductory topics such as upgrading your Drupal site, maintaining your site, and enabling core Drupal page compression and caching.\r\n\r\nThen we will turn to an advanced look at some contributed modules that help speed up performance, including Development, Boost, Authcache, Advanced Cache, and the Memcache API and Integration module.\r\n\r\nFinally, we?ll look at how best to implement a Drupal multisite environment and run it with high-speed performance in mind.\r\n\r\n<h2>Get 15% off!</h2>\r\n\r\nI have secured an exclusive 15% discount for you when you buy through <a href="http://www.packtpub.com/">PacktPub.com</a>.  Enter the following discount code at checkout in the shopping cart:  Drupal6PT15 (case sensitive). As with all of Packt?s Drupal books, Packt will be donating a percentage of its sales to the Drupal Association.\r\n\r\n<h2>Want a Sample?</h2>\r\nTo help promote the content provided within this book, Packt is generous enough to provide sample content of what you can expect from reading this book.\r\n\r\n<ul>\r\n<li> <a href="http://www.packtpub.com/article/drupal-6-performance-optimization-using-views-panels-caching">Article: Drupal 6 Performance Optimization Using Views and Panels Caching</a></li>\r\n</ul>\r\n<h2>About the authors</h2>\r\n\r\n<strong>Trevor James</strong><br>\r\nTrevor James (<a href="http://drupal.org/user/720820">trevorjames</a>) is a Drupal developer and web designer based in Middletown, MD, USA. Trevor has been designing websites for 13 years using a combination of HTML, XHTML, CSS, and ColdFusion. He has been using Drupal intensively for more than 2 years. Trevor''s focus is on building web portals for higher education, public education (K-12), non-profit, and small business environments. He is interested in the best methods of developing Drupal themes, Drupal site performance, and using CCK, Views and Panels to develop front-end interfaces to support data-intensive websites. He loves teaching people about Drupal and how to use this excellent open source content management framework. He is also a contributor and community member on drupal.org and related Drupal community projects.\r\n\r\n<strong>TJ Holowaychuk</strong><br>\r\nTJ Holowaychuk (<a href="http://drupal.org/user/78427">tjholowaychuk</a>), president of Vision Media, is an avid contributor to the Drupal project as well as to other open-source applications. Contributing over 16 Drupal modules, several themes, and having fully designed, developed, and maintained hundreds of Drupal websites, he has displayed a wealth of knowledge across different aspects of the industry.', '<a href="http://www.packtpub.com/drupal-6-performance-tips-to-maximize-and-optimize-your-framework/book?utm_source=drupal.org&amp;utm_medium=link&amp;utm_content=pod&amp;utm_campaign=mdb_002452">Drupal 6 Performance Tips</a>, by Trevor James and TJ Holowaychuk, is a newly-published title from Packt Publishing aimed at Drupal beginners, developers, designers, and webmasters who utilize the Drupal content management system to create robust websites.\r\n\r\nIt provides crucial performance-related information for Drupal users of all experience levels, including module contributors, webmasters who simply configure and maintain Drupal websites, and even themers. The book contains basic and advanced topics on Drupal performance that will appeal both to the Drupal novice and the advanced user or developer. ', 'full_html'),
('node', 'article', 0, 3, 3, 'und', 0, 'Core Conversations are a place for people actively working on Drupal or Drupal.org to meet and plan the future of Drupal (Drupal 8). We will announce selected Core Conversation sessions on 22 July 2011.\r\n\r\nWe remind you that we have some excellent pre-conference training courses and workshops scheduled for 22 August 2011 and invite you to register for these. This is a great opportunity for Drupalists at all levels of experience to learn from the experts.\r\n\r\nThe cost for a full day training varies from only Ãƒâ€šÃ‚Â£150 for the Absolute Beginner''s Guide to Drupal to Ãƒâ€šÃ‚Â£325 for advanced topics like Building Modules for Drupal 7 and Drupal Powered E-Commerce.\r\n\r\nDemand for Drupal talent is high, so why not invest in your future!\r\n\r\nRegister now to attend DrupalCon London and for pre-conference training.\r\n\r\nIf you would like to support DrupalCon London and help us spread the word about the conference. Here you can get badges for your website and promote the conference via our Twitter and Facebook widgets.\r\n\r\nSee you at DrupalCon London 22-26 August 2011!\r\n\r\nStay up-to-date with the latest information about DrupalCon London by going to http://london2011.drupal.org/ or following us on Twitter @drupalcon.', 'The DrupalCon London Team had the task of narrowing 341 fantastic proposals into a schedule of 60 sessions, balanced across 5 tracks: Site Building and Environment Set-up, Business and Best Practices, Code & Coders, Design, UX & Theming, and Ecosystem. You can check out the schedule now and attendees will be able to build their schedule on the DrupalCon London site by logging in later this week.\r\n\r\nThis breaks down to 5 tracks with 12 sessions each. The 6th track, Core Conversations, will also have 12 sessions slots available and DrupalCon London will be opening core conversation session proposals between 14 June and 14 July 2011, 23:59 GMT+1. ', 'full_html'),
('node', 'article', 0, 4, 4, 'und', 0, 'Of course, we have the most comprehensive film tax credit in the nation (films, commercials, new media, video games) and our Education Director is the head of the state-funded Film Industry Training Program.\r\n\r\nThe focus for New Media programs this year is Free Software, Web/New Media, Animation, Music and Advocacy. We are further sharing 1/3 of our curriculum with Film and Education.\r\n\r\nPlease email and/or call me if you are interested in helping us. The festival is May 4-9 and ours is May 6-9. I will know more at our next meeting about exact scheduling.\r\n\r\nWe aren''t a rich festival, therefore we cannot pay anyone, but we are only 65 miles from NYC on Metro North and we can cover your hotel room as long as you wish to stay as well as give you an All Access Pass for the week.\r\n\r\nLooking forward to chatting.\r\n\r\nDave Bonan\r\nDirector of New Media Programming, CT Film Festival\r\nwww.ctfilmfest.com\r\n203.770.8304', 'I''m the Director for New Media Programming at the CT Film Festival in Danbury, CT and I wanted to see if any Drupal demonstrators would like to teach a workshop at his/her discretion. We have a speaker doing a Social Media 2.0 Workshop as well as a CMS overview with Drupal, Joomla and Wordpress.\r\n\r\nFirst off, our independent festival is 6 years old and quickly growing. We are unique in that we are an 8-month traveling festival within the state, providing weekend and weekday performances at universities and theaters and then ending with a weeklong series of events in early May (over 300 films, workshops, performances and parties).', 'full_html'),
('node', 'article', 0, 5, 5, 'und', 0, 'Hello Drupalers!\r\n\r\nNetBeans 6.5 Release Candidate is out (with right PHP editing features : http://www.netbeans.org/kb/trails/php.html) and along with that I have released an update to the existing Drupal support in NetBeans. Please feel free to try out the enhanced wizard for assisting Drupal module development.\r\n\r\nThe modifications in the plugin are :\r\n* Generates the new module in appropriate location\r\n* Sticking to Drupal coding standards, generates template code for some of the common hooks (hook_block and hook_help) in the .module file\r\n* Sticking to Drupal coding standards, generates the .install file, which when not required can be removed. Some template code for some common hooks (hook_install and hook_uninstall) are provided.\r\n\r\nYou can download the plugin from NetBeans plugin portal (http://plugins.netbeans.org/PluginPortal/faces/PluginDetailPage.jsp?plug...) or from project page (https://nbdrupalsupport.dev.java.net/servlets/ProjectDocumentList?folder...). The source and documentation concerning usage of the plugin is hosted at the latter site.\r\n\r\nComments welcome!\r\n\r\nRegards,\r\nSujit Nair', '', 'filtered_html'),
('node', 'article', 0, 6, 6, 'und', 0, 'Besides the Handbook on drupal.org, there is also some Drupal documentation that is embedded in the Drupal source code, and visible from the administration pages of a Drupal site. This includes help pages for modules, help text displayed at the top of administration pages, and descriptive text within administration pages (e.g. help text for a setting field).\r\n\r\nBecause embedded documentation is part of the Drupal source code, the process for helping out with writing and editing this embedded documentation is slightly more complex than for editing pages on drupal.org. Here are some ways to help out:\r\n\r\nTest Drupal for text issues: During the development of a new Drupal version, download the new version from http://drupal.org/project/drupal, install it, and look over the help screens and user interface text. If you find something that should be fixed in a help screen or other embedded help text, file an issue: Even if you do not know how to create a patch, you can still give before/after text suggestions, and someone else can create the patch. To file an issue:\r\n\r\n<ol>\r\n<li>Log in to drupal.org</li>\r\n<li>Create an issue via the Create Content link (<a href="http://drupal.org/node/add/project-issue" title="http://drupal.org/node/add/project-issue" rel="nofollow">http://drupal.org/node/add/project-issue</a>)</li>\r\n<li>Choose "Drupal" as the project</li>\r\n<li>Choose the Drupal version. Note that it''s really only possible to change user interface text, help text, and other explanations in the version of Drupal that is under development. Stable releases have been translated into other languages, so their user interface text is almost never changed.</li>\r\n<li>Choose component "documentation" if the issue is in a help screen, or "user interface text" if it is user interface text, or choose the module that the issue pertains to as the component.</li>\r\n<li>Tag the issue with "ui-text" or "Help text" as appropriate.</li>\r\n<li>Choose category "bug report" -- text being wrong, missing, or unclear is a bug, not a feature request or task.</li>\r\n\r\n<li>Make up a clear title and description, and submit your issue.</li>\r\n</ol>\r\n\r\nHelp with existing issues: Use the advanced search for issues in the Drupal project (http://drupal.org/project/issues/search/drupal), and look for component "documentation" or "user interface text", or search for tags "Help text" or "ui-text". Be aware that most of the issues filed under component "documentation" are issues with the in-line programmer API documentation of functions in the source code (displayed on api.drupal.org), so if you are not a programmer, these will not be things you will probably want to work on. Even if you cannot write patches, you can still review patches and make suggestions on how to improve text, by commenting on issues. Some tips on using the issue queue:\r\n\r\n<ul>\r\n<li>Look for issues whose status is "active" or "needs work" if you want to write some documentation or code. Look for "needs review" issues if you want to review what others have done (an excellent place to start if you are new to Drupal issues, and a vitally important part of the process).</li>\r\n<li>Even if you are not a programmer, you can still review patches. Find an issue that has status "needs review", scroll down to the bottom of the issue''s comments, and find the latest patch attachment. Click on the attachment to see it. The lines with + are being added, lines with - are being removed. Some patches will also have a screen shot, making reviewing even easier.</li>\r\n<li>If you think a patch is good, add a comment saying what part you reviewed and that you thought it was good. If you think your review was comprehensive, or if several people have commented that it''s a good patch and you think the coverage overall is comprehensive enough, change the issue''s status to "Reviewed and tested by the community" (also known as "RTBC").</li>\r\n<li>If you think a patch needs some work, change the status of the issue to "needs work", and add a specific comment about what you think should be changed (if possible, with a suggestion of what to change it to). Please try to be constructive.</li>\r\n<li>If the issue you are looking at doesn''t yet have a patch, you can either make one or add suggestions as to what the text should say (someone else can read your suggestions and make a patch). If you attach a patch file, be sure to change the status of the issue to "needs review" so others can test and review your patch.</li>\r\n<li>And above all: Don''t take anything in the issue queue personally! The intent of the issue queue is to provide a forum for discussion on how to make Drupal better, so try to take any comments on your patches as constructive comments and thoughtful discussion (even if not everyone writes their comments in this way).</li>\r\n</ul>', '', 'full_html'),
('node', 'article', 0, 7, 7, 'und', 0, 'Hello,\r\n\r\nTwo months ago, a case study about the migration of France 24 from Drupal 5 to Drupal 6 was posted on drupal.org frontpage, and it was announced some really interesting modules were going to be open sourced.\r\n\r\nI''m happy to say it is (almost?) finished, and here is the list of modules:\r\n\r\n<ul>\r\n<li><b><a href="http://drupal.org/project/aef_multimedia_element" rel="nofollow">Multimedia Element</a>:</b> It allows you to create blocks (not drupal blocks) containing stories (inserted manually, automatically, semi-automatically with Easy View), carousels of stories, text, photos, diaporamas (including lightbox diapos), video, twitter, table, ... And you can embed these blocks directly into your story with a nifty FckEditor plugin. Here is a <a href="http://www.france24.com/en/20091116-obama-shanghai-students-speech-china-usa-relations-diplomacy-asia-economy" rel="nofollow">nice example of story with a carousel, a diaporama and a video multimedia element</a>.</li>\r\n<li><b><a href="http://drupal.org/project/aef_easy_view" rel="nofollow">Easy View</a>:</b> Easy View is a very easy and powerful interface framework to Views, in a CCK field. It also include Easy View Taxonomy, the easy view implementation of the taxonomy View. It basically allows a simple user to configure a View per node without using the complex View UI.</li>\r\n<li><b><a href="http://drupal.org/project/aef_image" rel="nofollow">Uberimage</a>:</b> Uberimage is an advanced image CCK field, with direct upload/nodereference support, result imagecache presets re-scaling and cropping, useful on websites with multiple different image ratio (16/9, 4/3, 16/5, ...)</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_formatter_selector" rel="nofollow">Formatter Selector</a>:</b> Ever wanted to let the user choose the theme of a node in a nodereference directly on the node edit page? This module allows you to do that.</li>\r\n<li><b><a href="http://drupal.org/project/aef_external_sources" rel="nofollow">External Sources</a> / <a href="http://drupal.org/project/aef_externodes" rel="nofollow">Externodes</a>:</b> Basically, this module allows you to map the nid and fid address space to another Drupal instance. A simple example: Given you have two drupals, if you type in your browser front.drupal.com/node/1000000001, it will in fact display the node 1 of back.drupal.com using front.drupal.com theme. back.drupal.com is nowhere visible to the end user. Basic example of use: A big image collection you want to share between drupals.</li>\r\n<li><b><a href="http://drupal.org/project/aef_nodeselect" rel="nofollow">Nodeselect</a>:</b> Nodeselect allows editors to search for content, in a simple exposed View integrated with Embedded Edit, and results can be drag and dropped into nodereferences.</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_embedded_edit" rel="nofollow">Embedded Edit</a>:</b> Embedded Edit allows you to create/view/edit a node in a kind of lightbox within a node edit page. When creating a node, a nodereference will get filled with this node.</li>\r\n<li><b><a href="http://drupal.org/project/aef_views_cck_formatter" rel="nofollow">Views CCK Formatter</a>:</b> Views CCK Formatter allows you to choose a node CCK formatter as a row style in your View. This is extremely useful when you want to reuse a node theme in different parts of your website.</li>\r\n<li><b><a href="http://drupal.org/project/aef_table" rel="nofollow">CSV Table</a>:</b> CSV table is a very simple table module that allows you to upload a CSV file in this CCK field, and display a table. This module will probably evolve a lot in the future.</li>\r\n<li><b><a href="http://drupal.org/project/aef_jcarousel_views" rel="nofollow">JCarousel for Views</a>:</b> JCarousel for Views is a simple module for using JCarousel in Views.</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_jcarousel" rel="nofollow">JCarouself formatter framework</a>:</b> JCarousel formatter framework contains the JCarousel plugin plus a node CCK Formatter &lt;-&gt; JCarousel theme relationships framework.</li>\r\n<li><b><a href="http://drupal.org/project/aef_utilities" rel="nofollow">Utilities</a>:</b> An utilities modules used by all the above modules.</li>\r\n</ul>\r\n\r\nSorry, no pictures :( You can find them here or directly on the module project page.\r\n\r\nConcerning theming, the France24 and RFI websites are heavily based on the standard CCK nodereference formatters, that''s why almost all these modules are using it. I''ll probably make some doc on how to combine all these modules later.\r\n\r\nCheers,\r\nNicolas', '', 'filtered_html'),
('node', 'article', 0, 8, 8, 'und', 0, 'Drupal 7.3, a maintenance release which fixes security vulnerabilities is now available for download.\r\n\r\nDrupal 7.4 also fixes other issues reported through the bug tracking system.\r\n\r\nUpgrading your existing Drupal 7 sites is strongly recommended. There are no new features in these releases. For more information about the Drupal 7.x release series, consult the Drupal 7.0 release announcement.\r\n\r\n<h2>Security information</h2>\r\n\r\nWe have a security announcement mailing list, a history of all security advisories, and an RSS feed with the most recent security advisories. We strongly advise Drupal administrators to sign up for the list.\r\n\r\nDrupal 7 includes the built-in Update status module, which informs you about important updates to your modules and themes.\r\n\r\n<h2>Bug reports</h2>\r\n\r\nDrupal 7.x is being maintained, so given enough bug fixes (not just bug reports), a new maintenance release will be made available the last Wednesday of next month (July 27).\r\n\r\nDrupal 7.3 only includes fixes for security issues. Drupal 7.4 also includes bugfixes. The full list of changes between the 7.2 and 7.4 releases can be found by reading the 7.4 release notes. A complete list of all bug fixes in the stable 7.x branch can be found in the git commit log.\r\n\r\n<h2>Security vulnerabilities</h2>\r\n\r\nDrupal 7.3 was released in response to the discovery of security vulnerabilities. Details can be found in the official security advisory: SA-CORE-2011-002\r\n\r\nTo fix the security problem, please upgrade Drupal.\r\n\r\n<h2>What is included with each release?</h2>\r\n\r\nShows a graph and that 7.3 should be used to upgrade quickly, 7.4 contains bug fixes and might need testing.\r\n\r\nWe make two versions of Drupal core available, so you can choose to only include security fixes (Drupal 7.3) or security fixes and bugfixes (Drupal 7.4). You can choose your preferred version. We are trying to make it easier and quicker to roll out security updates by making security-only releases available as well as ones with bugfixes included. We hope this helps you roll out the fixes as soon as possible. Read more details in the handbook.\r\n', 'Drupal 7.3, a maintenance release which fixes security vulnerabilities is now available for download.\r\n\r\nDrupal 7.4 also fixes other issues reported through the bug tracking system.\r\n\r\nUpgrading your existing Drupal 7 sites is strongly recommended. There are no new features in these releases. For more information about the Drupal 7.x release series, consult the Drupal 7.0 release announcement.', 'filtered_html'),
('node', 'page', 0, 9, 9, 'und', 0, '<p>Quisque mi turpis, lobortis sit amet placerat ut, auctor nec metus. Sed iaculis nisl sed nibh laoreet vitae interdum sapien suscipit. Duis sit amet nulla sit amet urna molestie tempus. Sed cursus tellus at eros imperdiet euismod. Praesent sodales commodo gravida. Quisque sit amet dapibus metus. Nam mattis turpis consequat lorem iaculis tempus. Phasellus quam mauris, volutpat vel scelerisque ac, elementum in velit! Praesent vehicula orci id odio aliquet pulvinar? Mauris est tellus, tempor sit amet semper eget, pulvinar ac eros. Nunc ultrices ornare tortor a egestas. Cras fermentum diam cursus dolor molestie quis congue velit sagittis? Sed a dapibus diam. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Donec eu odio nulla, vitae cursus neque?</p>\r\n<p>Sed quis erat nulla; et semper tortor. Integer ac diam massa, at lobortis neque! Nulla facilisi. Pellentesque blandit aliquam metus, id consectetur diam suscipit ac! Aliquam erat volutpat. Vestibulum at placerat metus! Mauris ullamcorper sagittis magna et varius. Curabitur fermentum dictum massa eu vestibulum. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos orci aliquam.</p>\r\n<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'blog', 0, 10, 10, 'und', 0, 'Welcome to Drupal! Drupal is a powerful content management system, meaning you can power many different types of websites with it without knowing any coding languages.\r\n\r\nIf you''re new to Drupal or having your own website, then this guide is for you.\r\n\r\nThe following pages should introduce you to the Drupal project, some best practices the community has accumulated, the concepts and technologies that underpin Drupal, and basic installation and configuration.\r\n\r\nThe Drupal documentation is currently being restructured. Some content has been moved to the Administration Guide, Structure Guide and Site Building Guide.\r\n\r\nIf you need help installing Drupal, the Installation Guide has step by step instructions and troubleshooting tips.', '', 'filtered_html'),
('node', 'blog', 0, 11, 11, 'und', 0, 'The Drupal Cookbook (for Beginners) helps Drupal "newbies" by providing a walkthrough of a common Drupal Setup. You might also be interested in this whirlwind video.\r\n\r\n<h2>Background</h2>\r\n\r\nThis handbook was originally written for Drupal 5. While the information is generally transferable to Drupal 6, some buttons, links, and menu items have been renamed or moved. Every attempt is made to keep these handbooks current.\r\n\r\nThe intent of the Cookbook is to help the new Drupal user create a typical site. At that point the user will be better equipped to diving deeper into more advanced features.\r\n\r\n<h2>Terminology</h2>\r\n\r\nThis cookbook requires a basic understanding of the General Concepts of Drupal. Additional resources for understanding terms used in Drupal include:\r\n<ul>\r\n    <li>Terminology (Terms).</li>\r\n   <li>Drupal Jargon.</li>\r\n</ul>\r\n\r\n<h2>Conventions</h2>\r\n\r\nThe Cookbook and other documentation on drupal.org uses the following standard for indicating site navigation:\r\n\r\nAdminister >> Access control >> User management >> Roles.\r\n\r\nThe above example tells the user to click on "Administer" in the navigation menu, then "Access control," then "User management," and then "Roles".\r\nWorking with Drupal\r\n\r\nHere are some general recomendations:\r\n\r\n<ol>\r\n    <li>Use a test site that uses the same Drupal version and modules as the target site. Use a copy of the live database. Avoid development on a live site.</li>\r\n    <li>Don''t try to make the "perfect site" on the first attempt. Muddle through for a while. Stressing over the perfect solution can lead to frustration.</li>\r\n    <li>Start by learning the basic functionality of Drupal. Find out what Drupal can do before working towards a specific goal. Once comfortable with the "core" features and behavior, move on to more complex contributed modules such as Views, CCK, and Organic Groups. These modules and some others require a good bit of understanding to master. The power and flexibility of Drupal and its modules will become apparent over time.</li>\r\n    <li>If you need a custom theme, customize one of the default themes before creating starting from scratch. Refer to the Drupal 5 theme guide or Drupal 6 theme guide.</li>\r\n   <li> Limit the number of blocks, images, and graphics that clutter the page.</li>\r\n    <li>Participate in the forums, the Documentation Team, and IRC.</li>\r\n</ol>\r\n\r\n<h2>Things to keep in mind</h2>\r\n\r\nA common mistake when approaching a solution to a problem in Drupal is to make an assumption about how Drupal works. Drupal is a unique and powerful platform that is probably quite different from other solutions you may have encountered.\r\n\r\nStart simply by making something visible, then celebrate what you have accomplished. Taking one small step at a time will lead to a better site. Don''t indiscriminately add many contributed modules right away. Get comfortable with modules one at a time. Modules that are not appropriate or used should be disabled and uninstalled.\r\n\r\nAs with most things worth mastering, there is a learning curve with Drupal. But there is lots of support available as well.', '', 'filtered_html'),
('node', 'blog', 0, 12, 12, 'und', 0, 'After Drupal was initially developed, thoughts turned to the creation of a logo. Of course the concept would have to include a drop, or water in general.\r\n\r\nThe initial idea was simple: a drop within a circle. It was conceived as an "O" in a fluid "drop".\r\n\r\nSomewhat later there was an idea to use a cartoon-like drop with a face. Steven Wittens (UnConeD) created a 3D version, but the idea didn''t get too far, mainly because 3D is difficult to work with.\r\n\r\nWhen the logo issue came up again, Kristjan Jansen (Kika) came up with the idea of putting two sideways drops together to form an infinity symbol. When placed inside a filled circle, it resembled a face. After more work by Steven Wittens, the Druplicon was created: a stylised drop with the "infinity" eyes, a round nose and a mischievous smile.\r\n\r\nYou can find more versions of the logo in the marketing section.', '', 'filtered_html'),
('node', 'blog', 0, 13, 13, 'und', 0, 'As an inclusive community, we are committed to making sure that Drupal is an accessible tool for building websites and that Drupal helps you create websites that are themselves accessible.\r\n\r\nThis initiative started with advancements with Drupal 7 accessibility. We have committed to ensuring that all features of Drupal core conform with the Worldwide Web Consortium (W3C) guidelines: WCAG 2.0 and ATAG 2.0. Where possible we will also update the previous version of Drupal core, version 6, to enhance its accessibility.\r\nAccessible Features in Drupal\r\n\r\nIf you rely on a screen reader or other assistive technology, you will be glad to know that we have built Drupal to encourage and support the proper use of semantic markup. For example, you should be able to use headings reliably for page-level navigation.\r\n\r\nThe accessibility team has worked to identify barriers to accessibility with Drupal and worked to resolve them. We''ve identified and resolved a number of issues in the core code of Drupal 7 and raised awareness within the community. We''ve added some additional support for Rich Internet Applications by adding some WAI-ARIA support. There have been many improvements to both the visitor and administrator sides of Drupal, especially:\r\n\r\n<ul>\r\n   <li>Search engine form and presentation</li>\r\n    <li>Drag and Drop functionality</li>\r\n   <li>Color contrast and intensity</li>\r\n    <li>Adding skip navigation to core themes</li>\r\n    <li>Image handling</li>\r\n    <li>Form labeling</li>\r\n    <li>Removing duplicate or null tags</li>\r\n</ul>', '', 'filtered_html'),
('node', 'forum', 0, 16, 16, 'und', 0, 'For information on managing the ongoing operation of a Drupal site, see the Administration Guide. For information on developing the basic information architecture using menus, taxonomies, blocks etc, see the Structure Guide.', '', 'filtered_html'),
('node', 'forum', 0, 17, 17, 'und', 0, 'I''m having a problem updating several modules in Drupal 6. I put the site off line and then uploaded the latest modules via ftp as is my usual practice. I rename the directory of the module to be updated to "moduleJan2012" and put the new module folder in its place.\r\n\r\nI then ran update.php and when I check the modules are still showing as out-of-date.\r\n\r\nThe problem modules are Google analytics, wysiwyg, imce and webform. webform validator and root candy theme updated okay.\r\n\r\nI''ve since uploaded the module again to see if this helps but it didn''t. On the server it''s showing that the files were updated.\r\n\r\nMany thanks in advance for any suggestions', '', 'filtered_html'),
('node', 'forum', 0, 18, 18, 'und', 0, 'What would be a best way to launch a simple Drupal web site on AWS?\r\nI''ve just started learning AWS. So far, from what I have learned, I can go either of the following ways.\r\n1. Create an EC2 instance, install xampp and drupal, and keep developing web pages and web apps in EC2.\r\nI''ve done this, but I have not figured out how to make the web site accessible. (Do I need to setup elastic IP?)\r\n\r\n2. Install Drupal on a local machine and develop all web pages and apps locally. And then upload all local files to S3.\r\nThen, is S3 enough to host a web site? EC2 instance is not needed?\r\nAlso, who would I manage the upload for constant updates on Drupal modules and Drupal DB?\r\n\r\nWell, I need to dig more into EC2 and S3, but your input would be highly appreciated.', '', 'filtered_html'),
('node', 'forum', 0, 19, 19, 'und', 0, 'I updated Pixture reloaded theme before updating everything okay,but after updating it the look of the website changes,WHATS THE PROBLEM?? How can I edit pixture reloaded theme to its previous look.\r\nNo Database backup is taken. Only Drupal files have backup.\r\n\r\n', '', 'filtered_html'),
('node', 'forum', 0, 20, 20, 'und', 0, 'See the phpinfo() page on Drupal.org to learn how to use phpinfo to get the details of your system. For example, phpinfo will tell you if you have a database already installed and what versions of PHP, MySQL, etc. your system is running. Phpinfo will also tell you what PHP variables are set as well as many other helpful things.', '', 'filtered_html'),
('node', 'forum', 0, 21, 21, 'und', 0, 'For all the effort you put into building your site, the most important thing to your users is how your site looks. Managing the inconsistencies in your theme for each browser, for each module, and for user selectable themes can be very challenging.\r\n\r\nFirst you should familiarize yourself with basic Cascading Style Sheets (CSS) concepts. Review CSS Discuss or HTML dog for CSS resources. A good overview of the power of CSS can be seen at the CSS Zen Garden.', '', 'filtered_html'),
('node', 'product', 0, 47, 47, 'und', 0, 'Capto comis esse ex importunus neque probo quis tation wisi. Abbas bene natu pertineo praesent.\r\n\r\nAccumsan antehabeo commodo ideo jus occuro paratus praemitto quidem turpis. Facilisi facilisis quidne scisco tincidunt. Abbas autem ex facilisi in neo nibh quadrum ullamcorper. Abdo at facilisi tation. Amet ideo neo pala. Abluo esse et ideo jumentum lenis mauris mos occuro wisi.\r\n\r\nComis feugiat macto metuo odio quidem sagaciter veniam vulpes. Amet importunus jumentum occuro os velit. Caecus capto dignissim ea facilisi natu nostrud si vero. Acsi consequat genitus inhibeo quae refero zelus. Et feugiat gilvus illum inhibeo modo nutus roto tum ymo. Abigo dolus lenis nostrud singularis sino suscipere turpis typicus.\r\n\r\nCamur nutus uxor wisi. Decet facilisi iriure ludus. Meus secundum tamen. Nimis scisco suscipere. Eros haero pagus. Aliquip capto lenis meus nibh scisco tum zelus. Consectetuer esse illum nisl nulla obruo refoveo scisco sed suscipit.\r\n\r\nAbico elit populus suscipit. Antehabeo appellatio eros esse melior nimis nobis pala refoveo verto. Accumsan appellatio capto enim letalis lucidus. Brevitas diam eros esca hos letalis. Fere humo immitto macto mos neo nibh quae quidem quidne. Abdo gilvus neque odio persto qui quibus roto si. Acsi elit haero magna volutpat. Dolore venio verto.\r\n\r\nConsectetuer suscipit veniam. Hos ibidem nisl. Antehabeo sudo torqueo. Ibidem nibh secundum sed tum. Camur hos lenis scisco torqueo. Ea exerci huic lobortis magna nostrud probo refero rusticus. Appellatio caecus distineo duis fere ideo nisl nutus vulpes. Commodo gilvus iaceo ideo incassum torqueo zelus. Caecus exputo iriure iustum lucidus macto nisl. Abico comis gemino premo. Genitus haero laoreet modo qui te vulputate wisi.\r\n\r\nBrevitas dolor erat loquor olim probo. Gravis laoreet pala paulatim quidne sudo venio. At dolor gemino mos refoveo saepius sudo tum valde vulpes. Acsi dignissim gemino hendrerit lobortis nimis nostrud pagus quidem valde. Aptent eros iusto meus quadrum saluto utinam vereor. Distineo os sagaciter usitas validus virtus zelus.\r\n\r\n', '', 'full_html'),
('node', 'product', 0, 52, 52, 'und', 0, 'Hos mos sagaciter. Augue commoveo macto pala sudo suscipit ymo. Iusto macto singularis suscipere. Abbas aliquip commodo distineo illum refoveo sudo suscipit ullamcorper valetudo. Appellatio commoveo cui esca incassum loquor nimis pecus pertineo proprius.\r\n\r\nDignissim dolus nobis suscipit volutpat. Ea hendrerit validus. Acsi illum importunus plaga suscipere. Caecus comis facilisis plaga premo saepius ulciscor. Caecus comis eros hendrerit plaga praesent uxor validus. Enim feugiat gemino premo sagaciter ut vel.\r\n\r\nDistineo dolus ea esse exputo jumentum populus. Aliquam at capto commoveo odio pertineo te tego. At inhibeo neo probo. Haero ille immitto loquor metuo premo ratis validus. Conventio cui humo mauris melior pertineo roto utinam. Fere iriure mauris praemitto quidne validus.\r\n\r\nAdipiscing amet eu eum neo paulatim. Abigo comis dolus feugiat paulatim quia vel vulputate. Accumsan inhibeo sino wisi.\r\n\r\nCamur cui diam huic laoreet voco. Amet at comis ideo imputo luptatum persto valetudo. Abigo minim molior obruo pagus pala paratus quis.\r\n\r\nEsca illum lobortis. Brevitas caecus capto dolore minim molior mos quidem ulciscor ymo. Dolore hos importunus jumentum nibh qui quibus sagaciter. Dignissim incassum proprius secundum vel. Abico jugis olim praesent refero tum ut vulpes zelus. At blandit defui imputo ullamcorper usitas valetudo.\r\n\r\nCogo defui ea inhibeo ludus pertineo utrum. Adipiscing elit ille in incassum magna neque ullamcorper vero. Blandit brevitas enim feugiat lucidus venio voco. Luptatum mos nulla nunc pertineo refero vulpes. Haero oppeto tamen zelus. Amet immitto iustum neo olim similis sit vereor wisi. Dolus duis nisl. Defui dolus ea euismod similis uxor.\r\n\r\n', '', 'plain_text'),
('node', 'product', 0, 53, 53, 'und', 0, 'Comis patria tum vel. Accumsan commoveo verto. Illum suscipere tum. Diam dolore modo nibh odio sed. Ea gravis illum modo nobis nulla pecus suscipit tation. Haero huic modo nibh quibus quidne saluto secundum ullamcorper. Appellatio duis exputo haero importunus modo plaga ullamcorper. Iustum lenis mos patria sudo. Aliquip comis enim fere hendrerit quadrum. Dolus importunus inhibeo.\r\n\r\nAd commoveo quia usitas. Euismod inhibeo roto. Abico esse et in quae refero secundum turpis. Abico antehabeo macto. Facilisi facilisis inhibeo luptatum praesent refoveo vicis. Dolor interdico patria praemitto. Abdo haero ibidem lucidus sudo ut uxor virtus vulputate zelus. Aptent capto eros fere laoreet lucidus luctus minim vulputate wisi. Iusto tamen voco. Aliquam antehabeo aptent eum jumentum luctus meus neo tamen turpis.\r\n\r\nQuae suscipit volutpat. Diam eros illum jumentum mauris neo persto plaga valetudo. Camur comis cui in suscipit veniam volutpat vulpes wisi. Luctus olim quidne venio. Aliquip incassum lobortis. Diam jumentum loquor macto odio velit. Aptent ideo nisl pagus pneum tamen tation velit. Antehabeo loquor minim modo persto premo sudo ullamcorper vulpes.\r\n\r\nEuismod gemino illum in meus pala suscipere virtus. Eligo eum facilisis iusto praesent quis usitas. Bene brevitas eu molior validus verto. Caecus cogo exputo facilisi loquor natu ullamcorper valetudo vero vindico.\r\n\r\nConventio loquor neque nutus occuro persto qui quidne secundum ullamcorper. Accumsan ea et imputo lenis macto pecus vel. Abbas iusto modo persto refoveo te uxor voco. Abico abigo meus minim. Abico autem commodo meus torqueo. Erat metuo olim.\r\n\r\n', '', 'plain_text'),
('node', 'product', 0, 54, 54, 'und', 0, 'Eum iaceo praemitto vereor. At melior pagus vulputate. Adipiscing antehabeo dolore fere importunus jumentum persto praemitto wisi. At brevitas duis. Abdo aptent elit laoreet proprius sagaciter sed uxor. Antehabeo dolore metuo. Distineo erat neo obruo pagus quis. Eligo in tum. Abigo magna tincidunt tum usitas. Accumsan lobortis saepius tamen.\r\n\r\nAt bene feugiat ideo torqueo. Abluo ad erat immitto meus nostrud nulla sagaciter wisi. Antehabeo bene gravis humo ideo laoreet tincidunt. Lobortis lucidus natu paratus plaga quae suscipit. Abico brevitas importunus typicus.\r\n\r\nCausa consequat lucidus metuo sagaciter ulciscor wisi. Hendrerit immitto iusto nisl paratus populus premo quae sudo.\r\n\r\nConsectetuer metuo wisi ymo. Blandit elit saluto valde. Obruo proprius utrum. Accumsan dolore magna ratis tamen.\r\n\r\nCamur haero importunus ludus nobis quis vero. Accumsan acsi adipiscing comis dolus gravis nulla. Comis illum vel. Ad augue dolus iriure jumentum ludus meus natu refero vulputate. Abdo camur damnum illum magna obruo paulatim ulciscor validus.\r\n\r\nCapto et neque persto pertineo quidne si velit. Comis jus molior valde valetudo veniam. Pagus sagaciter utrum. Abbas abluo decet dolus duis eu exputo os ut vel. Abico ea erat obruo ymo. Abigo ille melior nostrud paratus tation usitas voco vulpes. Cogo dignissim distineo dolore euismod imputo jus premo sino verto. Amet duis esse iustum jus ludus natu qui venio.\r\n\r\nAcsi elit eum gravis sino vindico. Abluo ibidem loquor luptatum nimis nobis praesent quae similis. Olim turpis vulpes. Camur conventio eu te. Conventio diam imputo melior praemitto usitas virtus. Antehabeo comis conventio decet persto premo ratis. Ibidem magna patria ullamcorper volutpat. Abico antehabeo appellatio causa proprius tego utrum virtus. Adipiscing augue dolus elit ex saluto. Nostrud proprius scisco sudo vulpes.\r\n\r\nCui euismod imputo tego. Comis praemitto rusticus vereor. Abico plaga quia. Abigo commodo dignissim facilisis hendrerit odio roto saepius sit usitas.\r\n\r\nDolore gravis huic mauris. Abigo brevitas esca melior mos. Abbas amet caecus decet humo immitto minim paulatim roto ulciscor. Duis lucidus persto premo tincidunt velit. Velit veniam volutpat. Adipiscing causa distineo iriure jus sit validus vicis. Acsi elit genitus melior praesent quae refero valetudo. Dolore humo mauris nobis refero valetudo virtus. Acsi nimis persto pneum premo quia ratis valde verto.\r\n\r\n', '', 'full_html'),
('node', 'product', 0, 55, 55, 'und', 0, 'Consequat illum jus mauris modo olim os ulciscor ut ymo. Facilisis ibidem jus neo nisl saepius scisco virtus ymo. Ea patria suscipere. Hendrerit luctus tego ulciscor validus.\r\n\r\nComis meus saluto. Aptent facilisis jugis jumentum paulatim secundum veniam vicis. Dignissim ideo virtus. Metuo neo valde. Distineo et interdico os. Appellatio bene laoreet odio quia scisco sino. Adipiscing hendrerit hos mauris os secundum virtus. Consequat dignissim facilisi lobortis mos nibh paulatim pecus virtus. Bene ea lenis. Abico camur dolus huic odio pala plaga proprius uxor.\r\n\r\nAbluo esse gemino gravis hendrerit quibus refero singularis te. Aliquip hos pagus. Bene capto distineo interdico meus persto torqueo vero. Abluo caecus diam ideo macto os si singularis velit vereor.\r\n\r\nAt euismod illum incassum magna nulla nutus pagus paratus validus. Gravis melior plaga qui validus.\r\n\r\nDolor exerci ideo molior tation. Acsi causa jus. Eu olim ullamcorper. Autem iaceo interdico ludus paulatim valetudo. Ex iaceo typicus vicis. Blandit dolor erat facilisis gilvus in neque odio. Ad inhibeo premo quae scisco typicus utinam valde.\r\n\r\nAdipiscing amet eligo laoreet ludus paratus praesent velit veniam voco. Abluo adipiscing euismod melior obruo saluto si te. Accumsan aliquam imputo magna modo pala pneum sed ut.\r\n\r\nFacilisi lenis tum ullamcorper validus vulpes. Aptent ille singularis. At cogo ex magna nobis saluto torqueo usitas validus. At camur et qui vereor vero. Humo illum neo nobis occuro pagus similis vicis. Macto sed suscipit ulciscor. Cui exputo uxor.\r\n\r\nAbico antehabeo sagaciter velit. Dolor erat minim saepius sed si tation valetudo veniam. Camur esca jugis lobortis odio pala. Camur eum lobortis nobis. Luctus modo praemitto quae qui refero usitas wisi. Amet natu paulatim torqueo. Ad brevitas cogo enim illum melior pagus pala roto. Aliquam antehabeo augue erat fere iustum nutus tego.\r\n\r\nCapto consequat valetudo. Brevitas consectetuer diam dolor esca iustum praemitto quidem zelus. Capto facilisi haero luptatum molior os paulatim populus quidne quis. Ea natu te ymo.\r\n\r\nAbdo accumsan appellatio conventio in iusto jumentum mos refoveo suscipere. Olim sed voco. Abigo brevitas cui diam esca eum haero rusticus vel. Dolus nibh nisl os. Abluo brevitas damnum volutpat.\r\n\r\nAppellatio caecus exerci illum jumentum macto metuo saluto valde. Letalis si zelus. Abbas capto commodo eligo eum gravis hos nimis ratis.\r\n\r\n', '', 'plain_text');
INSERT INTO `field_data_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'product', 0, 56, 56, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'full_html'),
('node', 'article', 0, 57, 57, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 58, 58, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 59, 59, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'filtered_html'),
('node', 'article', 0, 60, 60, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 61, 61, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'product', 0, 62, 62, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.', '', 'filtered_html'),
('node', 'product', 0, 63, 63, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.', '', 'filtered_html'),
('node', 'product', 0, 64, 64, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 65, 65, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 66, 66, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 67, 67, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 68, 68, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 69, 69, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 70, 70, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 71, 71, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 72, 72, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 73, 73, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 74, 74, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 75, 75, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 76, 76, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html');
INSERT INTO `field_data_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'product', 0, 77, 77, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 78, 78, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 79, 79, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'page', 0, 80, 80, 'und', 0, 'Praesent id urna erat. Cras porta venenatis libero quis viverra. Praesent lobortis, tellus quis aliquam posuere, lorem orci condimentum nisi, eu pretium leo leo ornare odio. In hac habitasse platea dictumst. Vestibulum euismod consectetur lorem non molestie. Cras fermentum placerat est, venenatis tincidunt ipsum consectetur vel. Duis tristique dolor at lorem tempor, id hendrerit orci vulputate. Morbi laoreet velit nec ipsum hendrerit consectetur. Cras mauris tortor; tincidunt vitae fermentum eu, aliquam eget nisl. In sit amet neque ante. Nam a fermentum nunc.\r\n\r\nVivamus id sem lorem. Donec in metus elementum, porttitor leo ut, suscipit enim. Phasellus nisi felis, volutpat a feugiat id, pulvinar vitae nulla. Morbi tempor diam vitae fringilla sollicitudin. Curabitur a ipsum sodales; ultricies nisi non, malesuada risus! Nunc scelerisque enim lacus; non luctus elit porttitor eget. Proin in nisl massa. Vestibulum convallis felis ut magna malesuada tempor. Morbi quis ipsum et mauris interdum posuere. Praesent tempus ac arcu ac sollicitudin.\r\n\r\nCurabitur ac est nulla. In in ornare orci, quis egestas metus! Proin eget vehicula ante. Etiam et libero et massa elementum commodo. Suspendisse volutpat.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 81, 81, 'und', 0, 'Nullam leo purus, posuere aliquet lorem non; vestibulum rhoncus lacus! Aliquam dapibus elit orci, ut vulputate erat accumsan eget. Pellentesque at libero sit amet tellus ornare convallis. Integer pellentesque facilisis lorem a malesuada. Cras vel nulla dictum; iaculis nibh id, pharetra urna. Aenean gravida lacus mauris. Pellentesque consectetur lectus sit amet velit vulputate, quis faucibus leo pretium. Curabitur at placerat leo. Praesent sagittis turpis sed velit congue adipiscing. Nullam tristique dui sed lorem feugiat, eget fermentum libero suscipit. Proin molestie, mi eget ultrices mollis, mauris magna fringilla sapien, eu interdum urna ipsum eu nulla. Nulla pharetra laoreet mi id ornare. Ut lectus enim, accumsan fringilla diam et; ultricies imperdiet lectus. Duis porttitor massa eget risus blandit laoreet. Sed molestie felis non felis consequat, in iaculis mi sodales.\r\n\r\nSed venenatis egestas massa eget suscipit. Praesent vitae placerat enim. Vestibulum a felis tortor. Quisque blandit eget tellus in convallis. Phasellus dignissim, enim ac auctor sodales, quam lectus mollis metus, ut accumsan justo nibh vel arcu. Proin ante libero, dignissim ullamcorper congue eu; elementum id sed.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 82, 82, 'und', 0, 'Etiam fringilla elementum urna, id venenatis urna commodo mollis! Quisque vel est sed nibh dapibus gravida sed id libero. Aliquam facilisis tortor sed feugiat condimentum. Sed euismod elementum tellus vitae egestas. Sed consectetur nisi non consectetur viverra. Nulla aliquet libero ac leo dictum elementum. Morbi eu nibh vitae neque viverra gravida. Nullam vehicula odio gravida, aliquam diam vel, dignissim dolor. Curabitur pharetra augue at ante varius fermentum. Cras consequat malesuada nisl elementum volutpat. Praesent vel dolor ultrices, vestibulum mauris laoreet, venenatis diam.\r\n\r\nDonec consectetur nibh in velit iaculis, ut viverra nibh imperdiet. Nullam tortor felis, commodo et interdum faucibus; vulputate nec metus. In hac habitasse platea dictumst. Quisque mollis leo a leo tincidunt semper. Morbi vitae congue ligula. Aliquam ornare purus ut nulla elementum, non vestibulum magna auctor. Donec quis dui sed odio volutpat ullamcorper. Pellentesque eleifend ipsum ac lacus elementum ullamcorper. Integer ut lorem nulla. Mauris laoreet eros id quam placerat tincidunt.\r\n\r\nInteger quam purus, varius et mauris ut, gravida faucibus tortor. Phasellus massa diam; vulputate a aliquet eget posuere.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 83, 83, 'und', 0, 'Etiam at leo leo! Maecenas blandit eget orci non adipiscing. Maecenas vulputate metus non odio iaculis egestas. Aenean fermentum imperdiet magna, eu sodales erat vulputate sed. Ut tincidunt dapibus mauris, non feugiat lorem volutpat sed. Ut eget dui non urna sodales feugiat. Nunc hendrerit, est sed egestas tincidunt, lectus mi tempor neque, ac ornare sapien ipsum at erat. Nulla sed risus pulvinar, scelerisque diam nec, egestas urna. Ut nec eros tempus, ullamcorper ipsum non, hendrerit ante. Aenean viverra molestie erat, quis dignissim ipsum bibendum vel? Morbi arcu purus; scelerisque mollis mi quis; tempor ullamcorper nisi. Fusce eget urna eleifend nulla mollis rhoncus vitae eget mi.\r\n\r\nVestibulum nec tortor sed tellus lobortis posuere. Phasellus ut massa consectetur risus gravida viverra. Etiam odio nisi, porta ut tortor egestas, sodales iaculis tortor. Quisque rhoncus imperdiet odio, elementum dignissim magna molestie nec. Etiam sit amet dolor id est aliquet congue in vel est. Ut feugiat felis in lacus dignissim scelerisque. Etiam urna ipsum, luctus eget risus ac, malesuada auctor felis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis turpis duis.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 84, 84, 'und', 0, 'Cras nec orci mattis; rhoncus orci vel, euismod nisl? Pellentesque sit amet neque a lacus euismod adipiscing sed sit amet risus. Suspendisse potenti. Pellentesque condimentum in ipsum in volutpat. Cras id faucibus massa. Proin vitae lobortis felis, ut lobortis augue. Ut tempor turpis in tellus bibendum, mattis lacinia magna porta. Nulla facilisi. Fusce luctus molestie ligula in molestie. Fusce luctus neque nec urna ornare rhoncus! Curabitur commodo sem dui, nec bibendum arcu ultricies eget. Cras eu augue a enim feugiat feugiat!\r\n\r\nEtiam dapibus est eu rhoncus viverra. Nullam eget convallis dolor. Aenean imperdiet diam vel arcu tristique, et tincidunt massa cursus. Aliquam molestie mollis dolor, vitae mollis libero auctor non. Suspendisse ornare purus ante, vitae lacinia orci varius quis! Suspendisse varius sapien ut gravida faucibus. Morbi vehicula, massa ut commodo pretium, metus nunc imperdiet lorem; a scelerisque erat tellus eget est. Ut vitae enim ut sem vehicula iaculis. Vestibulum consectetur urna id molestie pretium. Proin id consectetur nisl, sit amet fringilla lacus. Vivamus viverra turpis eu suscipit tincidunt. Mauris ornare venenatis gravida! Fusce tincidunt bibendum nullam.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 85, 85, 'und', 0, 'Duis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 86, 86, 'und', 0, 'Duis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 87, 87, 'und', 0, 'Duis blandit dictum diam, eu tristique elit eleifend a. Aenean molestie urna nulla, id pulvinar augue dapibus non. Ut ultrices mi in nibh rhoncus, ac aliquet sem commodo. Phasellus commodo tincidunt varius. Aliquam sit amet leo sit amet magna fringilla eleifend. Nam euismod tristique mi non lobortis. Integer feugiat eu mauris a semper. Duis sit amet diam in augue ullamcorper varius. Sed ut dolor hendrerit, ornare magna at, volutpat tellus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Praesent id hendrerit nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sit amet lorem facilisis, aliquam tellus sit amet, mollis arcu. Fusce dapibus enim ut risus suscipit; ut interdum enim dapibus.\r\n\r\nMauris risus massa, eleifend ac eros congue, fermentum placerat justo. Vestibulum sit amet dui mollis, sodales turpis vitae, dignissim sem. Nullam eget scelerisque dolor. Fusce lacinia malesuada aliquet. Curabitur venenatis posuere augue at bibendum. Mauris eu velit feugiat risus aliquam rutrum. Proin dapibus nisl sit amet risus molestie imperdiet.\r\n\r\nDonec fringilla nisl ac libero egestas, quis blandit ante vehicula. Nulla ac nulla in nisi pharetra cursus id at sem amet.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 88, 88, 'und', 0, 'Donec tincidunt ante ac turpis hendrerit, ut aliquam risus sollicitudin. Donec facilisis, ipsum vitae aliquam vulputate, libero purus consequat massa, eget consectetur neque turpis eget lectus. Fusce non libero venenatis, pharetra massa eu, adipiscing nulla. Fusce ullamcorper, justo at tempor elementum, dolor neque vestibulum magna, a egestas nisi mauris sed elit. Proin dapibus congue mi, ut sodales augue tincidunt vitae. In at adipiscing odio. Etiam pharetra consectetur leo, nec commodo nunc scelerisque vel. Proin feugiat porta sem, vitae fermentum diam dignissim a. Aenean eget odio sit amet tortor luctus fringilla. Nunc non pulvinar lacus. Praesent accumsan at eros at mollis. Vivamus rhoncus neque sit amet dolor blandit, sed scelerisque velit gravida. Mauris eu lacinia orci. Nunc tristique lectus eu gravida porttitor. Integer tempor nisi metus, in pellentesque justo interdum eu?\r\n\r\nSuspendisse egestas nisl massa, quis eleifend magna accumsan sit amet. Proin sed nibh quis odio eleifend molestie. Morbi vitae imperdiet ante. Donec tortor augue, euismod ac eros nec, lacinia lobortis est. In iaculis et sapien quis ullamcorper. Proin dictum, elit sit amet tincidunt dapibus, neque volutpat.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 89, 89, 'und', 0, 'Nunc mollis lorem a rutrum eleifend. Vestibulum lacus nisi, vehicula vel justo mollis, sodales fringilla urna. Quisque vestibulum libero sit amet varius pulvinar. Cras id orci vitae libero imperdiet vestibulum. Aliquam a condimentum sem, laoreet consequat metus. Curabitur purus augue, ornare ac fringilla nec, fringilla ac arcu. Maecenas tincidunt tempor suscipit. Donec nunc ante, iaculis vel erat non, pretium rutrum lectus. In elementum adipiscing malesuada. Aenean pellentesque a felis sit amet aliquam. Nunc non venenatis justo, sed adipiscing libero. Aenean rhoncus leo eget ornare placerat. Mauris imperdiet malesuada est, sit amet faucibus sapien pharetra sed.\r\n\r\nPellentesque nec volutpat odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula est quis libero vulputate laoreet. Pellentesque in neque ac turpis pellentesque bibendum quis et nisi. Etiam porta eros egestas consequat fringilla. Fusce gravida pharetra dui id mattis. Nulla dictum imperdiet justo, ac rhoncus tellus pulvinar sit amet. Donec convallis sagittis erat sit amet interdum. Cras ultricies velit sagittis mattis tincidunt! Donec sagittis adipiscing congue. Sed pharetra congue fringilla posuere.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_comment_body`
--

CREATE TABLE IF NOT EXISTS `field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 1 (comment_body)';

--
-- Dumping data for table `field_data_comment_body`
--

INSERT INTO `field_data_comment_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `comment_body_value`, `comment_body_format`) VALUES
('comment', 'comment_node_forum', 0, 1, 1, 'und', 0, 'And really, a validating, clean layout will work 90 % of the time. It will have easy fixes 9 % of the time and will require hard measures only 1 % of the time. Really!', 'filtered_html'),
('comment', 'comment_node_forum', 0, 2, 2, 'und', 0, 'Please ensure that you''ve validated both the CSS and HTML for your website using W3C tools. It would be great to review your theme with both the WAVE and FAE accessibility evaluators too. There are also some other good validation tools.', 'filtered_html'),
('comment', 'comment_node_article', 0, 3, 3, 'und', 0, 'Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.', 'filtered_html'),
('comment', 'comment_node_article', 0, 4, 4, 'und', 0, 'Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede.', 'filtered_html'),
('comment', 'comment_node_article', 0, 5, 5, 'und', 0, 'Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante.', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_articles`
--

CREATE TABLE IF NOT EXISTS `field_data_field_articles` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_articles_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_articles_tid` (`field_articles_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 18 (field_articles)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_blog_img`
--

CREATE TABLE IF NOT EXISTS `field_data_field_blog_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_blog_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_blog_img_alt` varchar(512) DEFAULT NULL,
  `field_blog_img_title` varchar(1024) DEFAULT NULL,
  `field_blog_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_blog_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_blog_img_fid` (`field_blog_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 9 (field_blog_img)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_blog_tags`
--

CREATE TABLE IF NOT EXISTS `field_data_field_blog_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_blog_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_blog_tags_tid` (`field_blog_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 10 (field_blog_tags)';

--
-- Dumping data for table `field_data_field_blog_tags`
--

INSERT INTO `field_data_field_blog_tags` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_blog_tags_tid`) VALUES
('node', 'blog', 0, 11, 11, 'und', 0, 14),
('node', 'blog', 0, 11, 11, 'und', 1, 15),
('node', 'blog', 0, 12, 12, 'und', 0, 14),
('node', 'blog', 0, 13, 13, 'und', 0, 14);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_categories`
--

CREATE TABLE IF NOT EXISTS `field_data_field_categories` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_categories_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_categories_tid` (`field_categories_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 16 (field_categories)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_category`
--

CREATE TABLE IF NOT EXISTS `field_data_field_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_tid` (`field_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 7 (field_category)';

--
-- Dumping data for table `field_data_field_category`
--

INSERT INTO `field_data_field_category` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_category_tid`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 3),
('node', 'article', 0, 2, 2, 'und', 0, 3),
('node', 'article', 0, 3, 3, 'und', 0, 3),
('node', 'article', 0, 5, 5, 'und', 0, 3),
('node', 'article', 0, 6, 6, 'und', 0, 3),
('node', 'article', 0, 7, 7, 'und', 0, 3),
('node', 'article', 0, 8, 8, 'und', 0, 3),
('node', 'article', 0, 57, 57, 'und', 0, 21),
('node', 'article', 0, 58, 58, 'und', 0, 21),
('node', 'article', 0, 59, 59, 'und', 0, 21),
('node', 'article', 0, 61, 61, 'und', 0, 21);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_category_image`
--

CREATE TABLE IF NOT EXISTS `field_data_field_category_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_category_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_category_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_category_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_category_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_image_fid` (`field_category_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 11 (field_category_image)';

--
-- Dumping data for table `field_data_field_category_image`
--

INSERT INTO `field_data_field_category_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_category_image_fid`, `field_category_image_alt`, `field_category_image_title`, `field_category_image_width`, `field_category_image_height`) VALUES
('taxonomy_term', 'categories', 0, 16, 16, 'und', 0, 345, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 17, 17, 'und', 0, 346, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 18, 18, 'und', 0, 348, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 19, 19, 'und', 0, 351, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 20, 20, 'und', 0, 349, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 22, 22, 'und', 0, 350, '', '', 270, 270);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_forums`
--

CREATE TABLE IF NOT EXISTS `field_data_field_forums` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_forums_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_forums_tid` (`field_forums_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 17 (field_forums)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_image`
--

CREATE TABLE IF NOT EXISTS `field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL,
  `field_image_title` varchar(1024) DEFAULT NULL,
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 4 (field_image)';

--
-- Dumping data for table `field_data_field_image`
--

INSERT INTO `field_data_field_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_image_fid`, `field_image_alt`, `field_image_title`, `field_image_width`, `field_image_height`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 239, '', '', 194, 174),
('node', 'article', 0, 57, 57, 'und', 0, 342, '', '', 700, 300),
('node', 'article', 0, 58, 58, 'und', 0, 341, '', '', 700, 300),
('node', 'article', 0, 59, 59, 'und', 0, 340, '', '', 700, 300),
('node', 'article', 0, 60, 60, 'und', 0, 339, '', '', 194, 174),
('node', 'article', 0, 61, 61, 'und', 0, 343, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_img`
--

CREATE TABLE IF NOT EXISTS `field_data_field_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_alt` varchar(512) DEFAULT NULL,
  `field_img_title` varchar(1024) DEFAULT NULL,
  `field_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_fid` (`field_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 8 (field_img)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_list_description`
--

CREATE TABLE IF NOT EXISTS `field_data_field_list_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_list_description_value` varchar(255) DEFAULT NULL,
  `field_list_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_list_description_format` (`field_list_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 22 (field_list_description)';

--
-- Dumping data for table `field_data_field_list_description`
--

INSERT INTO `field_data_field_list_description` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_list_description_value`, `field_list_description_format`) VALUES
('newsletter_list', 'newsletter_list', 0, 1, 1, 'und', 0, 'An example newsletter list with Manual Send Rate.', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_newsletter_body`
--

CREATE TABLE IF NOT EXISTS `field_data_field_newsletter_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_body_value` longtext,
  `field_newsletter_body_summary` longtext,
  `field_newsletter_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_body_format` (`field_newsletter_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 23 (field_newsletter_body)';

--
-- Dumping data for table `field_data_field_newsletter_body`
--

INSERT INTO `field_data_field_newsletter_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_newsletter_body_value`, `field_newsletter_body_summary`, `field_newsletter_body_format`) VALUES
('newsletter_template', 'newsletter_template', 0, 1, 1, 'und', 0, 'Hello [newsletter:subscriber_email],<br />\n\nWe received your request for information from [site:name] <br />\nBefore we begin sending you the information you requested, we want to be certain we have your permission.<br />\nClick the link below to give us permission to send you information. It''s fast and easy!  If you cannot click the full URL below, please copy the URL and paste it into your web browser.<br /><br />\n\nConfirm by clicking the URL below:<br /><br />\n<a href="[newsletter:confirmation_url]">[newsletter:confirmation_url]</a><br /><br />\n\nIf you do not want to subscribe, simply ignore this message.<br /><br />\n\nBest Regards,<br />\n[site:name]<br />\n[site:url]<br /><br />\n\nRequest generated by:<br />\nIP: [newsletter:subscription_ip]<br />\nDate: [newsletter:subscription_time]<br />\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 2, 2, 'und', 0, 'Hello [newsletter:subscriber_email],<br /><br />\n\nThank you for your subscription. You are now signed up to our newsletter!<br />\nWe will keep your personal information private and secure. We will not share your email address with any third parties. <br />\nTo ensure you receive future subscribers-only news, please add this e-mail to your e-mail address book or safe senders list.<br />\n\n\nSincerely,<br />\n[site:name]<br />\n[site:url]<br /><br />\n\n----<br />\nYou are receiving this email because on [newsletter:subscription_time] at [site:url] you subscribed to receive our e-newsletters.<br /><br />\nYou can unsubscribe via the link below:<br />\n<a href="[newsletter:unsubscribe_url]">Unsubscribe</a>\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 3, 3, 'und', 0, 'Dear [newsletter:subscriber_email],<br />\n\nThis email is being sent to notify you that we have received a request to remove the following record from our mailing list:<br /><br />\n\nEmail: [newsletter:subscriber_email]<br /><br />\n\nThis record was removed from our database.<br />\nIf you do receive further unwanted email from our system, please let us know and we''d be happy to address the issue immediately.<br /><br />\n\nSincerely,<br />\n[site:name]<br />\n[site:url] <br />\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 4, 4, 'und', 0, 'Hello [newsletter:subscriber_email],<br /><br />\n\nHere is what''s new on <a href="[site:url]">[site:name]</a> over the past few days. Your comments and feedback are always welcome.<br />\n\n<ol>\n [repeat] \n<li><a href="[node:url]">[node:title]</a> -[node:created]<br /> [node:summary]<br /></li>\n [/repeat] \n\n</ol>Sincerely,<br /> <a href="[site:url]">[site:name]</a><br /> <br /> <br />\n\n--<br />You are receiving this email because on [newsletter:subscription_time] you subscribed to receive our newsletter list : [newsletter:list_name].<br /><br />\n\nYou can unsubscribe by clicking the link below:<br /> \n<a href="[newsletter:unsubscribe_url]">Unsubscribe</a><br />\n', NULL, 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_newsletter_categories`
--

CREATE TABLE IF NOT EXISTS `field_data_field_newsletter_categories` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_categories_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_categories_tid` (`field_newsletter_categories_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 19 (field_newsletter_categories)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_newsletter_list`
--

CREATE TABLE IF NOT EXISTS `field_data_field_newsletter_list` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_list_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_list_target_id` (`field_newsletter_list_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 20 (field_newsletter_list)';

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_newsletter_template`
--

CREATE TABLE IF NOT EXISTS `field_data_field_newsletter_template` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_template_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_template_target_id` (`field_newsletter_template_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 21 (field_newsletter_template)';

--
-- Dumping data for table `field_data_field_newsletter_template`
--

INSERT INTO `field_data_field_newsletter_template` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_newsletter_template_target_id`) VALUES
('newsletter_list', 'newsletter_list', 0, 1, 1, 'und', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_product_category`
--

CREATE TABLE IF NOT EXISTS `field_data_field_product_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_category_tid` (`field_product_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 14 (field_product_category)';

--
-- Dumping data for table `field_data_field_product_category`
--

INSERT INTO `field_data_field_product_category` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_category_tid`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 17),
('node', 'product', 0, 52, 52, 'und', 0, 16),
('node', 'product', 0, 53, 53, 'und', 0, 16),
('node', 'product', 0, 54, 54, 'und', 0, 16),
('node', 'product', 0, 55, 55, 'und', 0, 17),
('node', 'product', 0, 56, 56, 'und', 0, 16),
('node', 'product', 0, 62, 62, 'und', 0, 22),
('node', 'product', 0, 63, 63, 'und', 0, 22),
('node', 'product', 0, 64, 64, 'und', 0, 22),
('node', 'product', 0, 65, 65, 'und', 0, 22),
('node', 'product', 0, 66, 66, 'und', 0, 17),
('node', 'product', 0, 67, 67, 'und', 0, 17),
('node', 'product', 0, 68, 68, 'und', 0, 20),
('node', 'product', 0, 69, 69, 'und', 0, 20),
('node', 'product', 0, 70, 70, 'und', 0, 20),
('node', 'product', 0, 71, 71, 'und', 0, 20),
('node', 'product', 0, 72, 72, 'und', 0, 18),
('node', 'product', 0, 73, 73, 'und', 0, 18),
('node', 'product', 0, 74, 74, 'und', 0, 18),
('node', 'product', 0, 75, 75, 'und', 0, 18),
('node', 'product', 0, 76, 76, 'und', 0, 19),
('node', 'product', 0, 77, 77, 'und', 0, 19),
('node', 'product', 0, 78, 78, 'und', 0, 19),
('node', 'product', 0, 79, 79, 'und', 0, 19);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_product_image`
--

CREATE TABLE IF NOT EXISTS `field_data_field_product_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_product_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_product_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_product_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_product_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_image_fid` (`field_product_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 12 (field_product_image)';

--
-- Dumping data for table `field_data_field_product_image`
--

INSERT INTO `field_data_field_product_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_image_fid`, `field_product_image_alt`, `field_product_image_title`, `field_product_image_width`, `field_product_image_height`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 306, '', '', 960, 330),
('node', 'product', 0, 47, 47, 'und', 1, 307, '', '', 960, 330),
('node', 'product', 0, 47, 47, 'und', 2, 308, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 0, 332, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 1, 333, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 2, 334, '', '', 700, 300),
('node', 'product', 0, 53, 53, 'und', 0, 328, '', '', 960, 330),
('node', 'product', 0, 53, 53, 'und', 1, 329, '', '', 960, 330),
('node', 'product', 0, 53, 53, 'und', 2, 330, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 0, 336, '', '', 700, 300),
('node', 'product', 0, 54, 54, 'und', 1, 337, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 2, 338, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 0, 310, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 1, 311, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 0, 243, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 1, 244, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 2, 245, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 3, 246, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 0, 324, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 1, 325, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 2, 326, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 0, 320, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 1, 321, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 2, 322, '', '', 960, 330),
('node', 'product', 0, 64, 64, 'und', 0, 316, '', '', 960, 330),
('node', 'product', 0, 64, 64, 'und', 1, 317, '', '', 700, 300),
('node', 'product', 0, 64, 64, 'und', 2, 318, '', '', 700, 300),
('node', 'product', 0, 65, 65, 'und', 0, 313, '', '', 700, 300),
('node', 'product', 0, 65, 65, 'und', 1, 314, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 0, 302, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 1, 303, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 2, 304, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 0, 298, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 1, 299, '', '', 960, 330),
('node', 'product', 0, 67, 67, 'und', 2, 300, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 0, 293, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 1, 294, '', '', 960, 330),
('node', 'product', 0, 68, 68, 'und', 2, 295, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 3, 296, '', '', 960, 330),
('node', 'product', 0, 69, 69, 'und', 0, 290, '', '', 960, 330),
('node', 'product', 0, 69, 69, 'und', 1, 291, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 0, 285, '', '', 960, 330),
('node', 'product', 0, 70, 70, 'und', 1, 286, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 2, 287, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 3, 288, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 0, 249, '', '', 700, 300),
('node', 'product', 0, 71, 71, 'und', 1, 251, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 2, 248, '', '', 700, 300),
('node', 'product', 0, 71, 71, 'und', 3, 250, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 0, 281, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 1, 282, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 2, 283, '', '', 960, 330),
('node', 'product', 0, 73, 73, 'und', 0, 277, '', '', 700, 300),
('node', 'product', 0, 73, 73, 'und', 1, 278, '', '', 960, 330),
('node', 'product', 0, 73, 73, 'und', 2, 279, '', '', 700, 300),
('node', 'product', 0, 74, 74, 'und', 0, 274, '', '', 960, 330),
('node', 'product', 0, 74, 74, 'und', 1, 275, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 0, 258, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 1, 259, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 2, 260, '', '', 960, 330),
('node', 'product', 0, 75, 75, 'und', 3, 261, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 0, 270, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 1, 271, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 2, 272, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 0, 266, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 1, 267, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 2, 268, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 0, 263, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 1, 264, '', '', 960, 330),
('node', 'product', 0, 79, 79, 'und', 0, 253, '', '', 960, 330),
('node', 'product', 0, 79, 79, 'und', 1, 254, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 2, 255, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 3, 256, '', '', 700, 300);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_product_thumb`
--

CREATE TABLE IF NOT EXISTS `field_data_field_product_thumb` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_thumb_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_product_thumb_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_product_thumb_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_product_thumb_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_product_thumb_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_thumb_fid` (`field_product_thumb_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 15 (field_product_thumb)';

--
-- Dumping data for table `field_data_field_product_thumb`
--

INSERT INTO `field_data_field_product_thumb` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_thumb_fid`, `field_product_thumb_alt`, `field_product_thumb_title`, `field_product_thumb_width`, `field_product_thumb_height`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 305, '', '', 960, 330),
('node', 'product', 0, 52, 52, 'und', 0, 331, '', '', 700, 300),
('node', 'product', 0, 53, 53, 'und', 0, 327, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 0, 335, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 0, 309, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 0, 242, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 0, 323, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 0, 319, '', '', 700, 300),
('node', 'product', 0, 64, 64, 'und', 0, 315, '', '', 960, 330),
('node', 'product', 0, 65, 65, 'und', 0, 312, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 0, 301, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 0, 297, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 0, 292, '', '', 700, 300),
('node', 'product', 0, 69, 69, 'und', 0, 289, '', '', 960, 330),
('node', 'product', 0, 70, 70, 'und', 0, 344, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 0, 352, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 0, 280, '', '', 700, 300),
('node', 'product', 0, 73, 73, 'und', 0, 276, '', '', 700, 300),
('node', 'product', 0, 74, 74, 'und', 0, 273, '', '', 960, 330),
('node', 'product', 0, 75, 75, 'und', 0, 257, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 0, 269, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 0, 265, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 0, 262, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 0, 252, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_slideshow`
--

CREATE TABLE IF NOT EXISTS `field_data_field_slideshow` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_slideshow_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_slideshow_alt` varchar(512) DEFAULT NULL,
  `field_slideshow_title` varchar(1024) DEFAULT NULL,
  `field_slideshow_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_slideshow_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_slideshow_fid` (`field_slideshow_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 6 (field_slideshow)';

--
-- Dumping data for table `field_data_field_slideshow`
--

INSERT INTO `field_data_field_slideshow` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_slideshow_fid`, `field_slideshow_alt`, `field_slideshow_title`, `field_slideshow_width`, `field_slideshow_height`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 238, '', '', 960, 330),
('node', 'article', 0, 3, 3, 'und', 0, 237, '', '', 960, 330),
('node', 'article', 0, 8, 8, 'und', 0, 241, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_field_tags`
--

CREATE TABLE IF NOT EXISTS `field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 3 (field_tags)';

--
-- Dumping data for table `field_data_field_tags`
--

INSERT INTO `field_data_field_tags` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_tags_tid`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 2),
('node', 'article', 0, 3, 3, 'und', 0, 2);

-- --------------------------------------------------------

--
-- Table structure for table `field_data_taxonomy_forums`
--

CREATE TABLE IF NOT EXISTS `field_data_taxonomy_forums` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `taxonomy_forums_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `taxonomy_forums_tid` (`taxonomy_forums_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 5 (taxonomy_forums)';

--
-- Dumping data for table `field_data_taxonomy_forums`
--

INSERT INTO `field_data_taxonomy_forums` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `taxonomy_forums_tid`) VALUES
('node', 'forum', 0, 16, 16, 'und', 0, 6),
('node', 'forum', 0, 17, 17, 'und', 0, 6),
('node', 'forum', 0, 18, 18, 'und', 0, 7),
('node', 'forum', 0, 19, 19, 'und', 0, 7),
('node', 'forum', 0, 20, 20, 'und', 0, 7),
('node', 'forum', 0, 21, 21, 'und', 0, 12);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_body`
--

CREATE TABLE IF NOT EXISTS `field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 2 (body)';

--
-- Dumping data for table `field_revision_body`
--

INSERT INTO `field_revision_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 2, 2, 'und', 0, 'With this book you will learn how to maximize and optimize your Drupal 6 framework using best practice performance solutions and tools.  The book covers how to vastly improve performance through upgrades, caching, configuring and optimization using core and contributed modules.\r\n\r\nAs a reader of drupal.org, you can receive a 15% discount (see below) and benefit the Drupal Association!\r\n\r\n<h2>Some of what you will learn</h2>\r\n\r\n<ul>\r\n<li> Upgrade your Drupal 5 site to Drupal 6 using best practice upgrade paths</li>\r\n<li> Back up and maintain your Drupal 6 site using core and contributed modules and utilities</li>\r\n\r\n<li> Configure the Drupal core and contributed modules for high traffic</li>\r\n<li> Run core Drupal page compression, CSS and JS compression, and use Drupal page caching</li>\r\n<li> Run scheduled cron tasks to perform crucial garbage-collection processes</li>\r\n<li> Use the Development (Devel) module to monitor page loads and queries</li>\r\n<li> Use the Boost module for anonymous page caching, tweak Boost settings, and use Boost blocks and advanced Boost settings to monitor site performance</li>\r\n<li> Install and use Memcache API and Integration module, and Authcache and Advanced Cached modules to enhance and monitor site performance</li>\r\n\r\n<li> Configure a Drupal multisite environment for best performance</li>\r\n</ul>\r\n<h2>About the Book</h2>\r\n\r\nDrupal is one of the most respected and widely used open source content management frameworks.  Small, medium, and large-scale websites are built using Drupal and the framework supports e-commerce, CRM, multisite and web service integrations.\r\n\r\nOnce you get your Drupal site installed and up and running, you will be concerned with site performance and how fast you can make your Drupal site run.  This book will focus on implementing performance modules and solutions to help speed up your Drupal website.\r\n\r\nWe will look at introductory topics such as upgrading your Drupal site, maintaining your site, and enabling core Drupal page compression and caching.\r\n\r\nThen we will turn to an advanced look at some contributed modules that help speed up performance, including Development, Boost, Authcache, Advanced Cache, and the Memcache API and Integration module.\r\n\r\nFinally, we?ll look at how best to implement a Drupal multisite environment and run it with high-speed performance in mind.\r\n\r\n<h2>Get 15% off!</h2>\r\n\r\nI have secured an exclusive 15% discount for you when you buy through <a href="http://www.packtpub.com/">PacktPub.com</a>.  Enter the following discount code at checkout in the shopping cart:  Drupal6PT15 (case sensitive). As with all of Packt?s Drupal books, Packt will be donating a percentage of its sales to the Drupal Association.\r\n\r\n<h2>Want a Sample?</h2>\r\nTo help promote the content provided within this book, Packt is generous enough to provide sample content of what you can expect from reading this book.\r\n\r\n<ul>\r\n<li> <a href="http://www.packtpub.com/article/drupal-6-performance-optimization-using-views-panels-caching">Article: Drupal 6 Performance Optimization Using Views and Panels Caching</a></li>\r\n</ul>\r\n<h2>About the authors</h2>\r\n\r\n<strong>Trevor James</strong><br>\r\nTrevor James (<a href="http://drupal.org/user/720820">trevorjames</a>) is a Drupal developer and web designer based in Middletown, MD, USA. Trevor has been designing websites for 13 years using a combination of HTML, XHTML, CSS, and ColdFusion. He has been using Drupal intensively for more than 2 years. Trevor''s focus is on building web portals for higher education, public education (K-12), non-profit, and small business environments. He is interested in the best methods of developing Drupal themes, Drupal site performance, and using CCK, Views and Panels to develop front-end interfaces to support data-intensive websites. He loves teaching people about Drupal and how to use this excellent open source content management framework. He is also a contributor and community member on drupal.org and related Drupal community projects.\r\n\r\n<strong>TJ Holowaychuk</strong><br>\r\nTJ Holowaychuk (<a href="http://drupal.org/user/78427">tjholowaychuk</a>), president of Vision Media, is an avid contributor to the Drupal project as well as to other open-source applications. Contributing over 16 Drupal modules, several themes, and having fully designed, developed, and maintained hundreds of Drupal websites, he has displayed a wealth of knowledge across different aspects of the industry.', '<a href="http://www.packtpub.com/drupal-6-performance-tips-to-maximize-and-optimize-your-framework/book?utm_source=drupal.org&amp;utm_medium=link&amp;utm_content=pod&amp;utm_campaign=mdb_002452">Drupal 6 Performance Tips</a>, by Trevor James and TJ Holowaychuk, is a newly-published title from Packt Publishing aimed at Drupal beginners, developers, designers, and webmasters who utilize the Drupal content management system to create robust websites.\r\n\r\nIt provides crucial performance-related information for Drupal users of all experience levels, including module contributors, webmasters who simply configure and maintain Drupal websites, and even themers. The book contains basic and advanced topics on Drupal performance that will appeal both to the Drupal novice and the advanced user or developer. ', 'full_html'),
('node', 'article', 0, 3, 3, 'und', 0, 'Core Conversations are a place for people actively working on Drupal or Drupal.org to meet and plan the future of Drupal (Drupal 8). We will announce selected Core Conversation sessions on 22 July 2011.\r\n\r\nWe remind you that we have some excellent pre-conference training courses and workshops scheduled for 22 August 2011 and invite you to register for these. This is a great opportunity for Drupalists at all levels of experience to learn from the experts.\r\n\r\nThe cost for a full day training varies from only Ãƒâ€šÃ‚Â£150 for the Absolute Beginner''s Guide to Drupal to Ãƒâ€šÃ‚Â£325 for advanced topics like Building Modules for Drupal 7 and Drupal Powered E-Commerce.\r\n\r\nDemand for Drupal talent is high, so why not invest in your future!\r\n\r\nRegister now to attend DrupalCon London and for pre-conference training.\r\n\r\nIf you would like to support DrupalCon London and help us spread the word about the conference. Here you can get badges for your website and promote the conference via our Twitter and Facebook widgets.\r\n\r\nSee you at DrupalCon London 22-26 August 2011!\r\n\r\nStay up-to-date with the latest information about DrupalCon London by going to http://london2011.drupal.org/ or following us on Twitter @drupalcon.', 'The DrupalCon London Team had the task of narrowing 341 fantastic proposals into a schedule of 60 sessions, balanced across 5 tracks: Site Building and Environment Set-up, Business and Best Practices, Code & Coders, Design, UX & Theming, and Ecosystem. You can check out the schedule now and attendees will be able to build their schedule on the DrupalCon London site by logging in later this week.\r\n\r\nThis breaks down to 5 tracks with 12 sessions each. The 6th track, Core Conversations, will also have 12 sessions slots available and DrupalCon London will be opening core conversation session proposals between 14 June and 14 July 2011, 23:59 GMT+1. ', 'full_html'),
('node', 'article', 0, 4, 4, 'und', 0, 'Of course, we have the most comprehensive film tax credit in the nation (films, commercials, new media, video games) and our Education Director is the head of the state-funded Film Industry Training Program.\r\n\r\nThe focus for New Media programs this year is Free Software, Web/New Media, Animation, Music and Advocacy. We are further sharing 1/3 of our curriculum with Film and Education.\r\n\r\nPlease email and/or call me if you are interested in helping us. The festival is May 4-9 and ours is May 6-9. I will know more at our next meeting about exact scheduling.\r\n\r\nWe aren''t a rich festival, therefore we cannot pay anyone, but we are only 65 miles from NYC on Metro North and we can cover your hotel room as long as you wish to stay as well as give you an All Access Pass for the week.\r\n\r\nLooking forward to chatting.\r\n\r\nDave Bonan\r\nDirector of New Media Programming, CT Film Festival\r\nwww.ctfilmfest.com\r\n203.770.8304', 'I''m the Director for New Media Programming at the CT Film Festival in Danbury, CT and I wanted to see if any Drupal demonstrators would like to teach a workshop at his/her discretion. We have a speaker doing a Social Media 2.0 Workshop as well as a CMS overview with Drupal, Joomla and Wordpress.\r\n\r\nFirst off, our independent festival is 6 years old and quickly growing. We are unique in that we are an 8-month traveling festival within the state, providing weekend and weekday performances at universities and theaters and then ending with a weeklong series of events in early May (over 300 films, workshops, performances and parties).', 'full_html'),
('node', 'article', 0, 5, 5, 'und', 0, 'Hello Drupalers!\r\n\r\nNetBeans 6.5 Release Candidate is out (with right PHP editing features : http://www.netbeans.org/kb/trails/php.html) and along with that I have released an update to the existing Drupal support in NetBeans. Please feel free to try out the enhanced wizard for assisting Drupal module development.\r\n\r\nThe modifications in the plugin are :\r\n* Generates the new module in appropriate location\r\n* Sticking to Drupal coding standards, generates template code for some of the common hooks (hook_block and hook_help) in the .module file\r\n* Sticking to Drupal coding standards, generates the .install file, which when not required can be removed. Some template code for some common hooks (hook_install and hook_uninstall) are provided.\r\n\r\nYou can download the plugin from NetBeans plugin portal (http://plugins.netbeans.org/PluginPortal/faces/PluginDetailPage.jsp?plug...) or from project page (https://nbdrupalsupport.dev.java.net/servlets/ProjectDocumentList?folder...). The source and documentation concerning usage of the plugin is hosted at the latter site.\r\n\r\nComments welcome!\r\n\r\nRegards,\r\nSujit Nair', '', 'filtered_html'),
('node', 'article', 0, 6, 6, 'und', 0, 'Besides the Handbook on drupal.org, there is also some Drupal documentation that is embedded in the Drupal source code, and visible from the administration pages of a Drupal site. This includes help pages for modules, help text displayed at the top of administration pages, and descriptive text within administration pages (e.g. help text for a setting field).\r\n\r\nBecause embedded documentation is part of the Drupal source code, the process for helping out with writing and editing this embedded documentation is slightly more complex than for editing pages on drupal.org. Here are some ways to help out:\r\n\r\nTest Drupal for text issues: During the development of a new Drupal version, download the new version from http://drupal.org/project/drupal, install it, and look over the help screens and user interface text. If you find something that should be fixed in a help screen or other embedded help text, file an issue: Even if you do not know how to create a patch, you can still give before/after text suggestions, and someone else can create the patch. To file an issue:\r\n\r\n<ol>\r\n<li>Log in to drupal.org</li>\r\n<li>Create an issue via the Create Content link (<a href="http://drupal.org/node/add/project-issue" title="http://drupal.org/node/add/project-issue" rel="nofollow">http://drupal.org/node/add/project-issue</a>)</li>\r\n<li>Choose "Drupal" as the project</li>\r\n<li>Choose the Drupal version. Note that it''s really only possible to change user interface text, help text, and other explanations in the version of Drupal that is under development. Stable releases have been translated into other languages, so their user interface text is almost never changed.</li>\r\n<li>Choose component "documentation" if the issue is in a help screen, or "user interface text" if it is user interface text, or choose the module that the issue pertains to as the component.</li>\r\n<li>Tag the issue with "ui-text" or "Help text" as appropriate.</li>\r\n<li>Choose category "bug report" -- text being wrong, missing, or unclear is a bug, not a feature request or task.</li>\r\n\r\n<li>Make up a clear title and description, and submit your issue.</li>\r\n</ol>\r\n\r\nHelp with existing issues: Use the advanced search for issues in the Drupal project (http://drupal.org/project/issues/search/drupal), and look for component "documentation" or "user interface text", or search for tags "Help text" or "ui-text". Be aware that most of the issues filed under component "documentation" are issues with the in-line programmer API documentation of functions in the source code (displayed on api.drupal.org), so if you are not a programmer, these will not be things you will probably want to work on. Even if you cannot write patches, you can still review patches and make suggestions on how to improve text, by commenting on issues. Some tips on using the issue queue:\r\n\r\n<ul>\r\n<li>Look for issues whose status is "active" or "needs work" if you want to write some documentation or code. Look for "needs review" issues if you want to review what others have done (an excellent place to start if you are new to Drupal issues, and a vitally important part of the process).</li>\r\n<li>Even if you are not a programmer, you can still review patches. Find an issue that has status "needs review", scroll down to the bottom of the issue''s comments, and find the latest patch attachment. Click on the attachment to see it. The lines with + are being added, lines with - are being removed. Some patches will also have a screen shot, making reviewing even easier.</li>\r\n<li>If you think a patch is good, add a comment saying what part you reviewed and that you thought it was good. If you think your review was comprehensive, or if several people have commented that it''s a good patch and you think the coverage overall is comprehensive enough, change the issue''s status to "Reviewed and tested by the community" (also known as "RTBC").</li>\r\n<li>If you think a patch needs some work, change the status of the issue to "needs work", and add a specific comment about what you think should be changed (if possible, with a suggestion of what to change it to). Please try to be constructive.</li>\r\n<li>If the issue you are looking at doesn''t yet have a patch, you can either make one or add suggestions as to what the text should say (someone else can read your suggestions and make a patch). If you attach a patch file, be sure to change the status of the issue to "needs review" so others can test and review your patch.</li>\r\n<li>And above all: Don''t take anything in the issue queue personally! The intent of the issue queue is to provide a forum for discussion on how to make Drupal better, so try to take any comments on your patches as constructive comments and thoughtful discussion (even if not everyone writes their comments in this way).</li>\r\n</ul>', '', 'full_html'),
('node', 'article', 0, 7, 7, 'und', 0, 'Hello,\r\n\r\nTwo months ago, a case study about the migration of France 24 from Drupal 5 to Drupal 6 was posted on drupal.org frontpage, and it was announced some really interesting modules were going to be open sourced.\r\n\r\nI''m happy to say it is (almost?) finished, and here is the list of modules:\r\n\r\n<ul>\r\n<li><b><a href="http://drupal.org/project/aef_multimedia_element" rel="nofollow">Multimedia Element</a>:</b> It allows you to create blocks (not drupal blocks) containing stories (inserted manually, automatically, semi-automatically with Easy View), carousels of stories, text, photos, diaporamas (including lightbox diapos), video, twitter, table, ... And you can embed these blocks directly into your story with a nifty FckEditor plugin. Here is a <a href="http://www.france24.com/en/20091116-obama-shanghai-students-speech-china-usa-relations-diplomacy-asia-economy" rel="nofollow">nice example of story with a carousel, a diaporama and a video multimedia element</a>.</li>\r\n<li><b><a href="http://drupal.org/project/aef_easy_view" rel="nofollow">Easy View</a>:</b> Easy View is a very easy and powerful interface framework to Views, in a CCK field. It also include Easy View Taxonomy, the easy view implementation of the taxonomy View. It basically allows a simple user to configure a View per node without using the complex View UI.</li>\r\n<li><b><a href="http://drupal.org/project/aef_image" rel="nofollow">Uberimage</a>:</b> Uberimage is an advanced image CCK field, with direct upload/nodereference support, result imagecache presets re-scaling and cropping, useful on websites with multiple different image ratio (16/9, 4/3, 16/5, ...)</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_formatter_selector" rel="nofollow">Formatter Selector</a>:</b> Ever wanted to let the user choose the theme of a node in a nodereference directly on the node edit page? This module allows you to do that.</li>\r\n<li><b><a href="http://drupal.org/project/aef_external_sources" rel="nofollow">External Sources</a> / <a href="http://drupal.org/project/aef_externodes" rel="nofollow">Externodes</a>:</b> Basically, this module allows you to map the nid and fid address space to another Drupal instance. A simple example: Given you have two drupals, if you type in your browser front.drupal.com/node/1000000001, it will in fact display the node 1 of back.drupal.com using front.drupal.com theme. back.drupal.com is nowhere visible to the end user. Basic example of use: A big image collection you want to share between drupals.</li>\r\n<li><b><a href="http://drupal.org/project/aef_nodeselect" rel="nofollow">Nodeselect</a>:</b> Nodeselect allows editors to search for content, in a simple exposed View integrated with Embedded Edit, and results can be drag and dropped into nodereferences.</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_embedded_edit" rel="nofollow">Embedded Edit</a>:</b> Embedded Edit allows you to create/view/edit a node in a kind of lightbox within a node edit page. When creating a node, a nodereference will get filled with this node.</li>\r\n<li><b><a href="http://drupal.org/project/aef_views_cck_formatter" rel="nofollow">Views CCK Formatter</a>:</b> Views CCK Formatter allows you to choose a node CCK formatter as a row style in your View. This is extremely useful when you want to reuse a node theme in different parts of your website.</li>\r\n<li><b><a href="http://drupal.org/project/aef_table" rel="nofollow">CSV Table</a>:</b> CSV table is a very simple table module that allows you to upload a CSV file in this CCK field, and display a table. This module will probably evolve a lot in the future.</li>\r\n<li><b><a href="http://drupal.org/project/aef_jcarousel_views" rel="nofollow">JCarousel for Views</a>:</b> JCarousel for Views is a simple module for using JCarousel in Views.</li>\r\n\r\n<li><b><a href="http://drupal.org/project/aef_jcarousel" rel="nofollow">JCarouself formatter framework</a>:</b> JCarousel formatter framework contains the JCarousel plugin plus a node CCK Formatter &lt;-&gt; JCarousel theme relationships framework.</li>\r\n<li><b><a href="http://drupal.org/project/aef_utilities" rel="nofollow">Utilities</a>:</b> An utilities modules used by all the above modules.</li>\r\n</ul>\r\n\r\nSorry, no pictures :( You can find them here or directly on the module project page.\r\n\r\nConcerning theming, the France24 and RFI websites are heavily based on the standard CCK nodereference formatters, that''s why almost all these modules are using it. I''ll probably make some doc on how to combine all these modules later.\r\n\r\nCheers,\r\nNicolas', '', 'filtered_html'),
('node', 'article', 0, 8, 8, 'und', 0, 'Drupal 7.3, a maintenance release which fixes security vulnerabilities is now available for download.\r\n\r\nDrupal 7.4 also fixes other issues reported through the bug tracking system.\r\n\r\nUpgrading your existing Drupal 7 sites is strongly recommended. There are no new features in these releases. For more information about the Drupal 7.x release series, consult the Drupal 7.0 release announcement.\r\n\r\n<h2>Security information</h2>\r\n\r\nWe have a security announcement mailing list, a history of all security advisories, and an RSS feed with the most recent security advisories. We strongly advise Drupal administrators to sign up for the list.\r\n\r\nDrupal 7 includes the built-in Update status module, which informs you about important updates to your modules and themes.\r\n\r\n<h2>Bug reports</h2>\r\n\r\nDrupal 7.x is being maintained, so given enough bug fixes (not just bug reports), a new maintenance release will be made available the last Wednesday of next month (July 27).\r\n\r\nDrupal 7.3 only includes fixes for security issues. Drupal 7.4 also includes bugfixes. The full list of changes between the 7.2 and 7.4 releases can be found by reading the 7.4 release notes. A complete list of all bug fixes in the stable 7.x branch can be found in the git commit log.\r\n\r\n<h2>Security vulnerabilities</h2>\r\n\r\nDrupal 7.3 was released in response to the discovery of security vulnerabilities. Details can be found in the official security advisory: SA-CORE-2011-002\r\n\r\nTo fix the security problem, please upgrade Drupal.\r\n\r\n<h2>What is included with each release?</h2>\r\n\r\nShows a graph and that 7.3 should be used to upgrade quickly, 7.4 contains bug fixes and might need testing.\r\n\r\nWe make two versions of Drupal core available, so you can choose to only include security fixes (Drupal 7.3) or security fixes and bugfixes (Drupal 7.4). You can choose your preferred version. We are trying to make it easier and quicker to roll out security updates by making security-only releases available as well as ones with bugfixes included. We hope this helps you roll out the fixes as soon as possible. Read more details in the handbook.\r\n', 'Drupal 7.3, a maintenance release which fixes security vulnerabilities is now available for download.\r\n\r\nDrupal 7.4 also fixes other issues reported through the bug tracking system.\r\n\r\nUpgrading your existing Drupal 7 sites is strongly recommended. There are no new features in these releases. For more information about the Drupal 7.x release series, consult the Drupal 7.0 release announcement.', 'filtered_html'),
('node', 'page', 0, 9, 9, 'und', 0, '<p>Quisque mi turpis, lobortis sit amet placerat ut, auctor nec metus. Sed iaculis nisl sed nibh laoreet vitae interdum sapien suscipit. Duis sit amet nulla sit amet urna molestie tempus. Sed cursus tellus at eros imperdiet euismod. Praesent sodales commodo gravida. Quisque sit amet dapibus metus. Nam mattis turpis consequat lorem iaculis tempus. Phasellus quam mauris, volutpat vel scelerisque ac, elementum in velit! Praesent vehicula orci id odio aliquet pulvinar? Mauris est tellus, tempor sit amet semper eget, pulvinar ac eros. Nunc ultrices ornare tortor a egestas. Cras fermentum diam cursus dolor molestie quis congue velit sagittis? Sed a dapibus diam. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Donec eu odio nulla, vitae cursus neque?</p>\r\n<p>Sed quis erat nulla; et semper tortor. Integer ac diam massa, at lobortis neque! Nulla facilisi. Pellentesque blandit aliquam metus, id consectetur diam suscipit ac! Aliquam erat volutpat. Vestibulum at placerat metus! Mauris ullamcorper sagittis magna et varius. Curabitur fermentum dictum massa eu vestibulum. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos orci aliquam.</p>\r\n<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'blog', 0, 10, 10, 'und', 0, 'Welcome to Drupal! Drupal is a powerful content management system, meaning you can power many different types of websites with it without knowing any coding languages.\r\n\r\nIf you''re new to Drupal or having your own website, then this guide is for you.\r\n\r\nThe following pages should introduce you to the Drupal project, some best practices the community has accumulated, the concepts and technologies that underpin Drupal, and basic installation and configuration.\r\n\r\nThe Drupal documentation is currently being restructured. Some content has been moved to the Administration Guide, Structure Guide and Site Building Guide.\r\n\r\nIf you need help installing Drupal, the Installation Guide has step by step instructions and troubleshooting tips.', '', 'filtered_html'),
('node', 'blog', 0, 11, 11, 'und', 0, 'The Drupal Cookbook (for Beginners) helps Drupal "newbies" by providing a walkthrough of a common Drupal Setup. You might also be interested in this whirlwind video.\r\n\r\n<h2>Background</h2>\r\n\r\nThis handbook was originally written for Drupal 5. While the information is generally transferable to Drupal 6, some buttons, links, and menu items have been renamed or moved. Every attempt is made to keep these handbooks current.\r\n\r\nThe intent of the Cookbook is to help the new Drupal user create a typical site. At that point the user will be better equipped to diving deeper into more advanced features.\r\n\r\n<h2>Terminology</h2>\r\n\r\nThis cookbook requires a basic understanding of the General Concepts of Drupal. Additional resources for understanding terms used in Drupal include:\r\n<ul>\r\n    <li>Terminology (Terms).</li>\r\n   <li>Drupal Jargon.</li>\r\n</ul>\r\n\r\n<h2>Conventions</h2>\r\n\r\nThe Cookbook and other documentation on drupal.org uses the following standard for indicating site navigation:\r\n\r\nAdminister >> Access control >> User management >> Roles.\r\n\r\nThe above example tells the user to click on "Administer" in the navigation menu, then "Access control," then "User management," and then "Roles".\r\nWorking with Drupal\r\n\r\nHere are some general recomendations:\r\n\r\n<ol>\r\n    <li>Use a test site that uses the same Drupal version and modules as the target site. Use a copy of the live database. Avoid development on a live site.</li>\r\n    <li>Don''t try to make the "perfect site" on the first attempt. Muddle through for a while. Stressing over the perfect solution can lead to frustration.</li>\r\n    <li>Start by learning the basic functionality of Drupal. Find out what Drupal can do before working towards a specific goal. Once comfortable with the "core" features and behavior, move on to more complex contributed modules such as Views, CCK, and Organic Groups. These modules and some others require a good bit of understanding to master. The power and flexibility of Drupal and its modules will become apparent over time.</li>\r\n    <li>If you need a custom theme, customize one of the default themes before creating starting from scratch. Refer to the Drupal 5 theme guide or Drupal 6 theme guide.</li>\r\n   <li> Limit the number of blocks, images, and graphics that clutter the page.</li>\r\n    <li>Participate in the forums, the Documentation Team, and IRC.</li>\r\n</ol>\r\n\r\n<h2>Things to keep in mind</h2>\r\n\r\nA common mistake when approaching a solution to a problem in Drupal is to make an assumption about how Drupal works. Drupal is a unique and powerful platform that is probably quite different from other solutions you may have encountered.\r\n\r\nStart simply by making something visible, then celebrate what you have accomplished. Taking one small step at a time will lead to a better site. Don''t indiscriminately add many contributed modules right away. Get comfortable with modules one at a time. Modules that are not appropriate or used should be disabled and uninstalled.\r\n\r\nAs with most things worth mastering, there is a learning curve with Drupal. But there is lots of support available as well.', '', 'filtered_html'),
('node', 'blog', 0, 12, 12, 'und', 0, 'After Drupal was initially developed, thoughts turned to the creation of a logo. Of course the concept would have to include a drop, or water in general.\r\n\r\nThe initial idea was simple: a drop within a circle. It was conceived as an "O" in a fluid "drop".\r\n\r\nSomewhat later there was an idea to use a cartoon-like drop with a face. Steven Wittens (UnConeD) created a 3D version, but the idea didn''t get too far, mainly because 3D is difficult to work with.\r\n\r\nWhen the logo issue came up again, Kristjan Jansen (Kika) came up with the idea of putting two sideways drops together to form an infinity symbol. When placed inside a filled circle, it resembled a face. After more work by Steven Wittens, the Druplicon was created: a stylised drop with the "infinity" eyes, a round nose and a mischievous smile.\r\n\r\nYou can find more versions of the logo in the marketing section.', '', 'filtered_html'),
('node', 'blog', 0, 13, 13, 'und', 0, 'As an inclusive community, we are committed to making sure that Drupal is an accessible tool for building websites and that Drupal helps you create websites that are themselves accessible.\r\n\r\nThis initiative started with advancements with Drupal 7 accessibility. We have committed to ensuring that all features of Drupal core conform with the Worldwide Web Consortium (W3C) guidelines: WCAG 2.0 and ATAG 2.0. Where possible we will also update the previous version of Drupal core, version 6, to enhance its accessibility.\r\nAccessible Features in Drupal\r\n\r\nIf you rely on a screen reader or other assistive technology, you will be glad to know that we have built Drupal to encourage and support the proper use of semantic markup. For example, you should be able to use headings reliably for page-level navigation.\r\n\r\nThe accessibility team has worked to identify barriers to accessibility with Drupal and worked to resolve them. We''ve identified and resolved a number of issues in the core code of Drupal 7 and raised awareness within the community. We''ve added some additional support for Rich Internet Applications by adding some WAI-ARIA support. There have been many improvements to both the visitor and administrator sides of Drupal, especially:\r\n\r\n<ul>\r\n   <li>Search engine form and presentation</li>\r\n    <li>Drag and Drop functionality</li>\r\n   <li>Color contrast and intensity</li>\r\n    <li>Adding skip navigation to core themes</li>\r\n    <li>Image handling</li>\r\n    <li>Form labeling</li>\r\n    <li>Removing duplicate or null tags</li>\r\n</ul>', '', 'filtered_html'),
('node', 'forum', 0, 16, 16, 'und', 0, 'For information on managing the ongoing operation of a Drupal site, see the Administration Guide. For information on developing the basic information architecture using menus, taxonomies, blocks etc, see the Structure Guide.', '', 'filtered_html'),
('node', 'forum', 0, 17, 17, 'und', 0, 'I''m having a problem updating several modules in Drupal 6. I put the site off line and then uploaded the latest modules via ftp as is my usual practice. I rename the directory of the module to be updated to "moduleJan2012" and put the new module folder in its place.\r\n\r\nI then ran update.php and when I check the modules are still showing as out-of-date.\r\n\r\nThe problem modules are Google analytics, wysiwyg, imce and webform. webform validator and root candy theme updated okay.\r\n\r\nI''ve since uploaded the module again to see if this helps but it didn''t. On the server it''s showing that the files were updated.\r\n\r\nMany thanks in advance for any suggestions', '', 'filtered_html'),
('node', 'forum', 0, 18, 18, 'und', 0, 'What would be a best way to launch a simple Drupal web site on AWS?\r\nI''ve just started learning AWS. So far, from what I have learned, I can go either of the following ways.\r\n1. Create an EC2 instance, install xampp and drupal, and keep developing web pages and web apps in EC2.\r\nI''ve done this, but I have not figured out how to make the web site accessible. (Do I need to setup elastic IP?)\r\n\r\n2. Install Drupal on a local machine and develop all web pages and apps locally. And then upload all local files to S3.\r\nThen, is S3 enough to host a web site? EC2 instance is not needed?\r\nAlso, who would I manage the upload for constant updates on Drupal modules and Drupal DB?\r\n\r\nWell, I need to dig more into EC2 and S3, but your input would be highly appreciated.', '', 'filtered_html'),
('node', 'forum', 0, 19, 19, 'und', 0, 'I updated Pixture reloaded theme before updating everything okay,but after updating it the look of the website changes,WHATS THE PROBLEM?? How can I edit pixture reloaded theme to its previous look.\r\nNo Database backup is taken. Only Drupal files have backup.\r\n\r\n', '', 'filtered_html'),
('node', 'forum', 0, 20, 20, 'und', 0, 'See the phpinfo() page on Drupal.org to learn how to use phpinfo to get the details of your system. For example, phpinfo will tell you if you have a database already installed and what versions of PHP, MySQL, etc. your system is running. Phpinfo will also tell you what PHP variables are set as well as many other helpful things.', '', 'filtered_html'),
('node', 'forum', 0, 21, 21, 'und', 0, 'For all the effort you put into building your site, the most important thing to your users is how your site looks. Managing the inconsistencies in your theme for each browser, for each module, and for user selectable themes can be very challenging.\r\n\r\nFirst you should familiarize yourself with basic Cascading Style Sheets (CSS) concepts. Review CSS Discuss or HTML dog for CSS resources. A good overview of the power of CSS can be seen at the CSS Zen Garden.', '', 'filtered_html'),
('node', 'product', 0, 47, 47, 'und', 0, 'Capto comis esse ex importunus neque probo quis tation wisi. Abbas bene natu pertineo praesent.\r\n\r\nAccumsan antehabeo commodo ideo jus occuro paratus praemitto quidem turpis. Facilisi facilisis quidne scisco tincidunt. Abbas autem ex facilisi in neo nibh quadrum ullamcorper. Abdo at facilisi tation. Amet ideo neo pala. Abluo esse et ideo jumentum lenis mauris mos occuro wisi.\r\n\r\nComis feugiat macto metuo odio quidem sagaciter veniam vulpes. Amet importunus jumentum occuro os velit. Caecus capto dignissim ea facilisi natu nostrud si vero. Acsi consequat genitus inhibeo quae refero zelus. Et feugiat gilvus illum inhibeo modo nutus roto tum ymo. Abigo dolus lenis nostrud singularis sino suscipere turpis typicus.\r\n\r\nCamur nutus uxor wisi. Decet facilisi iriure ludus. Meus secundum tamen. Nimis scisco suscipere. Eros haero pagus. Aliquip capto lenis meus nibh scisco tum zelus. Consectetuer esse illum nisl nulla obruo refoveo scisco sed suscipit.\r\n\r\nAbico elit populus suscipit. Antehabeo appellatio eros esse melior nimis nobis pala refoveo verto. Accumsan appellatio capto enim letalis lucidus. Brevitas diam eros esca hos letalis. Fere humo immitto macto mos neo nibh quae quidem quidne. Abdo gilvus neque odio persto qui quibus roto si. Acsi elit haero magna volutpat. Dolore venio verto.\r\n\r\nConsectetuer suscipit veniam. Hos ibidem nisl. Antehabeo sudo torqueo. Ibidem nibh secundum sed tum. Camur hos lenis scisco torqueo. Ea exerci huic lobortis magna nostrud probo refero rusticus. Appellatio caecus distineo duis fere ideo nisl nutus vulpes. Commodo gilvus iaceo ideo incassum torqueo zelus. Caecus exputo iriure iustum lucidus macto nisl. Abico comis gemino premo. Genitus haero laoreet modo qui te vulputate wisi.\r\n\r\nBrevitas dolor erat loquor olim probo. Gravis laoreet pala paulatim quidne sudo venio. At dolor gemino mos refoveo saepius sudo tum valde vulpes. Acsi dignissim gemino hendrerit lobortis nimis nostrud pagus quidem valde. Aptent eros iusto meus quadrum saluto utinam vereor. Distineo os sagaciter usitas validus virtus zelus.\r\n\r\n', '', 'full_html'),
('node', 'product', 0, 52, 52, 'und', 0, 'Hos mos sagaciter. Augue commoveo macto pala sudo suscipit ymo. Iusto macto singularis suscipere. Abbas aliquip commodo distineo illum refoveo sudo suscipit ullamcorper valetudo. Appellatio commoveo cui esca incassum loquor nimis pecus pertineo proprius.\r\n\r\nDignissim dolus nobis suscipit volutpat. Ea hendrerit validus. Acsi illum importunus plaga suscipere. Caecus comis facilisis plaga premo saepius ulciscor. Caecus comis eros hendrerit plaga praesent uxor validus. Enim feugiat gemino premo sagaciter ut vel.\r\n\r\nDistineo dolus ea esse exputo jumentum populus. Aliquam at capto commoveo odio pertineo te tego. At inhibeo neo probo. Haero ille immitto loquor metuo premo ratis validus. Conventio cui humo mauris melior pertineo roto utinam. Fere iriure mauris praemitto quidne validus.\r\n\r\nAdipiscing amet eu eum neo paulatim. Abigo comis dolus feugiat paulatim quia vel vulputate. Accumsan inhibeo sino wisi.\r\n\r\nCamur cui diam huic laoreet voco. Amet at comis ideo imputo luptatum persto valetudo. Abigo minim molior obruo pagus pala paratus quis.\r\n\r\nEsca illum lobortis. Brevitas caecus capto dolore minim molior mos quidem ulciscor ymo. Dolore hos importunus jumentum nibh qui quibus sagaciter. Dignissim incassum proprius secundum vel. Abico jugis olim praesent refero tum ut vulpes zelus. At blandit defui imputo ullamcorper usitas valetudo.\r\n\r\nCogo defui ea inhibeo ludus pertineo utrum. Adipiscing elit ille in incassum magna neque ullamcorper vero. Blandit brevitas enim feugiat lucidus venio voco. Luptatum mos nulla nunc pertineo refero vulpes. Haero oppeto tamen zelus. Amet immitto iustum neo olim similis sit vereor wisi. Dolus duis nisl. Defui dolus ea euismod similis uxor.\r\n\r\n', '', 'plain_text'),
('node', 'product', 0, 53, 53, 'und', 0, 'Comis patria tum vel. Accumsan commoveo verto. Illum suscipere tum. Diam dolore modo nibh odio sed. Ea gravis illum modo nobis nulla pecus suscipit tation. Haero huic modo nibh quibus quidne saluto secundum ullamcorper. Appellatio duis exputo haero importunus modo plaga ullamcorper. Iustum lenis mos patria sudo. Aliquip comis enim fere hendrerit quadrum. Dolus importunus inhibeo.\r\n\r\nAd commoveo quia usitas. Euismod inhibeo roto. Abico esse et in quae refero secundum turpis. Abico antehabeo macto. Facilisi facilisis inhibeo luptatum praesent refoveo vicis. Dolor interdico patria praemitto. Abdo haero ibidem lucidus sudo ut uxor virtus vulputate zelus. Aptent capto eros fere laoreet lucidus luctus minim vulputate wisi. Iusto tamen voco. Aliquam antehabeo aptent eum jumentum luctus meus neo tamen turpis.\r\n\r\nQuae suscipit volutpat. Diam eros illum jumentum mauris neo persto plaga valetudo. Camur comis cui in suscipit veniam volutpat vulpes wisi. Luctus olim quidne venio. Aliquip incassum lobortis. Diam jumentum loquor macto odio velit. Aptent ideo nisl pagus pneum tamen tation velit. Antehabeo loquor minim modo persto premo sudo ullamcorper vulpes.\r\n\r\nEuismod gemino illum in meus pala suscipere virtus. Eligo eum facilisis iusto praesent quis usitas. Bene brevitas eu molior validus verto. Caecus cogo exputo facilisi loquor natu ullamcorper valetudo vero vindico.\r\n\r\nConventio loquor neque nutus occuro persto qui quidne secundum ullamcorper. Accumsan ea et imputo lenis macto pecus vel. Abbas iusto modo persto refoveo te uxor voco. Abico abigo meus minim. Abico autem commodo meus torqueo. Erat metuo olim.\r\n\r\n', '', 'plain_text'),
('node', 'product', 0, 54, 54, 'und', 0, 'Eum iaceo praemitto vereor. At melior pagus vulputate. Adipiscing antehabeo dolore fere importunus jumentum persto praemitto wisi. At brevitas duis. Abdo aptent elit laoreet proprius sagaciter sed uxor. Antehabeo dolore metuo. Distineo erat neo obruo pagus quis. Eligo in tum. Abigo magna tincidunt tum usitas. Accumsan lobortis saepius tamen.\r\n\r\nAt bene feugiat ideo torqueo. Abluo ad erat immitto meus nostrud nulla sagaciter wisi. Antehabeo bene gravis humo ideo laoreet tincidunt. Lobortis lucidus natu paratus plaga quae suscipit. Abico brevitas importunus typicus.\r\n\r\nCausa consequat lucidus metuo sagaciter ulciscor wisi. Hendrerit immitto iusto nisl paratus populus premo quae sudo.\r\n\r\nConsectetuer metuo wisi ymo. Blandit elit saluto valde. Obruo proprius utrum. Accumsan dolore magna ratis tamen.\r\n\r\nCamur haero importunus ludus nobis quis vero. Accumsan acsi adipiscing comis dolus gravis nulla. Comis illum vel. Ad augue dolus iriure jumentum ludus meus natu refero vulputate. Abdo camur damnum illum magna obruo paulatim ulciscor validus.\r\n\r\nCapto et neque persto pertineo quidne si velit. Comis jus molior valde valetudo veniam. Pagus sagaciter utrum. Abbas abluo decet dolus duis eu exputo os ut vel. Abico ea erat obruo ymo. Abigo ille melior nostrud paratus tation usitas voco vulpes. Cogo dignissim distineo dolore euismod imputo jus premo sino verto. Amet duis esse iustum jus ludus natu qui venio.\r\n\r\nAcsi elit eum gravis sino vindico. Abluo ibidem loquor luptatum nimis nobis praesent quae similis. Olim turpis vulpes. Camur conventio eu te. Conventio diam imputo melior praemitto usitas virtus. Antehabeo comis conventio decet persto premo ratis. Ibidem magna patria ullamcorper volutpat. Abico antehabeo appellatio causa proprius tego utrum virtus. Adipiscing augue dolus elit ex saluto. Nostrud proprius scisco sudo vulpes.\r\n\r\nCui euismod imputo tego. Comis praemitto rusticus vereor. Abico plaga quia. Abigo commodo dignissim facilisis hendrerit odio roto saepius sit usitas.\r\n\r\nDolore gravis huic mauris. Abigo brevitas esca melior mos. Abbas amet caecus decet humo immitto minim paulatim roto ulciscor. Duis lucidus persto premo tincidunt velit. Velit veniam volutpat. Adipiscing causa distineo iriure jus sit validus vicis. Acsi elit genitus melior praesent quae refero valetudo. Dolore humo mauris nobis refero valetudo virtus. Acsi nimis persto pneum premo quia ratis valde verto.\r\n\r\n', '', 'full_html'),
('node', 'product', 0, 55, 55, 'und', 0, 'Consequat illum jus mauris modo olim os ulciscor ut ymo. Facilisis ibidem jus neo nisl saepius scisco virtus ymo. Ea patria suscipere. Hendrerit luctus tego ulciscor validus.\r\n\r\nComis meus saluto. Aptent facilisis jugis jumentum paulatim secundum veniam vicis. Dignissim ideo virtus. Metuo neo valde. Distineo et interdico os. Appellatio bene laoreet odio quia scisco sino. Adipiscing hendrerit hos mauris os secundum virtus. Consequat dignissim facilisi lobortis mos nibh paulatim pecus virtus. Bene ea lenis. Abico camur dolus huic odio pala plaga proprius uxor.\r\n\r\nAbluo esse gemino gravis hendrerit quibus refero singularis te. Aliquip hos pagus. Bene capto distineo interdico meus persto torqueo vero. Abluo caecus diam ideo macto os si singularis velit vereor.\r\n\r\nAt euismod illum incassum magna nulla nutus pagus paratus validus. Gravis melior plaga qui validus.\r\n\r\nDolor exerci ideo molior tation. Acsi causa jus. Eu olim ullamcorper. Autem iaceo interdico ludus paulatim valetudo. Ex iaceo typicus vicis. Blandit dolor erat facilisis gilvus in neque odio. Ad inhibeo premo quae scisco typicus utinam valde.\r\n\r\nAdipiscing amet eligo laoreet ludus paratus praesent velit veniam voco. Abluo adipiscing euismod melior obruo saluto si te. Accumsan aliquam imputo magna modo pala pneum sed ut.\r\n\r\nFacilisi lenis tum ullamcorper validus vulpes. Aptent ille singularis. At cogo ex magna nobis saluto torqueo usitas validus. At camur et qui vereor vero. Humo illum neo nobis occuro pagus similis vicis. Macto sed suscipit ulciscor. Cui exputo uxor.\r\n\r\nAbico antehabeo sagaciter velit. Dolor erat minim saepius sed si tation valetudo veniam. Camur esca jugis lobortis odio pala. Camur eum lobortis nobis. Luctus modo praemitto quae qui refero usitas wisi. Amet natu paulatim torqueo. Ad brevitas cogo enim illum melior pagus pala roto. Aliquam antehabeo augue erat fere iustum nutus tego.\r\n\r\nCapto consequat valetudo. Brevitas consectetuer diam dolor esca iustum praemitto quidem zelus. Capto facilisi haero luptatum molior os paulatim populus quidne quis. Ea natu te ymo.\r\n\r\nAbdo accumsan appellatio conventio in iusto jumentum mos refoveo suscipere. Olim sed voco. Abigo brevitas cui diam esca eum haero rusticus vel. Dolus nibh nisl os. Abluo brevitas damnum volutpat.\r\n\r\nAppellatio caecus exerci illum jumentum macto metuo saluto valde. Letalis si zelus. Abbas capto commodo eligo eum gravis hos nimis ratis.\r\n\r\n', '', 'plain_text');
INSERT INTO `field_revision_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'product', 0, 56, 56, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'full_html'),
('node', 'article', 0, 57, 57, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 58, 58, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 59, 59, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'filtered_html'),
('node', 'article', 0, 60, 60, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'article', 0, 61, 61, 'und', 0, '<p>Curabitur lectus tortor, dapibus quis fringilla nec, iaculis at tortor. Sed non hendrerit urpis. Duis viverra purus sit amet nisi tincidunt at iaculis velit ullamcorper. Sed mollis accumsan aliquam. Donec suscipit gravida nisl. Mauris nec diam nibh, a ullamcorper libero. Quisque elementum mauris at ellus egestas feugiat.</p>\r\n<p>Header One Lorem emphasised est dolor sit amet, ong est. Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus, fames nam erat pretium mattis volutpat leo, aliquam nulla.</p>\r\n<p>Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante. Nisl in Pellentesque mauris nibh et vel tincidunt auctor fringilla id. Neque elit augue.</p>\r\n<p>Ornare libero vel consectetuer eget feugiat Curabitur natoque neque nibh pretium. Risus dui sem convallis lacinia Donec vel Phasellus lacus velit commodo. Eu Quisque Integer gravida metus congue Vestibulum Curabitur id Vivamus elit. Sapien id elit nulla et mus Ut sed cursus et dictumst. Consectetuer molestie eros Sed et Vivamus condimentum orci Morbi eget mus. Wisi laoreet metus condimentum cursus Duis justo ante Donec.</p>\r\n<ul>\r\n<li>Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede</li>\r\n<li>Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur</li>\r\n<li>Risus dui sem convallis lacinia Donec vel Phasellus</li>\r\n<li>Ut nullam leo imperdiet arcu aliquam, a id massa anim molestie at, amet libero tellus</li>\r\n</ul>\r\n<p>Gravida massa amet at lacus pede Sed nunc ut nec laoreet. Amet sodales In enim mollis condimentum nec dui malesuada id Nunc. Lacus orci feugiat rhoncus Phasellus amet libero eu egestas rhoncus magna. Ac vitae consectetuer Aenean wisi adipiscing volutpat Mauris pede orci Nam. Magna mollis dictumst est Ut est ultrices wisi a platea urna. Ultrices elit et Morbi interdum enim lacus mauris nec consectetuer commodo. Laoreet id commodo.</p>\r\n<p>Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede. Quis nunc congue pede vitae vel wisi interdum Aliquam id tincidunt. Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.</p>', '', 'full_html'),
('node', 'product', 0, 62, 62, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.', '', 'filtered_html'),
('node', 'product', 0, 63, 63, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.', '', 'filtered_html'),
('node', 'product', 0, 64, 64, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 65, 65, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 66, 66, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 67, 67, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 68, 68, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 69, 69, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 70, 70, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 71, 71, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 72, 72, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 73, 73, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n\r\n', '', 'filtered_html'),
('node', 'product', 0, 74, 74, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 75, 75, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 76, 76, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html');
INSERT INTO `field_revision_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `body_value`, `body_summary`, `body_format`) VALUES
('node', 'product', 0, 77, 77, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 78, 78, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'product', 0, 79, 79, 'und', 0, 'Capto dignissim enim eu ratis similis valde valetudo. Abbas amet aptent importunus utinam utrum vindico. Augue causa haero os refero tamen ymo. Abbas abico sudo. Esca nutus obruo olim populus qui quidne tation tego. Blandit consequat iustum pecus probo quibus ullamcorper veniam.\r\n\r\nCamur et interdico jugis metuo occuro quibus quidne. Distineo in iriure luctus. Ideo modo premo. Abluo refoveo vereor. Genitus inhibeo nibh praemitto. Abico consequat et hos huic usitas utinam vicis.\r\n\r\nEligo facilisi incassum patria. Abigo eros populus proprius similis te. Bene gemino huic illum patria proprius similis usitas ymo. Abigo aliquip laoreet obruo patria proprius refero utrum virtus.\r\n\r\nAbluo acsi comis decet dignissim nimis nunc quae. Brevitas roto wisi ymo. Abluo jus premo probo singularis vero.\r\n\r\nInterdico ludus molior sed suscipit tego vero verto vulpes. Camur luctus quibus. Eligo laoreet magna natu nunc plaga quibus sit. Importunus neo roto saluto.\r\n\r\nAbbas autem dolus incassum patria pecus quia vero. Abbas abluo cui huic ille iustum laoreet validus. Gravis meus quae quidem. Camur dignissim luptatum saluto sino wisi. Aliquam damnum defui lucidus quis ratis usitas. Eros jus ratis. Aliquip damnum genitus lenis valde vel. Dolor dolus exputo ideo iustum nostrud. Duis ea iusto. Appellatio dignissim eum huic lucidus vero. Ex probo tamen voco.\r\n\r\nDignissim gilvus ille immitto laoreet melior meus nisl saluto tum. Lobortis luctus saluto. Eu eum iusto natu pertineo proprius. Comis dolore minim sino typicus. Dignissim fere nibh nobis quidne ymo. Caecus comis commoveo consectetuer conventio lucidus oppeto paratus pertineo quadrum. Abico camur duis ex saepius sudo suscipit ulciscor voco volutpat. Blandit cogo nunc probo. Adipiscing odio torqueo valde voco.\r\n\r\nAppellatio augue brevitas hendrerit premo quia quis sudo vero. Ibidem inhibeo velit.\r\n\r\nAppellatio facilisi te vulpes vulputate. Abico bene ibidem ideo odio. At cui enim euismod humo ideo magna obruo patria. Autem ibidem lucidus luptatum modo neque pala singularis utrum vicis. Appellatio cogo exputo populus. Cui immitto in. Defui incassum singularis.\r\n', '', 'filtered_html'),
('node', 'page', 0, 80, 80, 'und', 0, 'Praesent id urna erat. Cras porta venenatis libero quis viverra. Praesent lobortis, tellus quis aliquam posuere, lorem orci condimentum nisi, eu pretium leo leo ornare odio. In hac habitasse platea dictumst. Vestibulum euismod consectetur lorem non molestie. Cras fermentum placerat est, venenatis tincidunt ipsum consectetur vel. Duis tristique dolor at lorem tempor, id hendrerit orci vulputate. Morbi laoreet velit nec ipsum hendrerit consectetur. Cras mauris tortor; tincidunt vitae fermentum eu, aliquam eget nisl. In sit amet neque ante. Nam a fermentum nunc.\r\n\r\nVivamus id sem lorem. Donec in metus elementum, porttitor leo ut, suscipit enim. Phasellus nisi felis, volutpat a feugiat id, pulvinar vitae nulla. Morbi tempor diam vitae fringilla sollicitudin. Curabitur a ipsum sodales; ultricies nisi non, malesuada risus! Nunc scelerisque enim lacus; non luctus elit porttitor eget. Proin in nisl massa. Vestibulum convallis felis ut magna malesuada tempor. Morbi quis ipsum et mauris interdum posuere. Praesent tempus ac arcu ac sollicitudin.\r\n\r\nCurabitur ac est nulla. In in ornare orci, quis egestas metus! Proin eget vehicula ante. Etiam et libero et massa elementum commodo. Suspendisse volutpat.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 81, 81, 'und', 0, 'Nullam leo purus, posuere aliquet lorem non; vestibulum rhoncus lacus! Aliquam dapibus elit orci, ut vulputate erat accumsan eget. Pellentesque at libero sit amet tellus ornare convallis. Integer pellentesque facilisis lorem a malesuada. Cras vel nulla dictum; iaculis nibh id, pharetra urna. Aenean gravida lacus mauris. Pellentesque consectetur lectus sit amet velit vulputate, quis faucibus leo pretium. Curabitur at placerat leo. Praesent sagittis turpis sed velit congue adipiscing. Nullam tristique dui sed lorem feugiat, eget fermentum libero suscipit. Proin molestie, mi eget ultrices mollis, mauris magna fringilla sapien, eu interdum urna ipsum eu nulla. Nulla pharetra laoreet mi id ornare. Ut lectus enim, accumsan fringilla diam et; ultricies imperdiet lectus. Duis porttitor massa eget risus blandit laoreet. Sed molestie felis non felis consequat, in iaculis mi sodales.\r\n\r\nSed venenatis egestas massa eget suscipit. Praesent vitae placerat enim. Vestibulum a felis tortor. Quisque blandit eget tellus in convallis. Phasellus dignissim, enim ac auctor sodales, quam lectus mollis metus, ut accumsan justo nibh vel arcu. Proin ante libero, dignissim ullamcorper congue eu; elementum id sed.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 82, 82, 'und', 0, 'Etiam fringilla elementum urna, id venenatis urna commodo mollis! Quisque vel est sed nibh dapibus gravida sed id libero. Aliquam facilisis tortor sed feugiat condimentum. Sed euismod elementum tellus vitae egestas. Sed consectetur nisi non consectetur viverra. Nulla aliquet libero ac leo dictum elementum. Morbi eu nibh vitae neque viverra gravida. Nullam vehicula odio gravida, aliquam diam vel, dignissim dolor. Curabitur pharetra augue at ante varius fermentum. Cras consequat malesuada nisl elementum volutpat. Praesent vel dolor ultrices, vestibulum mauris laoreet, venenatis diam.\r\n\r\nDonec consectetur nibh in velit iaculis, ut viverra nibh imperdiet. Nullam tortor felis, commodo et interdum faucibus; vulputate nec metus. In hac habitasse platea dictumst. Quisque mollis leo a leo tincidunt semper. Morbi vitae congue ligula. Aliquam ornare purus ut nulla elementum, non vestibulum magna auctor. Donec quis dui sed odio volutpat ullamcorper. Pellentesque eleifend ipsum ac lacus elementum ullamcorper. Integer ut lorem nulla. Mauris laoreet eros id quam placerat tincidunt.\r\n\r\nInteger quam purus, varius et mauris ut, gravida faucibus tortor. Phasellus massa diam; vulputate a aliquet eget posuere.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 83, 83, 'und', 0, 'Etiam at leo leo! Maecenas blandit eget orci non adipiscing. Maecenas vulputate metus non odio iaculis egestas. Aenean fermentum imperdiet magna, eu sodales erat vulputate sed. Ut tincidunt dapibus mauris, non feugiat lorem volutpat sed. Ut eget dui non urna sodales feugiat. Nunc hendrerit, est sed egestas tincidunt, lectus mi tempor neque, ac ornare sapien ipsum at erat. Nulla sed risus pulvinar, scelerisque diam nec, egestas urna. Ut nec eros tempus, ullamcorper ipsum non, hendrerit ante. Aenean viverra molestie erat, quis dignissim ipsum bibendum vel? Morbi arcu purus; scelerisque mollis mi quis; tempor ullamcorper nisi. Fusce eget urna eleifend nulla mollis rhoncus vitae eget mi.\r\n\r\nVestibulum nec tortor sed tellus lobortis posuere. Phasellus ut massa consectetur risus gravida viverra. Etiam odio nisi, porta ut tortor egestas, sodales iaculis tortor. Quisque rhoncus imperdiet odio, elementum dignissim magna molestie nec. Etiam sit amet dolor id est aliquet congue in vel est. Ut feugiat felis in lacus dignissim scelerisque. Etiam urna ipsum, luctus eget risus ac, malesuada auctor felis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis turpis duis.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 84, 84, 'und', 0, 'Cras nec orci mattis; rhoncus orci vel, euismod nisl? Pellentesque sit amet neque a lacus euismod adipiscing sed sit amet risus. Suspendisse potenti. Pellentesque condimentum in ipsum in volutpat. Cras id faucibus massa. Proin vitae lobortis felis, ut lobortis augue. Ut tempor turpis in tellus bibendum, mattis lacinia magna porta. Nulla facilisi. Fusce luctus molestie ligula in molestie. Fusce luctus neque nec urna ornare rhoncus! Curabitur commodo sem dui, nec bibendum arcu ultricies eget. Cras eu augue a enim feugiat feugiat!\r\n\r\nEtiam dapibus est eu rhoncus viverra. Nullam eget convallis dolor. Aenean imperdiet diam vel arcu tristique, et tincidunt massa cursus. Aliquam molestie mollis dolor, vitae mollis libero auctor non. Suspendisse ornare purus ante, vitae lacinia orci varius quis! Suspendisse varius sapien ut gravida faucibus. Morbi vehicula, massa ut commodo pretium, metus nunc imperdiet lorem; a scelerisque erat tellus eget est. Ut vitae enim ut sem vehicula iaculis. Vestibulum consectetur urna id molestie pretium. Proin id consectetur nisl, sit amet fringilla lacus. Vivamus viverra turpis eu suscipit tincidunt. Mauris ornare venenatis gravida! Fusce tincidunt bibendum nullam.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 85, 85, 'und', 0, 'Duis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 86, 86, 'und', 0, 'Duis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 87, 87, 'und', 0, 'Duis blandit dictum diam, eu tristique elit eleifend a. Aenean molestie urna nulla, id pulvinar augue dapibus non. Ut ultrices mi in nibh rhoncus, ac aliquet sem commodo. Phasellus commodo tincidunt varius. Aliquam sit amet leo sit amet magna fringilla eleifend. Nam euismod tristique mi non lobortis. Integer feugiat eu mauris a semper. Duis sit amet diam in augue ullamcorper varius. Sed ut dolor hendrerit, ornare magna at, volutpat tellus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Praesent id hendrerit nibh. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sit amet lorem facilisis, aliquam tellus sit amet, mollis arcu. Fusce dapibus enim ut risus suscipit; ut interdum enim dapibus.\r\n\r\nMauris risus massa, eleifend ac eros congue, fermentum placerat justo. Vestibulum sit amet dui mollis, sodales turpis vitae, dignissim sem. Nullam eget scelerisque dolor. Fusce lacinia malesuada aliquet. Curabitur venenatis posuere augue at bibendum. Mauris eu velit feugiat risus aliquam rutrum. Proin dapibus nisl sit amet risus molestie imperdiet.\r\n\r\nDonec fringilla nisl ac libero egestas, quis blandit ante vehicula. Nulla ac nulla in nisi pharetra cursus id at sem amet.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 88, 88, 'und', 0, 'Donec tincidunt ante ac turpis hendrerit, ut aliquam risus sollicitudin. Donec facilisis, ipsum vitae aliquam vulputate, libero purus consequat massa, eget consectetur neque turpis eget lectus. Fusce non libero venenatis, pharetra massa eu, adipiscing nulla. Fusce ullamcorper, justo at tempor elementum, dolor neque vestibulum magna, a egestas nisi mauris sed elit. Proin dapibus congue mi, ut sodales augue tincidunt vitae. In at adipiscing odio. Etiam pharetra consectetur leo, nec commodo nunc scelerisque vel. Proin feugiat porta sem, vitae fermentum diam dignissim a. Aenean eget odio sit amet tortor luctus fringilla. Nunc non pulvinar lacus. Praesent accumsan at eros at mollis. Vivamus rhoncus neque sit amet dolor blandit, sed scelerisque velit gravida. Mauris eu lacinia orci. Nunc tristique lectus eu gravida porttitor. Integer tempor nisi metus, in pellentesque justo interdum eu?\r\n\r\nSuspendisse egestas nisl massa, quis eleifend magna accumsan sit amet. Proin sed nibh quis odio eleifend molestie. Morbi vitae imperdiet ante. Donec tortor augue, euismod ac eros nec, lacinia lobortis est. In iaculis et sapien quis ullamcorper. Proin dictum, elit sit amet tincidunt dapibus, neque volutpat.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html'),
('node', 'page', 0, 89, 89, 'und', 0, 'Nunc mollis lorem a rutrum eleifend. Vestibulum lacus nisi, vehicula vel justo mollis, sodales fringilla urna. Quisque vestibulum libero sit amet varius pulvinar. Cras id orci vitae libero imperdiet vestibulum. Aliquam a condimentum sem, laoreet consequat metus. Curabitur purus augue, ornare ac fringilla nec, fringilla ac arcu. Maecenas tincidunt tempor suscipit. Donec nunc ante, iaculis vel erat non, pretium rutrum lectus. In elementum adipiscing malesuada. Aenean pellentesque a felis sit amet aliquam. Nunc non venenatis justo, sed adipiscing libero. Aenean rhoncus leo eget ornare placerat. Mauris imperdiet malesuada est, sit amet faucibus sapien pharetra sed.\r\n\r\nPellentesque nec volutpat odio. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus vehicula est quis libero vulputate laoreet. Pellentesque in neque ac turpis pellentesque bibendum quis et nisi. Etiam porta eros egestas consequat fringilla. Fusce gravida pharetra dui id mattis. Nulla dictum imperdiet justo, ac rhoncus tellus pulvinar sit amet. Donec convallis sagittis erat sit amet interdum. Cras ultricies velit sagittis mattis tincidunt! Donec sagittis adipiscing congue. Sed pharetra congue fringilla posuere.\r\n\r\nDuis ipsum metus, gravida vel congue non, lobortis eget orci. Mauris pharetra interdum nisi ut tempus. Pellentesque non risus lacinia, congue nisl bibendum, vehicula velit. Nulla ut tortor eu odio sollicitudin placerat non eu leo. Donec ut ante vel est ultricies semper. Aliquam ipsum ligula, sagittis gravida arcu vel; facilisis commodo quam! Pellentesque dapibus sapien ante, sit amet fringilla lectus consequat sed. Integer congue, lectus quis cursus aliquam; justo lacus sagittis sem, nec rutrum lacus sem et nisi. Donec sit amet urna id nisi rutrum semper sed in purus? Sed cursus aliquam felis sit amet posuere. Donec vitae consectetur massa. Pellentesque augue tortor; euismod a arcu gravida, volutpat euismod eros? Donec ut dolor nec lacus iaculis sodales nec et magna. Nulla sodales sed ipsum a ultricies. Aenean viverra bibendum aliquet. Praesent mattis rutrum risus eget dictum.\r\n\r\nPhasellus tristique tempor tortor, ac auctor neque ullamcorper quis. In iaculis leo vitae congue mollis! Suspendisse potenti. Vivamus nec accumsan dolor, eu euismod lorem? Nulla hendrerit odio dui, at commodo metus consectetur eget? Sed tincidunt congue ullamcorper. Praesent et tellus eu purus vulputate metus.\r\n', '', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_comment_body`
--

CREATE TABLE IF NOT EXISTS `field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 1 (comment_body)';

--
-- Dumping data for table `field_revision_comment_body`
--

INSERT INTO `field_revision_comment_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `comment_body_value`, `comment_body_format`) VALUES
('comment', 'comment_node_forum', 0, 1, 1, 'und', 0, 'And really, a validating, clean layout will work 90 % of the time. It will have easy fixes 9 % of the time and will require hard measures only 1 % of the time. Really!', 'filtered_html'),
('comment', 'comment_node_forum', 0, 2, 2, 'und', 0, 'Please ensure that you''ve validated both the CSS and HTML for your website using W3C tools. It would be great to review your theme with both the WAVE and FAE accessibility evaluators too. There are also some other good validation tools.', 'filtered_html'),
('comment', 'comment_node_article', 0, 3, 3, 'und', 0, 'Est condimentum fringilla justo tellus est velit lacus et Vestibulum Vestibulum. Ullamcorper vitae ante mauris consectetuer dui pede Lorem Cum lorem ac.', 'filtered_html'),
('comment', 'comment_node_article', 0, 4, 4, 'und', 0, 'Non ornare Curabitur auctor quis id justo sem lacinia Vestibulum montes. Laoreet Mauris ipsum at et laoreet justo eget quis ultrices pede.', 'filtered_html'),
('comment', 'comment_node_article', 0, 5, 5, 'und', 0, 'Sodales ac feugiat elit Integer gravida risus eu habitasse ligula Lorem. Id senectus tincidunt metus porta amet sem senectus tellus Curabitur Fusce. Eget Curabitur rutrum Pellentesque Curabitur Nullam orci ut tristique Curabitur lacinia. Tortor consectetuer ac at montes id id neque est leo vel. Phasellus libero ut dui pede sagittis vel auctor dignissim Nunc ante.', 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_articles`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_articles` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_articles_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_articles_tid` (`field_articles_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 18 (field_articles)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_blog_img`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_blog_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_blog_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_blog_img_alt` varchar(512) DEFAULT NULL,
  `field_blog_img_title` varchar(1024) DEFAULT NULL,
  `field_blog_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_blog_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_blog_img_fid` (`field_blog_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 9 (field_blog_img)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_blog_tags`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_blog_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_blog_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_blog_tags_tid` (`field_blog_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 10 (field_blog_tags)';

--
-- Dumping data for table `field_revision_field_blog_tags`
--

INSERT INTO `field_revision_field_blog_tags` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_blog_tags_tid`) VALUES
('node', 'blog', 0, 11, 11, 'und', 0, 14),
('node', 'blog', 0, 11, 11, 'und', 1, 15),
('node', 'blog', 0, 12, 12, 'und', 0, 14),
('node', 'blog', 0, 13, 13, 'und', 0, 14);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_categories`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_categories` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_categories_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_categories_tid` (`field_categories_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 16 (field_categories)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_category`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_tid` (`field_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 7 (field_category)';

--
-- Dumping data for table `field_revision_field_category`
--

INSERT INTO `field_revision_field_category` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_category_tid`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 3),
('node', 'article', 0, 2, 2, 'und', 0, 3),
('node', 'article', 0, 3, 3, 'und', 0, 3),
('node', 'article', 0, 5, 5, 'und', 0, 3),
('node', 'article', 0, 6, 6, 'und', 0, 3),
('node', 'article', 0, 7, 7, 'und', 0, 3),
('node', 'article', 0, 8, 8, 'und', 0, 3),
('node', 'article', 0, 57, 57, 'und', 0, 21),
('node', 'article', 0, 58, 58, 'und', 0, 21),
('node', 'article', 0, 59, 59, 'und', 0, 21),
('node', 'article', 0, 61, 61, 'und', 0, 21);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_category_image`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_category_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_category_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_category_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_category_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_category_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_category_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_category_image_fid` (`field_category_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 11 (field_category_image)';

--
-- Dumping data for table `field_revision_field_category_image`
--

INSERT INTO `field_revision_field_category_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_category_image_fid`, `field_category_image_alt`, `field_category_image_title`, `field_category_image_width`, `field_category_image_height`) VALUES
('taxonomy_term', 'categories', 0, 16, 16, 'und', 0, 345, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 17, 17, 'und', 0, 346, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 18, 18, 'und', 0, 348, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 19, 19, 'und', 0, 351, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 20, 20, 'und', 0, 349, '', '', 270, 270),
('taxonomy_term', 'categories', 0, 22, 22, 'und', 0, 350, '', '', 270, 270);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_forums`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_forums` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_forums_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_forums_tid` (`field_forums_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 17 (field_forums)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_image`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL,
  `field_image_title` varchar(1024) DEFAULT NULL,
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 4 (field_image)';

--
-- Dumping data for table `field_revision_field_image`
--

INSERT INTO `field_revision_field_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_image_fid`, `field_image_alt`, `field_image_title`, `field_image_width`, `field_image_height`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 239, '', '', 194, 174),
('node', 'article', 0, 57, 57, 'und', 0, 342, '', '', 700, 300),
('node', 'article', 0, 58, 58, 'und', 0, 341, '', '', 700, 300),
('node', 'article', 0, 59, 59, 'und', 0, 340, '', '', 700, 300),
('node', 'article', 0, 60, 60, 'und', 0, 339, '', '', 194, 174),
('node', 'article', 0, 61, 61, 'und', 0, 343, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_img`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_img` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_img_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_img_alt` varchar(512) DEFAULT NULL,
  `field_img_title` varchar(1024) DEFAULT NULL,
  `field_img_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_img_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_img_fid` (`field_img_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 8 (field_img)';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_list_description`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_list_description` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_list_description_value` varchar(255) DEFAULT NULL,
  `field_list_description_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_list_description_format` (`field_list_description_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 22 (field_list...';

--
-- Dumping data for table `field_revision_field_list_description`
--

INSERT INTO `field_revision_field_list_description` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_list_description_value`, `field_list_description_format`) VALUES
('newsletter_list', 'newsletter_list', 0, 1, 1, 'und', 0, 'An example newsletter list with Manual Send Rate.', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_newsletter_body`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_newsletter_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_body_value` longtext,
  `field_newsletter_body_summary` longtext,
  `field_newsletter_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_body_format` (`field_newsletter_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 23 (field_newsletter...';

--
-- Dumping data for table `field_revision_field_newsletter_body`
--

INSERT INTO `field_revision_field_newsletter_body` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_newsletter_body_value`, `field_newsletter_body_summary`, `field_newsletter_body_format`) VALUES
('newsletter_template', 'newsletter_template', 0, 1, 1, 'und', 0, 'Hello [newsletter:subscriber_email],<br />\n\nWe received your request for information from [site:name] <br />\nBefore we begin sending you the information you requested, we want to be certain we have your permission.<br />\nClick the link below to give us permission to send you information. It''s fast and easy!  If you cannot click the full URL below, please copy the URL and paste it into your web browser.<br /><br />\n\nConfirm by clicking the URL below:<br /><br />\n<a href="[newsletter:confirmation_url]">[newsletter:confirmation_url]</a><br /><br />\n\nIf you do not want to subscribe, simply ignore this message.<br /><br />\n\nBest Regards,<br />\n[site:name]<br />\n[site:url]<br /><br />\n\nRequest generated by:<br />\nIP: [newsletter:subscription_ip]<br />\nDate: [newsletter:subscription_time]<br />\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 2, 2, 'und', 0, 'Hello [newsletter:subscriber_email],<br /><br />\n\nThank you for your subscription. You are now signed up to our newsletter!<br />\nWe will keep your personal information private and secure. We will not share your email address with any third parties. <br />\nTo ensure you receive future subscribers-only news, please add this e-mail to your e-mail address book or safe senders list.<br />\n\n\nSincerely,<br />\n[site:name]<br />\n[site:url]<br /><br />\n\n----<br />\nYou are receiving this email because on [newsletter:subscription_time] at [site:url] you subscribed to receive our e-newsletters.<br /><br />\nYou can unsubscribe via the link below:<br />\n<a href="[newsletter:unsubscribe_url]">Unsubscribe</a>\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 3, 3, 'und', 0, 'Dear [newsletter:subscriber_email],<br />\n\nThis email is being sent to notify you that we have received a request to remove the following record from our mailing list:<br /><br />\n\nEmail: [newsletter:subscriber_email]<br /><br />\n\nThis record was removed from our database.<br />\nIf you do receive further unwanted email from our system, please let us know and we''d be happy to address the issue immediately.<br /><br />\n\nSincerely,<br />\n[site:name]<br />\n[site:url] <br />\n', NULL, 'filtered_html'),
('newsletter_template', 'newsletter_template', 0, 4, 4, 'und', 0, 'Hello [newsletter:subscriber_email],<br /><br />\n\nHere is what''s new on <a href="[site:url]">[site:name]</a> over the past few days. Your comments and feedback are always welcome.<br />\n\n<ol>\n [repeat] \n<li><a href="[node:url]">[node:title]</a> -[node:created]<br /> [node:summary]<br /></li>\n [/repeat] \n\n</ol>Sincerely,<br /> <a href="[site:url]">[site:name]</a><br /> <br /> <br />\n\n--<br />You are receiving this email because on [newsletter:subscription_time] you subscribed to receive our newsletter list : [newsletter:list_name].<br /><br />\n\nYou can unsubscribe by clicking the link below:<br /> \n<a href="[newsletter:unsubscribe_url]">Unsubscribe</a><br />\n', NULL, 'filtered_html');

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_newsletter_categories`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_newsletter_categories` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_categories_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_categories_tid` (`field_newsletter_categories_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 19 (field_newsletter...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_newsletter_list`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_newsletter_list` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_list_target_id` int(10) unsigned NOT NULL COMMENT 'The id of the target entity.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_list_target_id` (`field_newsletter_list_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 20 (field_newsletter...';

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_newsletter_template`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_newsletter_template` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_newsletter_template_target_id` int(10) unsigned DEFAULT NULL COMMENT 'The id of the target entity',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_newsletter_template_target_id` (`field_newsletter_template_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 21 (field_newsletter...';

--
-- Dumping data for table `field_revision_field_newsletter_template`
--

INSERT INTO `field_revision_field_newsletter_template` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_newsletter_template_target_id`) VALUES
('newsletter_list', 'newsletter_list', 0, 1, 1, 'und', 0, 4);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_product_category`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_product_category` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_category_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_category_tid` (`field_product_category_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 14 (field_product...';

--
-- Dumping data for table `field_revision_field_product_category`
--

INSERT INTO `field_revision_field_product_category` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_category_tid`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 17),
('node', 'product', 0, 52, 52, 'und', 0, 16),
('node', 'product', 0, 53, 53, 'und', 0, 16),
('node', 'product', 0, 54, 54, 'und', 0, 16),
('node', 'product', 0, 55, 55, 'und', 0, 17),
('node', 'product', 0, 56, 56, 'und', 0, 16),
('node', 'product', 0, 62, 62, 'und', 0, 22),
('node', 'product', 0, 63, 63, 'und', 0, 22),
('node', 'product', 0, 64, 64, 'und', 0, 22),
('node', 'product', 0, 65, 65, 'und', 0, 22),
('node', 'product', 0, 66, 66, 'und', 0, 17),
('node', 'product', 0, 67, 67, 'und', 0, 17),
('node', 'product', 0, 68, 68, 'und', 0, 20),
('node', 'product', 0, 69, 69, 'und', 0, 20),
('node', 'product', 0, 70, 70, 'und', 0, 20),
('node', 'product', 0, 71, 71, 'und', 0, 20),
('node', 'product', 0, 72, 72, 'und', 0, 18),
('node', 'product', 0, 73, 73, 'und', 0, 18),
('node', 'product', 0, 74, 74, 'und', 0, 18),
('node', 'product', 0, 75, 75, 'und', 0, 18),
('node', 'product', 0, 76, 76, 'und', 0, 19),
('node', 'product', 0, 77, 77, 'und', 0, 19),
('node', 'product', 0, 78, 78, 'und', 0, 19),
('node', 'product', 0, 79, 79, 'und', 0, 19);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_product_image`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_product_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_product_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_product_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_product_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_product_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_image_fid` (`field_product_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 12 (field_product_image)';

--
-- Dumping data for table `field_revision_field_product_image`
--

INSERT INTO `field_revision_field_product_image` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_image_fid`, `field_product_image_alt`, `field_product_image_title`, `field_product_image_width`, `field_product_image_height`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 306, '', '', 960, 330),
('node', 'product', 0, 47, 47, 'und', 1, 307, '', '', 960, 330),
('node', 'product', 0, 47, 47, 'und', 2, 308, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 0, 332, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 1, 333, '', '', 700, 300),
('node', 'product', 0, 52, 52, 'und', 2, 334, '', '', 700, 300),
('node', 'product', 0, 53, 53, 'und', 0, 328, '', '', 960, 330),
('node', 'product', 0, 53, 53, 'und', 1, 329, '', '', 960, 330),
('node', 'product', 0, 53, 53, 'und', 2, 330, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 0, 336, '', '', 700, 300),
('node', 'product', 0, 54, 54, 'und', 1, 337, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 2, 338, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 0, 310, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 1, 311, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 0, 243, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 1, 244, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 2, 245, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 3, 246, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 0, 324, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 1, 325, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 2, 326, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 0, 320, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 1, 321, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 2, 322, '', '', 960, 330),
('node', 'product', 0, 64, 64, 'und', 0, 316, '', '', 960, 330),
('node', 'product', 0, 64, 64, 'und', 1, 317, '', '', 700, 300),
('node', 'product', 0, 64, 64, 'und', 2, 318, '', '', 700, 300),
('node', 'product', 0, 65, 65, 'und', 0, 313, '', '', 700, 300),
('node', 'product', 0, 65, 65, 'und', 1, 314, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 0, 302, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 1, 303, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 2, 304, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 0, 298, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 1, 299, '', '', 960, 330),
('node', 'product', 0, 67, 67, 'und', 2, 300, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 0, 293, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 1, 294, '', '', 960, 330),
('node', 'product', 0, 68, 68, 'und', 2, 295, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 3, 296, '', '', 960, 330),
('node', 'product', 0, 69, 69, 'und', 0, 290, '', '', 960, 330),
('node', 'product', 0, 69, 69, 'und', 1, 291, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 0, 285, '', '', 960, 330),
('node', 'product', 0, 70, 70, 'und', 1, 286, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 2, 287, '', '', 700, 300),
('node', 'product', 0, 70, 70, 'und', 3, 288, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 0, 249, '', '', 700, 300),
('node', 'product', 0, 71, 71, 'und', 1, 251, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 2, 248, '', '', 700, 300),
('node', 'product', 0, 71, 71, 'und', 3, 250, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 0, 281, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 1, 282, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 2, 283, '', '', 960, 330),
('node', 'product', 0, 73, 73, 'und', 0, 277, '', '', 700, 300),
('node', 'product', 0, 73, 73, 'und', 1, 278, '', '', 960, 330),
('node', 'product', 0, 73, 73, 'und', 2, 279, '', '', 700, 300),
('node', 'product', 0, 74, 74, 'und', 0, 274, '', '', 960, 330),
('node', 'product', 0, 74, 74, 'und', 1, 275, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 0, 258, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 1, 259, '', '', 700, 300),
('node', 'product', 0, 75, 75, 'und', 2, 260, '', '', 960, 330),
('node', 'product', 0, 75, 75, 'und', 3, 261, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 0, 270, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 1, 271, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 2, 272, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 0, 266, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 1, 267, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 2, 268, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 0, 263, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 1, 264, '', '', 960, 330),
('node', 'product', 0, 79, 79, 'und', 0, 253, '', '', 960, 330),
('node', 'product', 0, 79, 79, 'und', 1, 254, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 2, 255, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 3, 256, '', '', 700, 300);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_product_thumb`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_product_thumb` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_product_thumb_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_product_thumb_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_product_thumb_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_product_thumb_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_product_thumb_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_product_thumb_fid` (`field_product_thumb_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 15 (field_product_thumb)';

--
-- Dumping data for table `field_revision_field_product_thumb`
--

INSERT INTO `field_revision_field_product_thumb` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_product_thumb_fid`, `field_product_thumb_alt`, `field_product_thumb_title`, `field_product_thumb_width`, `field_product_thumb_height`) VALUES
('node', 'product', 0, 47, 47, 'und', 0, 305, '', '', 960, 330),
('node', 'product', 0, 52, 52, 'und', 0, 331, '', '', 700, 300),
('node', 'product', 0, 53, 53, 'und', 0, 327, '', '', 960, 330),
('node', 'product', 0, 54, 54, 'und', 0, 335, '', '', 700, 300),
('node', 'product', 0, 55, 55, 'und', 0, 309, '', '', 700, 300),
('node', 'product', 0, 56, 56, 'und', 0, 242, '', '', 700, 300),
('node', 'product', 0, 62, 62, 'und', 0, 323, '', '', 700, 300),
('node', 'product', 0, 63, 63, 'und', 0, 319, '', '', 700, 300),
('node', 'product', 0, 64, 64, 'und', 0, 315, '', '', 960, 330),
('node', 'product', 0, 65, 65, 'und', 0, 312, '', '', 700, 300),
('node', 'product', 0, 66, 66, 'und', 0, 301, '', '', 700, 300),
('node', 'product', 0, 67, 67, 'und', 0, 297, '', '', 700, 300),
('node', 'product', 0, 68, 68, 'und', 0, 292, '', '', 700, 300),
('node', 'product', 0, 69, 69, 'und', 0, 289, '', '', 960, 330),
('node', 'product', 0, 70, 70, 'und', 0, 344, '', '', 960, 330),
('node', 'product', 0, 71, 71, 'und', 0, 352, '', '', 700, 300),
('node', 'product', 0, 72, 72, 'und', 0, 280, '', '', 700, 300),
('node', 'product', 0, 73, 73, 'und', 0, 276, '', '', 700, 300),
('node', 'product', 0, 74, 74, 'und', 0, 273, '', '', 960, 330),
('node', 'product', 0, 75, 75, 'und', 0, 257, '', '', 700, 300),
('node', 'product', 0, 76, 76, 'und', 0, 269, '', '', 700, 300),
('node', 'product', 0, 77, 77, 'und', 0, 265, '', '', 700, 300),
('node', 'product', 0, 78, 78, 'und', 0, 262, '', '', 700, 300),
('node', 'product', 0, 79, 79, 'und', 0, 252, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_slideshow`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_slideshow` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_slideshow_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_slideshow_alt` varchar(512) DEFAULT NULL,
  `field_slideshow_title` varchar(1024) DEFAULT NULL,
  `field_slideshow_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_slideshow_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_slideshow_fid` (`field_slideshow_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 6 (field_slideshow)';

--
-- Dumping data for table `field_revision_field_slideshow`
--

INSERT INTO `field_revision_field_slideshow` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_slideshow_fid`, `field_slideshow_alt`, `field_slideshow_title`, `field_slideshow_width`, `field_slideshow_height`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 238, '', '', 960, 330),
('node', 'article', 0, 3, 3, 'und', 0, 237, '', '', 960, 330),
('node', 'article', 0, 8, 8, 'und', 0, 241, '', '', 960, 330);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_field_tags`
--

CREATE TABLE IF NOT EXISTS `field_revision_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 3 (field_tags)';

--
-- Dumping data for table `field_revision_field_tags`
--

INSERT INTO `field_revision_field_tags` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `field_tags_tid`) VALUES
('node', 'article', 0, 1, 1, 'und', 0, 2),
('node', 'article', 0, 3, 3, 'und', 0, 2);

-- --------------------------------------------------------

--
-- Table structure for table `field_revision_taxonomy_forums`
--

CREATE TABLE IF NOT EXISTS `field_revision_taxonomy_forums` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `taxonomy_forums_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `taxonomy_forums_tid` (`taxonomy_forums_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 5 (taxonomy_forums)';

--
-- Dumping data for table `field_revision_taxonomy_forums`
--

INSERT INTO `field_revision_taxonomy_forums` (`entity_type`, `bundle`, `deleted`, `entity_id`, `revision_id`, `language`, `delta`, `taxonomy_forums_tid`) VALUES
('node', 'forum', 0, 16, 16, 'und', 0, 6),
('node', 'forum', 0, 17, 17, 'und', 0, 6),
('node', 'forum', 0, 18, 18, 'und', 0, 7),
('node', 'forum', 0, 19, 19, 'und', 0, 7),
('node', 'forum', 0, 20, 20, 'und', 0, 7),
('node', 'forum', 0, 21, 21, 'und', 0, 12);

-- --------------------------------------------------------

--
-- Table structure for table `file_managed`
--

CREATE TABLE IF NOT EXISTS `file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The users.uid of the user who is associated with the file.',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
  `uri` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'The URI to access the file (either local or remote).',
  `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
  `filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than DRUPAL_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `uri` (`uri`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores information for uploaded files.' AUTO_INCREMENT=353 ;

--
-- Dumping data for table `file_managed`
--

INSERT INTO `file_managed` (`fid`, `uid`, `filename`, `uri`, `filemime`, `filesize`, `status`, `timestamp`) VALUES
(237, 1, 'demo-1.jpg', 'public://field/slideshow/demo-1.jpg', 'image/jpeg', 99233, 1, 1355929524),
(238, 1, 'demo-3.jpg', 'public://field/slideshow/demo-3.jpg', 'image/jpeg', 97196, 1, 1355929757),
(239, 1, 'demo-5.jpg', 'public://field/image/demo-5_0.jpg', 'image/jpeg', 15895, 1, 1355929757),
(241, 1, 'demo-4.jpg', 'public://field/slideshow/demo-4_0.jpg', 'image/jpeg', 100329, 1, 1355930168),
(242, 1, 'demo-6.jpg', 'public://field/image/thumbs/demo-6.jpg', 'image/jpeg', 140505, 1, 1355931335),
(243, 1, 'demo-6.jpg', 'public://field/image/products/demo-6.jpg', 'image/jpeg', 140505, 1, 1355931335),
(244, 1, 'demo-7.jpg', 'public://field/image/products/demo-7_1.jpg', 'image/jpeg', 75875, 1, 1355931335),
(245, 1, 'demo-8.jpg', 'public://field/image/products/demo-8.jpg', 'image/jpeg', 70889, 1, 1355931335),
(246, 1, 'demo-9.jpg', 'public://field/image/products/demo-9.jpg', 'image/jpeg', 76467, 1, 1355931335),
(248, 1, 'demo-8.jpg', 'public://field/image/products/demo-8_0.jpg', 'image/jpeg', 70889, 1, 1355931598),
(249, 1, 'demo-9.jpg', 'public://field/image/products/demo-9_2.jpg', 'image/jpeg', 76467, 1, 1355931598),
(250, 1, 'demo-7.jpg', 'public://field/image/products/demo-7.jpg', 'image/jpeg', 75875, 1, 1355931598),
(251, 1, 'demo-1.jpg', 'public://field/image/products/demo-1.jpg', 'image/jpeg', 99233, 1, 1355931598),
(252, 1, 'demo-4.jpg', 'public://field/image/thumbs/demo-4.jpg', 'image/jpeg', 100329, 1, 1355932333),
(253, 1, 'demo-4.jpg', 'public://field/image/products/demo-4.jpg', 'image/jpeg', 100329, 1, 1355932333),
(254, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_0.jpg', 'image/jpeg', 140505, 1, 1355932333),
(255, 1, 'demo-9.jpg', 'public://field/image/products/demo-9_3.jpg', 'image/jpeg', 76467, 1, 1355932333),
(256, 1, 'demo-8.jpg', 'public://field/image/products/demo-8_2.jpg', 'image/jpeg', 70889, 1, 1355932333),
(257, 1, 'demo-10.jpg', 'public://field/image/thumbs/demo-10.jpg', 'image/jpeg', 88302, 1, 1356099216),
(258, 1, 'demo-10.jpg', 'public://field/image/products/demo-10.jpg', 'image/jpeg', 88302, 1, 1356099216),
(259, 1, 'demo-11.jpg', 'public://field/image/products/demo-11_1.jpg', 'image/jpeg', 66089, 1, 1356099216),
(260, 1, 'demo-3.jpg', 'public://field/image/products/demo-3.jpg', 'image/jpeg', 97196, 1, 1356099216),
(261, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_1.jpg', 'image/jpeg', 140505, 1, 1356099216),
(262, 1, 'demo-11.jpg', 'public://field/image/thumbs/demo-11.jpg', 'image/jpeg', 66089, 1, 1356099480),
(263, 1, 'demo-11.jpg', 'public://field/image/products/demo-11_3.jpg', 'image/jpeg', 66089, 1, 1356099480),
(264, 1, 'demo-4.jpg', 'public://field/image/products/demo-4_0.jpg', 'image/jpeg', 100329, 1, 1356099480),
(265, 1, 'demo-12.jpg', 'public://field/image/thumbs/demo-12_0.jpg', 'image/jpeg', 166499, 1, 1356099707),
(266, 1, 'demo-12.jpg', 'public://field/image/products/demo-12_1.jpg', 'image/jpeg', 166499, 1, 1356099707),
(267, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_2.jpg', 'image/jpeg', 140505, 1, 1356099707),
(268, 1, 'demo-7.jpg', 'public://field/image/products/demo-7_2.jpg', 'image/jpeg', 75875, 1, 1356099707),
(269, 1, 'demo-9.jpg', 'public://field/image/thumbs/demo-9.jpg', 'image/jpeg', 76467, 1, 1356099834),
(270, 1, 'demo-9.jpg', 'public://field/image/products/demo-9_4.jpg', 'image/jpeg', 76467, 1, 1356099834),
(271, 1, 'demo-11.jpg', 'public://field/image/products/demo-11_4.jpg', 'image/jpeg', 66089, 1, 1356099834),
(272, 1, 'demo-10.jpg', 'public://field/image/products/demo-10_2.jpg', 'image/jpeg', 88302, 1, 1356099834),
(273, 1, 'demo-13.jpg', 'public://field/image/thumbs/demo-13.jpg', 'image/jpeg', 102335, 1, 1356100103),
(274, 1, 'demo-13.jpg', 'public://field/image/products/demo-13.jpg', 'image/jpeg', 102335, 1, 1356100103),
(275, 1, 'demo-12.jpg', 'public://field/image/products/demo-12_2.jpg', 'image/jpeg', 166499, 1, 1356100103),
(276, 1, 'demo-14.jpg', 'public://field/image/thumbs/demo-14.jpg', 'image/jpeg', 74880, 1, 1356100522),
(277, 1, 'demo-14.jpg', 'public://field/image/products/demo-14.jpg', 'image/jpeg', 74880, 1, 1356100522),
(278, 1, 'demo-13.jpg', 'public://field/image/products/demo-13_0.jpg', 'image/jpeg', 102335, 1, 1356100522),
(279, 1, 'demo-9.jpg', 'public://field/image/products/demo-9_5.jpg', 'image/jpeg', 76467, 1, 1356100522),
(280, 1, 'demo-16.jpg', 'public://field/image/thumbs/demo-16.jpg', 'image/jpeg', 90930, 1, 1356100816),
(281, 1, 'demo-16.jpg', 'public://field/image/products/demo-16.jpg', 'image/jpeg', 90930, 1, 1356100816),
(282, 1, 'demo-15.jpg', 'public://field/image/products/demo-15.jpg', 'image/jpeg', 69377, 1, 1356100816),
(283, 1, 'demo-13.jpg', 'public://field/image/products/demo-13_1.jpg', 'image/jpeg', 102335, 1, 1356100816),
(285, 1, 'demo-1.jpg', 'public://field/image/products/demo-1_0.jpg', 'image/jpeg', 99233, 1, 1356100906),
(286, 1, 'demo-15.jpg', 'public://field/image/products/demo-15_0.jpg', 'image/jpeg', 69377, 1, 1356100906),
(287, 1, 'demo-10.jpg', 'public://field/image/products/demo-10_3.jpg', 'image/jpeg', 88302, 1, 1356100906),
(288, 1, 'demo-3.jpg', 'public://field/image/products/demo-3_0.jpg', 'image/jpeg', 97196, 1, 1356100906),
(289, 1, 'demo-2.jpg', 'public://field/image/thumbs/demo-2.jpg', 'image/jpeg', 84571, 1, 1356101025),
(290, 1, 'demo-2.jpg', 'public://field/image/products/demo-2.jpg', 'image/jpeg', 84571, 1, 1356101025),
(291, 1, 'demo-10.jpg', 'public://field/image/products/demo-10_4.jpg', 'image/jpeg', 88302, 1, 1356101025),
(292, 1, 'demo-17.jpg', 'public://field/image/thumbs/demo-17.jpg', 'image/jpeg', 74593, 1, 1356101397),
(293, 1, 'demo-17.jpg', 'public://field/image/products/demo-17.jpg', 'image/jpeg', 74593, 1, 1356101397),
(294, 1, 'demo-13.jpg', 'public://field/image/products/demo-13_2.jpg', 'image/jpeg', 102335, 1, 1356101397),
(295, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_3.jpg', 'image/jpeg', 140505, 1, 1356101397),
(296, 1, 'demo-4.jpg', 'public://field/image/products/demo-4_1.jpg', 'image/jpeg', 100329, 1, 1356101397),
(297, 1, 'demo-18.jpg', 'public://field/image/thumbs/demo-18.jpg', 'image/jpeg', 45374, 1, 1356101589),
(298, 1, 'demo-18.jpg', 'public://field/image/products/demo-18.jpg', 'image/jpeg', 45374, 1, 1356101589),
(299, 1, 'demo-2.jpg', 'public://field/image/products/demo-2_0.jpg', 'image/jpeg', 84571, 1, 1356101589),
(300, 1, 'demo-12.jpg', 'public://field/image/products/demo-12_3.jpg', 'image/jpeg', 166499, 1, 1356101589),
(301, 1, 'demo-19.jpg', 'public://field/image/thumbs/demo-19.jpg', 'image/jpeg', 44507, 1, 1356101711),
(302, 1, 'demo-19.jpg', 'public://field/image/products/demo-19.jpg', 'image/jpeg', 44507, 1, 1356101711),
(303, 1, 'demo-14.jpg', 'public://field/image/products/demo-14_0.jpg', 'image/jpeg', 74880, 1, 1356101711),
(304, 1, 'demo-11.jpg', 'public://field/image/products/demo-11_5.jpg', 'image/jpeg', 66089, 1, 1356101711),
(305, 1, 'demo-13.jpg', 'public://field/image/thumbs/demo-13_0.jpg', 'image/jpeg', 102335, 1, 1356101985),
(306, 1, 'demo-13.jpg', 'public://field/image/products/demo-13_3.jpg', 'image/jpeg', 102335, 1, 1356101985),
(307, 1, 'demo-3.jpg', 'public://field/image/products/demo-3_1.jpg', 'image/jpeg', 97196, 1, 1356101985),
(308, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_4.jpg', 'image/jpeg', 140505, 1, 1356101985),
(309, 1, 'demo-11.jpg', 'public://field/image/thumbs/demo-11_0.jpg', 'image/jpeg', 66089, 1, 1356102071),
(310, 1, 'demo-11.jpg', 'public://field/image/products/demo-11_6.jpg', 'image/jpeg', 66089, 1, 1356102071),
(311, 1, 'demo-14.jpg', 'public://field/image/products/demo-14_1.jpg', 'image/jpeg', 74880, 1, 1356102071),
(312, 1, 'demo-8.jpg', 'public://field/image/thumbs/demo-8.jpg', 'image/jpeg', 70889, 1, 1356102205),
(313, 1, 'demo-8.jpg', 'public://field/image/products/demo-8_4.jpg', 'image/jpeg', 70889, 1, 1356102205),
(314, 1, 'demo-17.jpg', 'public://field/image/products/demo-17_0.jpg', 'image/jpeg', 74593, 1, 1356102205),
(315, 1, 'demo-3.jpg', 'public://field/image/thumbs/demo-3.jpg', 'image/jpeg', 97196, 1, 1356102353),
(316, 1, 'demo-3.jpg', 'public://field/image/products/demo-3_2.jpg', 'image/jpeg', 97196, 1, 1356102353),
(317, 1, 'demo-14.jpg', 'public://field/image/products/demo-14_2.jpg', 'image/jpeg', 74880, 1, 1356102353),
(318, 1, 'demo-18.jpg', 'public://field/image/products/demo-18_0.jpg', 'image/jpeg', 45374, 1, 1356102353),
(319, 1, 'demo-16.jpg', 'public://field/image/thumbs/demo-16_0.jpg', 'image/jpeg', 90930, 1, 1356102459),
(320, 1, 'demo-16.jpg', 'public://field/image/products/demo-16_0.jpg', 'image/jpeg', 90930, 1, 1356102459),
(321, 1, 'demo-10.jpg', 'public://field/image/products/demo-10_5.jpg', 'image/jpeg', 88302, 1, 1356102459),
(322, 1, 'demo-2.jpg', 'public://field/image/products/demo-2_1.jpg', 'image/jpeg', 84571, 1, 1356102459),
(323, 1, 'demo-19.jpg', 'public://field/image/thumbs/demo-19_0.jpg', 'image/jpeg', 44507, 1, 1356102609),
(324, 1, 'demo-19.jpg', 'public://field/image/products/demo-19_0.jpg', 'image/jpeg', 44507, 1, 1356102609),
(325, 1, 'demo-9.jpg', 'public://field/image/products/demo-9_6.jpg', 'image/jpeg', 76467, 1, 1356102609),
(326, 1, 'demo-7.jpg', 'public://field/image/products/demo-7_3.jpg', 'image/jpeg', 75875, 1, 1356102609),
(327, 1, 'demo-4.jpg', 'public://field/image/thumbs/demo-4_0.jpg', 'image/jpeg', 100329, 1, 1356102709),
(328, 1, 'demo-4.jpg', 'public://field/image/products/demo-4_2.jpg', 'image/jpeg', 100329, 1, 1356102709),
(329, 1, 'demo-1.jpg', 'public://field/image/products/demo-1_1.jpg', 'image/jpeg', 99233, 1, 1356102709),
(330, 1, 'demo-2.jpg', 'public://field/image/products/demo-2_2.jpg', 'image/jpeg', 84571, 1, 1356102709),
(331, 1, 'demo-10.jpg', 'public://field/image/thumbs/demo-10_0.jpg', 'image/jpeg', 88302, 1, 1356102833),
(332, 1, 'demo-6.jpg', 'public://field/image/products/demo-6_5.jpg', 'image/jpeg', 140505, 1, 1356102833),
(333, 1, 'demo-14.jpg', 'public://field/image/products/demo-14_3.jpg', 'image/jpeg', 74880, 1, 1356102833),
(334, 1, 'demo-16.jpg', 'public://field/image/products/demo-16_1.jpg', 'image/jpeg', 90930, 1, 1356102833),
(335, 1, 'demo-6.jpg', 'public://field/image/thumbs/demo-6_0.jpg', 'image/jpeg', 140505, 1, 1356102922),
(336, 1, 'demo-12.jpg', 'public://field/image/products/demo-12_0.jpg', 'image/jpeg', 166499, 1, 1356102922),
(337, 1, 'demo-13.jpg', 'public://field/image/products/demo-13_4.jpg', 'image/jpeg', 102335, 1, 1356102922),
(338, 1, 'demo-15.jpg', 'public://field/image/products/demo-15_1.jpg', 'image/jpeg', 69377, 1, 1356102922),
(339, 1, 'demo-5.jpg', 'public://field/image/demo-5_1.jpg', 'image/jpeg', 15895, 1, 1356397329),
(340, 1, 'demo-23.jpg', 'public://field/image/demo-23.jpg', 'image/jpeg', 85607, 1, 1356397400),
(341, 1, 'demo-21.jpg', 'public://field/image/demo-21.jpg', 'image/jpeg', 54609, 1, 1356397452),
(342, 1, 'demo-19.jpg', 'public://field/image/demo-19.jpg', 'image/jpeg', 44507, 1, 1356397495),
(343, 1, 'demo-13.jpg', 'public://field/image/demo-13.jpg', 'image/jpeg', 102335, 1, 1356398009),
(344, 1, 'demo-1.jpg', 'public://field/image/thumbs/demo-1_0.jpg', 'image/jpeg', 99233, 1, 1356398188),
(345, 1, 'demo-24.jpg', 'public://field/image/services/demo-24.jpg', 'image/jpeg', 26583, 1, 1356399078),
(346, 1, 'demo-25.jpg', 'public://field/image/services/demo-25.jpg', 'image/jpeg', 30264, 1, 1356399273),
(348, 1, 'demo-27.jpg', 'public://field/image/services/demo-27.jpg', 'image/jpeg', 29188, 1, 1356399719),
(349, 1, 'demo-28.jpg', 'public://field/image/services/demo-28.jpg', 'image/jpeg', 23123, 1, 1356399730),
(350, 1, 'demo-29.jpg', 'public://field/image/services/demo-29.jpg', 'image/jpeg', 27022, 1, 1356399836),
(351, 1, 'demo-26.jpg', 'public://field/image/services/demo-26_0.jpg', 'image/jpeg', 34696, 1, 1356399930),
(352, 1, 'demo-9.jpg', 'public://field/image/thumbs/demo-9_0.jpg', 'image/jpeg', 76467, 1, 1356400326);

-- --------------------------------------------------------

--
-- Table structure for table `file_usage`
--

CREATE TABLE IF NOT EXISTS `file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Track where a file is used.';

--
-- Dumping data for table `file_usage`
--

INSERT INTO `file_usage` (`fid`, `module`, `type`, `id`, `count`) VALUES
(237, 'file', 'node', 3, 1),
(238, 'file', 'node', 1, 1),
(239, 'file', 'node', 1, 1),
(241, 'file', 'node', 8, 1),
(242, 'file', 'node', 56, 1),
(243, 'file', 'node', 56, 1),
(244, 'file', 'node', 56, 1),
(245, 'file', 'node', 56, 1),
(246, 'file', 'node', 56, 1),
(248, 'file', 'node', 71, 1),
(249, 'file', 'node', 71, 1),
(250, 'file', 'node', 71, 1),
(251, 'file', 'node', 71, 1),
(252, 'file', 'node', 79, 1),
(253, 'file', 'node', 79, 1),
(254, 'file', 'node', 79, 1),
(255, 'file', 'node', 79, 1),
(256, 'file', 'node', 79, 1),
(257, 'file', 'node', 75, 1),
(258, 'file', 'node', 75, 1),
(259, 'file', 'node', 75, 1),
(260, 'file', 'node', 75, 1),
(261, 'file', 'node', 75, 1),
(262, 'file', 'node', 78, 1),
(263, 'file', 'node', 78, 1),
(264, 'file', 'node', 78, 1),
(265, 'file', 'node', 77, 1),
(266, 'file', 'node', 77, 1),
(267, 'file', 'node', 77, 1),
(268, 'file', 'node', 77, 1),
(269, 'file', 'node', 76, 1),
(270, 'file', 'node', 76, 1),
(271, 'file', 'node', 76, 1),
(272, 'file', 'node', 76, 1),
(273, 'file', 'node', 74, 1),
(274, 'file', 'node', 74, 1),
(275, 'file', 'node', 74, 1),
(276, 'file', 'node', 73, 1),
(277, 'file', 'node', 73, 1),
(278, 'file', 'node', 73, 1),
(279, 'file', 'node', 73, 1),
(280, 'file', 'node', 72, 1),
(281, 'file', 'node', 72, 1),
(282, 'file', 'node', 72, 1),
(283, 'file', 'node', 72, 1),
(285, 'file', 'node', 70, 1),
(286, 'file', 'node', 70, 1),
(287, 'file', 'node', 70, 1),
(288, 'file', 'node', 70, 1),
(289, 'file', 'node', 69, 1),
(290, 'file', 'node', 69, 1),
(291, 'file', 'node', 69, 1),
(292, 'file', 'node', 68, 1),
(293, 'file', 'node', 68, 1),
(294, 'file', 'node', 68, 1),
(295, 'file', 'node', 68, 1),
(296, 'file', 'node', 68, 1),
(297, 'file', 'node', 67, 1),
(298, 'file', 'node', 67, 1),
(299, 'file', 'node', 67, 1),
(300, 'file', 'node', 67, 1),
(301, 'file', 'node', 66, 1),
(302, 'file', 'node', 66, 1),
(303, 'file', 'node', 66, 1),
(304, 'file', 'node', 66, 1),
(305, 'file', 'node', 47, 1),
(306, 'file', 'node', 47, 1),
(307, 'file', 'node', 47, 1),
(308, 'file', 'node', 47, 1),
(309, 'file', 'node', 55, 1),
(310, 'file', 'node', 55, 1),
(311, 'file', 'node', 55, 1),
(312, 'file', 'node', 65, 1),
(313, 'file', 'node', 65, 1),
(314, 'file', 'node', 65, 1),
(315, 'file', 'node', 64, 1),
(316, 'file', 'node', 64, 1),
(317, 'file', 'node', 64, 1),
(318, 'file', 'node', 64, 1),
(319, 'file', 'node', 63, 1),
(320, 'file', 'node', 63, 1),
(321, 'file', 'node', 63, 1),
(322, 'file', 'node', 63, 1),
(323, 'file', 'node', 62, 1),
(324, 'file', 'node', 62, 1),
(325, 'file', 'node', 62, 1),
(326, 'file', 'node', 62, 1),
(327, 'file', 'node', 53, 1),
(328, 'file', 'node', 53, 1),
(329, 'file', 'node', 53, 1),
(330, 'file', 'node', 53, 1),
(331, 'file', 'node', 52, 1),
(332, 'file', 'node', 52, 1),
(333, 'file', 'node', 52, 1),
(334, 'file', 'node', 52, 1),
(335, 'file', 'node', 54, 1),
(336, 'file', 'node', 54, 1),
(337, 'file', 'node', 54, 1),
(338, 'file', 'node', 54, 1),
(339, 'file', 'node', 60, 1),
(340, 'file', 'node', 59, 1),
(341, 'file', 'node', 58, 1),
(342, 'file', 'node', 57, 1),
(343, 'file', 'node', 61, 1),
(344, 'file', 'node', 70, 1),
(345, 'file', 'taxonomy_term', 16, 1),
(346, 'file', 'taxonomy_term', 17, 1),
(348, 'file', 'taxonomy_term', 18, 1),
(349, 'file', 'taxonomy_term', 20, 1),
(350, 'file', 'taxonomy_term', 22, 1),
(351, 'file', 'taxonomy_term', 19, 1),
(352, 'file', 'node', 71, 1);

-- --------------------------------------------------------

--
-- Table structure for table `filter`
--

CREATE TABLE IF NOT EXISTS `filter` (
  `format` varchar(255) NOT NULL COMMENT 'Foreign key: The filter_format.format to which this filter is assigned.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The origin module of the filter.',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Name of the filter being referenced.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of filter within format.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Filter enabled status. (1 = enabled, 0 = disabled)',
  `settings` longblob COMMENT 'A serialized array of name value pairs that store the filter settings for the specific format.',
  PRIMARY KEY (`format`,`name`),
  KEY `list` (`weight`,`module`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table that maps filters (HTML corrector) to text formats ...';

--
-- Dumping data for table `filter`
--

INSERT INTO `filter` (`format`, `module`, `name`, `weight`, `status`, `settings`) VALUES
('filtered_html', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html', 1, 1, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('filtered_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_html_escape', 10, 0, 0x613a303a7b7d),
('filtered_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('full_html', 'filter', 'filter_autop', 1, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html', 10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('full_html', 'filter', 'filter_htmlcorrector', 10, 1, 0x613a303a7b7d),
('full_html', 'filter', 'filter_html_escape', 10, 0, 0x613a303a7b7d),
('full_html', 'filter', 'filter_url', 0, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('php_code', 'filter', 'filter_autop', 10, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_html', 10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('php_code', 'filter', 'filter_htmlcorrector', 10, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_html_escape', 10, 0, 0x613a303a7b7d),
('php_code', 'filter', 'filter_url', 10, 0, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d),
('php_code', 'php', 'php_code', 0, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_autop', 2, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html', 10, 0, 0x613a333a7b733a31323a22616c6c6f7765645f68746d6c223b733a37343a223c613e203c656d3e203c7374726f6e673e203c636974653e203c626c6f636b71756f74653e203c636f64653e203c756c3e203c6f6c3e203c6c693e203c646c3e203c64743e203c64643e223b733a31363a2266696c7465725f68746d6c5f68656c70223b693a313b733a32303a2266696c7465725f68746d6c5f6e6f666f6c6c6f77223b693a303b7d),
('plain_text', 'filter', 'filter_htmlcorrector', 10, 0, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_html_escape', 0, 1, 0x613a303a7b7d),
('plain_text', 'filter', 'filter_url', 1, 1, 0x613a313a7b733a31373a2266696c7465725f75726c5f6c656e677468223b693a37323b7d);

-- --------------------------------------------------------

--
-- Table structure for table `filter_format`
--

CREATE TABLE IF NOT EXISTS `filter_format` (
  `format` varchar(255) NOT NULL COMMENT 'Primary Key: Unique machine name of the format.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the text format (Filtered HTML).',
  `cache` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether format is cacheable. (1 = cacheable, 0 = not cacheable)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The status of the text format. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of text format to use when listing.',
  PRIMARY KEY (`format`),
  UNIQUE KEY `name` (`name`),
  KEY `status_weight` (`status`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores text formats: custom groupings of filters, such as...';

--
-- Dumping data for table `filter_format`
--

INSERT INTO `filter_format` (`format`, `name`, `cache`, `status`, `weight`) VALUES
('filtered_html', 'Filtered HTML', 1, 1, 0),
('full_html', 'Full HTML', 1, 1, 1),
('php_code', 'PHP code', 0, 1, 11),
('plain_text', 'Plain text', 1, 1, 10);

-- --------------------------------------------------------

--
-- Table structure for table `flood`
--

CREATE TABLE IF NOT EXISTS `flood` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique flood event ID.',
  `event` varchar(64) NOT NULL DEFAULT '' COMMENT 'Name of event (e.g. contact).',
  `identifier` varchar(128) NOT NULL DEFAULT '' COMMENT 'Identifier of the visitor, such as an IP address or hostname.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp of the event.',
  `expiration` int(11) NOT NULL DEFAULT '0' COMMENT 'Expiration timestamp. Expired events are purged on cron run.',
  PRIMARY KEY (`fid`),
  KEY `allow` (`event`,`identifier`,`timestamp`),
  KEY `purge` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Flood controls the threshold of events, such as the...' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `forum`
--

CREATE TABLE IF NOT EXISTS `forum` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid of the node.',
  `vid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Primary Key: The node.vid of the node.',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The taxonomy_term_data.tid of the forum term assigned to the node.',
  PRIMARY KEY (`vid`),
  KEY `forum_topic` (`nid`,`tid`),
  KEY `tid` (`tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores the relationship of nodes to forum terms.';

--
-- Dumping data for table `forum`
--

INSERT INTO `forum` (`nid`, `vid`, `tid`) VALUES
(16, 16, 6),
(17, 17, 6),
(18, 18, 7),
(19, 19, 7),
(20, 20, 7),
(21, 21, 12);

-- --------------------------------------------------------

--
-- Table structure for table `forum_index`
--

CREATE TABLE IF NOT EXISTS `forum_index` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid this record tracks.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this node, always treated as non-markup plain text.',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The term ID.',
  `sticky` tinyint(4) DEFAULT '0' COMMENT 'Boolean indicating whether the node is sticky.',
  `created` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was created.',
  `last_comment_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from comment.timestamp.',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this node.',
  KEY `forum_topics` (`nid`,`tid`,`sticky`,`last_comment_timestamp`),
  KEY `created` (`created`),
  KEY `last_comment_timestamp` (`last_comment_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maintains denormalized information about node/term...';

--
-- Dumping data for table `forum_index`
--

INSERT INTO `forum_index` (`nid`, `title`, `tid`, `sticky`, `created`, `last_comment_timestamp`, `comment_count`) VALUES
(16, 'Site Building Guide', 6, 0, 1326766039, 1326766039, 0),
(17, 'modules failed to update', 6, 0, 1326766123, 1326766123, 0),
(18, 'Simplest way to launch Drupal on AWS', 7, 0, 1326766270, 1326766270, 0),
(19, 'change in look after Upadting Pixture Reloaded theme', 7, 0, 1326766321, 1326766321, 0),
(20, 'System requirements', 7, 0, 1326766416, 1326766416, 0),
(21, 'HTML and CSS techniques', 12, 0, 1326766554, 1326766651, 2);

-- --------------------------------------------------------

--
-- Table structure for table `history`
--

CREATE TABLE IF NOT EXISTS `history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that read the node nid.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid that was read.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of which users have read which nodes.';

--
-- Dumping data for table `history`
--

INSERT INTO `history` (`uid`, `nid`, `timestamp`) VALUES
(1, 9, 1385180362),
(1, 11, 1385196186),
(1, 54, 1385196992),
(1, 71, 1385196431),
(1, 80, 1385566343),
(1, 81, 1385566454),
(1, 82, 1385567172),
(1, 83, 1385566663),
(1, 84, 1385566751),
(1, 85, 1385566941),
(1, 86, 1385567137),
(1, 87, 1385567243),
(1, 88, 1385567358),
(1, 89, 1387000729);

-- --------------------------------------------------------

--
-- Table structure for table `image_effects`
--

CREATE TABLE IF NOT EXISTS `image_effects` (
  `ieid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image effect.',
  `isid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The image_styles.isid for an image style.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the effect in the style.',
  `name` varchar(255) NOT NULL COMMENT 'The unique name of the effect to be executed.',
  `data` longblob NOT NULL COMMENT 'The configuration data for the effect.',
  PRIMARY KEY (`ieid`),
  KEY `isid` (`isid`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image effects.' AUTO_INCREMENT=11 ;

--
-- Dumping data for table `image_effects`
--

INSERT INTO `image_effects` (`ieid`, `isid`, `weight`, `name`, `data`) VALUES
(1, 1, 1, 'image_crop', 0x613a333a7b733a353a227769647468223b733a333a22393630223b733a363a22686569676874223b733a333a22333330223b733a363a22616e63686f72223b733a31333a2263656e7465722d63656e746572223b7d),
(2, 2, 1, 'image_scale', 0x613a333a7b733a353a227769647468223b733a333a22313830223b733a363a22686569676874223b733a303a22223b733a373a2275707363616c65223b693a303b7d),
(3, 3, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313938223b733a363a22686569676874223b733a333a22313138223b7d),
(5, 4, 2, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313934223b733a363a22686569676874223b733a333a22313734223b7d),
(6, 5, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22323730223b733a363a22686569676874223b733a333a22323730223b7d),
(7, 6, 0, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22373030223b733a363a22686569676874223b733a333a22333030223b7d),
(8, 7, 0, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313539223b733a363a22686569676874223b733a323a223733223b7d),
(9, 8, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a333a22313938223b733a363a22686569676874223b733a333a22313030223b7d),
(10, 9, 1, 'image_scale_and_crop', 0x613a323a7b733a353a227769647468223b733a323a223430223b733a363a22686569676874223b733a323a223430223b7d);

-- --------------------------------------------------------

--
-- Table structure for table `image_styles`
--

CREATE TABLE IF NOT EXISTS `image_styles` (
  `isid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image style.',
  `name` varchar(255) NOT NULL COMMENT 'The style name.',
  `label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The style administrative name.',
  PRIMARY KEY (`isid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image styles.' AUTO_INCREMENT=10 ;

--
-- Dumping data for table `image_styles`
--

INSERT INTO `image_styles` (`isid`, `name`, `label`) VALUES
(1, 'slideshow', 'slideshow'),
(2, 'small', 'small'),
(3, 'jcarousel', 'jcarousel'),
(4, 'medium', 'medium'),
(5, 'img_270_270', 'img_270_270'),
(6, 'galleryformatter_slide', 'galleryformatter_slide'),
(7, 'galleryformatter_thumb', 'galleryformatter_thumb'),
(8, 'img_198_100', 'img_198_100'),
(9, 'img_40_40', 'img_40_40');

-- --------------------------------------------------------

--
-- Table structure for table `menu_custom`
--

CREATE TABLE IF NOT EXISTS `menu_custom` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique key for menu. This is used as a block delta so length is 32.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Menu title; displayed at top of block.',
  `description` text COMMENT 'Menu description.',
  PRIMARY KEY (`menu_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds definitions for top-level custom menus (for example...';

--
-- Dumping data for table `menu_custom`
--

INSERT INTO `menu_custom` (`menu_name`, `title`, `description`) VALUES
('devel', 'Development', 'Development link'),
('main-menu', 'Main menu', 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.'),
('management', 'Management', 'The <em>Management</em> menu contains links for administrative tasks.'),
('menu-footer-menu', 'Footer Menu', 'Additional Menu for Footer'),
('navigation', 'Navigation', 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.'),
('user-menu', 'User menu', 'The <em>User</em> menu contains links related to the user''s account, as well as the ''Log out'' link.');

-- --------------------------------------------------------

--
-- Table structure for table `menu_links`
--

CREATE TABLE IF NOT EXISTS `menu_links` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ’navigation’) are part of the same menu.',
  `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `plid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.',
  `link_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Drupal path or external path this link points to.',
  `router_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'For links corresponding to a Drupal path (external = 0), this connects the link to a menu_router.path for joins.',
  `link_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The text displayed for the link, which may be modified by a title callback stored in menu_router.',
  `options` blob COMMENT 'A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.',
  `module` varchar(255) NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `hidden` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)',
  `external` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).',
  `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).',
  `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with plid == 0 will have depth == 1.',
  `customized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).',
  `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `updated` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag that indicates that this link was generated during the update from Drupal 5.',
  PRIMARY KEY (`mlid`),
  KEY `path_menu` (`link_path`(128),`menu_name`),
  KEY `menu_plid_expand_child` (`menu_name`,`plid`,`expanded`,`has_children`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `router_path` (`router_path`(128))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Contains the individual links within a menu.' AUTO_INCREMENT=1032 ;

--
-- Dumping data for table `menu_links`
--

INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 1, 0, 'admin', 'admin', 'Administration', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 9, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 2, 0, 'user', 'user', 'User account', 0x613a313a7b733a353a22616c746572223b623a313b7d, 'system', 0, 0, 0, 0, -10, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 3, 0, 'comment/%', 'comment/%', 'Comment permalink', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 4, 0, 'filter/tips', 'filter/tips', 'Compose tips', 0x613a303a7b7d, 'system', 1, 0, 0, 0, -48, 1, 1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 5, 0, 'node/%', 'node/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 6, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'system', 0, 0, 1, 0, -50, 1, 1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 7, 1, 'admin/appearance', 'admin/appearance', 'Appearance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -6, 2, 0, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 8, 1, 'admin/config', 'admin/config', 'Configuration', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32303a2241646d696e69737465722073657474696e67732e223b7d7d, 'system', 0, 0, 1, 0, 0, 2, 0, 1, 8, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 9, 1, 'admin/content', 'admin/content', 'Content', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33323a2241646d696e697374657220636f6e74656e7420616e6420636f6d6d656e74732e223b7d7d, 'system', 0, 0, 1, 0, -10, 2, 0, 1, 9, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 10, 2, 'user/register', 'user/register', 'Create new account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 10, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 11, 1, 'admin/dashboard', 'admin/dashboard', 'Dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a225669657720616e6420637573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', 0, 0, 0, 0, -15, 2, 0, 1, 11, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 12, 1, 'admin/help', 'admin/help', 'Help', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a225265666572656e636520666f722075736167652c20636f6e66696775726174696f6e2c20616e64206d6f64756c65732e223b7d7d, 'system', 0, 0, 0, 0, 9, 2, 0, 1, 12, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 13, 1, 'admin/index', 'admin/index', 'Index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -18, 2, 0, 1, 13, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 14, 2, 'user/login', 'user/login', 'Log in', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 14, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 15, 0, 'user/logout', 'user/logout', 'Log out', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 10, 1, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 16, 1, 'admin/modules', 'admin/modules', 'Modules', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a22457874656e6420736974652066756e6374696f6e616c6974792e223b7d7d, 'system', 0, 0, 0, 0, -2, 2, 0, 1, 16, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 17, 0, 'user/%', 'user/%', 'My account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 1, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 18, 1, 'admin/people', 'admin/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a224d616e6167652075736572206163636f756e74732c20726f6c65732c20616e64207065726d697373696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -4, 2, 0, 1, 18, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 19, 1, 'admin/reports', 'admin/reports', 'Reports', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a2256696577207265706f7274732c20757064617465732c20616e64206572726f72732e223b7d7d, 'system', 0, 0, 1, 0, 5, 2, 0, 1, 19, 0, 0, 0, 0, 0, 0, 0, 0),
('user-menu', 20, 2, 'user/password', 'user/password', 'Request new password', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 2, 20, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 21, 1, 'admin/structure', 'admin/structure', 'Structure', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a2241646d696e697374657220626c6f636b732c20636f6e74656e742074797065732c206d656e75732c206574632e223b7d7d, 'system', 0, 0, 1, 0, -8, 2, 0, 1, 21, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 22, 1, 'admin/tasks', 'admin/tasks', 'Tasks', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 2, 0, 1, 22, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 23, 0, 'comment/reply/%', 'comment/reply/%', 'Add new comment', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 24, 3, 'comment/%/approve', 'comment/%/approve', 'Approve', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 1, 2, 0, 3, 24, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 25, 3, 'comment/%/delete', 'comment/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 3, 25, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 26, 3, 'comment/%/edit', 'comment/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 3, 26, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 27, 0, 'taxonomy/term/%', 'taxonomy/term/%', 'Taxonomy term', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 1, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 28, 3, 'comment/%/view', 'comment/%/view', 'View comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 3, 28, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 29, 18, 'admin/people/create', 'admin/people/create', 'Add user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 18, 29, 0, 0, 0, 0, 0, 0, 0),
('management', 30, 21, 'admin/structure/block', 'admin/structure/block', 'Blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37393a22436f6e666967757265207768617420626c6f636b20636f6e74656e74206170706561727320696e20796f75722073697465277320736964656261727320616e64206f7468657220726567696f6e732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 30, 0, 0, 0, 0, 0, 0, 0),
('navigation', 31, 17, 'user/%/cancel', 'user/%/cancel', 'Cancel account', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 2, 0, 17, 31, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 32, 9, 'admin/content/comment', 'admin/content/comment', 'Comments', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35393a224c69737420616e642065646974207369746520636f6d6d656e747320616e642074686520636f6d6d656e7420617070726f76616c2071756575652e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 9, 32, 0, 0, 0, 0, 0, 0, 0),
('management', 33, 11, 'admin/dashboard/configure', 'admin/dashboard/configure', 'Configure available dashboard blocks', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a22436f6e66696775726520776869636820626c6f636b732063616e2062652073686f776e206f6e207468652064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 33, 0, 0, 0, 0, 0, 0, 0),
('management', 34, 9, 'admin/content/node', 'admin/content/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 9, 34, 0, 0, 0, 0, 0, 0, 0),
('management', 35, 8, 'admin/config/content', 'admin/config/content', 'Content authoring', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a2253657474696e67732072656c6174656420746f20666f726d617474696e6720616e6420617574686f72696e6720636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 35, 0, 0, 0, 0, 0, 0, 0),
('management', 36, 21, 'admin/structure/types', 'admin/structure/types', 'Content types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a39323a224d616e61676520636f6e74656e742074797065732c20696e636c7564696e672064656661756c74207374617475732c2066726f6e7420706167652070726f6d6f74696f6e2c20636f6d6d656e742073657474696e67732c206574632e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 36, 0, 0, 0, 0, 0, 0, 0),
('management', 37, 11, 'admin/dashboard/customize', 'admin/dashboard/customize', 'Customize dashboard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22437573746f6d697a6520796f75722064617368626f6172642e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 11, 37, 0, 0, 0, 0, 0, 0, 0),
('navigation', 38, 5, 'node/%/delete', 'node/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 2, 0, 5, 38, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 39, 8, 'admin/config/development', 'admin/config/development', 'Development', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22446576656c6f706d656e7420746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 39, 0, 0, 0, 0, 0, 0, 0),
('navigation', 40, 17, 'user/%/edit', 'user/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 40, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 41, 5, 'node/%/edit', 'node/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 5, 41, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 42, 19, 'admin/reports/fields', 'admin/reports/fields', 'Field list', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224f76657276696577206f66206669656c6473206f6e20616c6c20656e746974792074797065732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 42, 0, 0, 0, 0, 0, 0, 0),
('management', 43, 16, 'admin/modules/list', 'admin/modules/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 16, 43, 0, 0, 0, 0, 0, 0, 0),
('management', 44, 18, 'admin/people/people', 'admin/people/people', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35303a2246696e6420616e64206d616e6167652070656f706c6520696e746572616374696e67207769746820796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -10, 3, 0, 1, 18, 44, 0, 0, 0, 0, 0, 0, 0),
('management', 45, 7, 'admin/appearance/list', 'admin/appearance/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a2253656c65637420616e6420636f6e66696775726520796f7572207468656d65223b7d7d, 'system', -1, 0, 0, 0, -1, 3, 0, 1, 7, 45, 0, 0, 0, 0, 0, 0, 0),
('management', 46, 8, 'admin/config/media', 'admin/config/media', 'Media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31323a224d6564696120746f6f6c732e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 46, 0, 0, 0, 0, 0, 0, 0),
('management', 47, 21, 'admin/structure/menu', 'admin/structure/menu', 'Menus', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38363a22416464206e6577206d656e757320746f20796f757220736974652c2065646974206578697374696e67206d656e75732c20616e642072656e616d6520616e642072656f7267616e697a65206d656e75206c696e6b732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 47, 0, 0, 0, 0, 0, 0, 0),
('management', 48, 8, 'admin/config/people', 'admin/config/people', 'People', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22436f6e6669677572652075736572206163636f756e74732e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 48, 0, 0, 0, 0, 0, 0, 0),
('management', 49, 18, 'admin/people/permissions', 'admin/people/permissions', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 18, 49, 0, 0, 0, 0, 0, 0, 0),
('management', 51, 8, 'admin/config/regional', 'admin/config/regional', 'Regional and language', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34383a22526567696f6e616c2073657474696e67732c206c6f63616c697a6174696f6e20616e64207472616e736c6174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -5, 3, 0, 1, 8, 51, 0, 0, 0, 0, 0, 0, 0),
('navigation', 52, 5, 'node/%/revisions', 'node/%/revisions', 'Revisions', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 2, 2, 0, 5, 52, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 53, 8, 'admin/config/search', 'admin/config/search', 'Search and metadata', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33363a224c6f63616c2073697465207365617263682c206d6574616461746120616e642053454f2e223b7d7d, 'system', 0, 0, 1, 0, -10, 3, 0, 1, 8, 53, 0, 0, 0, 0, 0, 0, 0),
('management', 54, 7, 'admin/appearance/settings', 'admin/appearance/settings', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a22436f6e6669677572652064656661756c7420616e64207468656d652073706563696669632073657474696e67732e223b7d7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 7, 54, 0, 0, 0, 0, 0, 0, 0),
('management', 55, 19, 'admin/reports/status', 'admin/reports/status', 'Status report', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a22476574206120737461747573207265706f72742061626f757420796f757220736974652773206f7065726174696f6e20616e6420616e792064657465637465642070726f626c656d732e223b7d7d, 'system', 0, 0, 0, 0, -60, 3, 0, 1, 19, 55, 0, 0, 0, 0, 0, 0, 0),
('management', 56, 8, 'admin/config/system', 'admin/config/system', 'System', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2247656e6572616c2073797374656d2072656c6174656420636f6e66696775726174696f6e2e223b7d7d, 'system', 0, 0, 1, 0, -20, 3, 0, 1, 8, 56, 0, 0, 0, 0, 0, 0, 0),
('management', 57, 21, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Taxonomy', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a224d616e6167652074616767696e672c2063617465676f72697a6174696f6e2c20616e6420636c617373696669636174696f6e206f6620796f757220636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 57, 0, 0, 0, 0, 0, 0, 0),
('management', 60, 16, 'admin/modules/uninstall', 'admin/modules/uninstall', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 3, 0, 1, 16, 60, 0, 0, 0, 0, 0, 0, 0),
('management', 61, 8, 'admin/config/user-interface', 'admin/config/user-interface', 'User interface', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22546f6f6c73207468617420656e68616e636520746865207573657220696e746572666163652e223b7d7d, 'system', 0, 0, 1, 0, -15, 3, 0, 1, 8, 61, 0, 0, 0, 0, 0, 0, 0),
('navigation', 62, 5, 'node/%/view', 'node/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 5, 62, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 63, 17, 'user/%/view', 'user/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 17, 63, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 64, 8, 'admin/config/services', 'admin/config/services', 'Web services', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a22546f6f6c732072656c6174656420746f207765622073657276696365732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 8, 64, 0, 0, 0, 0, 0, 0, 0),
('management', 65, 8, 'admin/config/workflow', 'admin/config/workflow', 'Workflow', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22436f6e74656e7420776f726b666c6f772c20656469746f7269616c20776f726b666c6f7720746f6f6c732e223b7d7d, 'system', 0, 0, 0, 0, 5, 3, 0, 1, 8, 65, 0, 0, 0, 0, 0, 0, 0),
('management', 66, 12, 'admin/help/block', 'admin/help/block', 'block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 66, 0, 0, 0, 0, 0, 0, 0),
('management', 67, 12, 'admin/help/color', 'admin/help/color', 'color', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 67, 0, 0, 0, 0, 0, 0, 0),
('management', 68, 12, 'admin/help/comment', 'admin/help/comment', 'comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 68, 0, 0, 0, 0, 0, 0, 0),
('management', 69, 12, 'admin/help/contextual', 'admin/help/contextual', 'contextual', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 69, 0, 0, 0, 0, 0, 0, 0),
('management', 70, 12, 'admin/help/dashboard', 'admin/help/dashboard', 'dashboard', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 70, 0, 0, 0, 0, 0, 0, 0),
('management', 72, 12, 'admin/help/field', 'admin/help/field', 'field', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 72, 0, 0, 0, 0, 0, 0, 0),
('management', 73, 12, 'admin/help/field_sql_storage', 'admin/help/field_sql_storage', 'field_sql_storage', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 73, 0, 0, 0, 0, 0, 0, 0),
('management', 74, 12, 'admin/help/field_ui', 'admin/help/field_ui', 'field_ui', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 74, 0, 0, 0, 0, 0, 0, 0),
('management', 75, 12, 'admin/help/file', 'admin/help/file', 'file', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 75, 0, 0, 0, 0, 0, 0, 0),
('management', 76, 12, 'admin/help/filter', 'admin/help/filter', 'filter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 76, 0, 0, 0, 0, 0, 0, 0),
('management', 77, 12, 'admin/help/help', 'admin/help/help', 'help', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 77, 0, 0, 0, 0, 0, 0, 0),
('management', 78, 12, 'admin/help/image', 'admin/help/image', 'image', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 78, 0, 0, 0, 0, 0, 0, 0),
('management', 79, 12, 'admin/help/list', 'admin/help/list', 'list', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 79, 0, 0, 0, 0, 0, 0, 0),
('management', 80, 12, 'admin/help/menu', 'admin/help/menu', 'menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 80, 0, 0, 0, 0, 0, 0, 0),
('management', 81, 12, 'admin/help/node', 'admin/help/node', 'node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 81, 0, 0, 0, 0, 0, 0, 0),
('management', 82, 12, 'admin/help/options', 'admin/help/options', 'options', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 82, 0, 0, 0, 0, 0, 0, 0),
('management', 83, 12, 'admin/help/system', 'admin/help/system', 'system', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 83, 0, 0, 0, 0, 0, 0, 0),
('management', 84, 12, 'admin/help/taxonomy', 'admin/help/taxonomy', 'taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 84, 0, 0, 0, 0, 0, 0, 0),
('management', 85, 12, 'admin/help/text', 'admin/help/text', 'text', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 85, 0, 0, 0, 0, 0, 0, 0),
('management', 86, 12, 'admin/help/user', 'admin/help/user', 'user', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 86, 0, 0, 0, 0, 0, 0, 0),
('navigation', 87, 27, 'taxonomy/term/%/edit', 'taxonomy/term/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 2, 0, 27, 87, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 88, 27, 'taxonomy/term/%/view', 'taxonomy/term/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 27, 88, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 89, 48, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Account settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130393a22436f6e6669677572652064656661756c74206265686176696f72206f662075736572732c20696e636c7564696e6720726567697374726174696f6e20726571756972656d656e74732c20652d6d61696c732c206669656c64732c20616e6420757365722070696374757265732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 48, 89, 0, 0, 0, 0, 0, 0),
('management', 90, 56, 'admin/config/system/actions', 'admin/config/system/actions', 'Actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 56, 90, 0, 0, 0, 0, 0, 0),
('management', 91, 30, 'admin/structure/block/add', 'admin/structure/block/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 91, 0, 0, 0, 0, 0, 0),
('management', 92, 36, 'admin/structure/types/add', 'admin/structure/types/add', 'Add content type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 36, 92, 0, 0, 0, 0, 0, 0),
('management', 93, 47, 'admin/structure/menu/add', 'admin/structure/menu/add', 'Add menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 47, 93, 0, 0, 0, 0, 0, 0),
('management', 94, 57, 'admin/structure/taxonomy/add', 'admin/structure/taxonomy/add', 'Add vocabulary', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 57, 94, 0, 0, 0, 0, 0, 0),
('management', 95, 54, 'admin/appearance/settings/bartik', 'admin/appearance/settings/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 95, 0, 0, 0, 0, 0, 0),
('management', 97, 53, 'admin/config/search/clean-urls', 'admin/config/search/clean-urls', 'Clean URLs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22456e61626c65206f722064697361626c6520636c65616e2055524c7320666f7220796f757220736974652e223b7d7d, 'system', 0, 0, 0, 0, 5, 4, 0, 1, 8, 53, 97, 0, 0, 0, 0, 0, 0),
('management', 98, 56, 'admin/config/system/cron', 'admin/config/system/cron', 'Cron', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34303a224d616e616765206175746f6d617469632073697465206d61696e74656e616e6365207461736b732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 56, 98, 0, 0, 0, 0, 0, 0),
('management', 99, 51, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Date and time', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 51, 99, 0, 0, 0, 0, 0, 0),
('management', 101, 46, 'admin/config/media/file-system', 'admin/config/media/file-system', 'File system', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36383a2254656c6c2044727570616c20776865726520746f2073746f72652075706c6f616465642066696c657320616e6420686f772074686579206172652061636365737365642e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 46, 101, 0, 0, 0, 0, 0, 0),
('management', 102, 54, 'admin/appearance/settings/garland', 'admin/appearance/settings/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 102, 0, 0, 0, 0, 0, 0),
('management', 103, 54, 'admin/appearance/settings/global', 'admin/appearance/settings/global', 'Global settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -1, 4, 0, 1, 7, 54, 103, 0, 0, 0, 0, 0, 0),
('management', 104, 48, 'admin/config/people/ip-blocking', 'admin/config/people/ip-blocking', 'IP address blocking', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224d616e61676520626c6f636b6564204950206164647265737365732e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 8, 48, 104, 0, 0, 0, 0, 0, 0),
('management', 105, 46, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Image styles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37383a22436f6e666967757265207374796c657320746861742063616e206265207573656420666f7220726573697a696e67206f722061646a757374696e6720696d61676573206f6e20646973706c61792e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 46, 105, 0, 0, 0, 0, 0, 0),
('management', 106, 46, 'admin/config/media/image-toolkit', 'admin/config/media/image-toolkit', 'Image toolkit', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37343a2243686f6f736520776869636820696d61676520746f6f6c6b697420746f2075736520696620796f75206861766520696e7374616c6c6564206f7074696f6e616c20746f6f6c6b6974732e223b7d7d, 'system', 0, 0, 0, 0, 20, 4, 0, 1, 8, 46, 106, 0, 0, 0, 0, 0, 0),
('management', 107, 36, 'admin/structure/types/list', 'admin/structure/types/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 36, 107, 0, 0, 0, 0, 0, 0),
('management', 108, 43, 'admin/modules/list/confirm', 'admin/modules/list/confirm', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 43, 108, 0, 0, 0, 0, 0, 0),
('management', 109, 57, 'admin/structure/taxonomy/list', 'admin/structure/taxonomy/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 57, 109, 0, 0, 0, 0, 0, 0),
('management', 110, 47, 'admin/structure/menu/list', 'admin/structure/menu/list', 'List menus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 47, 110, 0, 0, 0, 0, 0, 0),
('management', 111, 39, 'admin/config/development/logging', 'admin/config/development/logging', 'Logging and errors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3135343a2253657474696e677320666f72206c6f6767696e6720616e6420616c65727473206d6f64756c65732e20566172696f7573206d6f64756c65732063616e20726f7574652044727570616c27732073797374656d206576656e747320746f20646966666572656e742064657374696e6174696f6e732c2073756368206173207379736c6f672c2064617461626173652c20656d61696c2c206574632e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 39, 111, 0, 0, 0, 0, 0, 0),
('management', 112, 39, 'admin/config/development/maintenance', 'admin/config/development/maintenance', 'Maintenance mode', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a2254616b65207468652073697465206f66666c696e6520666f72206d61696e74656e616e6365206f72206272696e67206974206261636b206f6e6c696e652e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 39, 112, 0, 0, 0, 0, 0, 0),
('management', 113, 39, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130313a22456e61626c65206f722064697361626c6520706167652063616368696e6720666f7220616e6f6e796d6f757320757365727320616e64207365742043535320616e64204a532062616e647769647468206f7074696d697a6174696f6e206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 39, 113, 0, 0, 0, 0, 0, 0),
('management', 114, 54, 'admin/appearance/settings/stark', 'admin/appearance/settings/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 114, 0, 0, 0, 0, 0, 0),
('management', 117, 32, 'admin/content/comment/approval', 'admin/content/comment/approval', 'Unapproved comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 9, 32, 117, 0, 0, 0, 0, 0, 0),
('management', 118, 60, 'admin/modules/uninstall/confirm', 'admin/modules/uninstall/confirm', 'Uninstall', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 16, 60, 118, 0, 0, 0, 0, 0, 0),
('management', 120, 54, 'admin/appearance/settings/nucleus', 'admin/appearance/settings/nucleus', 'nucleus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 120, 0, 0, 0, 0, 0, 0),
('management', 121, 54, 'admin/appearance/settings/nucleus_starter', 'admin/appearance/settings/nucleus_starter', 'nucleus_starter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 121, 0, 0, 0, 0, 0, 0),
('management', 122, 57, 'admin/structure/taxonomy/%', 'admin/structure/taxonomy/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 57, 122, 0, 0, 0, 0, 0, 0),
('management', 123, 49, 'admin/people/permissions/list', 'admin/people/permissions/list', 'Permissions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36343a2244657465726d696e652061636365737320746f2066656174757265732062792073656c656374696e67207065726d697373696f6e7320666f7220726f6c65732e223b7d7d, 'system', -1, 0, 0, 0, -8, 4, 0, 1, 18, 49, 123, 0, 0, 0, 0, 0, 0),
('management', 124, 32, 'admin/content/comment/new', 'admin/content/comment/new', 'Published comments', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 9, 32, 124, 0, 0, 0, 0, 0, 0),
('management', 125, 64, 'admin/config/services/rss-publishing', 'admin/config/services/rss-publishing', 'RSS publishing', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3131343a22436f6e666967757265207468652073697465206465736372697074696f6e2c20746865206e756d626572206f66206974656d7320706572206665656420616e6420776865746865722066656564732073686f756c64206265207469746c65732f746561736572732f66756c6c2d746578742e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 64, 125, 0, 0, 0, 0, 0, 0),
('management', 126, 51, 'admin/config/regional/settings', 'admin/config/regional/settings', 'Regional settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35343a2253657474696e677320666f7220746865207369746527732064656661756c742074696d65207a6f6e6520616e6420636f756e7472792e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 51, 126, 0, 0, 0, 0, 0, 0),
('management', 127, 49, 'admin/people/permissions/roles', 'admin/people/permissions/roles', 'Roles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a224c6973742c20656469742c206f7220616464207573657220726f6c65732e223b7d7d, 'system', -1, 0, 1, 0, -5, 4, 0, 1, 18, 49, 127, 0, 0, 0, 0, 0, 0),
('management', 128, 47, 'admin/structure/menu/settings', 'admin/structure/menu/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 4, 0, 1, 21, 47, 128, 0, 0, 0, 0, 0, 0),
('management', 129, 54, 'admin/appearance/settings/seven', 'admin/appearance/settings/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 129, 0, 0, 0, 0, 0, 0),
('management', 130, 56, 'admin/config/system/site-information', 'admin/config/system/site-information', 'Site information', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3130343a224368616e67652073697465206e616d652c20652d6d61696c20616464726573732c20736c6f67616e2c2064656661756c742066726f6e7420706167652c20616e64206e756d626572206f6620706f7374732070657220706167652c206572726f722070616765732e223b7d7d, 'system', 0, 0, 0, 0, -20, 4, 0, 1, 8, 56, 130, 0, 0, 0, 0, 0, 0),
('management', 131, 35, 'admin/config/content/formats', 'admin/config/content/formats', 'Text formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3132373a22436f6e66696775726520686f7720636f6e74656e7420696e7075742062792075736572732069732066696c74657265642c20696e636c7564696e6720616c6c6f7765642048544d4c20746167732e20416c736f20616c6c6f777320656e61626c696e67206f66206d6f64756c652d70726f76696465642066696c746572732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 35, 131, 0, 0, 0, 0, 0, 0),
('navigation', 133, 40, 'user/%/edit/account', 'user/%/edit/account', 'Account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 17, 40, 133, 0, 0, 0, 0, 0, 0, 0),
('management', 134, 131, 'admin/config/content/formats/%', 'admin/config/content/formats/%', '', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 35, 131, 134, 0, 0, 0, 0, 0),
('management', 135, 105, 'admin/config/media/image-styles/add', 'admin/config/media/image-styles/add', 'Add style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a224164642061206e657720696d616765207374796c652e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 46, 105, 135, 0, 0, 0, 0, 0),
('management', 136, 122, 'admin/structure/taxonomy/%/add', 'admin/structure/taxonomy/%/add', 'Add term', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 57, 122, 136, 0, 0, 0, 0, 0),
('management', 137, 131, 'admin/config/content/formats/add', 'admin/config/content/formats/add', 'Add text format', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 35, 131, 137, 0, 0, 0, 0, 0),
('management', 138, 30, 'admin/structure/block/list/bartik', 'admin/structure/block/list/bartik', 'Bartik', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 138, 0, 0, 0, 0, 0, 0),
('management', 140, 90, 'admin/config/system/actions/configure', 'admin/config/system/actions/configure', 'Configure an advanced action', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 56, 90, 140, 0, 0, 0, 0, 0),
('management', 141, 47, 'admin/structure/menu/manage/%', 'admin/structure/menu/manage/%', 'Customize menu', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 21, 47, 141, 0, 0, 0, 0, 0, 0),
('management', 142, 122, 'admin/structure/taxonomy/%/edit', 'admin/structure/taxonomy/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 57, 122, 142, 0, 0, 0, 0, 0),
('management', 143, 36, 'admin/structure/types/manage/%', 'admin/structure/types/manage/%', 'Edit content type', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 21, 36, 143, 0, 0, 0, 0, 0, 0),
('management', 144, 99, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time/formats', 'Formats', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35313a22436f6e66696775726520646973706c617920666f726d617420737472696e677320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -9, 5, 0, 1, 8, 51, 99, 144, 0, 0, 0, 0, 0),
('management', 145, 30, 'admin/structure/block/list/garland', 'admin/structure/block/list/garland', 'Garland', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 145, 0, 0, 0, 0, 0, 0),
('management', 146, 131, 'admin/config/content/formats/list', 'admin/config/content/formats/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 35, 131, 146, 0, 0, 0, 0, 0),
('management', 147, 122, 'admin/structure/taxonomy/%/list', 'admin/structure/taxonomy/%/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -20, 5, 0, 1, 21, 57, 122, 147, 0, 0, 0, 0, 0),
('management', 148, 105, 'admin/config/media/image-styles/list', 'admin/config/media/image-styles/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34323a224c697374207468652063757272656e7420696d616765207374796c6573206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 46, 105, 148, 0, 0, 0, 0, 0),
('management', 149, 90, 'admin/config/system/actions/manage', 'admin/config/system/actions/manage', 'Manage actions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224d616e6167652074686520616374696f6e7320646566696e656420666f7220796f757220736974652e223b7d7d, 'system', -1, 0, 0, 0, -2, 5, 0, 1, 8, 56, 90, 149, 0, 0, 0, 0, 0),
('management', 150, 89, 'admin/config/people/accounts/settings', 'admin/config/people/accounts/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 48, 89, 150, 0, 0, 0, 0, 0),
('management', 151, 30, 'admin/structure/block/list/seven', 'admin/structure/block/list/seven', 'Seven', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 151, 0, 0, 0, 0, 0, 0),
('management', 152, 30, 'admin/structure/block/list/stark', 'admin/structure/block/list/stark', 'Stark', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 152, 0, 0, 0, 0, 0, 0),
('management', 155, 99, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time/types', 'Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34343a22436f6e66696775726520646973706c617920666f726d61747320666f72206461746520616e642074696d652e223b7d7d, 'system', -1, 0, 1, 0, -10, 5, 0, 1, 8, 51, 99, 155, 0, 0, 0, 0, 0),
('management', 158, 30, 'admin/structure/block/list/nucleus', 'admin/structure/block/list/nucleus', 'nucleus', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 158, 0, 0, 0, 0, 0, 0),
('management', 159, 30, 'admin/structure/block/list/nucleus_starter', 'admin/structure/block/list/nucleus_starter', 'nucleus_starter', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 30, 159, 0, 0, 0, 0, 0, 0),
('navigation', 160, 52, 'node/%/revisions/%/delete', 'node/%/revisions/%/delete', 'Delete earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 160, 0, 0, 0, 0, 0, 0, 0),
('navigation', 161, 52, 'node/%/revisions/%/revert', 'node/%/revisions/%/revert', 'Revert to earlier revision', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 161, 0, 0, 0, 0, 0, 0, 0),
('navigation', 162, 52, 'node/%/revisions/%/view', 'node/%/revisions/%/view', 'Revisions', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 5, 52, 162, 0, 0, 0, 0, 0, 0, 0),
('management', 164, 145, 'admin/structure/block/list/garland/add', 'admin/structure/block/list/garland/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 145, 164, 0, 0, 0, 0, 0),
('management', 165, 158, 'admin/structure/block/list/nucleus/add', 'admin/structure/block/list/nucleus/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 158, 165, 0, 0, 0, 0, 0),
('management', 166, 159, 'admin/structure/block/list/nucleus_starter/add', 'admin/structure/block/list/nucleus_starter/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 159, 166, 0, 0, 0, 0, 0),
('management', 167, 151, 'admin/structure/block/list/seven/add', 'admin/structure/block/list/seven/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 151, 167, 0, 0, 0, 0, 0),
('management', 168, 152, 'admin/structure/block/list/stark/add', 'admin/structure/block/list/stark/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 152, 168, 0, 0, 0, 0, 0),
('management', 173, 155, 'admin/config/regional/date-time/types/add', 'admin/config/regional/date-time/types/add', 'Add date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31383a22416464206e6577206461746520747970652e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 51, 99, 155, 173, 0, 0, 0, 0),
('management', 174, 144, 'admin/config/regional/date-time/formats/add', 'admin/config/regional/date-time/formats/add', 'Add format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22416c6c6f7720757365727320746f20616464206164646974696f6e616c206461746520666f726d6174732e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 51, 99, 144, 174, 0, 0, 0, 0),
('management', 175, 141, 'admin/structure/menu/manage/%/add', 'admin/structure/menu/manage/%/add', 'Add link', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 47, 141, 175, 0, 0, 0, 0, 0),
('management', 176, 30, 'admin/structure/block/manage/%/%', 'admin/structure/block/manage/%/%', 'Configure block', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 30, 176, 0, 0, 0, 0, 0, 0),
('navigation', 177, 31, 'user/%/cancel/confirm/%/%', 'user/%/cancel/confirm/%/%', 'Confirm account cancellation', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 3, 0, 17, 31, 177, 0, 0, 0, 0, 0, 0, 0),
('management', 178, 143, 'admin/structure/types/manage/%/delete', 'admin/structure/types/manage/%/delete', 'Delete', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 36, 143, 178, 0, 0, 0, 0, 0),
('management', 179, 104, 'admin/config/people/ip-blocking/delete/%', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 48, 104, 179, 0, 0, 0, 0, 0),
('management', 180, 90, 'admin/config/system/actions/delete/%', 'admin/config/system/actions/delete/%', 'Delete action', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a2244656c65746520616e20616374696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 56, 90, 180, 0, 0, 0, 0, 0),
('management', 181, 141, 'admin/structure/menu/manage/%/delete', 'admin/structure/menu/manage/%/delete', 'Delete menu', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 47, 141, 181, 0, 0, 0, 0, 0),
('management', 182, 47, 'admin/structure/menu/item/%/delete', 'admin/structure/menu/item/%/delete', 'Delete menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 182, 0, 0, 0, 0, 0, 0),
('management', 183, 127, 'admin/people/permissions/roles/delete/%', 'admin/people/permissions/roles/delete/%', 'Delete role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 18, 49, 127, 183, 0, 0, 0, 0, 0),
('management', 184, 134, 'admin/config/content/formats/%/disable', 'admin/config/content/formats/%/disable', 'Disable text format', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 35, 131, 134, 184, 0, 0, 0, 0),
('management', 185, 143, 'admin/structure/types/manage/%/edit', 'admin/structure/types/manage/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 36, 143, 185, 0, 0, 0, 0, 0),
('management', 186, 141, 'admin/structure/menu/manage/%/edit', 'admin/structure/menu/manage/%/edit', 'Edit menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 47, 141, 186, 0, 0, 0, 0, 0),
('management', 187, 47, 'admin/structure/menu/item/%/edit', 'admin/structure/menu/item/%/edit', 'Edit menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 187, 0, 0, 0, 0, 0, 0),
('management', 188, 127, 'admin/people/permissions/roles/edit/%', 'admin/people/permissions/roles/edit/%', 'Edit role', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 18, 49, 127, 188, 0, 0, 0, 0, 0),
('management', 189, 105, 'admin/config/media/image-styles/edit/%', 'admin/config/media/image-styles/edit/%', 'Edit style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22436f6e66696775726520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 46, 105, 189, 0, 0, 0, 0, 0),
('management', 190, 141, 'admin/structure/menu/manage/%/list', 'admin/structure/menu/manage/%/list', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 47, 141, 190, 0, 0, 0, 0, 0),
('management', 191, 47, 'admin/structure/menu/item/%/reset', 'admin/structure/menu/item/%/reset', 'Reset menu link', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 191, 0, 0, 0, 0, 0, 0),
('management', 192, 105, 'admin/config/media/image-styles/delete/%', 'admin/config/media/image-styles/delete/%', 'Delete style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2244656c65746520616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 105, 192, 0, 0, 0, 0, 0),
('management', 193, 105, 'admin/config/media/image-styles/revert/%', 'admin/config/media/image-styles/revert/%', 'Revert style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a2252657665727420616e20696d616765207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 46, 105, 193, 0, 0, 0, 0, 0),
('management', 194, 143, 'admin/structure/types/manage/%/comment/display', 'admin/structure/types/manage/%/comment/display', 'Comment display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 5, 0, 1, 21, 36, 143, 194, 0, 0, 0, 0, 0),
('management', 195, 143, 'admin/structure/types/manage/%/comment/fields', 'admin/structure/types/manage/%/comment/fields', 'Comment fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 3, 5, 0, 1, 21, 36, 143, 195, 0, 0, 0, 0, 0),
('management', 196, 176, 'admin/structure/block/manage/%/%/configure', 'admin/structure/block/manage/%/%/configure', 'Configure block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 176, 196, 0, 0, 0, 0, 0),
('management', 197, 176, 'admin/structure/block/manage/%/%/delete', 'admin/structure/block/manage/%/%/delete', 'Delete block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 176, 197, 0, 0, 0, 0, 0),
('management', 198, 144, 'admin/config/regional/date-time/formats/%/delete', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 144, 198, 0, 0, 0, 0),
('management', 199, 155, 'admin/config/regional/date-time/types/%/delete', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2064656c657465206120636f6e66696775726564206461746520747970652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 155, 199, 0, 0, 0, 0),
('management', 200, 144, 'admin/config/regional/date-time/formats/%/edit', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a22416c6c6f7720757365727320746f2065646974206120636f6e66696775726564206461746520666f726d61742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 51, 99, 144, 200, 0, 0, 0, 0),
('management', 201, 189, 'admin/config/media/image-styles/edit/%/add/%', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224164642061206e65772065666665637420746f2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 46, 105, 189, 201, 0, 0, 0, 0),
('management', 202, 189, 'admin/config/media/image-styles/edit/%/effects/%', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a224564697420616e206578697374696e67206566666563742077697468696e2061207374796c652e223b7d7d, 'system', 0, 0, 1, 0, 0, 6, 0, 1, 8, 46, 105, 189, 202, 0, 0, 0, 0),
('management', 203, 202, 'admin/config/media/image-styles/edit/%/effects/%/delete', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33393a2244656c65746520616e206578697374696e67206566666563742066726f6d2061207374796c652e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 46, 105, 189, 202, 203, 0, 0, 0),
('management', 204, 47, 'admin/structure/menu/manage/main-menu', 'admin/structure/menu/manage/%', 'Main menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 204, 0, 0, 0, 0, 0, 0),
('management', 205, 47, 'admin/structure/menu/manage/management', 'admin/structure/menu/manage/%', 'Management', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 205, 0, 0, 0, 0, 0, 0),
('management', 206, 47, 'admin/structure/menu/manage/navigation', 'admin/structure/menu/manage/%', 'Navigation', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 206, 0, 0, 0, 0, 0, 0),
('management', 207, 47, 'admin/structure/menu/manage/user-menu', 'admin/structure/menu/manage/%', 'User menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 207, 0, 0, 0, 0, 0, 0),
('navigation', 208, 0, 'search', 'search', 'Search', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -44, 1, 1, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 209, 208, 'search/node', 'search/node', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 2, 0, 208, 209, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 210, 208, 'search/user', 'search/user', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 208, 210, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 211, 209, 'search/node/%', 'search/node/%', 'Content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 208, 209, 211, 0, 0, 0, 0, 0, 0, 0),
('navigation', 212, 17, 'user/%/shortcuts', 'user/%/shortcuts', 'Shortcuts', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 212, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 214, 210, 'search/user/%', 'search/user/%', 'Users', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 208, 210, 214, 0, 0, 0, 0, 0, 0, 0),
('management', 215, 12, 'admin/help/number', 'admin/help/number', 'number', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 215, 0, 0, 0, 0, 0, 0, 0),
('management', 216, 12, 'admin/help/overlay', 'admin/help/overlay', 'overlay', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 216, 0, 0, 0, 0, 0, 0, 0),
('management', 217, 12, 'admin/help/path', 'admin/help/path', 'path', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 217, 0, 0, 0, 0, 0, 0, 0),
('management', 219, 12, 'admin/help/search', 'admin/help/search', 'search', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 219, 0, 0, 0, 0, 0, 0, 0),
('management', 220, 12, 'admin/help/shortcut', 'admin/help/shortcut', 'shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 220, 0, 0, 0, 0, 0, 0, 0),
('management', 221, 53, 'admin/config/search/settings', 'admin/config/search/settings', 'Search settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36373a22436f6e6669677572652072656c6576616e63652073657474696e677320666f722073656172636820616e64206f7468657220696e646578696e67206f7074696f6e732e223b7d7d, 'system', 0, 0, 0, 0, -10, 4, 0, 1, 8, 53, 221, 0, 0, 0, 0, 0, 0),
('management', 222, 61, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Shortcuts', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32393a2241646420616e64206d6f646966792073686f727463757420736574732e223b7d7d, 'system', 0, 0, 1, 0, 0, 4, 0, 1, 8, 61, 222, 0, 0, 0, 0, 0, 0),
('management', 223, 53, 'admin/config/search/path', 'admin/config/search/path', 'URL aliases', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a224368616e676520796f7572207369746527732055524c20706174687320627920616c696173696e67207468656d2e223b7d7d, 'system', 0, 0, 1, 0, -5, 4, 0, 1, 8, 53, 223, 0, 0, 0, 0, 0, 0),
('management', 224, 223, 'admin/config/search/path/add', 'admin/config/search/path/add', 'Add alias', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 53, 223, 224, 0, 0, 0, 0, 0),
('management', 225, 222, 'admin/config/user-interface/shortcut/add-set', 'admin/config/user-interface/shortcut/add-set', 'Add shortcut set', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 61, 222, 225, 0, 0, 0, 0, 0),
('management', 226, 221, 'admin/config/search/settings/reindex', 'admin/config/search/settings/reindex', 'Clear index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 53, 221, 226, 0, 0, 0, 0, 0),
('management', 227, 222, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 61, 222, 227, 0, 0, 0, 0, 0),
('management', 228, 223, 'admin/config/search/path/list', 'admin/config/search/path/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 53, 223, 228, 0, 0, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('management', 229, 227, 'admin/config/user-interface/shortcut/%/add-link', 'admin/config/user-interface/shortcut/%/add-link', 'Add shortcut', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 61, 222, 227, 229, 0, 0, 0, 0),
('management', 230, 223, 'admin/config/search/path/delete/%', 'admin/config/search/path/delete/%', 'Delete alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 53, 223, 230, 0, 0, 0, 0, 0),
('management', 231, 227, 'admin/config/user-interface/shortcut/%/delete', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 61, 222, 227, 231, 0, 0, 0, 0),
('management', 232, 223, 'admin/config/search/path/edit/%', 'admin/config/search/path/edit/%', 'Edit alias', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 53, 223, 232, 0, 0, 0, 0, 0),
('management', 233, 227, 'admin/config/user-interface/shortcut/%/edit', 'admin/config/user-interface/shortcut/%/edit', 'Edit set name', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 8, 61, 222, 227, 233, 0, 0, 0, 0),
('management', 234, 222, 'admin/config/user-interface/shortcut/link/%', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 5, 0, 1, 8, 61, 222, 234, 0, 0, 0, 0, 0),
('management', 235, 227, 'admin/config/user-interface/shortcut/%/links', 'admin/config/user-interface/shortcut/%/links', 'List links', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 61, 222, 227, 235, 0, 0, 0, 0),
('management', 236, 234, 'admin/config/user-interface/shortcut/link/%/delete', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 61, 222, 234, 236, 0, 0, 0, 0),
('shortcut-set-1', 237, 0, 'node/add', 'node/add', 'Add content', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -50, 1, 0, 237, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 238, 0, 'admin/content', 'admin/content', 'Find content', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -49, 1, 0, 238, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 239, 0, '<front>', '', 'Home', 0x613a303a7b7d, 'menu', 0, 1, 0, 0, -50, 1, 1, 239, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 240, 6, 'node/add/article', 'node/add/article', 'Article', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38393a22557365203c656d3e61727469636c65733c2f656d3e20666f722074696d652d73656e73697469766520636f6e74656e74206c696b65206e6577732c2070726573732072656c6561736573206f7220626c6f6720706f7374732e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 240, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 241, 6, 'node/add/page', 'node/add/page', 'Basic page', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37373a22557365203c656d3e62617369632070616765733c2f656d3e20666f7220796f75722073746174696320636f6e74656e742c207375636820617320616e202741626f75742075732720706167652e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 241, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 242, 12, 'admin/help/toolbar', 'admin/help/toolbar', 'toolbar', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 242, 0, 0, 0, 0, 0, 0, 0),
('management', 281, 19, 'admin/reports/updates', 'admin/reports/updates', 'Available updates', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38323a22476574206120737461747573207265706f72742061626f757420617661696c61626c65207570646174657320666f7220796f757220696e7374616c6c6564206d6f64756c657320616e64207468656d65732e223b7d7d, 'system', 0, 0, 0, 0, -50, 3, 0, 1, 19, 281, 0, 0, 0, 0, 0, 0, 0),
('management', 282, 16, 'admin/modules/install', 'admin/modules/install', 'Install new module', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 16, 282, 0, 0, 0, 0, 0, 0, 0),
('management', 283, 7, 'admin/appearance/install', 'admin/appearance/install', 'Install new theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 3, 0, 1, 7, 283, 0, 0, 0, 0, 0, 0, 0),
('management', 284, 16, 'admin/modules/update', 'admin/modules/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 16, 284, 0, 0, 0, 0, 0, 0, 0),
('management', 285, 7, 'admin/appearance/update', 'admin/appearance/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 3, 0, 1, 7, 285, 0, 0, 0, 0, 0, 0, 0),
('management', 286, 12, 'admin/help/update', 'admin/help/update', 'update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 286, 0, 0, 0, 0, 0, 0, 0),
('management', 287, 281, 'admin/reports/updates/list', 'admin/reports/updates/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 281, 287, 0, 0, 0, 0, 0, 0),
('management', 288, 281, 'admin/reports/updates/settings', 'admin/reports/updates/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 50, 4, 0, 1, 19, 281, 288, 0, 0, 0, 0, 0, 0),
('management', 289, 281, 'admin/reports/updates/install', 'admin/reports/updates/install', 'Install new module or theme', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 25, 4, 0, 1, 19, 281, 289, 0, 0, 0, 0, 0, 0),
('management', 290, 281, 'admin/reports/updates/update', 'admin/reports/updates/update', 'Update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 4, 0, 1, 19, 281, 290, 0, 0, 0, 0, 0, 0),
('management', 329, 138, 'admin/structure/block/list/bartik/add', 'admin/structure/block/list/bartik/add', 'Add block', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 30, 138, 329, 0, 0, 0, 0, 0),
('shortcut-set-1', 330, 0, 'admin/config/development/performance', 'admin/config/development/performance', 'Performance', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -48, 1, 0, 330, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 331, 478, 'blog', 'blog', 'Blogs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -50, 2, 1, 478, 331, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 332, 0, 'contact', 'contact', 'Contact', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -45, 1, 1, 332, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 333, 478, 'aggregator', 'aggregator', 'Feed aggregator', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 1, 0, 1, 0, -48, 2, 1, 478, 333, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 334, 0, 'forum', 'forum', 'Forums', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 1, 0, -46, 1, 1, 334, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 335, 478, 'poll', 'poll', 'Polls', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 0, 0, -49, 2, 1, 478, 335, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 336, 0, 'tracker', 'tracker', 'Recent content', 0x613a303a7b7d, 'system', 1, 0, 1, 0, -43, 1, 1, 336, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 337, 336, 'tracker/all', 'tracker/all', 'All recent content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 336, 337, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 338, 333, 'aggregator/categories', 'aggregator/categories', 'Categories', 0x613a303a7b7d, 'system', 0, 0, 1, 0, 0, 3, 0, 478, 333, 338, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 339, 334, 'forum/%', 'forum/%', 'Forums', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 2, 0, 334, 339, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 340, 333, 'blog/%', 'blog/%', 'My blog', 0x613a303a7b7d, 'system', 1, 0, 0, 0, -50, 3, 1, 478, 333, 340, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 341, 336, 'tracker/%', 'tracker/%', 'My recent content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 336, 341, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 342, 331, 'aggregator/sources', 'aggregator/sources', 'Sources', 0x613a303a7b7d, 'system', 1, 0, 1, 0, -49, 3, 1, 478, 331, 342, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 343, 338, 'aggregator/categories/%', 'aggregator/categories/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 478, 333, 338, 343, 0, 0, 0, 0, 0, 0),
('main-menu', 344, 342, 'aggregator/sources/%', 'aggregator/sources/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 478, 331, 342, 344, 0, 0, 0, 0, 0, 0),
('navigation', 345, 6, 'node/add/blog', 'node/add/blog', 'Blog entry', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35383a2255736520666f72206d756c74692d7573657220626c6f67732e20457665727920757365722067657473206120706572736f6e616c20626c6f672e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 345, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 346, 17, 'user/%/contact', 'user/%/contact', 'Contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 17, 346, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 347, 21, 'admin/structure/contact', 'admin/structure/contact', 'Contact form', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a37313a2243726561746520612073797374656d20636f6e7461637420666f726d20616e64207365742075702063617465676f7269657320666f722074686520666f726d20746f207573652e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 347, 0, 0, 0, 0, 0, 0, 0),
('navigation', 349, 6, 'node/add/forum', 'node/add/forum', 'Forum topic', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36393a2241203c656d3e666f72756d20746f7069633c2f656d3e207374617274732061206e65772064697363757373696f6e207468726561642077697468696e206120666f72756d2e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 349, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 350, 21, 'admin/structure/forum', 'admin/structure/forum', 'Forums', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a22436f6e74726f6c20666f72756d206869657261726368792073657474696e67732e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 350, 0, 0, 0, 0, 0, 0, 0),
('navigation', 352, 6, 'node/add/poll', 'node/add/poll', 'Poll', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3139313a2241203c656d3e706f6c6c3c2f656d3e2069732061207175657374696f6e2077697468206120736574206f6620706f737369626c6520726573706f6e7365732e2041203c656d3e706f6c6c3c2f656d3e2c206f6e636520637265617465642c206175746f6d61746963616c6c792070726f766964657320612073696d706c652072756e6e696e6720636f756e74206f6620746865206e756d626572206f6620766f74657320726563656976656420666f72206561636820726573706f6e73652e223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 352, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 353, 21, 'admin/structure/quicktabs', 'admin/structure/quicktabs', 'Quicktabs', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33323a2243726561746520626c6f636b73206f662074616262656420636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 353, 0, 0, 0, 0, 0, 0, 0),
('management', 354, 19, 'admin/reports/hits', 'admin/reports/hits', 'Recent hits', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22566965772070616765732074686174206861766520726563656e746c79206265656e20766973697465642e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 354, 0, 0, 0, 0, 0, 0, 0),
('navigation', 355, 5, 'node/%/results', 'node/%/results', 'Results', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 2, 0, 5, 355, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 356, 19, 'admin/reports/pages', 'admin/reports/pages', 'Top pages', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a225669657720706167657320746861742068617665206265656e20686974206672657175656e746c792e223b7d7d, 'system', 0, 0, 0, 0, 1, 3, 0, 1, 19, 356, 0, 0, 0, 0, 0, 0, 0),
('management', 357, 19, 'admin/reports/referrers', 'admin/reports/referrers', 'Top referrers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31393a225669657720746f70207265666572726572732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 357, 0, 0, 0, 0, 0, 0, 0),
('management', 358, 19, 'admin/reports/visitors', 'admin/reports/visitors', 'Top visitors', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22566965772076697369746f7273207468617420686974206d616e792070616765732e223b7d7d, 'system', 0, 0, 0, 0, 2, 3, 0, 1, 19, 358, 0, 0, 0, 0, 0, 0, 0),
('navigation', 359, 5, 'node/%/track', 'node/%/track', 'Track', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 2, 0, 5, 359, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 360, 17, 'user/%/track', 'user/%/track', 'Track', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 360, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 362, 21, 'admin/structure/trigger', 'admin/structure/trigger', 'Triggers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22436f6e666967757265207768656e20746f206578656375746520616374696f6e732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 362, 0, 0, 0, 0, 0, 0, 0),
('management', 363, 21, 'admin/structure/views', 'admin/structure/views', 'Views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33353a224d616e61676520637573746f6d697a6564206c69737473206f6620636f6e74656e742e223b7d7d, 'system', 0, 0, 1, 0, 0, 3, 0, 1, 21, 363, 0, 0, 0, 0, 0, 0, 0),
('navigation', 364, 5, 'node/%/votes', 'node/%/votes', 'Votes', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 2, 0, 5, 364, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 365, 12, 'admin/help/aggregator', 'admin/help/aggregator', 'aggregator', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 365, 0, 0, 0, 0, 0, 0, 0),
('management', 366, 12, 'admin/help/blog', 'admin/help/blog', 'blog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 366, 0, 0, 0, 0, 0, 0, 0),
('management', 367, 12, 'admin/help/contact', 'admin/help/contact', 'contact', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 367, 0, 0, 0, 0, 0, 0, 0),
('management', 368, 12, 'admin/help/forum', 'admin/help/forum', 'forum', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 368, 0, 0, 0, 0, 0, 0, 0),
('management', 371, 12, 'admin/help/pathauto', 'admin/help/pathauto', 'pathauto', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 371, 0, 0, 0, 0, 0, 0, 0),
('management', 372, 12, 'admin/help/php', 'admin/help/php', 'php', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 372, 0, 0, 0, 0, 0, 0, 0),
('management', 373, 12, 'admin/help/poll', 'admin/help/poll', 'poll', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 373, 0, 0, 0, 0, 0, 0, 0),
('management', 374, 12, 'admin/help/quicktabs', 'admin/help/quicktabs', 'quicktabs', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 374, 0, 0, 0, 0, 0, 0, 0),
('management', 375, 12, 'admin/help/statistics', 'admin/help/statistics', 'statistics', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 375, 0, 0, 0, 0, 0, 0, 0),
('management', 376, 12, 'admin/help/superfish', 'admin/help/superfish', 'superfish', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 376, 0, 0, 0, 0, 0, 0, 0),
('management', 377, 12, 'admin/help/syslog', 'admin/help/syslog', 'syslog', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 377, 0, 0, 0, 0, 0, 0, 0),
('management', 378, 12, 'admin/help/token', 'admin/help/token', 'token', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 378, 0, 0, 0, 0, 0, 0, 0),
('management', 379, 12, 'admin/help/tracker', 'admin/help/tracker', 'tracker', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 379, 0, 0, 0, 0, 0, 0, 0),
('management', 381, 12, 'admin/help/trigger', 'admin/help/trigger', 'trigger', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 381, 0, 0, 0, 0, 0, 0, 0),
('management', 382, 12, 'admin/help/views_slideshow', 'admin/help/views_slideshow', 'views_slideshow', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 382, 0, 0, 0, 0, 0, 0, 0),
('management', 383, 12, 'admin/help/views_slideshow_cycle', 'admin/help/views_slideshow_cycle', 'views_slideshow_cycle', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 383, 0, 0, 0, 0, 0, 0, 0),
('management', 384, 12, 'admin/help/wysiwyg', 'admin/help/wysiwyg', 'wysiwyg', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 384, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 385, 343, 'aggregator/categories/%/categorize', 'aggregator/categories/%/categorize', 'Categorize', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 478, 333, 338, 343, 385, 0, 0, 0, 0, 0),
('main-menu', 386, 344, 'aggregator/sources/%/categorize', 'aggregator/sources/%/categorize', 'Categorize', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 478, 331, 342, 344, 386, 0, 0, 0, 0, 0),
('main-menu', 387, 343, 'aggregator/categories/%/configure', 'aggregator/categories/%/configure', 'Configure', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 478, 333, 338, 343, 387, 0, 0, 0, 0, 0),
('main-menu', 388, 344, 'aggregator/sources/%/configure', 'aggregator/sources/%/configure', 'Configure', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 478, 331, 342, 344, 388, 0, 0, 0, 0, 0),
('main-menu', 389, 343, 'aggregator/categories/%/view', 'aggregator/categories/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 478, 333, 338, 343, 389, 0, 0, 0, 0, 0),
('main-menu', 390, 344, 'aggregator/sources/%/view', 'aggregator/sources/%/view', 'View', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 478, 331, 342, 344, 390, 0, 0, 0, 0, 0),
('management', 391, 353, 'admin/structure/quicktabs/add', 'admin/structure/quicktabs/add', 'Add Quicktabs Instance', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 353, 391, 0, 0, 0, 0, 0, 0),
('management', 392, 347, 'admin/structure/contact/add', 'admin/structure/contact/add', 'Add category', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 4, 0, 1, 21, 347, 392, 0, 0, 0, 0, 0, 0),
('management', 393, 363, 'admin/structure/views/add', 'admin/structure/views/add', 'Add new view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 363, 393, 0, 0, 0, 0, 0, 0),
('management', 394, 363, 'admin/structure/views/add-template', 'admin/structure/views/add-template', 'Add view from template', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 363, 394, 0, 0, 0, 0, 0, 0),
('management', 395, 362, 'admin/structure/trigger/comment', 'admin/structure/trigger/comment', 'Comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 395, 0, 0, 0, 0, 0, 0),
('management', 397, 19, 'admin/reports/access/%', 'admin/reports/access/%', 'Details', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31363a225669657720616363657373206c6f672e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 397, 0, 0, 0, 0, 0, 0, 0),
('management', 398, 64, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'Feed aggregator', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3131363a22436f6e66696775726520776869636820636f6e74656e7420796f7572207369746520616767726567617465732066726f6d206f746865722073697465732c20686f77206f6674656e20697420706f6c6c73207468656d2c20616e6420686f7720746865792772652063617465676f72697a65642e223b7d7d, 'system', 0, 0, 1, 0, 10, 4, 0, 1, 8, 64, 398, 0, 0, 0, 0, 0, 0),
('management', 399, 363, 'admin/structure/views/import', 'admin/structure/views/import', 'Import', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 363, 399, 0, 0, 0, 0, 0, 0),
('management', 401, 350, 'admin/structure/forum/list', 'admin/structure/forum/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 350, 401, 0, 0, 0, 0, 0, 0),
('management', 402, 363, 'admin/structure/views/list', 'admin/structure/views/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 363, 402, 0, 0, 0, 0, 0, 0),
('management', 403, 353, 'admin/structure/quicktabs/list', 'admin/structure/quicktabs/list', 'List quicktabs', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 353, 403, 0, 0, 0, 0, 0, 0),
('management', 404, 362, 'admin/structure/trigger/node', 'admin/structure/trigger/node', 'Node', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 404, 0, 0, 0, 0, 0, 0),
('management', 405, 363, 'admin/structure/views/settings', 'admin/structure/views/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 363, 405, 0, 0, 0, 0, 0, 0),
('management', 406, 56, 'admin/config/system/statistics', 'admin/config/system/statistics', 'Statistics', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36383a22436f6e74726f6c2064657461696c732061626f7574207768617420616e6420686f7720796f75722073697465206c6f67732061636365737320737461746973746963732e223b7d7d, 'system', 0, 0, 0, 0, -15, 4, 0, 1, 8, 56, 406, 0, 0, 0, 0, 0, 0),
('management', 407, 353, 'admin/structure/quicktabs/styles', 'admin/structure/quicktabs/styles', 'Styles', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 353, 407, 0, 0, 0, 0, 0, 0),
('management', 408, 61, 'admin/config/user-interface/superfish', 'admin/config/user-interface/superfish', 'Superfish', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a22436f6e66696775726520537570657266697368204d656e7573223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 61, 408, 0, 0, 0, 0, 0, 0),
('management', 409, 362, 'admin/structure/trigger/system', 'admin/structure/trigger/system', 'System', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 409, 0, 0, 0, 0, 0, 0),
('management', 410, 362, 'admin/structure/trigger/taxonomy', 'admin/structure/trigger/taxonomy', 'Taxonomy', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 410, 0, 0, 0, 0, 0, 0),
('navigation', 411, 360, 'user/%/track/content', 'user/%/track/content', 'Track content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 17, 360, 411, 0, 0, 0, 0, 0, 0, 0),
('navigation', 412, 360, 'user/%/track/navigation', 'user/%/track/navigation', 'Track page visits', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 3, 0, 17, 360, 412, 0, 0, 0, 0, 0, 0, 0),
('management', 414, 362, 'admin/structure/trigger/unassign', 'admin/structure/trigger/unassign', 'Unassign', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22556e61737369676e20616e20616374696f6e2066726f6d206120747269676765722e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 414, 0, 0, 0, 0, 0, 0),
('management', 415, 362, 'admin/structure/trigger/user', 'admin/structure/trigger/user', 'User', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 362, 415, 0, 0, 0, 0, 0, 0),
('management', 416, 35, 'admin/config/content/wysiwyg', 'admin/config/content/wysiwyg', 'Wysiwyg profiles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33303a22436f6e66696775726520636c69656e742d7369646520656469746f72732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 35, 416, 0, 0, 0, 0, 0, 0),
('management', 417, 350, 'admin/structure/forum/settings', 'admin/structure/forum/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 4, 0, 1, 21, 350, 417, 0, 0, 0, 0, 0, 0),
('management', 419, 405, 'admin/structure/views/settings/advanced', 'admin/structure/views/settings/advanced', 'Advanced', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 21, 363, 405, 419, 0, 0, 0, 0, 0),
('management', 420, 405, 'admin/structure/views/settings/basic', 'admin/structure/views/settings/basic', 'Basic', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 405, 420, 0, 0, 0, 0, 0),
('management', 421, 223, 'admin/config/search/path/update_bulk', 'admin/config/search/path/update_bulk', 'Bulk update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 30, 5, 0, 1, 8, 53, 223, 421, 0, 0, 0, 0, 0),
('management', 422, 223, 'admin/config/search/path/delete_bulk', 'admin/config/search/path/delete_bulk', 'Delete aliases', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 40, 5, 0, 1, 8, 53, 223, 422, 0, 0, 0, 0, 0),
('management', 423, 347, 'admin/structure/contact/delete/%', 'admin/structure/contact/delete/%', 'Delete contact', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 347, 423, 0, 0, 0, 0, 0, 0),
('management', 425, 347, 'admin/structure/contact/edit/%', 'admin/structure/contact/edit/%', 'Edit contact category', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 347, 425, 0, 0, 0, 0, 0, 0),
('management', 426, 353, 'admin/structure/quicktabs/manage/%', 'admin/structure/quicktabs/manage/%', 'Edit quicktab', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 353, 426, 0, 0, 0, 0, 0, 0),
('management', 429, 398, 'admin/config/services/aggregator/list', 'admin/config/services/aggregator/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 8, 64, 398, 429, 0, 0, 0, 0, 0),
('management', 431, 416, 'admin/config/content/wysiwyg/profile', 'admin/config/content/wysiwyg/profile', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 35, 416, 431, 0, 0, 0, 0, 0),
('management', 434, 223, 'admin/config/search/path/patterns', 'admin/config/search/path/patterns', 'Patterns', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 5, 0, 1, 8, 53, 223, 434, 0, 0, 0, 0, 0),
('management', 435, 398, 'admin/config/services/aggregator/settings', 'admin/config/services/aggregator/settings', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3132393a22436f6e66696775726520746865206265686176696f72206f662074686520666565642061676772656761746f722c20696e636c7564696e67207768656e20746f20646973636172642066656564206974656d7320616e6420686f7720746f2070726573656e742066656564206974656d7320616e642063617465676f726965732e223b7d7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 435, 0, 0, 0, 0, 0),
('management', 436, 223, 'admin/config/search/path/settings', 'admin/config/search/path/settings', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 20, 5, 0, 1, 8, 53, 223, 436, 0, 0, 0, 0, 0),
('management', 438, 363, 'admin/structure/views/view/%', 'admin/structure/views/view/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 363, 438, 0, 0, 0, 0, 0, 0),
('management', 439, 350, 'admin/structure/forum/add/container', 'admin/structure/forum/add/container', 'Add container', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 350, 439, 0, 0, 0, 0, 0, 0),
('management', 440, 350, 'admin/structure/forum/add/forum', 'admin/structure/forum/add/forum', 'Add forum', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 21, 350, 440, 0, 0, 0, 0, 0, 0),
('management', 441, 398, 'admin/config/services/aggregator/add/category', 'admin/config/services/aggregator/add/category', 'Add category', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 441, 0, 0, 0, 0, 0),
('management', 442, 398, 'admin/config/services/aggregator/add/feed', 'admin/config/services/aggregator/add/feed', 'Add feed', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 442, 0, 0, 0, 0, 0),
('management', 443, 438, 'admin/structure/views/view/%/break-lock', 'admin/structure/views/view/%/break-lock', 'Break lock', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 443, 0, 0, 0, 0, 0),
('management', 444, 426, 'admin/structure/quicktabs/manage/%/clone', 'admin/structure/quicktabs/manage/%/clone', 'Clone quicktab', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 353, 426, 444, 0, 0, 0, 0, 0),
('management', 446, 426, 'admin/structure/quicktabs/manage/%/delete', 'admin/structure/quicktabs/manage/%/delete', 'Delete quicktab', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 353, 426, 446, 0, 0, 0, 0, 0),
('management', 448, 350, 'admin/structure/forum/edit/container/%', 'admin/structure/forum/edit/container/%', 'Edit container', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 350, 448, 0, 0, 0, 0, 0, 0),
('management', 449, 350, 'admin/structure/forum/edit/forum/%', 'admin/structure/forum/edit/forum/%', 'Edit forum', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 350, 449, 0, 0, 0, 0, 0, 0),
('management', 451, 426, 'admin/structure/quicktabs/manage/%/edit', 'admin/structure/quicktabs/manage/%/edit', 'Edit quicktab', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 353, 426, 451, 0, 0, 0, 0, 0),
('management', 453, 438, 'admin/structure/views/view/%/edit', 'admin/structure/views/view/%/edit', 'Edit view', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 5, 0, 1, 21, 363, 438, 453, 0, 0, 0, 0, 0),
('management', 454, 426, 'admin/structure/quicktabs/manage/%/export', 'admin/structure/quicktabs/manage/%/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 353, 426, 454, 0, 0, 0, 0, 0),
('management', 455, 398, 'admin/config/services/aggregator/add/opml', 'admin/config/services/aggregator/add/opml', 'Import OPML', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 455, 0, 0, 0, 0, 0),
('management', 456, 398, 'admin/config/services/aggregator/remove/%', 'admin/config/services/aggregator/remove/%', 'Remove items', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 456, 0, 0, 0, 0, 0),
('management', 461, 398, 'admin/config/services/aggregator/update/%', 'admin/config/services/aggregator/update/%', 'Update items', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 461, 0, 0, 0, 0, 0),
('management', 462, 438, 'admin/structure/views/view/%/clone', 'admin/structure/views/view/%/clone', 'Clone', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 462, 0, 0, 0, 0, 0),
('management', 463, 438, 'admin/structure/views/view/%/delete', 'admin/structure/views/view/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 463, 0, 0, 0, 0, 0),
('management', 464, 438, 'admin/structure/views/view/%/export', 'admin/structure/views/view/%/export', 'Export', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 464, 0, 0, 0, 0, 0),
('management', 465, 438, 'admin/structure/views/view/%/revert', 'admin/structure/views/view/%/revert', 'Revert', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 465, 0, 0, 0, 0, 0),
('management', 466, 398, 'admin/config/services/aggregator/edit/category/%', 'admin/config/services/aggregator/edit/category/%', 'Edit category', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 466, 0, 0, 0, 0, 0),
('management', 467, 398, 'admin/config/services/aggregator/edit/feed/%', 'admin/config/services/aggregator/edit/feed/%', 'Edit feed', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 8, 64, 398, 467, 0, 0, 0, 0, 0),
('management', 470, 438, 'admin/structure/views/view/%/preview/%', 'admin/structure/views/view/%/preview/%', '', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 363, 438, 470, 0, 0, 0, 0, 0),
('management', 471, 363, 'admin/structure/views/nojs/preview/%/%', 'admin/structure/views/nojs/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 363, 471, 0, 0, 0, 0, 0, 0),
('management', 473, 363, 'admin/structure/views/ajax/preview/%/%', 'admin/structure/views/ajax/preview/%/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 21, 363, 473, 0, 0, 0, 0, 0, 0),
('management', 474, 431, 'admin/config/content/wysiwyg/profile/%/edit', 'admin/config/content/wysiwyg/profile/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 416, 431, 474, 0, 0, 0, 0),
('management', 475, 431, 'admin/config/content/wysiwyg/profile/%/delete', 'admin/config/content/wysiwyg/profile/%/delete', 'Remove', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 6, 0, 1, 8, 35, 416, 431, 475, 0, 0, 0, 0),
('main-menu', 477, 0, 'node/9', 'node/%', 'About Us', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -49, 1, 1, 477, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 478, 0, 'articles', 'articles', 'Content Types', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'system', 0, 0, 1, 0, -48, 1, 1, 478, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 479, 47, 'admin/structure/menu/manage/menu-footer-menu', 'admin/structure/menu/manage/%', 'Footer Menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 4, 0, 1, 21, 47, 479, 0, 0, 0, 0, 0, 0),
('menu-footer-menu', 480, 0, '<front>', '', 'Home', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 1, 0, 0, -50, 1, 1, 480, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-footer-menu', 481, 0, 'node/9', 'node/%', 'About Drupal', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -49, 1, 1, 481, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-footer-menu', 482, 0, 'contact', 'contact', 'Contact Us', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -47, 1, 1, 482, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('menu-footer-menu', 483, 0, 'articles', 'articles', 'Articles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -48, 1, 1, 483, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 484, 54, 'admin/appearance/settings/zircon', 'admin/appearance/settings/zircon', 'Zircon', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 7, 54, 484, 0, 0, 0, 0, 0, 0),
('management', 485, 30, 'admin/structure/block/list/zircon', 'admin/structure/block/list/zircon', 'Zircon', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 30, 485, 0, 0, 0, 0, 0, 0),
('management', 531, 12, 'admin/help/jcarousel', 'admin/help/jcarousel', 'jcarousel', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 531, 0, 0, 0, 0, 0, 0, 0),
('management', 532, 35, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Easy Social Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34333a22436f6e6669677572652074686520736f6369616c20627574746f6e7320616e64206e6f6465207479706573223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 35, 532, 0, 0, 0, 0, 0, 0),
('management', 533, 35, 'admin/config/content/easy_social_wizard', 'admin/config/content/easy_social_wizard', 'Easy Social Wizard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34393a22517569636b6c7920656e61626c65204561737920536f6369616c20666f7220796f757220436f6e74656e74205479706573223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 35, 533, 0, 0, 0, 0, 0, 0),
('management', 536, 532, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social/widget-extra', 'Extra Widgets', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a2245787472612073657474696e677320666f722077696467657473223b7d7d, 'system', -1, 0, 0, 0, 3, 5, 0, 1, 8, 35, 532, 536, 0, 0, 0, 0, 0),
('management', 537, 532, 'admin/config/content/easy_social/ignore-paths', 'admin/config/content/easy_social/ignore-paths', 'Ignore Paths', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35333a22476c6f62616c20706174687320746f2069676e6f726520616e6420646f206e6f7420646973706c6179204561737920536f6369616c223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 35, 532, 537, 0, 0, 0, 0, 0),
('management', 538, 532, 'admin/config/content/easy_social/default', 'admin/config/content/easy_social/default', 'Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 35, 532, 538, 0, 0, 0, 0, 0),
('management', 539, 532, 'admin/config/content/easy_social/summary', 'admin/config/content/easy_social/summary', 'Summary', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31393a224561737920536f6369616c2053756d6d617279223b7d7d, 'system', -1, 0, 0, 0, 4, 5, 0, 1, 8, 35, 532, 539, 0, 0, 0, 0, 0),
('management', 540, 532, 'admin/config/content/easy_social/order', 'admin/config/content/easy_social/order', 'Widget Order', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a224561737920536f6369616c20576964676574204f72646572223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 35, 532, 540, 0, 0, 0, 0, 0),
('management', 541, 536, 'admin/config/content/easy_social/widget-extra/default', 'admin/config/content/easy_social/widget-extra/default', 'Extra Widget Settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 532, 536, 541, 0, 0, 0, 0),
('management', 542, 536, 'admin/config/content/easy_social/widget-extra/facebook', 'admin/config/content/easy_social/widget-extra/facebook', 'Facebook', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a2245787472612073657474696e677320666f722046616365626f6f6b223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 532, 536, 542, 0, 0, 0, 0),
('management', 543, 536, 'admin/config/content/easy_social/widget-extra/googleplus', 'admin/config/content/easy_social/widget-extra/googleplus', 'Google+', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a2245787472612073657474696e677320666f7220476f6f676c652b223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 532, 536, 543, 0, 0, 0, 0),
('management', 544, 536, 'admin/config/content/easy_social/widget-extra/twitter', 'admin/config/content/easy_social/widget-extra/twitter', 'Twitter', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a2245787472612073657474696e677320666f722054776974746572223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 532, 536, 544, 0, 0, 0, 0),
('navigation', 545, 0, 'sitemap', 'sitemap', 'Site map', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22446973706c617920612073697465206d61702077697468205253532066656564732e223b7d7d, 'system', 1, 0, 0, 0, 0, 1, 0, 545, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 546, 53, 'admin/config/search/sitemap', 'admin/config/search/sitemap', 'Site map', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34393a22436f6e74726f6c20776861742073686f756c6420626520646973706c61796564206f6e207468652073697465206d61702e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 53, 546, 0, 0, 0, 0, 0, 0),
('main-menu', 547, 0, 'sitemap', 'sitemap', 'Sitemap', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -44, 1, 1, 547, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 548, 6, 'node/add/product', 'node/add/product', 'Product', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a3330323a224d6f7262692061756775652065726f732c2072686f6e637573206e6f6e206d616c657375616461207365642c206665756769617420616320617263753f20496e20766f6c7574706174206665756769617420736f6c6c696369747564696e2e204d616563656e617320636f6e64696d656e74756d3b2066656c6973207175697320656c656d656e74756d20656c656966656e642c2065726174206e6962682061646970697363696e67206d617373612c2076697461652070756c76696e6172206475692075726e612065752070757275732e2050686173656c6c7573206672696e67696c6c612065726174206e6f6e2073656d206d617474697320656c656966656e642065676573746173206c656f20636f6e73656374657475722e204e756c6c61206f64696f207365642e0d0a223b7d7d, 'system', 0, 0, 0, 0, 0, 2, 0, 6, 548, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 549, 0, 'services', 'services', 'Services', 0x613a303a7b7d, 'system', 0, 0, 1, 0, -48, 1, 1, 549, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 550, 549, 'taxonomy/term/19', 'taxonomy/term/%', 'Bathroom', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 549, 550, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 551, 549, 'taxonomy/term/18', 'taxonomy/term/%', 'Bedroom', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a22437572616269747572207075727573206469616d2c206567657374617320616320636f6e7365717561742073697420616d657420706f73756572652e0d0a223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 549, 551, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 552, 549, 'taxonomy/term/20', 'taxonomy/term/%', 'Home office', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 549, 552, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 553, 549, 'taxonomy/term/17', 'taxonomy/term/%', 'Kitchen', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 549, 553, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 554, 549, 'taxonomy/term/16', 'taxonomy/term/%', 'Living Room', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36323a22566573746962756c756d20706f72747469746f72206375727375732068656e6472657269742e20496e7465676572207175697320706f73756572652e0d0a223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 549, 554, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 594, 0, 'admin/structure/block', 'admin/structure/block', 'Blocks', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -47, 1, 0, 594, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 595, 0, 'admin/structure/taxonomy', 'admin/structure/taxonomy', 'Taxonomy', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -46, 1, 0, 595, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 596, 21, 'admin/structure/widgets', 'admin/structure/widgets', 'Widgets', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22436f6e6669677572652073657473206f66207769646765747320746f20646973706c617920696e20626c6f636b732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 596, 0, 0, 0, 0, 0, 0, 0),
('management', 597, 12, 'admin/help/widgets', 'admin/help/widgets', 'widgets', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 597, 0, 0, 0, 0, 0, 0, 0),
('management', 598, 596, 'admin/structure/widgets/definitions', 'admin/structure/widgets/definitions', 'Definitions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22436f6e6669677572652073657473206f66207769646765747320746f20646973706c617920696e20626c6f636b732e223b7d7d, 'system', -1, 0, 1, 0, 1, 4, 0, 1, 21, 596, 598, 0, 0, 0, 0, 0, 0),
('management', 599, 596, 'admin/structure/widgets/sets', 'admin/structure/widgets/sets', 'Sets', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224c697374207468652063757272656e74207769646765742073657473206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 1, 0, 0, 4, 0, 1, 21, 596, 599, 0, 0, 0, 0, 0, 0),
('management', 600, 598, 'admin/structure/widgets/definitions/add', 'admin/structure/widgets/definitions/add', 'Add widget definition', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224164642061206e65772077696467657420646566696e6974696f6e2e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 596, 598, 600, 0, 0, 0, 0, 0),
('management', 601, 599, 'admin/structure/widgets/sets/add', 'admin/structure/widgets/sets/add', 'Add widget set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a224164642061206e657720776964676574207365742e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 596, 599, 601, 0, 0, 0, 0, 0),
('management', 602, 598, 'admin/structure/widgets/definitions/list', 'admin/structure/widgets/definitions/list', 'Definitions', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224c697374207468652063757272656e74207769646765742073657473206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 21, 596, 598, 602, 0, 0, 0, 0, 0),
('management', 603, 599, 'admin/structure/widgets/sets/list', 'admin/structure/widgets/sets/list', 'List', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34313a224c697374207468652063757272656e74207769646765742073657473206f6e2074686520736974652e223b7d7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 21, 596, 599, 603, 0, 0, 0, 0, 0),
('management', 604, 598, 'admin/structure/widgets/definitions/edit/%', 'admin/structure/widgets/definitions/edit/%', 'Edit widget definition', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a22436f6e66696775726520616e2077696467657420646566696e6974696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 598, 604, 0, 0, 0, 0, 0),
('management', 605, 599, 'admin/structure/widgets/sets/edit/%', 'admin/structure/widgets/sets/edit/%', 'Edit widget set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22436f6e66696775726520616e20776964676574207365742e223b7d7d, 'system', -1, 0, 1, 0, 0, 5, 0, 1, 21, 596, 599, 605, 0, 0, 0, 0, 0),
('management', 606, 598, 'admin/structure/widgets/definitions/preview/%', 'admin/structure/widgets/definitions/preview/%', 'Preview widget definition', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33313a22436f6e66696775726520616e2077696467657420646566696e6974696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 598, 606, 0, 0, 0, 0, 0),
('management', 607, 599, 'admin/structure/widgets/sets/delete/%', 'admin/structure/widgets/sets/delete/%', 'Delete widget set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a2244656c65746520616e20776964676574207365742e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 599, 607, 0, 0, 0, 0, 0),
('management', 608, 599, 'admin/structure/widgets/sets/revert/%', 'admin/structure/widgets/sets/revert/%', 'Revert style', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a2252657665727420616e20776964676574207365742e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 599, 608, 0, 0, 0, 0, 0),
('management', 609, 599, 'admin/structure/widgets/sets/export/%', 'admin/structure/widgets/sets/export/%', 'Export widget set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32313a224578706f727420616e20776964676574207365742e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 599, 609, 0, 0, 0, 0, 0),
('management', 610, 605, 'admin/structure/widgets/sets/edit/%/add/%', 'admin/structure/widgets/sets/edit/%/add/%', 'Add widget', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a224164642061206e65772077696467657420746f2061207365742e223b7d7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 596, 599, 605, 610, 0, 0, 0, 0),
('management', 611, 605, 'admin/structure/widgets/sets/edit/%/elements/%', 'admin/structure/widgets/sets/edit/%/elements/%', 'Edit widget element', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a224564697420616e206578697374696e67207769646765742077697468696e2061207365742e223b7d7d, 'system', 0, 0, 1, 0, 0, 6, 0, 1, 21, 596, 599, 605, 611, 0, 0, 0, 0),
('management', 612, 611, 'admin/structure/widgets/sets/edit/%/elements/%/delete', 'admin/structure/widgets/sets/edit/%/elements/%/delete', 'Delete widget', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a2244656c65746520616e206578697374696e67207769646765742066726f6d2061207365742e223b7d7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 21, 596, 599, 605, 611, 612, 0, 0, 0),
('main-menu', 613, 0, 'categories', 'categories', 'Categories', 0x613a303a7b7d, 'system', 0, 0, 1, 0, -47, 1, 1, 613, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 614, 17, 'user/%/socialmedia', 'user/%/socialmedia', 'Social profiles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a225573657220736f6369616c206d656469612070726f66696c6573223b7d7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 614, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 615, 12, 'admin/help/socialmedia', 'admin/help/socialmedia', 'socialmedia', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 615, 0, 0, 0, 0, 0, 0, 0),
('management', 616, 46, 'admin/config/media/socialmedia', 'admin/config/media/socialmedia', 'Social media', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22536f6369616c206d656469612064656661756c747320616e6420736974652070726f66696c652073657474696e6773223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 46, 616, 0, 0, 0, 0, 0, 0),
('management', 617, 616, 'admin/config/media/socialmedia/profiles', 'admin/config/media/socialmedia/profiles', 'Profiles', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33343a22536f6369616c206d656469612070726f66696c6520636f6e66696775726174696f6e223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 46, 616, 617, 0, 0, 0, 0, 0),
('management', 618, 616, 'admin/config/media/socialmedia/settings', 'admin/config/media/socialmedia/settings', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34373a22536f6369616c206d656469612064656661756c747320616e6420736974652070726f66696c652073657474696e6773223b7d7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 46, 616, 618, 0, 0, 0, 0, 0),
('management', 619, 616, 'admin/config/media/socialmedia/setup', 'admin/config/media/socialmedia/setup', 'Setup wizard', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34353a2253657475702077697a61726420746f2068656c7020796f7520676574207374617274656420717569636b6c792e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 46, 616, 619, 0, 0, 0, 0, 0),
('management', 620, 616, 'admin/config/media/socialmedia/widgets', 'admin/config/media/socialmedia/widgets', 'Widgets', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a22536f6369616c206d6564696120776964676574207365747320636f6e66696775726174696f6e223b7d7d, 'system', -1, 0, 0, 0, 3, 5, 0, 1, 8, 46, 616, 620, 0, 0, 0, 0, 0),
('management', 621, 620, 'admin/config/media/socialmedia/widgets/profile', 'admin/config/media/socialmedia/widgets/profile', 'Default profile set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35343a22536f6369616c206d656469612064656661756c742070726f66696c6520776964676574207365747320636f6e66696775726174696f6e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 616, 620, 621, 0, 0, 0, 0),
('management', 622, 620, 'admin/config/media/socialmedia/widgets/share', 'admin/config/media/socialmedia/widgets/share', 'Default share set', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a35343a22536f6369616c206d656469612064656661756c742070726f66696c6520776964676574207365747320636f6e66696775726174696f6e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 616, 620, 622, 0, 0, 0, 0);
INSERT INTO `menu_links` (`menu_name`, `mlid`, `plid`, `link_path`, `router_path`, `link_title`, `options`, `module`, `hidden`, `external`, `has_children`, `expanded`, `weight`, `depth`, `customized`, `p1`, `p2`, `p3`, `p4`, `p5`, `p6`, `p7`, `p8`, `p9`, `updated`) VALUES
('shortcut-set-1', 660, 0, 'admin/appearance/settings/zircon', 'admin/appearance/settings/zircon', 'Zircon', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -45, 1, 0, 660, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 661, 613, 'taxonomy/term/16', 'taxonomy/term/%', 'Living Room', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31313a224c6976696e6720526f6f6d223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -48, 2, 1, 613, 661, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 662, 613, 'taxonomy/term/17', 'taxonomy/term/%', 'Kitchen', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a373a224b69746368656e223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -50, 2, 1, 613, 662, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 663, 613, 'taxonomy/term/20', 'taxonomy/term/%', 'Home office', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31313a22486f6d65206f6666696365223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -45, 2, 1, 613, 663, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 664, 613, 'taxonomy/term/18', 'taxonomy/term/%', 'Bedroom', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a373a22426564726f6f6d223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -46, 2, 1, 613, 664, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 665, 613, 'taxonomy/term/19', 'taxonomy/term/%', 'Bathroom', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a383a2242617468726f6f6d223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -47, 2, 1, 613, 665, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 666, 598, 'admin/structure/widgets/definitions/export/%', 'admin/structure/widgets/definitions/export/%', 'Export widget definition', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32383a224578706f727420616e2077696467657420646566696e6974696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 5, 0, 1, 21, 596, 598, 666, 0, 0, 0, 0, 0),
('main-menu', 671, 613, 'taxonomy/term/22', 'taxonomy/term/%', 'Dining room', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31313a2244696e696e6720726f6f6d223b7d7d, 'taxonomy_menu', 0, 0, 0, 1, -49, 2, 1, 613, 671, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 673, 0, 'newsletter/edit/%', 'newsletter/edit/%', 'Edit newsletter subscriptions', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 1, 0, 673, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('navigation', 674, 17, 'user/%/newsletter', 'user/%/newsletter', 'Newsletter subscriptions', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 2, 0, 17, 674, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 675, 46, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Newsletters', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a34363a224d616e616765206e6577736c6574746572732c2073756273637269626572732c20616e642073657474696e67732e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 46, 675, 0, 0, 0, 0, 0, 0),
('management', 676, 675, 'admin/config/media/newsletter/create-send', 'admin/config/media/newsletter/create-send', 'Create/Send', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a36303a2243726561746520637573746f6d20737461746963206e6577736c65747465727320616e642073656e64206e6f6e2d6175746f6d61746564206f6e6573223b7d7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 46, 675, 676, 0, 0, 0, 0, 0),
('management', 677, 675, 'admin/config/media/newsletter/lists', 'admin/config/media/newsletter/lists', 'Lists', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a2246696e6420616e64206d616e616765206e6577736c6574746572206c697374732e223b7d7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 46, 675, 677, 0, 0, 0, 0, 0),
('management', 678, 675, 'admin/config/media/newsletter/configure', 'admin/config/media/newsletter/configure', 'Settings', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a22436f6e666967757265206e6577736c6574746572206c697374732e223b7d7d, 'system', -1, 0, 0, 0, 5, 5, 0, 1, 8, 46, 675, 678, 0, 0, 0, 0, 0),
('management', 679, 675, 'admin/config/media/newsletter/stats', 'admin/config/media/newsletter/stats', 'Statistics', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 5, 0, 1, 8, 46, 675, 679, 0, 0, 0, 0, 0),
('management', 680, 675, 'admin/config/media/newsletter/subscribers', 'admin/config/media/newsletter/subscribers', 'Subscribers', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31373a224c6973742073756273637269626572732e223b7d7d, 'system', -1, 0, 0, 0, 3, 5, 0, 1, 8, 46, 675, 680, 0, 0, 0, 0, 0),
('management', 681, 675, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter/templates', 'Templates', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33323a2241646d696e6973746572206e6577736c65747465722074656d706c617465732e223b7d7d, 'system', -1, 0, 0, 0, 4, 5, 0, 1, 8, 46, 675, 681, 0, 0, 0, 0, 0),
('management', 682, 677, 'admin/config/media/newsletter/lists/add', 'admin/config/media/newsletter/lists/add', 'Add new list', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22416464206e6577206e6577736c6574746572206c6973742e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 675, 677, 682, 0, 0, 0, 0),
('management', 683, 680, 'admin/config/media/newsletter/subscribers/add', 'admin/config/media/newsletter/subscribers/add', 'Add new subscriber', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32343a22416464206e6577206c69737420737562736372696265722e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 675, 680, 683, 0, 0, 0, 0),
('management', 684, 680, 'admin/config/media/newsletter/subscribers/add-mass', 'admin/config/media/newsletter/subscribers/add-mass', 'Add subscribers (Mass)', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31363a224164642073756273637269626572732e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 675, 680, 684, 0, 0, 0, 0),
('management', 685, 681, 'admin/config/media/newsletter/templates/confirmation', 'admin/config/media/newsletter/templates/confirmation', 'Confirmation', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a224564697420636f6e6669726d6174696f6e2074656d706c6174652e223b7d7d, 'system', -1, 0, 0, 0, -9, 6, 0, 1, 8, 46, 675, 681, 685, 0, 0, 0, 0),
('management', 686, 676, 'admin/config/media/newsletter/create-send/new', 'admin/config/media/newsletter/create-send/new', 'Create and send a custom newsletter', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a22437265617465206120637573746f6d20737461746963206e6577736c6574746572223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 675, 676, 686, 0, 0, 0, 0),
('management', 687, 679, 'admin/config/media/newsletter/stats/general', 'admin/config/media/newsletter/stats/general', 'General', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32353a2257617463682067656e6572616c20737461746973746963732e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 46, 675, 679, 687, 0, 0, 0, 0),
('management', 688, 679, 'admin/config/media/newsletter/stats/graphic', 'admin/config/media/newsletter/stats/graphic', 'Graphic', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33333a22576174636820616476616e636564204a517565727920737461746973746963732e223b7d7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 8, 46, 675, 679, 688, 0, 0, 0, 0),
('management', 689, 681, 'admin/config/media/newsletter/templates/mail', 'admin/config/media/newsletter/templates/mail', 'Mail templates', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a2241646d696e6973746572206d61696c2074656d706c617465732e223b7d7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 46, 675, 681, 689, 0, 0, 0, 0),
('management', 694, 681, 'admin/config/media/newsletter/templates/unsubscribe', 'admin/config/media/newsletter/templates/unsubscribe', 'Unsubscribe', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a224564697420756e7375627363726962652074656d706c6174652e223b7d7d, 'system', -1, 0, 0, 0, -7, 6, 0, 1, 8, 46, 675, 681, 694, 0, 0, 0, 0),
('management', 695, 681, 'admin/config/media/newsletter/templates/welcome', 'admin/config/media/newsletter/templates/welcome', 'Welcome', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32323a22456469742077656c636f6d652074656d706c6174652e223b7d7d, 'system', -1, 0, 0, 0, -8, 6, 0, 1, 8, 46, 675, 681, 695, 0, 0, 0, 0),
('management', 696, 689, 'admin/config/media/newsletter/templates/mail/add', 'admin/config/media/newsletter/templates/mail/add', 'Add new mail template', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32363a2241646d696e6973746572206d61696c2074656d706c617465732e223b7d7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 46, 675, 681, 689, 696, 0, 0, 0),
('management', 827, 19, 'admin/reports/views-plugins', 'admin/reports/views-plugins', 'Views plugins', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33383a224f76657276696577206f6620706c7567696e73207573656420696e20616c6c2076696577732e223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 19, 827, 0, 0, 0, 0, 0, 0, 0),
('management', 828, 42, 'admin/reports/fields/list', 'admin/reports/fields/list', 'List', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 19, 42, 828, 0, 0, 0, 0, 0, 0),
('management', 829, 42, 'admin/reports/fields/views-fields', 'admin/reports/fields/views-fields', 'Used in views', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a33373a224f76657276696577206f66206669656c6473207573656420696e20616c6c2076696577732e223b7d7d, 'system', -1, 0, 0, 0, 0, 4, 0, 1, 19, 42, 829, 0, 0, 0, 0, 0, 0),
('management', 888, 675, 'admin/config/media/newsletter/archive', 'admin/config/media/newsletter/archive', 'Issue archive', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 5, 0, 1, 8, 46, 675, 888, 0, 0, 0, 0, 0),
('management', 889, 21, 'admin/structure/tb-megamenu', 'admin/structure/tb-megamenu', 'TB Mega Menu', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a31323a225442204d656761204d656e75223b7d7d, 'system', 0, 0, 0, 0, 0, 3, 0, 1, 21, 889, 0, 0, 0, 0, 0, 0, 0),
('management', 890, 12, 'admin/help/jquery_update', 'admin/help/jquery_update', 'jquery_update', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 3, 0, 1, 12, 890, 0, 0, 0, 0, 0, 0, 0),
('management', 891, 889, 'admin/structure/tb-megamenu/request', 'admin/structure/tb-megamenu/request', 'Request', 0x613a303a7b7d, 'system', 1, 0, 0, 0, 0, 4, 0, 1, 21, 889, 891, 0, 0, 0, 0, 0, 0),
('management', 892, 39, 'admin/config/development/jquery_update', 'admin/config/development/jquery_update', 'jQuery update', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a38333a22436f6e6669677572652073657474696e67732072656c6174656420746f20746865206a517565727920757067726164652c20746865206c696272617279207061746820616e6420636f6d7072657373696f6e2e223b7d7d, 'system', 0, 0, 0, 0, 0, 4, 0, 1, 8, 39, 892, 0, 0, 0, 0, 0, 0),
('management', 893, 889, 'admin/structure/tb-megamenu/%/config', 'admin/structure/tb-megamenu/%/config', 'Config TB Mega Menu', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 4, 0, 1, 21, 889, 893, 0, 0, 0, 0, 0, 0),
('shortcut-set-1', 894, 0, 'admin/structure/views', 'admin/structure/views', 'Views', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, -44, 1, 0, 894, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 953, 0, 'node/80', 'node/%', 'Explore', 0x613a303a7b7d, 'menu', 0, 0, 1, 0, 0, 1, 0, 953, 0, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 954, 953, 'node/81', 'node/%', 'Color', 0x613a303a7b7d, 'menu', 0, 0, 1, 0, 0, 2, 0, 953, 954, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 955, 954, 'node/82', 'node/%', 'Blue Color', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 954, 955, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 956, 954, 'node/83', 'node/%', 'Orange Color', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 954, 956, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 957, 954, 'node/84', 'node/%', 'Pink Color', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 954, 957, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 958, 954, 'node/85', 'node/%', 'Green Color', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 954, 958, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 959, 954, 'node/86', 'node/%', 'Tea Color', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 954, 959, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 960, 953, 'node/87', 'node/%', 'Navigation', 0x613a303a7b7d, 'menu', 0, 0, 1, 0, 0, 2, 0, 953, 960, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 961, 960, 'node/88', 'node/%', 'Mega Menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 960, 961, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 962, 960, 'node/89', 'node/%', 'Superfish Menu', 0x613a303a7b7d, 'menu', 0, 0, 0, 0, 0, 3, 0, 953, 960, 962, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 963, 613, 'categories', 'categories', 'Mauris semper', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -42, 2, 1, 613, 963, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 964, 613, 'categories', 'categories', 'Etiam lacus odio', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -43, 2, 1, 613, 964, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 965, 613, 'categories', 'categories', 'Donec sollicitudin', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -44, 2, 1, 613, 965, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 966, 613, 'categories', 'categories', 'Pellentesque gravida', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -41, 2, 1, 613, 966, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 967, 613, 'categories', 'categories', 'Proin tristique', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -40, 2, 1, 613, 967, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 968, 613, 'categories', 'categories', 'Suspendisse tincidunt', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -39, 2, 1, 613, 968, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 969, 613, 'categories', 'categories', 'Vivamus semper', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -38, 2, 1, 613, 969, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 970, 613, 'categories', 'categories', 'Curabitur pharetra', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, -37, 2, 1, 613, 970, 0, 0, 0, 0, 0, 0, 0, 0),
('main-menu', 972, 613, 'categories', 'categories', 'Proin lobortis', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a303a22223b7d7d, 'menu', 0, 0, 0, 0, 0, 2, 1, 613, 972, 0, 0, 0, 0, 0, 0, 0, 0),
('management', 973, 536, 'admin/config/content/easy_social/widget-extra/linkedin', 'admin/config/content/easy_social/widget-extra/linkedin', 'LinkedIn', 0x613a313a7b733a31303a2261747472696275746573223b613a313a7b733a353a227469746c65223b733a32373a2245787472612073657474696e677320666f72204c696e6b6564496e223b7d7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 35, 532, 536, 973, 0, 0, 0, 0),
('management', 974, 122, 'admin/structure/taxonomy/%/display', 'admin/structure/taxonomy/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 57, 122, 974, 0, 0, 0, 0, 0),
('management', 975, 89, 'admin/config/people/accounts/display', 'admin/config/people/accounts/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 8, 48, 89, 975, 0, 0, 0, 0, 0),
('management', 976, 122, 'admin/structure/taxonomy/%/fields', 'admin/structure/taxonomy/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 21, 57, 122, 976, 0, 0, 0, 0, 0),
('management', 977, 89, 'admin/config/people/accounts/fields', 'admin/config/people/accounts/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 8, 48, 89, 977, 0, 0, 0, 0, 0),
('management', 978, 974, 'admin/structure/taxonomy/%/display/default', 'admin/structure/taxonomy/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 57, 122, 974, 978, 0, 0, 0, 0),
('management', 979, 975, 'admin/config/people/accounts/display/default', 'admin/config/people/accounts/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 8, 48, 89, 975, 979, 0, 0, 0, 0),
('management', 980, 680, 'admin/config/media/newsletter/subscribers/display', 'admin/config/media/newsletter/subscribers/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 8, 46, 675, 680, 980, 0, 0, 0, 0),
('management', 981, 681, 'admin/config/media/newsletter/templates/display', 'admin/config/media/newsletter/templates/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 8, 46, 675, 681, 981, 0, 0, 0, 0),
('management', 982, 143, 'admin/structure/types/manage/%/display', 'admin/structure/types/manage/%/display', 'Manage display', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 5, 0, 1, 21, 36, 143, 982, 0, 0, 0, 0, 0),
('management', 983, 680, 'admin/config/media/newsletter/subscribers/fields', 'admin/config/media/newsletter/subscribers/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 8, 46, 675, 680, 983, 0, 0, 0, 0),
('management', 984, 681, 'admin/config/media/newsletter/templates/fields', 'admin/config/media/newsletter/templates/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 6, 0, 1, 8, 46, 675, 681, 984, 0, 0, 0, 0),
('management', 985, 143, 'admin/structure/types/manage/%/fields', 'admin/structure/types/manage/%/fields', 'Manage fields', 0x613a303a7b7d, 'system', -1, 0, 1, 0, 1, 5, 0, 1, 21, 36, 143, 985, 0, 0, 0, 0, 0),
('management', 986, 974, 'admin/structure/taxonomy/%/display/full', 'admin/structure/taxonomy/%/display/full', 'Taxonomy term page', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 57, 122, 974, 986, 0, 0, 0, 0),
('management', 987, 974, 'admin/structure/taxonomy/%/display/token', 'admin/structure/taxonomy/%/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 21, 57, 122, 974, 987, 0, 0, 0, 0),
('management', 988, 975, 'admin/config/people/accounts/display/token', 'admin/config/people/accounts/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 8, 48, 89, 975, 988, 0, 0, 0, 0),
('management', 989, 975, 'admin/config/people/accounts/display/full', 'admin/config/people/accounts/display/full', 'User account', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 8, 48, 89, 975, 989, 0, 0, 0, 0),
('management', 990, 976, 'admin/structure/taxonomy/%/fields/%', 'admin/structure/taxonomy/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 57, 122, 976, 990, 0, 0, 0, 0),
('management', 991, 977, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 8, 48, 89, 977, 991, 0, 0, 0, 0),
('management', 992, 980, 'admin/config/media/newsletter/subscribers/display/default', 'admin/config/media/newsletter/subscribers/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 8, 46, 675, 680, 980, 992, 0, 0, 0),
('management', 993, 981, 'admin/config/media/newsletter/templates/display/default', 'admin/config/media/newsletter/templates/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 7, 0, 1, 8, 46, 675, 681, 981, 993, 0, 0, 0),
('management', 994, 982, 'admin/structure/types/manage/%/display/default', 'admin/structure/types/manage/%/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 36, 143, 982, 994, 0, 0, 0, 0),
('management', 995, 982, 'admin/structure/types/manage/%/display/full', 'admin/structure/types/manage/%/display/full', 'Full content', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 36, 143, 982, 995, 0, 0, 0, 0),
('management', 996, 982, 'admin/structure/types/manage/%/display/rss', 'admin/structure/types/manage/%/display/rss', 'RSS', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 2, 6, 0, 1, 21, 36, 143, 982, 996, 0, 0, 0, 0),
('management', 997, 982, 'admin/structure/types/manage/%/display/search_index', 'admin/structure/types/manage/%/display/search_index', 'Search index', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 3, 6, 0, 1, 21, 36, 143, 982, 997, 0, 0, 0, 0),
('management', 998, 982, 'admin/structure/types/manage/%/display/search_result', 'admin/structure/types/manage/%/display/search_result', 'Search result', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 4, 6, 0, 1, 21, 36, 143, 982, 998, 0, 0, 0, 0),
('management', 999, 982, 'admin/structure/types/manage/%/display/teaser', 'admin/structure/types/manage/%/display/teaser', 'Teaser', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 21, 36, 143, 982, 999, 0, 0, 0, 0),
('management', 1000, 982, 'admin/structure/types/manage/%/display/token', 'admin/structure/types/manage/%/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 5, 6, 0, 1, 21, 36, 143, 982, 1000, 0, 0, 0, 0),
('management', 1001, 983, 'admin/config/media/newsletter/subscribers/fields/%', 'admin/config/media/newsletter/subscribers/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 46, 675, 680, 983, 1001, 0, 0, 0),
('management', 1002, 984, 'admin/config/media/newsletter/templates/fields/%', 'admin/config/media/newsletter/templates/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 7, 0, 1, 8, 46, 675, 681, 984, 1002, 0, 0, 0),
('management', 1003, 985, 'admin/structure/types/manage/%/fields/%', 'admin/structure/types/manage/%/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 36, 143, 985, 1003, 0, 0, 0, 0),
('management', 1004, 990, 'admin/structure/taxonomy/%/fields/%/delete', 'admin/structure/taxonomy/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 57, 122, 976, 990, 1004, 0, 0, 0),
('management', 1005, 990, 'admin/structure/taxonomy/%/fields/%/edit', 'admin/structure/taxonomy/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 122, 976, 990, 1005, 0, 0, 0),
('management', 1006, 990, 'admin/structure/taxonomy/%/fields/%/field-settings', 'admin/structure/taxonomy/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 122, 976, 990, 1006, 0, 0, 0),
('management', 1007, 990, 'admin/structure/taxonomy/%/fields/%/widget-type', 'admin/structure/taxonomy/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 57, 122, 976, 990, 1007, 0, 0, 0),
('management', 1008, 991, 'admin/config/people/accounts/fields/%/delete', 'admin/config/people/accounts/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 8, 48, 89, 977, 991, 1008, 0, 0, 0),
('management', 1009, 991, 'admin/config/people/accounts/fields/%/edit', 'admin/config/people/accounts/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 89, 977, 991, 1009, 0, 0, 0),
('management', 1010, 991, 'admin/config/people/accounts/fields/%/field-settings', 'admin/config/people/accounts/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 89, 977, 991, 1010, 0, 0, 0),
('management', 1011, 991, 'admin/config/people/accounts/fields/%/widget-type', 'admin/config/people/accounts/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 8, 48, 89, 977, 991, 1011, 0, 0, 0),
('management', 1012, 194, 'admin/structure/types/manage/%/comment/display/default', 'admin/structure/types/manage/%/comment/display/default', 'Default', 0x613a303a7b7d, 'system', -1, 0, 0, 0, -10, 6, 0, 1, 21, 36, 143, 194, 1012, 0, 0, 0, 0),
('management', 1013, 194, 'admin/structure/types/manage/%/comment/display/full', 'admin/structure/types/manage/%/comment/display/full', 'Full comment', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 6, 0, 1, 21, 36, 143, 194, 1013, 0, 0, 0, 0),
('management', 1014, 194, 'admin/structure/types/manage/%/comment/display/token', 'admin/structure/types/manage/%/comment/display/token', 'Tokens', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 1, 6, 0, 1, 21, 36, 143, 194, 1014, 0, 0, 0, 0),
('management', 1015, 195, 'admin/structure/types/manage/%/comment/fields/%', 'admin/structure/types/manage/%/comment/fields/%', '', 0x613a303a7b7d, 'system', 0, 0, 0, 0, 0, 6, 0, 1, 21, 36, 143, 195, 1015, 0, 0, 0, 0),
('management', 1016, 1001, 'admin/config/media/newsletter/subscribers/fields/%/delete', 'admin/config/media/newsletter/subscribers/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 8, 46, 675, 680, 983, 1001, 1016, 0, 0),
('management', 1017, 1001, 'admin/config/media/newsletter/subscribers/fields/%/edit', 'admin/config/media/newsletter/subscribers/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 680, 983, 1001, 1017, 0, 0),
('management', 1018, 1001, 'admin/config/media/newsletter/subscribers/fields/%/field-settings', 'admin/config/media/newsletter/subscribers/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 680, 983, 1001, 1018, 0, 0),
('management', 1019, 1001, 'admin/config/media/newsletter/subscribers/fields/%/widget-type', 'admin/config/media/newsletter/subscribers/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 680, 983, 1001, 1019, 0, 0),
('management', 1020, 1002, 'admin/config/media/newsletter/templates/fields/%/delete', 'admin/config/media/newsletter/templates/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 8, 0, 1, 8, 46, 675, 681, 984, 1002, 1020, 0, 0),
('management', 1021, 1002, 'admin/config/media/newsletter/templates/fields/%/edit', 'admin/config/media/newsletter/templates/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 681, 984, 1002, 1021, 0, 0),
('management', 1022, 1002, 'admin/config/media/newsletter/templates/fields/%/field-settings', 'admin/config/media/newsletter/templates/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 681, 984, 1002, 1022, 0, 0),
('management', 1023, 1002, 'admin/config/media/newsletter/templates/fields/%/widget-type', 'admin/config/media/newsletter/templates/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 8, 0, 1, 8, 46, 675, 681, 984, 1002, 1023, 0, 0),
('management', 1024, 1003, 'admin/structure/types/manage/%/fields/%/delete', 'admin/structure/types/manage/%/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 36, 143, 985, 1003, 1024, 0, 0, 0),
('management', 1025, 1003, 'admin/structure/types/manage/%/fields/%/edit', 'admin/structure/types/manage/%/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 985, 1003, 1025, 0, 0, 0),
('management', 1026, 1003, 'admin/structure/types/manage/%/fields/%/field-settings', 'admin/structure/types/manage/%/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 985, 1003, 1026, 0, 0, 0),
('management', 1027, 1003, 'admin/structure/types/manage/%/fields/%/widget-type', 'admin/structure/types/manage/%/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 985, 1003, 1027, 0, 0, 0),
('management', 1028, 1015, 'admin/structure/types/manage/%/comment/fields/%/delete', 'admin/structure/types/manage/%/comment/fields/%/delete', 'Delete', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 10, 7, 0, 1, 21, 36, 143, 195, 1015, 1028, 0, 0, 0),
('management', 1029, 1015, 'admin/structure/types/manage/%/comment/fields/%/edit', 'admin/structure/types/manage/%/comment/fields/%/edit', 'Edit', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 195, 1015, 1029, 0, 0, 0),
('management', 1030, 1015, 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'admin/structure/types/manage/%/comment/fields/%/field-settings', 'Field settings', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 195, 1015, 1030, 0, 0, 0),
('management', 1031, 1015, 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'admin/structure/types/manage/%/comment/fields/%/widget-type', 'Widget type', 0x613a303a7b7d, 'system', -1, 0, 0, 0, 0, 7, 0, 1, 21, 36, 143, 195, 1015, 1031, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `menu_router`
--

CREATE TABLE IF NOT EXISTS `menu_router` (
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: the Drupal path this entry describes',
  `load_functions` blob NOT NULL COMMENT 'A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.',
  `to_arg_functions` blob NOT NULL COMMENT 'A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.',
  `access_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback which determines the access to this router path. Defaults to user_access.',
  `access_arguments` blob COMMENT 'A serialized array of arguments for the access callback.',
  `page_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that renders the page.',
  `page_arguments` blob COMMENT 'A serialized array of arguments for the page callback.',
  `delivery_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that sends the result of the page_callback function to the browser.',
  `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `context` int(11) NOT NULL DEFAULT '0' COMMENT 'Only for local tasks (tabs) - the context of a local task to control its placement.',
  `tab_parent` varchar(255) NOT NULL DEFAULT '' COMMENT 'Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).',
  `tab_root` varchar(255) NOT NULL DEFAULT '' COMMENT 'Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title for the current page, or the title for the tab if this is a local task.',
  `title_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which will alter the title. Defaults to t()',
  `title_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.',
  `theme_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which returns the name of the theme that will be used to render this page. If left empty, the default theme will be used.',
  `theme_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the theme callback.',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT 'Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.',
  `description` text NOT NULL COMMENT 'A description of this item.',
  `position` varchar(255) NOT NULL DEFAULT '' COMMENT 'The position of the block (left or right) on the system administration page for this item.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of the element. Lighter weights are higher up, heavier weights go down.',
  `include_file` mediumtext COMMENT 'The file to include for this element, usually the page callback function lives in this file.',
  PRIMARY KEY (`path`),
  KEY `fit` (`fit`),
  KEY `tab_parent` (`tab_parent`(64),`weight`,`title`),
  KEY `tab_root_weight_title` (`tab_root`(64),`weight`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps paths to various callbacks (access, page and title)';

--
-- Dumping data for table `menu_router`
--

INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 1, 1, 0, '', 'admin', 'Administration', 't', '', '', 'a:0:{}', 6, '', '', 9, 'modules/system/system.admin.inc'),
('admin/appearance', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/appearance', 'Appearance', 't', '', '', 'a:0:{}', 6, 'Select and configure your themes.', 'left', -6, 'modules/system/system.admin.inc'),
('admin/appearance/default', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_default', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/default', 'Set default theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/disable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_disable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/disable', 'Disable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/enable', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_theme_enable', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/appearance/enable', 'Enable theme', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Install new theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/appearance/list', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'system_themes_page', 0x613a303a7b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'List', 't', '', '', 'a:0:{}', 140, 'Select and configure your theme', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure default and theme specific settings.', '', 20, 'modules/system/system.admin.inc'),
('admin/appearance/settings/bartik', '', '', '_system_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32353a227468656d65732f62617274696b2f62617274696b2e696e666f223b733a343a226e616d65223b733a363a2262617274696b223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2231223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31383a7b733a343a226e616d65223b733a363a2242617274696b223b733a31313a226465736372697074696f6e223b733a34383a224120666c657869626c652c207265636f6c6f7261626c65207468656d652077697468206d616e7920726567696f6e732e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3234223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a333a7b733a31343a226373732f6c61796f75742e637373223b733a32383a227468656d65732f62617274696b2f6373732f6c61796f75742e637373223b733a31333a226373732f7374796c652e637373223b733a32373a227468656d65732f62617274696b2f6373732f7374796c652e637373223b733a31343a226373732f636f6c6f72732e637373223b733a32383a227468656d65732f62617274696b2f6373732f636f6c6f72732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a32373a227468656d65732f62617274696b2f6373732f7072696e742e637373223b7d7d733a373a22726567696f6e73223b613a32303a7b733a363a22686561646572223b733a363a22486561646572223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31313a22686967686c696768746564223b733a31313a22486967686c696768746564223b733a383a226665617475726564223b733a383a224665617475726564223b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a31333a22736964656261725f6669727374223b733a31333a2253696465626172206669727374223b733a31343a22736964656261725f7365636f6e64223b733a31343a2253696465626172207365636f6e64223b733a31343a2274726970747963685f6669727374223b733a31343a225472697074796368206669727374223b733a31353a2274726970747963685f6d6964646c65223b733a31353a225472697074796368206d6964646c65223b733a31333a2274726970747963685f6c617374223b733a31333a225472697074796368206c617374223b733a31383a22666f6f7465725f6669727374636f6c756d6e223b733a31393a22466f6f74657220666972737420636f6c756d6e223b733a31393a22666f6f7465725f7365636f6e64636f6c756d6e223b733a32303a22466f6f746572207365636f6e6420636f6c756d6e223b733a31383a22666f6f7465725f7468697264636f6c756d6e223b733a31393a22466f6f74657220746869726420636f6c756d6e223b733a31393a22666f6f7465725f666f75727468636f6c756d6e223b733a32303a22466f6f74657220666f7572746820636f6c756d6e223b733a363a22666f6f746572223b733a363a22466f6f746572223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a383a2273657474696e6773223b613a313a7b733a32303a2273686f72746375745f6d6f64756c655f6c696e6b223b733a313a2230223b7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231333834393833323430223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32383a227468656d65732f62617274696b2f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a353a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b693a333b733a373a22636f6e74656e74223b693a343b733a343a2268656c70223b7d733a31343a22726567696f6e735f68696464656e223b613a323a7b693a303b733a383a22706167655f746f70223b693a313b733a31313a22706167655f626f74746f6d223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a383a22706167655f746f70223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a333a7b733a31343a226373732f6c61796f75742e637373223b733a32383a227468656d65732f62617274696b2f6373732f6c61796f75742e637373223b733a31333a226373732f7374796c652e637373223b733a32373a227468656d65732f62617274696b2f6373732f7374796c652e637373223b733a31343a226373732f636f6c6f72732e637373223b733a32383a227468656d65732f62617274696b2f6373732f636f6c6f72732e637373223b7d733a353a227072696e74223b613a313a7b733a31333a226373732f7072696e742e637373223b733a32373a227468656d65732f62617274696b2f6373732f7072696e742e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a363a2262617274696b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Bartik', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/garland', '', '', '_system_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32373a227468656d65732f6761726c616e642f6761726c616e642e696e666f223b733a343a226e616d65223b733a373a226761726c616e64223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2230223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31383a7b733a343a226e616d65223b733a373a224761726c616e64223b733a31313a226465736372697074696f6e223b733a3131313a2241206d756c74692d636f6c756d6e207468656d652077686963682063616e20626520636f6e6669677572656420746f206d6f6469667920636f6c6f727320616e6420737769746368206265747765656e20666978656420616e6420666c756964207769647468206c61796f7574732e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3234223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a313a7b733a393a227374796c652e637373223b733a32343a227468656d65732f6761726c616e642f7374796c652e637373223b7d733a353a227072696e74223b613a313a7b733a393a227072696e742e637373223b733a32343a227468656d65732f6761726c616e642f7072696e742e637373223b7d7d733a383a2273657474696e6773223b613a313a7b733a31333a226761726c616e645f7769647468223b733a353a22666c756964223b7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231333834393833323430223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a373a22726567696f6e73223b613a31323a7b733a31333a22736964656261725f6669727374223b733a31323a224c6566742073696465626172223b733a31343a22736964656261725f7365636f6e64223b733a31333a2252696768742073696465626172223b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a363a22686561646572223b733a363a22486561646572223b733a363a22666f6f746572223b733a363a22466f6f746572223b733a31313a22686967686c696768746564223b733a31313a22486967686c696768746564223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32393a227468656d65732f6761726c616e642f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a353a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b693a333b733a373a22636f6e74656e74223b693a343b733a343a2268656c70223b7d733a31343a22726567696f6e735f68696464656e223b613a323a7b693a303b733a383a22706167655f746f70223b693a313b733a31313a22706167655f626f74746f6d223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a383a22706167655f746f70223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a323a7b733a333a22616c6c223b613a313a7b733a393a227374796c652e637373223b733a32343a227468656d65732f6761726c616e642f7374796c652e637373223b7d733a353a227072696e74223b613a313a7b733a393a227072696e742e637373223b733a32343a227468656d65732f6761726c616e642f7072696e742e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a373a226761726c616e64223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Garland', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/global', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e6973746572207468656d6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Global settings', 't', '', '', 'a:0:{}', 140, '', '', -1, 'modules/system/system.admin.inc'),
('admin/appearance/settings/nucleus', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a373a226e75636c657573223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'nucleus', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/nucleus_starter', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a31353a226e75636c6575735f73746172746572223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'nucleus_starter', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/seven', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22736576656e223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Seven', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/settings/stark', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a353a22737461726b223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Stark', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/appearance/settings/zircon', '', '', '_system_themes_access', 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, 'drupal_get_form', 0x613a323a7b693a303b733a32313a2273797374656d5f7468656d655f73657474696e6773223b693a313b733a363a227a6972636f6e223b7d, '', 15, 4, 1, 'admin/appearance/settings', 'admin/appearance', 'Zircon', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/system/system.admin.inc'),
('admin/appearance/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a353a227468656d65223b7d, '', 7, 3, 1, 'admin/appearance', 'admin/appearance', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/compact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_compact_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/compact', 'Compact mode', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_config_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/config', 'Configuration', 't', '', '', 'a:0:{}', 6, 'Administer settings.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/content', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/content', 'Content authoring', 't', '', '', 'a:0:{}', 6, 'Settings related to formatting and authoring content.', 'left', -15, 'modules/system/system.admin.inc'),
('admin/config/content/easy_social', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a22656173795f736f6369616c5f61646d696e5f636f6e6669675f6d61696e223b7d, '', 15, 4, 0, '', 'admin/config/content/easy_social', 'Easy Social Settings', 't', '', '', 'a:0:{}', 6, 'Configure the social buttons and node types', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/default', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a22656173795f736f6369616c5f61646d696e5f636f6e6669675f6d61696e223b7d, '', 31, 5, 1, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Settings', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/ignore-paths', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33373a22656173795f736f6369616c5f61646d696e5f636f6e6669675f69676e6f72655f7061746873223b7d, '', 31, 5, 1, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Ignore Paths', 't', '', '', 'a:0:{}', 132, 'Global paths to ignore and do not display Easy Social', '', 2, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/order', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32333a22656173795f736f6369616c5f61646d696e5f6f72646572223b7d, '', 31, 5, 1, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Widget Order', 't', '', '', 'a:0:{}', 132, 'Easy Social Widget Order', '', 1, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/summary', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a22656173795f736f6369616c5f61646d696e5f73756d6d617279223b7d, '', 31, 5, 1, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Summary', 't', '', '', 'a:0:{}', 132, 'Easy Social Summary', '', 4, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a22656173795f736f6369616c5f61646d696e5f636f6e6669675f6578747261223b7d, '', 31, 5, 1, 'admin/config/content/easy_social', 'admin/config/content/easy_social', 'Extra Widgets', 't', '', '', 'a:0:{}', 132, 'Extra settings for widgets', '', 3, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra/default', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a22656173795f736f6369616c5f61646d696e5f636f6e6669675f6578747261223b7d, '', 63, 6, 1, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social', 'Extra Widget Settings', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra/facebook', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33393a22656173795f736f6369616c5f61646d696e5f636f6e6669675f65787472615f66616365626f6f6b223b7d, '', 63, 6, 1, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social', 'Facebook', 't', '', '', 'a:0:{}', 132, 'Extra settings for Facebook', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra/googleplus', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a34313a22656173795f736f6369616c5f61646d696e5f636f6e6669675f65787472615f676f6f676c65706c7573223b7d, '', 63, 6, 1, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social', 'Google+', 't', '', '', 'a:0:{}', 132, 'Extra settings for Google+', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra/linkedin', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33393a22656173795f736f6369616c5f61646d696e5f636f6e6669675f65787472615f6c696e6b6564696e223b7d, '', 63, 6, 1, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social', 'LinkedIn', 't', '', '', 'a:0:{}', 132, 'Extra settings for LinkedIn', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social/widget-extra/twitter', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206561737920736f6369616c223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33383a22656173795f736f6369616c5f61646d696e5f636f6e6669675f65787472615f74776974746572223b7d, '', 63, 6, 1, 'admin/config/content/easy_social/widget-extra', 'admin/config/content/easy_social', 'Twitter', 't', '', '', 'a:0:{}', 132, 'Extra settings for Twitter', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/easy_social_wizard', '', '', 'user_access', 0x613a313a7b693a303b733a32323a22757365206561737920736f6369616c2077697a617264223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22656173795f736f6369616c5f61646d696e5f77697a617264223b7d, '', 15, 4, 0, '', 'admin/config/content/easy_social_wizard', 'Easy Social Wizard', 't', '', '', 'a:0:{}', 6, 'Quickly enable Easy Social for your Content Types', '', 0, 'sites/all/modules/easy_social/includes/easy_social.admin.inc'),
('admin/config/content/formats', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 15, 4, 0, '', 'admin/config/content/formats', 'Text formats', 't', '', '', 'a:0:{}', 6, 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a313a7b693a303b693a343b7d, '', 30, 5, 0, '', 'admin/config/content/formats/%', '', 'filter_admin_format_title', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/%/disable', 0x613a313a7b693a343b733a31383a2266696c7465725f666f726d61745f6c6f6164223b7d, '', '_filter_disable_format_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2266696c7465725f61646d696e5f64697361626c65223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/content/formats/%/disable', 'Disable text format', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'filter_admin_format_page', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'Add text format', 't', '', '', 'a:0:{}', 388, '', '', 1, 'modules/filter/filter.admin.inc'),
('admin/config/content/formats/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2266696c7465725f61646d696e5f6f76657276696577223b7d, '', 31, 5, 1, 'admin/config/content/formats', 'admin/config/content/formats', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/filter/filter.admin.inc'),
('admin/config/content/wysiwyg', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22777973697779675f70726f66696c655f6f76657276696577223b7d, '', 15, 4, 0, '', 'admin/config/content/wysiwyg', 'Wysiwyg profiles', 't', '', '', 'a:0:{}', 6, 'Configure client-side editors.', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22777973697779675f70726f66696c655f6f76657276696577223b7d, '', 31, 5, 1, 'admin/config/content/wysiwyg', 'admin/config/content/wysiwyg', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile/%/delete', 0x613a313a7b693a353b733a32303a22777973697779675f70726f66696c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22777973697779675f70726f66696c655f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/content/wysiwyg/profile/%wysiwyg_profile', 'admin/config/content/wysiwyg/profile', 'Remove', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/content/wysiwyg/profile/%/edit', 0x613a313a7b693a353b733a32303a22777973697779675f70726f66696c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e69737465722066696c74657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a22777973697779675f70726f66696c655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/content/wysiwyg/profile/%wysiwyg_profile', 'admin/config/content/wysiwyg/profile', 'Edit', 't', '', '', 'a:0:{}', 132, '', '', 0, 'sites/all/modules/wysiwyg/wysiwyg.admin.inc'),
('admin/config/development', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/development', 'Development', 't', '', '', 'a:0:{}', 6, 'Development tools.', 'right', -10, 'modules/system/system.admin.inc'),
('admin/config/development/jquery_update', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a226a71756572795f7570646174655f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/development/jquery_update', 'jQuery update', 't', '', '', 'a:0:{}', 6, 'Configure settings related to the jQuery upgrade, the library path and compression.', '', 0, ''),
('admin/config/development/logging', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32333a2273797374656d5f6c6f6767696e675f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/logging', 'Logging and errors', 't', '', '', 'a:0:{}', 6, 'Settings for logging and alerts modules. Various modules can route Drupal''s system events to different destinations, such as syslog, database, email, etc.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/development/maintenance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a2273797374656d5f736974655f6d61696e74656e616e63655f6d6f6465223b7d, '', 15, 4, 0, '', 'admin/config/development/maintenance', 'Maintenance mode', 't', '', '', 'a:0:{}', 6, 'Take the site offline for maintenance or bring it back online.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/development/performance', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f706572666f726d616e63655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/development/performance', 'Performance', 't', '', '', 'a:0:{}', 6, 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/media', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/media', 'Media', 't', '', '', 'a:0:{}', 6, 'Media tools.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/media/file-system', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32373a2273797374656d5f66696c655f73797374656d5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/file-system', 'File system', 't', '', '', 'a:0:{}', 6, 'Tell Drupal where to store uploaded files and how they are accessed.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/media/image-styles', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/media/image-styles', 'Image styles', 't', '', '', 'a:0:{}', 6, 'Configure styles that can be used for resizing or adjusting images on display.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/add', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22696d6167655f7374796c655f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'Add style', 't', '', '', 'a:0:{}', 388, 'Add a new image style.', '', 2, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/delete/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2231223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/delete/%', 'Delete style', 't', '', '', 'a:0:{}', 6, 'Delete an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%', 0x613a313a7b693a353b733a31363a22696d6167655f7374796c655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31363a22696d6167655f7374796c655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/edit/%', 'Edit style', 't', '', '', 'a:0:{}', 6, 'Configure an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/add/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a313a7b693a303b693a353b7d7d693a373b613a313a7b733a32383a22696d6167655f6566666563745f646566696e6974696f6e5f6c6f6164223b613a313a7b693a303b693a353b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/add/%', 'Add image effect', 't', '', '', 'a:0:{}', 6, 'Add a new effect to a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a31373a22696d6167655f6566666563745f666f726d223b693a313b693a353b693a323b693a373b7d, '', 250, 8, 0, '', 'admin/config/media/image-styles/edit/%/effects/%', 'Edit image effect', 't', '', '', 'a:0:{}', 6, 'Edit an existing effect within a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/edit/%/effects/%/delete', 0x613a323a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d693a373b613a313a7b733a31373a22696d6167655f6566666563745f6c6f6164223b613a323a7b693a303b693a353b693a313b733a313a2233223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32343a22696d6167655f6566666563745f64656c6574655f666f726d223b693a313b693a353b693a323b693a373b7d, '', 501, 9, 0, '', 'admin/config/media/image-styles/edit/%/effects/%/delete', 'Delete image effect', 't', '', '', 'a:0:{}', 6, 'Delete an existing effect from a style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/list', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'image_style_list', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/media/image-styles', 'admin/config/media/image-styles', 'List', 't', '', '', 'a:0:{}', 140, 'List the current image styles on the site.', '', 1, 'modules/image/image.admin.inc'),
('admin/config/media/image-styles/revert/%', 0x613a313a7b693a353b613a313a7b733a31363a22696d6167655f7374796c655f6c6f6164223b613a323a7b693a303b4e3b693a313b733a313a2232223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220696d616765207374796c6573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32333a22696d6167655f7374796c655f7265766572745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/media/image-styles/revert/%', 'Revert style', 't', '', '', 'a:0:{}', 6, 'Revert an image style.', '', 0, 'modules/image/image.admin.inc'),
('admin/config/media/image-toolkit', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32393a2273797374656d5f696d6167655f746f6f6c6b69745f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/image-toolkit', 'Image toolkit', 't', '', '', 'a:0:{}', 6, 'Choose which image toolkit to use if you have installed optional toolkits.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/media/newsletter', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a226e6577736c65747465725f7374617473223b7d, '', 15, 4, 0, '', 'admin/config/media/newsletter', 'Newsletters', 't', '', '', 'a:0:{}', 6, 'Manage newsletters, subscribers, and settings.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/archive', '', '', 'views_access', 0x613a313a7b693a303b613a323a7b693a303b733a31363a2276696577735f636865636b5f7065726d223b693a313b613a313a7b693a303b733a32383a22616363657373206e6577736c65747465722073746174697374696373223b7d7d7d, 'views_page', 0x613a323a7b693a303b733a31383a226e6577736c65747465725f61726368697665223b693a313b733a343a2270616765223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Issue archive', 't', '', '', 'a:0:{}', 132, '', '', 1, ''),
('admin/config/media/newsletter/configure', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a226e6577736c65747465725f636f6e666967757265223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure newsletter lists.', '', 5, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/create-send', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_draft_manual_list', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Create/Send', 't', '', '', 'a:0:{}', 132, 'Create custom static newsletters and send non-automated ones', '', 1, 'sites/all/modules/newsletter/includes/newsletter.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/config/media/newsletter/create-send/draft/%', 0x613a313a7b693a363b733a32363a226e6577736c65747465725f6e6577736c65747465725f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226e6577736c65747465725f666f726d5f73656e645f6472616674223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/create-send/draft/%', 'Send a newsletter draft', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/create-send/draft/delete/%', 0x613a313a7b693a373b733a32363a226e6577736c65747465725f6e6577736c65747465725f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226e6577736c65747465725f666f726d5f64656c6574655f6472616674223b693a313b693a373b7d, '', 254, 8, 0, '', 'admin/config/media/newsletter/create-send/draft/delete/%', 'Delete a newsletter draft', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/create-send/new', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a226e6577736c65747465725f6372656174655f73656e64223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/create-send', 'admin/config/media/newsletter', 'Create and send a custom newsletter', 't', '', '', 'a:0:{}', 388, 'Create a custom static newsletter', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/create-send/newsletter/delete/%', 0x613a313a7b693a373b733a32363a226e6577736c65747465725f6e6577736c65747465725f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33333a226e6577736c65747465725f666f726d5f64656c6574655f6e6577736c6574746572223b693a313b693a373b7d, '', 254, 8, 0, '', 'admin/config/media/newsletter/create-send/newsletter/delete/%', 'Delete a newsletter draft', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/create-send/send/%', 0x613a313a7b693a363b733a32303a226e6577736c65747465725f6c6973745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_manual_send', 0x613a313a7b693a303b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/create-send/send/%', 'Send a manual newsletter', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/lists', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31353a226e6577736c65747465725f6c697374223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Lists', 't', '', '', 'a:0:{}', 132, 'Find and manage newsletter lists.', '', 2, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/lists/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_list_add', 0x613a303a7b7d, '', 63, 6, 1, 'admin/config/media/newsletter/lists', 'admin/config/media/newsletter', 'Add new list', 't', '', '', 'a:0:{}', 388, 'Add new newsletter list.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/lists/delete/%', 0x613a313a7b693a363b733a32303a226e6577736c65747465725f6c6973745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a226e6577736c65747465725f6c6973745f64656c657465223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/lists/delete/%', 'Delete newsletter list', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/lists/edit/%', 0x613a313a7b693a363b733a32303a226e6577736c65747465725f6c6973745f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a226e6577736c65747465725f6c6973745f65646974223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/lists/edit/%', 'Edit newsletter list', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/stats', '', '', 'user_access', 0x613a313a7b693a303b733a32383a22616363657373206e6577736c65747465722073746174697374696373223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a226e6577736c65747465725f7374617473223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Statistics', 't', '', '', 'a:0:{}', 140, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/stats/general', '', '', 'user_access', 0x613a313a7b693a303b733a32383a22616363657373206e6577736c65747465722073746174697374696373223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a226e6577736c65747465725f7374617473223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/stats', 'admin/config/media/newsletter', 'General', 't', '', '', 'a:0:{}', 140, 'Watch general statistics.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/stats/graphic', '', '', 'user_access', 0x613a313a7b693a303b733a32383a22616363657373206e6577736c65747465722073746174697374696373223b7d, 'newsletter_stats_graphic', 0x613a303a7b7d, '', 63, 6, 1, 'admin/config/media/newsletter/stats', 'admin/config/media/newsletter', 'Graphic', 't', '', '', 'a:0:{}', 132, 'Watch advanced JQuery statistics.', '', 1, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a226e6577736c65747465725f737562736372696265725f6c697374223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Subscribers', 't', '', '', 'a:0:{}', 132, 'List subscribers.', '', 3, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_subscriber_add', 0x613a303a7b7d, '', 63, 6, 1, 'admin/config/media/newsletter/subscribers', 'admin/config/media/newsletter', 'Add new subscriber', 't', '', '', 'a:0:{}', 388, 'Add new list subscriber.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers/add-mass', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226e6577736c65747465725f737562736372696265725f6164645f6d617373223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/subscribers', 'admin/config/media/newsletter', 'Add subscribers (Mass)', 't', '', '', 'a:0:{}', 388, 'Add subscribers.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers/delete/%', 0x613a313a7b693a363b733a32363a226e6577736c65747465725f737562736372696265725f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226e6577736c65747465725f737562736372696265725f64656c657465223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/subscribers/delete/%', 'Delete subscriber', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers/display', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a32313a226e6577736c65747465725f73756273637269626572223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/subscribers', 'admin/config/media/newsletter', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a32313a226e6577736c65747465725f73756273637269626572223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/config/media/newsletter/subscribers/display', 'admin/config/media/newsletter', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/edit/%', 0x613a313a7b693a363b733a32363a226e6577736c65747465725f737562736372696265725f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226e6577736c65747465725f737562736372696265725f65646974223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/subscribers/edit/%', 'Edit newsletter subscriber', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/subscribers/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a32313a226e6577736c65747465725f73756273637269626572223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/subscribers', 'admin/config/media/newsletter', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/subscribers/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/subscribers/fields/%', 'admin/config/media/newsletter/subscribers/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/subscribers/fields/%', 'admin/config/media/newsletter/subscribers/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/subscribers/fields/%', 'admin/config/media/newsletter/subscribers/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/subscribers/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a32313a226e6577736c65747465725f73756273637269626572223b693a313b733a32313a226e6577736c65747465725f73756273637269626572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/subscribers/fields/%', 'admin/config/media/newsletter/subscribers/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a226e6577736c65747465725f74656d706c6174655f6c697374223b7d, '', 31, 5, 1, 'admin/config/media/newsletter', 'admin/config/media/newsletter', 'Templates', 't', '', '', 'a:0:{}', 132, 'Administer newsletter templates.', '', 4, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/confirmation', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_basic_template_edit', 0x613a313a7b693a303b733a313a2231223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Confirmation', 't', '', '', 'a:0:{}', 132, 'Edit confirmation template.', '', -9, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/delete/%', 0x613a313a7b693a363b733a32343a226e6577736c65747465725f74656d706c6174655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226e6577736c65747465725f74656d706c6174655f64656c657465223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/templates/delete/%', 'Delete newsletter templates', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/display', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a31393a226e6577736c65747465725f74656d706c617465223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a31393a226e6577736c65747465725f74656d706c617465223b693a333b733a373a2264656661756c74223b7d, '', 127, 7, 1, 'admin/config/media/newsletter/templates/display', 'admin/config/media/newsletter', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/edit/%', 0x613a313a7b693a363b733a32343a226e6577736c65747465725f74656d706c6174655f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226e6577736c65747465725f74656d706c6174655f65646974223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/templates/edit/%', 'Edit newsletter templates', 't', '', '', 'a:0:{}', 0, '', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a31393a226e6577736c65747465725f74656d706c617465223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/fields/%', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/media/newsletter/templates/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:6;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/fields/%/delete', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/templates/fields/%', 'admin/config/media/newsletter/templates/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/fields/%/edit', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/templates/fields/%', 'admin/config/media/newsletter/templates/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/fields/%/field-settings', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/templates/fields/%', 'admin/config/media/newsletter/templates/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/fields/%/widget-type', 0x613a313a7b693a363b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a31393a226e6577736c65747465725f74656d706c617465223b693a313b733a31393a226e6577736c65747465725f74656d706c617465223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a363b7d, '', 253, 8, 1, 'admin/config/media/newsletter/templates/fields/%', 'admin/config/media/newsletter/templates/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/media/newsletter/templates/mail', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a226e6577736c65747465725f74656d706c6174655f6c697374223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Mail templates', 't', '', '', 'a:0:{}', 140, 'Administer mail templates.', '', -10, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/mail/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_template_add', 0x613a303a7b7d, '', 127, 7, 1, 'admin/config/media/newsletter/templates/mail', 'admin/config/media/newsletter', 'Add new mail template', 't', '', '', 'a:0:{}', 388, 'Administer mail templates.', '', 0, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/unsubscribe', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_basic_template_edit', 0x613a313a7b693a303b733a313a2233223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Unsubscribe', 't', '', '', 'a:0:{}', 132, 'Edit unsubscribe template.', '', -7, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/newsletter/templates/welcome', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572206e6577736c657474657273223b7d, 'newsletter_basic_template_edit', 0x613a313a7b693a303b733a313a2232223b7d, '', 63, 6, 1, 'admin/config/media/newsletter/templates', 'admin/config/media/newsletter', 'Welcome', 't', '', '', 'a:0:{}', 132, 'Edit welcome template.', '', -8, 'sites/all/modules/newsletter/includes/newsletter.admin.inc'),
('admin/config/media/socialmedia', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a22736f6369616c6d656469615f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/media/socialmedia', 'Social media', 't', '', '', 'a:0:{}', 6, 'Social media defaults and site profile settings', '', 0, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/media/socialmedia/profiles', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33313a22736f6369616c6d656469615f61646d696e5f70726f66696c65735f666f726d223b7d, '', 31, 5, 1, 'admin/config/media/socialmedia', 'admin/config/media/socialmedia', 'Profiles', 't', '', '', 'a:0:{}', 132, 'Social media profile configuration', '', 1, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/media/socialmedia/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32363a22736f6369616c6d656469615f61646d696e5f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/media/socialmedia', 'admin/config/media/socialmedia', 'Settings', 't', '', '', 'a:0:{}', 140, 'Social media defaults and site profile settings', '', 0, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/media/socialmedia/setup', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'socialmedia_admin_setup', 0x613a313a7b693a303b693a353b7d, '', 31, 5, 1, 'admin/config/media/socialmedia', 'admin/config/media/socialmedia', 'Setup wizard', 't', '', '', 'a:0:{}', 388, 'Setup wizard to help you get started quickly.', '', 2, 'sites/all/modules/socialmedia/socialmedia.setup.inc'),
('admin/config/media/socialmedia/widgets', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33383a22736f6369616c6d656469615f61646d696e5f70726f66696c655f776964676574735f666f726d223b7d, '', 31, 5, 1, 'admin/config/media/socialmedia', 'admin/config/media/socialmedia', 'Widgets', 't', '', '', 'a:0:{}', 132, 'Social media widget sets configuration', '', 3, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/media/socialmedia/widgets/profile', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33383a22736f6369616c6d656469615f61646d696e5f70726f66696c655f776964676574735f666f726d223b7d, '', 63, 6, 1, 'admin/config/media/socialmedia/widgets', 'admin/config/media/socialmedia', 'Default profile set', 't', '', '', 'a:0:{}', 140, 'Social media default profile widget sets configuration', '', 0, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/media/socialmedia/widgets/share', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261646d696e697374657220736f6369616c206d65646961223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33363a22736f6369616c6d656469615f61646d696e5f73686172655f776964676574735f666f726d223b7d, '', 63, 6, 1, 'admin/config/media/socialmedia/widgets', 'admin/config/media/socialmedia', 'Default share set', 't', '', '', 'a:0:{}', 132, 'Social media default profile widget sets configuration', '', 0, 'sites/all/modules/socialmedia/socialmedia.admin.inc'),
('admin/config/people', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/people', 'People', 't', '', '', 'a:0:{}', 6, 'Configure user accounts.', 'left', -20, 'modules/system/system.admin.inc'),
('admin/config/people/accounts', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/people/accounts', 'Account settings', 't', '', '', 'a:0:{}', 6, 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/accounts/display', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage display', 't', '', '', 'a:0:{}', 132, '', '', 2, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/default', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a373a2264656661756c74223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a373a2264656661756c74223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'Default', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/full', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a343a2266756c6c223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a343a2266756c6c223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'User account', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/display/token', '', '', '_field_ui_view_mode_menu_access', 0x613a353a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a353a22746f6b656e223b693a333b733a31313a22757365725f616363657373223b693a343b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a343a7b693a303b733a33303a226669656c645f75695f646973706c61795f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b693a333b733a353a22746f6b656e223b7d, '', 63, 6, 1, 'admin/config/people/accounts/display', 'admin/config/people/accounts', 'Tokens', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a333a7b693a303b733a32383a226669656c645f75695f6669656c645f6f766572766965775f666f726d223b693a313b733a343a2275736572223b693a323b733a343a2275736572223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Manage fields', 't', '', '', 'a:0:{}', 132, '', '', 1, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/accounts/fields/%', '', 'field_ui_menu_title', 'a:1:{i:0;i:5;}', '', 'a:0:{}', 6, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/delete', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a226669656c645f75695f6669656c645f64656c6574655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Delete', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/edit', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a226669656c645f75695f6669656c645f656469745f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Edit', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/field-settings', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a226669656c645f75695f6669656c645f73657474696e67735f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Field settings', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/fields/%/widget-type', 0x613a313a7b693a353b613a313a7b733a31383a226669656c645f75695f6d656e755f6c6f6164223b613a343a7b693a303b733a343a2275736572223b693a313b733a343a2275736572223b693a323b733a313a2230223b693a333b733a343a22256d6170223b7d7d7d, '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a226669656c645f75695f7769646765745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 1, 'admin/config/people/accounts/fields/%', 'admin/config/people/accounts/fields/%', 'Widget type', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/config/people/accounts/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31393a22757365725f61646d696e5f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/people/accounts', 'admin/config/people/accounts', 'Settings', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/user/user.admin.inc'),
('admin/config/people/ip-blocking', '', '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'system_ip_blocking', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/people/ip-blocking', 'IP address blocking', 't', '', '', 'a:0:{}', 6, 'Manage blocked IP addresses.', '', 10, 'modules/system/system.admin.inc'),
('admin/config/people/ip-blocking/delete/%', 0x613a313a7b693a353b733a31353a22626c6f636b65645f69705f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a22626c6f636b20495020616464726573736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a2273797374656d5f69705f626c6f636b696e675f64656c657465223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/people/ip-blocking/delete/%', 'Delete IP address', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/regional', 'Regional and language', 't', '', '', 'a:0:{}', 6, 'Regional settings, localization and translation.', 'left', -5, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/date-time', 'Date and time', 't', '', '', 'a:0:{}', 6, 'Configure display formats for date and time.', '', -15, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_formats', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Formats', 't', '', '', 'a:0:{}', 132, 'Configure display format strings for date and time.', '', -9, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a2273797374656d5f646174655f64656c6574655f666f726d61745f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/delete', 'Delete date format', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/%/edit', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/formats/%/edit', 'Edit date format', 't', '', '', 'a:0:{}', 6, 'Allow users to edit a configured date format.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33343a2273797374656d5f636f6e6669677572655f646174655f666f726d6174735f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/formats', 'admin/config/regional/date-time', 'Add format', 't', '', '', 'a:0:{}', 388, 'Allow users to add additional date formats.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/formats/lookup', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_date_time_lookup', 0x613a303a7b7d, '', 63, 6, 0, '', 'admin/config/regional/date-time/formats/lookup', 'Date and time lookup', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f646174655f74696d655f73657474696e6773223b7d, '', 31, 5, 1, 'admin/config/regional/date-time', 'admin/config/regional/date-time', 'Types', 't', '', '', 'a:0:{}', 140, 'Configure display formats for date and time.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/%/delete', 0x613a313a7b693a353b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33353a2273797374656d5f64656c6574655f646174655f666f726d61745f747970655f666f726d223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/regional/date-time/types/%/delete', 'Delete date type', 't', '', '', 'a:0:{}', 6, 'Allow users to delete a configured date type.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/regional/date-time/types/add', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f6164645f646174655f666f726d61745f747970655f666f726d223b7d, '', 63, 6, 1, 'admin/config/regional/date-time/types', 'admin/config/regional/date-time', 'Add date type', 't', '', '', 'a:0:{}', 388, 'Add new date type.', '', -10, 'modules/system/system.admin.inc'),
('admin/config/regional/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f726567696f6e616c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/regional/settings', 'Regional settings', 't', '', '', 'a:0:{}', 6, 'Settings for the site''s default time zone and country.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/search', 'Search and metadata', 't', '', '', 'a:0:{}', 6, 'Local site search, metadata and SEO.', 'left', -10, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f636c65616e5f75726c5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/clean-urls', 'Clean URLs', 't', '', '', 'a:0:{}', 6, 'Enable or disable clean URLs for your site.', '', 5, 'modules/system/system.admin.inc'),
('admin/config/search/clean-urls/check', '', '', '1', 0x613a303a7b7d, 'drupal_json_output', 0x613a313a7b693a303b613a313a7b733a363a22737461747573223b623a313b7d7d, '', 31, 5, 0, '', 'admin/config/search/clean-urls/check', 'Clean URL check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/search/path', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/search/path', 'URL aliases', 't', '', '', 'a:0:{}', 6, 'Change your site''s URL paths by aliasing them.', '', -5, 'modules/path/path.admin.inc'),
('admin/config/search/path/add', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Add alias', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/delete/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32353a22706174685f61646d696e5f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/delete/%', 'Delete alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/delete_bulk', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a22706174686175746f5f61646d696e5f64656c657465223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Delete aliases', 't', '', '', 'a:0:{}', 132, '', '', 40, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/edit/%', 0x613a313a7b693a353b733a393a22706174685f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_edit', 0x613a313a7b693a303b693a353b7d, '', 62, 6, 0, '', 'admin/config/search/path/edit/%', 'Edit alias', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/path/path.admin.inc'),
('admin/config/search/path/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'path_admin_overview', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/path/path.admin.inc'),
('admin/config/search/path/patterns', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220706174686175746f223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22706174686175746f5f7061747465726e735f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Patterns', 't', '', '', 'a:0:{}', 132, '', '', 10, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220706174686175746f223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22706174686175746f5f73657474696e67735f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 20, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/path/update_bulk', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e69737465722075726c20616c6961736573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a22706174686175746f5f62756c6b5f7570646174655f666f726d223b7d, '', 31, 5, 1, 'admin/config/search/path', 'admin/config/search/path', 'Bulk update', 't', '', '', 'a:0:{}', 132, '', '', 30, 'sites/all/modules/pathauto/pathauto.admin.inc'),
('admin/config/search/settings', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a227365617263685f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/search/settings', 'Search settings', 't', '', '', 'a:0:{}', 6, 'Configure relevance settings for search and other indexing options.', '', -10, 'modules/search/search.admin.inc'),
('admin/config/search/settings/reindex', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220736561726368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a227365617263685f7265696e6465785f636f6e6669726d223b7d, '', 31, 5, 0, '', 'admin/config/search/settings/reindex', 'Clear index', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/search/search.admin.inc'),
('admin/config/search/sitemap', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32383a22736974655f6d61705f61646d696e5f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/search/sitemap', 'Site map', 't', '', '', 'a:0:{}', 6, 'Control what should be displayed on the site map.', '', 0, 'sites/all/modules/site_map/site_map.admin.inc'),
('admin/config/services', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/services', 'Web services', 't', '', '', 'a:0:{}', 6, 'Tools related to web services.', 'right', 0, 'modules/system/system.admin.inc'),
('admin/config/services/aggregator', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'aggregator_admin_overview', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/services/aggregator', 'Feed aggregator', 't', '', '', 'a:0:{}', 6, 'Configure which content your site aggregates from other sites, how often it polls them, and how they''re categorized.', '', 10, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/add/category', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2261676772656761746f725f666f726d5f63617465676f7279223b7d, '', 63, 6, 1, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'Add category', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/add/feed', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2261676772656761746f725f666f726d5f66656564223b7d, '', 63, 6, 1, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'Add feed', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/aggregator/aggregator.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/config/services/aggregator/add/opml', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2261676772656761746f725f666f726d5f6f706d6c223b7d, '', 63, 6, 1, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'Import OPML', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/edit/category/%', 0x613a313a7b693a363b733a32343a2261676772656761746f725f63617465676f72795f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a2261676772656761746f725f666f726d5f63617465676f7279223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/services/aggregator/edit/category/%', 'Edit category', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/edit/feed/%', 0x613a313a7b693a363b733a32303a2261676772656761746f725f666565645f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2261676772656761746f725f666f726d5f66656564223b693a313b693a363b7d, '', 126, 7, 0, '', 'admin/config/services/aggregator/edit/feed/%', 'Edit feed', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/list', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'aggregator_admin_overview', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/remove/%', 0x613a313a7b693a353b733a32303a2261676772656761746f725f666565645f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32383a2261676772656761746f725f61646d696e5f72656d6f76655f66656564223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/services/aggregator/remove/%', 'Remove items', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2261676772656761746f725f61646d696e5f666f726d223b7d, '', 31, 5, 1, 'admin/config/services/aggregator', 'admin/config/services/aggregator', 'Settings', 't', '', '', 'a:0:{}', 132, 'Configure the behavior of the feed aggregator, including when to discard feed items and how to present feed items and categories.', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/aggregator/update/%', 0x613a313a7b693a353b733a32303a2261676772656761746f725f666565645f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e6973746572206e657773206665656473223b7d, 'aggregator_admin_refresh_feed', 0x613a313a7b693a303b693a353b7d, '', 62, 6, 0, '', 'admin/config/services/aggregator/update/%', 'Update items', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/aggregator/aggregator.admin.inc'),
('admin/config/services/rss-publishing', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32353a2273797374656d5f7273735f66656564735f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/services/rss-publishing', 'RSS publishing', 't', '', '', 'a:0:{}', 6, 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/system', 'System', 't', '', '', 'a:0:{}', 6, 'General system related configuration.', 'right', -20, 'modules/system/system.admin.inc'),
('admin/config/system/actions', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/system/actions', 'Actions', 't', '', '', 'a:0:{}', 6, 'Manage the actions defined for your site.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f616374696f6e735f636f6e666967757265223b7d, '', 31, 5, 0, '', 'admin/config/system/actions/configure', 'Configure an advanced action', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/delete/%', 0x613a313a7b693a353b733a31323a22616374696f6e735f6c6f6164223b7d, '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a2273797374656d5f616374696f6e735f64656c6574655f666f726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/system/actions/delete/%', 'Delete action', 't', '', '', 'a:0:{}', 6, 'Delete an action.', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/actions/manage', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_manage', 0x613a303a7b7d, '', 31, 5, 1, 'admin/config/system/actions', 'admin/config/system/actions', 'Manage actions', 't', '', '', 'a:0:{}', 140, 'Manage the actions defined for your site.', '', -2, 'modules/system/system.admin.inc'),
('admin/config/system/actions/orphan', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e697374657220616374696f6e73223b7d, 'system_actions_remove_orphans', 0x613a303a7b7d, '', 31, 5, 0, '', 'admin/config/system/actions/orphan', 'Remove orphans', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/config/system/cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a2273797374656d5f63726f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/cron', 'Cron', 't', '', '', 'a:0:{}', 6, 'Manage automatic site maintenance tasks.', '', 20, 'modules/system/system.admin.inc'),
('admin/config/system/site-information', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33323a2273797374656d5f736974655f696e666f726d6174696f6e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/system/site-information', 'Site information', 't', '', '', 'a:0:{}', 6, 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.', '', -20, 'modules/system/system.admin.inc'),
('admin/config/system/statistics', '', '', 'user_access', 0x613a313a7b693a303b733a32313a2261646d696e69737465722073746174697374696373223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a22737461746973746963735f73657474696e67735f666f726d223b7d, '', 15, 4, 0, '', 'admin/config/system/statistics', 'Statistics', 't', '', '', 'a:0:{}', 6, 'Control details about what and how your site logs access statistics.', '', -15, 'modules/statistics/statistics.admin.inc'),
('admin/config/user-interface', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/user-interface', 'User interface', 't', '', '', 'a:0:{}', 6, 'Tools that enhance the user interface.', 'right', -15, 'modules/system/system.admin.inc'),
('admin/config/user-interface/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'shortcut_set_admin', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/config/user-interface/shortcut', 'Shortcuts', 't', '', '', 'a:0:{}', 6, 'Add and modify shortcut sets.', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 30, 5, 0, '', 'admin/config/user-interface/shortcut/%', 'Edit shortcuts', 'shortcut_set_title_callback', 'a:1:{i:0;i:4;}', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31373a2273686f72746375745f6c696e6b5f616464223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Add shortcut', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/add-link-inline', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'shortcut_link_add_inline', 0x613a313a7b693a303b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/add-link-inline', 'Add shortcut', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/delete', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_delete_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32343a2273686f72746375745f7365745f64656c6574655f666f726d223b693a313b693a343b7d, '', 61, 6, 0, '', 'admin/config/user-interface/shortcut/%/delete', 'Delete shortcut set', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/edit', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f656469745f666f726d223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'Edit set name', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/%/links', 0x613a313a7b693a343b733a31373a2273686f72746375745f7365745f6c6f6164223b7d, '', 'shortcut_set_edit_access', 0x613a313a7b693a303b693a343b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32323a2273686f72746375745f7365745f637573746f6d697a65223b693a313b693a343b7d, '', 61, 6, 1, 'admin/config/user-interface/shortcut/%', 'admin/config/user-interface/shortcut/%', 'List links', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/add-set', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e69737465722073686f727463757473223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32313a2273686f72746375745f7365745f6164645f666f726d223b7d, '', 31, 5, 1, 'admin/config/user-interface/shortcut', 'admin/config/user-interface/shortcut', 'Add shortcut set', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31383a2273686f72746375745f6c696e6b5f65646974223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/config/user-interface/shortcut/link/%', 'Edit shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/shortcut/link/%/delete', 0x613a313a7b693a353b733a31343a226d656e755f6c696e6b5f6c6f6164223b7d, '', 'shortcut_link_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32303a2273686f72746375745f6c696e6b5f64656c657465223b693a313b693a353b7d, '', 125, 7, 0, '', 'admin/config/user-interface/shortcut/link/%/delete', 'Delete shortcut', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/shortcut/shortcut.admin.inc'),
('admin/config/user-interface/superfish', '', '', 'user_access', 0x613a313a7b693a303b733a32303a2261646d696e697374657220737570657266697368223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a227375706572666973685f61646d696e5f73657474696e6773223b7d, '', 15, 4, 0, '', 'admin/config/user-interface/superfish', 'Superfish', 't', '', '', 'a:0:{}', 6, 'Configure Superfish Menus', '', 0, 'sites/all/modules/superfish/superfish.admin.inc'),
('admin/config/workflow', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/config/workflow', 'Workflow', 't', '', '', 'a:0:{}', 6, 'Content workflow, editorial workflow tools.', 'right', 5, 'modules/system/system.admin.inc'),
('admin/content', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 3, 2, 0, '', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 6, 'Administer content and comments.', '', -10, 'modules/node/node.admin.inc'),
('admin/content/comment', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Comments', 't', '', '', 'a:0:{}', 134, 'List and edit site comments and the comment approval queue.', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/approval', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a313a7b693a303b733a383a22617070726f76616c223b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Unapproved comments', 'comment_count_unpublished', '', '', 'a:0:{}', 132, '', '', 0, 'modules/comment/comment.admin.inc'),
('admin/content/comment/new', '', '', 'user_access', 0x613a313a7b693a303b733a31393a2261646d696e697374657220636f6d6d656e7473223b7d, 'comment_admin', 0x613a303a7b7d, '', 15, 4, 1, 'admin/content/comment', 'admin/content', 'Published comments', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/comment/comment.admin.inc'),
('admin/content/node', '', '', 'user_access', 0x613a313a7b693a303b733a32333a2261636365737320636f6e74656e74206f76657276696577223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31383a226e6f64655f61646d696e5f636f6e74656e74223b7d, '', 7, 3, 1, 'admin/content', 'admin/content', 'Content', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/node/node.admin.inc'),
('admin/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/dashboard', 'Dashboard', 't', '', '', 'a:0:{}', 6, 'View and customize your dashboard.', '', -15, ''),
('admin/dashboard/block-content/%/%', 0x613a323a7b693a333b4e3b693a343b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_block_content', 0x613a323a7b693a303b693a333b693a313b693a343b7d, '', 28, 5, 0, '', 'admin/dashboard/block-content/%/%', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/configure', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_admin_blocks', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/configure', 'Configure available dashboard blocks', 't', '', '', 'a:0:{}', 4, 'Configure which blocks can be shown on the dashboard.', '', 0, ''),
('admin/dashboard/customize', '', '', 'user_access', 0x613a313a7b693a303b733a31363a226163636573732064617368626f617264223b7d, 'dashboard_admin', 0x613a313a7b693a303b623a313b7d, '', 7, 3, 0, '', 'admin/dashboard/customize', 'Customize dashboard', 't', '', '', 'a:0:{}', 4, 'Customize your dashboard.', '', 0, ''),
('admin/dashboard/drawer', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_show_disabled', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/drawer', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/dashboard/update', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'dashboard_update', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/dashboard/update', '', 't', '', '', 'a:0:{}', 0, '', '', 0, ''),
('admin/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_main', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/help', 'Help', 't', '', '', 'a:0:{}', 6, 'Reference for usage, configuration, and modules.', '', 9, 'modules/help/help.admin.inc'),
('admin/help/aggregator', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/aggregator', 'aggregator', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/block', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/block', 'block', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/blog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/blog', 'blog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/color', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/color', 'color', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/comment', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/comment', 'comment', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contact', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contact', 'contact', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/contextual', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/contextual', 'contextual', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/dashboard', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/dashboard', 'dashboard', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field', 'field', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_sql_storage', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_sql_storage', 'field_sql_storage', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/field_ui', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/field_ui', 'field_ui', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/file', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/file', 'file', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/filter', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/filter', 'filter', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/forum', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/forum', 'forum', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/help', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/help', 'help', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/image', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/image', 'image', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/jcarousel', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/jcarousel', 'jcarousel', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/jquery_update', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/jquery_update', 'jquery_update', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/list', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/list', 'list', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/menu', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/menu', 'menu', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/node', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/node', 'node', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/number', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/number', 'number', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/options', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/options', 'options', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/overlay', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/overlay', 'overlay', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/path', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/path', 'path', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/pathauto', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/pathauto', 'pathauto', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/php', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/php', 'php', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/poll', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/poll', 'poll', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/quicktabs', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/quicktabs', 'quicktabs', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/search', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/search', 'search', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/shortcut', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/shortcut', 'shortcut', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/socialmedia', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/socialmedia', 'socialmedia', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/statistics', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/statistics', 'statistics', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/superfish', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/superfish', 'superfish', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/syslog', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/syslog', 'syslog', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/system', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/system', 'system', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/taxonomy', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/taxonomy', 'taxonomy', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/text', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/text', 'text', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/token', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/token', 'token', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/toolbar', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/toolbar', 'toolbar', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/tracker', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/tracker', 'tracker', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/trigger', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/trigger', 'trigger', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/update', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/update', 'update', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/user', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/user', 'user', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/views_slideshow', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/views_slideshow', 'views_slideshow', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/views_slideshow_cycle', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/views_slideshow_cycle', 'views_slideshow_cycle', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/widgets', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/widgets', 'widgets', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/help/wysiwyg', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'help_page', 0x613a313a7b693a303b693a323b7d, '', 7, 3, 0, '', 'admin/help/wysiwyg', 'wysiwyg', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/help/help.admin.inc'),
('admin/index', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_index', 0x613a303a7b7d, '', 3, 2, 1, 'admin', 'admin', 'Index', 't', '', '', 'a:0:{}', 132, '', '', -18, 'modules/system/system.admin.inc'),
('admin/modules', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 3, 2, 0, '', 'admin/modules', 'Modules', 't', '', '', 'a:0:{}', 6, 'Extend site functionality.', '', -2, 'modules/system/system.admin.inc'),
('admin/modules/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Install new module', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/modules/list', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/list/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31343a2273797374656d5f6d6f64756c6573223b7d, '', 15, 4, 0, '', 'admin/modules/list/confirm', 'List', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/uninstall', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Uninstall', 't', '', '', 'a:0:{}', 132, '', '', 20, 'modules/system/system.admin.inc'),
('admin/modules/uninstall/confirm', '', '', 'user_access', 0x613a313a7b693a303b733a31383a2261646d696e6973746572206d6f64756c6573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32343a2273797374656d5f6d6f64756c65735f756e696e7374616c6c223b7d, '', 15, 4, 0, '', 'admin/modules/uninstall/confirm', 'Uninstall', 't', '', '', 'a:0:{}', 4, '', '', 0, 'modules/system/system.admin.inc'),
('admin/modules/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a226d6f64756c65223b7d, '', 7, 3, 1, 'admin/modules', 'admin/modules', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 3, 2, 0, '', 'admin/people', 'People', 't', '', '', 'a:0:{}', 6, 'Manage user accounts, roles, and permissions.', 'left', -4, 'modules/user/user.admin.inc'),
('admin/people/create', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a363a22637265617465223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Add user', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/people', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207573657273223b7d, 'user_admin', 0x613a313a7b693a303b733a343a226c697374223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'List', 't', '', '', 'a:0:{}', 140, 'Find and manage people interacting with your site.', '', -10, 'modules/user/user.admin.inc'),
('admin/people/permissions', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 7, 3, 1, 'admin/people', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 132, 'Determine access to features by selecting permissions for roles.', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/list', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32323a22757365725f61646d696e5f7065726d697373696f6e73223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Permissions', 't', '', '', 'a:0:{}', 140, 'Determine access to features by selecting permissions for roles.', '', -8, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles', '', '', 'user_access', 0x613a313a7b693a303b733a32323a2261646d696e6973746572207065726d697373696f6e73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31363a22757365725f61646d696e5f726f6c6573223b7d, '', 15, 4, 1, 'admin/people/permissions', 'admin/people', 'Roles', 't', '', '', 'a:0:{}', 132, 'List, edit, or add user roles.', '', -5, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/delete/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a33303a22757365725f61646d696e5f726f6c655f64656c6574655f636f6e6669726d223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/delete/%', 'Delete role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/people/permissions/roles/edit/%', 0x613a313a7b693a353b733a31343a22757365725f726f6c655f6c6f6164223b7d, '', 'user_role_edit_access', 0x613a313a7b693a303b693a353b7d, 'drupal_get_form', 0x613a323a7b693a303b733a31353a22757365725f61646d696e5f726f6c65223b693a313b693a353b7d, '', 62, 6, 0, '', 'admin/people/permissions/roles/edit/%', 'Edit role', 't', '', '', 'a:0:{}', 6, '', '', 0, 'modules/user/user.admin.inc'),
('admin/reports', '', '', 'user_access', 0x613a313a7b693a303b733a31393a226163636573732073697465207265706f727473223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/reports', 'Reports', 't', '', '', 'a:0:{}', 6, 'View reports, updates, and errors.', 'left', 5, 'modules/system/system.admin.inc'),
('admin/reports/access/%', 0x613a313a7b693a333b4e3b7d, '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_access_log', 0x613a313a7b693a303b693a333b7d, '', 14, 4, 0, '', 'admin/reports/access/%', 'Details', 't', '', '', 'a:0:{}', 6, 'View access log.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/fields', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/fields', 'Field list', 't', '', '', 'a:0:{}', 6, 'Overview of fields on all entity types.', '', 0, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/list', '', '', 'user_access', 0x613a313a7b693a303b733a32343a2261646d696e697374657220636f6e74656e74207479706573223b7d, 'field_ui_fields_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'List', 't', '', '', 'a:0:{}', 140, '', '', -10, 'modules/field_ui/field_ui.admin.inc'),
('admin/reports/fields/views-fields', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_field_list', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/fields', 'admin/reports/fields', 'Used in views', 't', '', '', 'a:0:{}', 132, 'Overview of fields used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/reports/hits', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_recent_hits', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/hits', 'Recent hits', 't', '', '', 'a:0:{}', 6, 'View pages that have recently been visited.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/pages', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_pages', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/pages', 'Top pages', 't', '', '', 'a:0:{}', 6, 'View pages that have been hit frequently.', '', 1, 'modules/statistics/statistics.admin.inc'),
('admin/reports/referrers', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_referrers', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/referrers', 'Top referrers', 't', '', '', 'a:0:{}', 6, 'View top referrers.', '', 0, 'modules/statistics/statistics.admin.inc'),
('admin/reports/status', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/status', 'Status report', 't', '', '', 'a:0:{}', 6, 'Get a status report about your site''s operation and any detected problems.', '', -60, 'modules/system/system.admin.inc'),
('admin/reports/status/php', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_php', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/php', 'PHP', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/status/rebuild', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a33303a226e6f64655f636f6e6669677572655f72656275696c645f636f6e6669726d223b7d, '', 15, 4, 0, '', 'admin/reports/status/rebuild', 'Rebuild permissions', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/node/node.admin.inc'),
('admin/reports/status/run-cron', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'system_run_cron', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/status/run-cron', 'Run cron', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/system/system.admin.inc'),
('admin/reports/updates', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/updates', 'Available updates', 't', '', '', 'a:0:{}', 6, 'Get a status report about available updates for your installed modules and themes.', '', -50, 'modules/update/update.report.inc'),
('admin/reports/updates/check', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_manual_status', 0x613a303a7b7d, '', 15, 4, 0, '', 'admin/reports/updates/check', 'Manual update check', 't', '', '', 'a:0:{}', 0, '', '', 0, 'modules/update/update.fetch.inc'),
('admin/reports/updates/install', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32373a227570646174655f6d616e616765725f696e7374616c6c5f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Install new module or theme', 't', '', '', 'a:0:{}', 388, '', '', 25, 'modules/update/update.manager.inc'),
('admin/reports/updates/list', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'update_status', 0x613a303a7b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'List', 't', '', '', 'a:0:{}', 140, '', '', 0, 'modules/update/update.report.inc'),
('admin/reports/updates/settings', '', '', 'user_access', 0x613a313a7b693a303b733a32393a2261646d696e6973746572207369746520636f6e66696775726174696f6e223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a31353a227570646174655f73657474696e6773223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Settings', 't', '', '', 'a:0:{}', 132, '', '', 50, 'modules/update/update.settings.inc'),
('admin/reports/updates/update', '', '', 'update_manager_access', 0x613a303a7b7d, 'drupal_get_form', 0x613a323a7b693a303b733a32363a227570646174655f6d616e616765725f7570646174655f666f726d223b693a313b733a363a227265706f7274223b7d, '', 15, 4, 1, 'admin/reports/updates', 'admin/reports/updates', 'Update', 't', '', '', 'a:0:{}', 132, '', '', 10, 'modules/update/update.manager.inc'),
('admin/reports/views-plugins', '', '', 'user_access', 0x613a313a7b693a303b733a31363a2261646d696e6973746572207669657773223b7d, 'views_ui_plugin_list', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/views-plugins', 'Views plugins', 't', '', '', 'a:0:{}', 6, 'Overview of plugins used in all views.', '', 0, 'sites/all/modules/views/includes/admin.inc'),
('admin/reports/visitors', '', '', 'user_access', 0x613a313a7b693a303b733a31373a226163636573732073746174697374696373223b7d, 'statistics_top_visitors', 0x613a303a7b7d, '', 7, 3, 0, '', 'admin/reports/visitors', 'Top visitors', 't', '', '', 'a:0:{}', 6, 'View visitors that hit many pages.', '', 2, 'modules/statistics/statistics.admin.inc'),
('admin/structure', '', '', 'user_access', 0x613a313a7b693a303b733a32373a226163636573732061646d696e697374726174696f6e207061676573223b7d, 'system_admin_menu_block_page', 0x613a303a7b7d, '', 3, 2, 0, '', 'admin/structure', 'Structure', 't', '', '', 'a:0:{}', 6, 'Administer blocks, content types, menus, etc.', 'right', -8, 'modules/system/system.admin.inc'),
('admin/structure/block', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'block_admin_display', 0x613a313a7b693a303b733a363a227a6972636f6e223b7d, '', 7, 3, 0, '', 'admin/structure/block', 'Blocks', 't', '', '', 'a:0:{}', 6, 'Configure what block content appears in your site''s sidebars and other regions.', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 15, 4, 1, 'admin/structure/block', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/structure/block/demo/bartik', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a363a2262617274696b223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/bartik', 'Bartik', 't', '', '_block_custom_theme', 'a:1:{i:0;s:6:"bartik";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/garland', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a373a226761726c616e64223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/garland', 'Garland', 't', '', '_block_custom_theme', 'a:1:{i:0;s:7:"garland";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/nucleus', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a373a226e75636c657573223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/nucleus', 'nucleus', 't', '', '_block_custom_theme', 'a:1:{i:0;s:7:"nucleus";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/nucleus_starter', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a31353a226e75636c6575735f73746172746572223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/nucleus_starter', 'nucleus_starter', 't', '', '_block_custom_theme', 'a:1:{i:0;s:15:"nucleus_starter";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/seven', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a353a22736576656e223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/seven', 'Seven', 't', '', '_block_custom_theme', 'a:1:{i:0;s:5:"seven";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/demo/stark', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a353a22737461726b223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/stark', 'Stark', 't', '', '_block_custom_theme', 'a:1:{i:0;s:5:"stark";}', 0, '', '', 0, 'modules/block/block.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/structure/block/demo/zircon', '', '', '_block_themes_access', 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, 'block_admin_demo', 0x613a313a7b693a303b733a363a227a6972636f6e223b7d, '', 31, 5, 0, '', 'admin/structure/block/demo/zircon', 'Zircon', 't', '', '_block_custom_theme', 'a:1:{i:0;s:6:"zircon";}', 0, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/bartik', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a363a2262617274696b223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Bartik', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/bartik/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/bartik', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/garland', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a373a226761726c616e64223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Garland', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/garland/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/garland', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/nucleus', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a373a226e75636c657573223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'nucleus', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/nucleus/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/nucleus', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc');
INSERT INTO `menu_router` (`path`, `load_functions`, `to_arg_functions`, `access_callback`, `access_arguments`, `page_callback`, `page_arguments`, `delivery_callback`, `fit`, `number_parts`, `context`, `tab_parent`, `tab_root`, `title`, `title_callback`, `title_arguments`, `theme_callback`, `theme_arguments`, `type`, `description`, `position`, `weight`, `include_file`) VALUES
('admin/structure/block/list/nucleus_starter', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a31353a226e75636c6575735f73746172746572223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'nucleus_starter', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/nucleus_starter/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/nucleus_starter', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/seven', '', '', '_block_themes_access', 0x613a313a7b693a303b4f3a383a22737464436c617373223a31323a7b733a383a2266696c656e616d65223b733a32333a227468656d65732f736576656e2f736576656e2e696e666f223b733a343a226e616d65223b733a353a22736576656e223b733a343a2274797065223b733a353a227468656d65223b733a353a226f776e6572223b733a34353a227468656d65732f656e67696e65732f70687074656d706c6174652f70687074656d706c6174652e656e67696e65223b733a363a22737461747573223b733a313a2231223b733a393a22626f6f747374726170223b733a313a2230223b733a31343a22736368656d615f76657273696f6e223b733a323a222d31223b733a363a22776569676874223b733a313a2230223b733a343a22696e666f223b613a31383a7b733a343a226e616d65223b733a353a22536576656e223b733a31313a226465736372697074696f6e223b733a36353a22412073696d706c65206f6e652d636f6c756d6e2c207461626c656c6573732c20666c7569642077696474682061646d696e697374726174696f6e207468656d652e223b733a373a227061636b616765223b733a343a22436f7265223b733a373a2276657273696f6e223b733a343a22372e3234223b733a343a22636f7265223b733a333a22372e78223b733a31313a227374796c65736865657473223b613a313a7b733a363a2273637265656e223b613a323a7b733a393a2272657365742e637373223b733a32323a227468656d65732f736576656e2f72657365742e637373223b733a393a227374796c652e637373223b733a32323a227468656d65732f736576656e2f7374796c652e637373223b7d7d733a383a2273657474696e6773223b613a313a7b733a32303a2273686f72746375745f6d6f64756c655f6c696e6b223b733a313a2231223b7d733a373a22726567696f6e73223b613a383a7b733a373a22636f6e74656e74223b733a373a22436f6e74656e74223b733a343a2268656c70223b733a343a2248656c70223b733a383a22706167655f746f70223b733a383a225061676520746f70223b733a31313a22706167655f626f74746f6d223b733a31313a225061676520626f74746f6d223b733a31333a22736964656261725f6669727374223b733a31333a2246697273742073696465626172223b733a31343a2264617368626f6172645f6d61696e223b733a31363a2244617368626f61726420286d61696e29223b733a31373a2264617368626f6172645f73696465626172223b733a31393a2244617368626f61726420287369646562617229223b733a31383a2264617368626f6172645f696e616374697665223b733a32303a2244617368626f6172642028696e61637469766529223b7d733a31343a22726567696f6e735f68696464656e223b613a333a7b693a303b733a31333a22736964656261725f6669727374223b693a313b733a383a22706167655f746f70223b693a323b733a31313a22706167655f626f74746f6d223b7d733a373a2270726f6a656374223b733a363a2264727570616c223b733a393a22646174657374616d70223b733a31303a2231333834393833323430223b733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b733a383a226665617475726573223b613a393a7b693a303b733a343a226c6f676f223b693a313b733a373a2266617669636f6e223b693a323b733a343a226e616d65223b693a333b733a363a22736c6f67616e223b693a343b733a31373a226e6f64655f757365725f70696374757265223b693a353b733a32303a22636f6d6d656e745f757365725f70696374757265223b693a363b733a32353a22636f6d6d656e745f757365725f766572696669636174696f6e223b693a373b733a393a226d61696e5f6d656e75223b693a383b733a31343a227365636f6e646172795f6d656e75223b7d733a31303a2273637265656e73686f74223b733a32373a227468656d65732f736576656e2f73637265656e73686f742e706e67223b733a333a22706870223b733a353a22352e322e34223b733a373a2273637269707473223b613a303a7b7d733a31353a226f7665726c61795f726567696f6e73223b613a353a7b693a303b733a31343a2264617368626f6172645f6d61696e223b693a313b733a31373a2264617368626f6172645f73696465626172223b693a323b733a31383a2264617368626f6172645f696e616374697665223b693a333b733a373a22636f6e74656e74223b693a343b733a343a2268656c70223b7d733a32383a226f7665726c61795f737570706c656d656e74616c5f726567696f6e73223b613a313a7b693a303b733a383a22706167655f746f70223b7d7d733a363a22707265666978223b733a31313a2270687074656d706c617465223b733a31313a227374796c65736865657473223b613a313a7b733a363a2273637265656e223b613a323a7b733a393a2272657365742e637373223b733a32323a227468656d65732f736576656e2f72657365742e637373223b733a393a227374796c652e637373223b733a32323a227468656d65732f736576656e2f7374796c652e637373223b7d7d733a363a22656e67696e65223b733a31313a2270687074656d706c617465223b7d7d, 'block_admin_display', 0x613a313a7b693a303b733a353a22736576656e223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Seven', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/seven/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/seven', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/stark', '', '', '_block_themes_access', 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, 'block_admin_display', 0x613a313a7b693a303b733a353a22737461726b223b7d, '', 31, 5, 1, 'admin/structure/block', 'admin/structure/block', 'Stark', 't', '', '', 'a:0:{}', 132, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/stark/add', '', '', 'user_access', 0x613a313a7b693a303b733a31373a2261646d696e697374657220626c6f636b73223b7d, 'drupal_get_form', 0x613a313a7b693a303b733a32303a22626c6f636b5f6164645f626c6f636b5f666f726d223b7d, '', 63, 6, 1, 'admin/structure/block/list/stark', 'admin/structure/block', 'Add block', 't', '', '', 'a:0:{}', 388, '', '', 0, 'modules/block/block.admin.inc'),
('admin/structure/block/list/zircon', '', '', '_block_themes_access', 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