<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WP_Generic
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<?php if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php wp_generic_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div><!-- .entry-summary -->
<?php 
if('page' != get_post_type()):?>
	<footer class="entry-footer">
		<?php wp_generic_entry_footer(); ?>
	</footer><!-- .entry-footer -->
<?php 
elseif(current_user_can('edit_pages')):?>	
	<footer class="entry-footer">
		<?php wp_generic_entry_footer(); ?>
	</footer><!-- .entry-footer -->
<?php endif;?>
</article><!-- #post-## -->
