<?php 


    // Blog Page Setting
    $wp_customize->add_section(
        'wp_generic_blog',
        array(
            'title'         =>  esc_html__('Blog Page Setting','wp-generic'),
            'description'   =>  esc_html__( 'Setup Blog Page of the theme. Before setup Go to Apperance-> Customize -> Theme Setup -> Category setup and choose blog category.','wp-generic' ),
            'capability'    =>  'edit_theme_options',
            'priority'      =>  50,            
            )
        );

        $wp_customize->add_setting(
            'wp_generic_blog_post_layout',
            array(
                'default'           =>  'large-image',
                'sanitize_callback' =>  'wp_generic_sanitize_post_layout',
                )
            );

        $wp_customize->add_control(
            'wp_generic_blog_post_layout',
            array(
                'priority'      =>  10,  
                'type'          =>  'radio',
                'label'         =>  esc_html__('Post Layout','wp-generic'),
                'description'   =>  esc_html__('Choose Blog Post Layout','wp-generic'),
                'section'       =>  'wp_generic_blog',
                'choices'        =>  array(
                    'large-image' => esc_html__('Posts with Large Image', 'wp-generic'),
                    'medium-image' => esc_html__('Posts with Medium Image', 'wp-generic'),
                    'alternate-image' => esc_html__('Post with Alternate Image', 'wp-generic'),
                    )
                )                   
            );