<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magentocommerce.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magentocommerce.com for more information.
 *
 * @category    Mage
 * @package     Mage_CatalogSearch
 * @copyright   Copyright (c) 2012 Magento Inc. (http://www.magentocommerce.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

class Ves_PriceSlider_Model_Catalogsearch_Layer extends Mage_CatalogSearch_Model_Layer 
{
	const FILTER_ON_SALE = 1;
    const FILTER_NOT_ON_SALE = 2;
    const FILTER_IN_STOCK = 1;
    const FILTER_OUT_STOCK = 2;
    /**
     * Prepare product collection
     *
     * @param Mage_Catalog_Model_Resource_Eav_Resource_Product_Collection $collection
     * @return Mage_Catalog_Model_Layer
     */
    public function prepareProductCollection($collection)
    {
        $collection
            ->addAttributeToSelect(Mage::getSingleton('catalog/config')->getProductAttributes())
            ->addSearchFilter(Mage::helper('catalogsearch')->getQuery()->getQueryText())
            ->setStore(Mage::app()->getStore())
            ->addMinimalPrice()
            ->addFinalPrice()
            ->addTaxPercents()
            ->addStoreFilter()
            ->addUrlRewrite();

        $config = Mage::getStoreConfig('ves_priceslider');
		if(isset($config['ves_layerfilter_conf']['show_stock_filter']) && $config['ves_layerfilter_conf']['show_stock_filter']) {
			if(!Mage::registry('ves_stock_joined')) {
				$collection->joinField(
                    'qty',
                    'cataloginventory/stock_item',
                    'is_in_stock',
                    'product_id=entity_id',
                    '{{table}}.stock_id=1',
                    'left'
                );

                Mage::register('ves_stock_joined', true);
			}
		}
		    
        Mage::getSingleton('catalog/product_status')->addVisibleFilterToCollection($collection);
        Mage::getSingleton('catalog/product_visibility')->addVisibleInSearchFilterToCollection($collection);
		
		$this->currentRate = Mage::app()->getStore()->getCurrentCurrencyRate();;
		$max=$this->getMaxPriceFilter();
		$min=$this->getMinPriceFilter();
		
		//print_r($collection->getData());
		
		if($min && $max){
			//$collection= $collection->addAttributeToFilter('price',array('from'=>$min, 'to'=>$max)); 
			$collection->getSelect()->where(' final_price >= "'.$min.'" AND final_price <= "'.$max.'" ');
			
			//echo $collection->getSelect();exit;
		}
		
		/*PRICE SLIDER FILTER*/
        return $this;
    }
	
	/*
	* convert Price as per currency
	*
	* @return currency
	*/
	public function getMaxPriceFilter(){
		return isset($_GET['max'])?round($_GET['max']/$this->currentRate):0;
	}
	
	
	/*
	* Convert Min Price to current currency
	*
	* @return currency
	*/
	public function getMinPriceFilter(){
		return isset($_GET['min'])?round($_GET['min']/$this->currentRate):0;
	}
    /*
	* Convert Min Price to current currency
	*
	* @return currency
	*/
	public function getSaleFilter(){
		return isset($_GET['sale'])?$_GET['sale']:0;
	}
    
    /*
	* Convert Min Price to current currency
	*
	* @return currency
	*/
	public function getStockFilter(){
		return isset($_GET['stock'])?$_GET['stock']:0;
	}
}