<?php
/**
 * Venustheme
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Venustheme EULA that is bundled with
 * this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.venustheme.com/LICENSE-1.0.html
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the extension
 * to newer versions in the future. If you wish to customize the extension
 * for your needs please refer to http://www.venustheme.com/ for more information
 *
 * @category   Ves
 * @package    Ves_FAQ
 * @copyright  Copyright (c) 2014 Venustheme (http://www.venustheme.com/)
 * @license    http://www.venustheme.com/LICENSE-1.0.html
 */

/**
 * Ves FAQ Extension
 *
 * @category   Ves
 * @package    Ves_FAQ
 * @author     Venustheme Dev Team <venustheme@gmail.com>
 */
class Ves_FAQ_Model_Mysql4_Answer_Collection extends Mage_Core_Model_Mysql4_Collection_Abstract
{
	public function _construct()
	{
		parent::_construct();
		$this->_init('ves_faq/answer');
	}

	 /**
     * Add Filter by store
     *
     * @param int|Mage_Core_Model_Store $store
     * @return Ves_FAQ_Model_Mysql4_Answer_Collection
     */
	 public function addStoreFilter($store = null) {

	 	$store = Mage::app()->getStore($store);
	 	$this->getSelect()->join(
	 		array('store_table' => $this->getTable('ves_faq/answer_store')),
	 		'main_table.answer_id = store_table.answer_id',
	 		array()
	 		)
	 	->where('store_table.store_id in (?)', array(0, $store->getId()))
	 	->group('main_table.answer_id');
	 	return $this;
	 }
	}