<?php
class Ves_BlockBuilder_Block_Widget_Product_Information extends Mage_Catalog_Block_Product_View implements Mage_Widget_Block_Interface{


	public function __construct($attributes = array())
	{
		parent::__construct($attributes);

		if($this->hasData("template")) {
        	$my_template = $this->getData("template");
        }else{
        	$layout_mode = $this->getConfig("layout", "accordion");
        	$layout_mode = !$layout_mode?"accordion": $layout_mode;
 			$my_template = "ves/productbuilder/widget/information_{$layout_mode}.phtml";
 		}
        $this->setTemplate($my_template);
	}



	protected function _toHtml(){
		if(!Mage::getStoreConfig('ves_base/general_setting/show')) {
			return ;
		}

		if(!Mage::getStoreConfig("ves_productbuilder/general/show")) {
			return ;
		}
		
		return parent::_toHtml();
	}
	/**
	 * get value of the extension's configuration
	 *
	 * @return string
	 */
	public function getConfig( $key, $default = ""){
	    $value = $this->getData($key);
	    //Check if has widget config data
	    if($this->hasData($key) && $value !== null) {

	      if($value == "true") {
	        return 1;
	      } elseif($value == "false") {
	        return 0;
	      }
	      
	      return $value;
	      
	    }
	    return $default;
	}
}