<?php
/**
 * The main theme functions file loads styles/scripts, allows some theme functionality and provides some helper functions.
 * @version:1.0
 */
/**
 * This theme only works in WordPress 4.2 or later.
 */

if ( version_compare( $GLOBALS['wp_version'], '4.2', '<' ) ) {
    require get_template_directory() . '/inc/back-compat.php';
}

if ( ! isset( $content_width ) ) $content_width = 1140;

/*----------------------------------------------------------------
    TGMPA Activation.
 -----------------------------------------------------------------*/
require_once(get_template_directory() . '/inc/tgm_activation/tgm.php');


function getAssetsPath($path) {
    return get_template_directory_uri().$path;
}

/*------------------------------
         * Register Navigation 
    --------------------------------*/
    //Navigation Menus
 register_nav_menus(array(
        'primary' => __('Primary Menu', 'star-law-firm-lite')
    ));
 
function image($name) {
    return getAssetsPath('/assets/images/'.$name);
}

function star_lawfirm_pro_setup(){

    /*------------------------------
         * Register Navigation 
    --------------------------------*/
    //Navigation Menus
    register_nav_menus(array(
        'primary' => __('Primary Menu', 'star-law-firm-lite')
    ));

    /*---------------------------------------------------
         Theme Supports.
     ----------------------------------------------------*/

    //Add featured image support
    add_theme_support('post-thumbnails');

    //This feature enables plugins and themes to manage the document title tag.
    add_theme_support('title-tag');
    //This feature adds RSS feed links to HTML <head>.
    add_theme_support( 'automatic-feed-links' );
 

    add_theme_support('post-thumbnails');
    set_post_thumbnail_size( 700, 500, true );
     add_image_size( 'small-thumb', 200, 200);
    add_image_size( 'video-logo', 90, 90, true );
    add_image_size( 'medium-photo', 500, 500, true );
    add_image_size( 'single-photo', 140, 70, true );

        // Load Text Domain
    load_theme_textdomain('star-law-firm-lite');
 }

add_action( 'after_setup_theme', 'star_lawfirm_pro_setup' );



    /**
     * Enqueue scripts and styles.
     *
     */
    function star_lawfirm_pro_scripts() {
        global $wp_styles;
        
        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
            wp_enqueue_script( 'comment-reply' );

  // Loads bootstrap.
  wp_enqueue_style( 'lawfirm-bootstrap-style', getAssetsPath('/assets/css/bootstrap.min.css') );


    // Adds bootstrap JavaScript.
    wp_enqueue_script( 'lawfirm-bootstrap-js',getAssetsPath('/assets/js/bootstrap.min.js'), array( 'jquery' ) , '','', true);

  // Loads our main stylesheet.
  wp_enqueue_style( 'lawfirm-style', get_stylesheet_uri() );

   /* OWL */
    // Loads stylesheets.
    wp_enqueue_style( 'lawfirm-owl-style', getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.css'));
    
      // Loads font.
    wp_enqueue_style( 'google-vietnamese-font', 'https://fonts.googleapis.com/css?family=Open+Sans:400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese' );

    //Load Fontawesome css
    wp_enqueue_style('lawfirm-font-awesome.min', getAssetsPath('/assets/vendors/font-awesome/css/font-awesome.min.css"'));
    
    //Load animation css
    wp_enqueue_style('lawfirm-animate-css', getAssetsPath('/assets/vendors/animate/animate.css"'));

     /*----------------------------
       Load Javascript
        -----------------------------*/
    //Loads animation js
    wp_enqueue_script( 'lawfirm-wow.min',  getAssetsPath('/assets/vendors/animate/wow.min.js'), '','', true);

    wp_enqueue_script( 'lawfirm-carousel.min',  getAssetsPath('/assets/vendors/owl_carousel/owl.carousel.min.js'), '','', true);
    
    // Slider JS
    wp_enqueue_script( 'lawfirm-slider',  getAssetsPath('/assets/js/slider.js'), '','', true);

    // Custom JS
    wp_enqueue_script( 'lawfirm-custom',  getAssetsPath('/assets/js/theme.min.js'), '','', true);


      /*----------------------------
       Google Map
        -----------------------------*/
    if (get_theme_mod('google_map_active', 1) ) {
            
            $map_key = get_theme_mod("map_key");
            wp_enqueue_script( 'lawfirm-google-js',  'https://maps.googleapis.com/maps/api/js?key='.$map_key.'&v=3.exp');

        }   
  }
  
  add_action( 'wp_enqueue_scripts', 'star_lawfirm_pro_scripts' );


 /*----------------------------
   Excerpt Word Length
    -----------------------------*/

 if(!function_exists( 'star_lawfirm_pro_custom_excerpt_length' )) {

    //Customize excerpt word count
    function star_lawfirm_pro_custom_excerpt_length() {
        return 25; //25 words
    }
    
    add_filter('excerpt_length', 'star_lawfirm_pro_custom_excerpt_length');
}


/*----------------------------
   Add our Widget Locations
    -----------------------------*/

    function star_lawfirm_pro_widgets() {
        register_sidebar( array(
            'name' => __( 'Sidebar', 'star-law-firm-lite' ),
            'id' => 'sidebar-1',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer_1', 'star-law-firm-lite' ),
            'id' => 'sidebar-2',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer_2', 'star-law-firm-lite' ),
            'id' => 'sidebar-3',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Footer_3', 'star-law-firm-lite' ),
            'id' => 'sidebar-4',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) ); 

         register_sidebar( array(
            'name' => __( 'Testimonials Section', 'star-law-firm-lite' ),
            'id' => 'testimonials_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Partners Section', 'star-law-firm-lite' ),
            'id' => 'partners_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Services Section', 'star-law-firm-lite' ),
            'id' => 'services_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        
        register_sidebar( array(
            'name' => __( 'Team Section', 'star-law-firm-lite' ),
            'id' => 'team_widget_',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );
       
        register_sidebar( array(
            'name' => __( 'About Us Section', 'star-law-firm-lite' ),
            'id' => 'about_widgets',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );

        register_sidebar( array(
            'name' => __( 'Call Action Section', 'star-law-firm-lite' ),
            'id' => 'call_action_widget',
            'description' => __( 'Widgets in this area will be shown on all posts and pages.', 'star-law-firm-lite' ),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h2 class="widgettitle">',
            'after_title'   => '</h2>',
            ) );   
        }
add_action('widgets_init', 'star_lawfirm_pro_widgets');



/*----------------------------
    Including NavThemes Functions File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/navthemes-functions.php')) :
    include_once(dirname( __FILE__ ) . '/navthemes-functions.php');
 endif;   



/*----------------------------
    Including theme-options File 
    -----------------------------*/

if(file_exists(dirname( __FILE__ ) . '/theme-options.php')) :
    include_once(dirname( __FILE__ ) . '/theme-options.php');
 endif; 
    
 
    /*----------------------------
    Adds customizer css
    -----------------------------*/
if(!function_exists('navthemes_customizer_css')) {

    function navthemes_customizer_css() {
     // Loads our main stylesheet.
        wp_enqueue_style( 'customizer-css', get_template_directory_uri().'/customizer.css' );
    }
    
    add_action( 'customize_controls_print_styles', 'navthemes_customizer_css');

}