<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/

//include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}
 
/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}

add_filter( 'kirki/config', 'navthemes_configuration' );

/*=================================
	Priorities-

* NavThemes Branding  - 10 
* Sample Content      - 11
* General settings    - 20-30
* Front page          - 31-125
* Addons              - 130-249
* Global Partners     - 250-252
* Global Testimonials - 260-264
* Call To Action      - 270-275

================================= */


/*=================================
	Panels Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 2
* General Settings    - 3
* Front Page          - 4
* Service Page        - 5
* Contact page        - 6
* About Page          - 7
* Global Partners     - 8
* Global Testimonials - 9
* Call To Action      - 10
================================= */

/*=================================
	Config	
  ================================= */

Kirki::add_config( 'star-law-firm-lite', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );


	/*------------------------------------------
     NavThemes Branding
     ------------------------------------------*/

     $theme = wp_get_theme();
	 $theme_version = $theme->get( 'Version' );
	 $theme_name = $theme->get( 'Name' );
 
  Kirki::add_section( 'NavThemes_Support', array(
			'title'          => __( 'NavThemes Support', 'navthemes' ),
			'description'    => sprintf( 'You are using Free version of %s Theme, Check out Paid version, which comes with many exciting features in the package.', __($theme->Name, 'navthemes','star-law-firm-lite') ),
			'priority'       => 1,
	) );
			
		Kirki::add_field( 'navthemes', array(
		'type'        => 'custom',
		'settings'     => 'navthemes_support',
		'section'     => 'NavThemes_Support',
		'default'     => sprintf( '<div id="navthemes_branding"><h1>Get Premium Version of %s for Just $59</h1>
			<div class="navthemes-links">
			<ul>
				<li><a target="_blank" href="%s">Check out All Features of Paid version</a></li>
				<li><a target="_blank" href="%s">View Demo</a></li>
			</ul> 
		</div>
		</div>', __($theme->Name, 'navthemes','star-law-firm-lite'), 'https://www.navthemes.com/wp-themes/starlaw-pro-law-firm-wordpress-theme/' , 'http://demo.navthemes.com/?demo=lawfirm-pro' ),
		'priority'    => 10,
	) );    


/*------------------------------------------
    Maintenance Service
    ------------------------------------------*/


 Kirki::add_section( 'NavThemes_Maintenance_Service', array(
            'title'          => __( 'Maintenance Service', 'navthemes' ),
            'description'    => sprintf( '<h1> Managing WordPress Site is a hassle ? Let us handle that.

</h1>', __($theme->Name, 'navthemes','star-law-firm-lite') ),
            'priority'       => 1,
    ) );
            

        Kirki::add_field( 'navthemes', array(
        'type'        => 'custom',
        'settings'     => 'navThemes_maintenance_service',
        'section'     => 'NavThemes_Maintenance_Service',
        'default'     => sprintf( '<div id="navthemes_maintenance">
        <div class="themeisle-upsell"> 
        <h1>**Key Features**</h1>
            <h3>FREE Lightning Fast Hosting <span class="color_span" ><br>This is a Google Ranking factor. </span></h3>
            <h3>FREE SSL Certificate   <span class="color_span"> <br>This is a Google Ranking factor. </span></h3> 
            <h3>24/7 Uptime monitoring</h3>
            <h3>Access All NavThemes Premium WordPress Themes and Plugins</h3>
            <h3>Free Migration Service to our hosting</h3>
            <h3>Free CDN Service</h3>
            <h3>Unlimited Website Edits</h3>
            <h3>Hack/Malware Removal</h3>
            <h3>Weekly Website Report</h3>
            <div class="navthemes-links">
            <ul>
            <li>

            <a target="_blank" href="http://navthemes.com/wordpress-management-service/?utm_source=Star-Law-Firm-Lite&utm_medium=lite-wordpress-theme&utm_campaign=customizer&utm_term=maintenance-service" class="button button-primary button_70">Starting at just $39/Month</a>
          </li>

                
            </ul>
            </div>
        </div>
        </div>', __($theme->Name, 'navthemes','star-law-firm-lite'), 'https://www.navthemes.com/free-wordpress-theme/star-law-firm-pro-wordpress-theme/'),
        'priority'    => 11,
    ) );

		


	/*=================================
		Sample Content	
	 ================================= */
	
	Kirki::add_section( 'required_settings', array(
		'title'          => __( 'Sample Content', 'star-law-firm-lite' ), 
		'priority'       => 2,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'star-law-firm-lite', array(
				'section'  => 'required_settings',
				'type'     => 'custom',
				'priority' => 10,
				'default'  =>sprintf('<div><h3>Once you have installed and activated all recommended plugins, to setup your theme look like demo, Please download  <a target="_blank" href="%s">this</a> file and import it in customizer export/import and <a target="_blank" href="%s">this</a> file and import it in dashboard. If you\'re not sure how to do that, Please check this <a target="_blank" href="%s">tutorial</a></h3>
		</div>
		<div id="navthemes_maintenance">
		 <a target="_blank" href="https://docs.navthemes.com/docs/lawfirm-lite" class="button button-primary button_70">Documentation</a>
		 </div>', 'https://docs.navthemes.com/download/1897/', 'https://docs.navthemes.com/download/3329/', 'https://docs.navthemes.com/docs/lawfirm-lite/sample-content/'),
		'priority'    => 11,
	) );   
	

/*--------------------------------------------------------------------------
  --------------------------------------------------------------------------
			General Settings
--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
			
		
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 3,
		'title'       => __( 'General Settings', 'star-law-firm-lite' ),
		'description' => __( 'Manage General Setting from here', 'star-law-firm-lite' ),
	) );
	

	
	/*=================================
		General Section	
  	================================= */
  	
	/*=================================
		Site Logo 	
  	================================= */
  	
		Kirki::add_section( 'logo_settings', array(
			'title'          => __( 'Logo Settings', 'star-law-firm-lite' ),
			'description'    => __( 'From Here You Can Manage Manage Settings' , 'star-law-firm-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 20,
			'capability'     => 'edit_theme_options', 
		) );
	
		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'sitelogo',
				'label'    => __( 'Logo', 'star-law-firm-lite' ),
				'section'  => 'logo_settings',
				'type'     => 'image',
				'priority' => 21,
				'default'  => '',
			 
			) );


/*=================================
	Banner Image setting	
  ================================= */

	Kirki::add_section( 'banner_image', array(
		'title'          => __( 'Header', 'star-law-firm-lite' ),
		'description'    => __( 'From here you can manage background image banner', 'star-law-firm-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 22,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'star-law-firm-lite', array(
		'settings' => 'home_banner_image',
		'label'    => __( 'Header Image', 'star-law-firm-lite' ),
		'section'  => 'banner_image',
		'type'        => 'image',
		'priority' => 23,
		'default'  => get_template_directory_uri() . '/assets/images/banner-img.jpg',
	) );



	/*=================================
		Top social Section	
  	================================= */


	Kirki::add_section( 'topsocial_settings', array(
		'title'          => __( 'Top Bar Settings', 'star-law-firm-lite' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'star-law-firm-lite'),
		'panel'          => 'general_settings', 
		'priority'       => 22,
		'capability'     => 'edit_theme_options', 
	) );


		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topcontact_number',
				'label'    => __( 'Contact Number ', 'star-law-firm-lite' ),
				'section'  => 'topsocial_settings',
				'type'     => 'text',
				'priority' => 22,
				'default'  => '',
			) );

		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topcontact_email',
				'label'    => __( 'Contact Email ', 'star-law-firm-lite' ),
				'section'  => 'topsocial_settings',
				'type'     => 'text',
				'priority' => 22,
				'default'  => '',
			) );
		
		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'topfooterfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'topsocial_settings',
                'type'     => 'toggle',
                'priority' => 23,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topsocial_facebook',
				'label'    => __( 'Facebook', 'star-law-firm-lite' ),
				'section'  => 'topsocial_settings',
				'type'     => 'url',
				'priority' => 23,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'topfootertwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'topsocial_settings',
                'type'     => 'toggle',
                'priority' => 23,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topsocial_twitter',
				'label'    => __( 'Twiiter', 'star-law-firm-lite' ),
				'section'  => 'topsocial_settings',
				'type'     => 'url',
				'priority' => 23,
				'default'  => '#',
			) );


		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'topinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'topsocial_settings',
                'type'     => 'toggle',
                'priority' => 23,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topsocial_instagram',
				'label'    => __( 'Instagram', 'star-law-firm-lite'),
				'section'  => 'topsocial_settings',
				'type'     => 'url',
				'priority' => 24,
				'default'  => '#',
			) );

		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'topyoutubeplayonoff',
                'label'    => __( 'Instagram Active/Inactive', 'star-law-firm-lite'),
                'section'  => 'topsocial_settings',
                'type'     => 'toggle',
                'priority' => 24,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'topsocial_youtubeplay',
				'label'    => __( 'YouTube Play', 'star-law-firm-lite' ),
				'section'  => 'topsocial_settings',
				'type'     => 'url',
				'priority' => 24,
				'default'  => '#',
			) );

  	/*=================================
		Footer social Section	
  	================================= */

	Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Footer Social Settings', 'star-law-firm-lite' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'star-law-firm-lite'),
		'panel'          => 'general_settings', 
		'priority'       => 24,
		'capability'     => 'edit_theme_options', 
	) );
		
	Kirki::add_field( 'star-law-firm-lite', array(
            'settings' => 'footerfacebookonoff',
            'label'    => __( 'Facebook Active/Inactive', 'star-law-firm-lite'),
            'section'  => 'social_settings',
            'type'     => 'toggle',
            'priority' => 25,
            'default'  => 1,           
        ) );

	Kirki::add_field( 'star-law-firm-lite', array(
			'settings' => 'social_facebook',
			'label'    => __( 'Facebook', 'star-law-firm-lite' ),
			'section'  => 'social_settings',
			'type'     => 'url',
			'priority' => 26,
			'default'  => '#',
		) );
	
	Kirki::add_field( 'star-law-firm-lite', array(
            'settings' => 'footertwitteronoff',
            'label'    => __( 'Twitter Active/Inactive', 'star-law-firm-lite'),
            'section'  => 'social_settings',
            'type'     => 'toggle',
            'priority' => 27,
            'default'  => 1,           
        ) );

	Kirki::add_field( 'star-law-firm-lite', array(
			'settings' => 'social_twitter',
			'label'    => __( 'Twiiter', 'star-law-firm-lite' ),
			'section'  => 'social_settings',
			'type'     => 'url',
			'priority' => 28,
			'default'  => '#',
		) );


	Kirki::add_field( 'star-law-firm-lite', array(
            'settings' => 'footerinstagramonoff',
            'label'    => __( 'Instagram Active/Inactive', 'star-law-firm-lite'),
            'section'  => 'social_settings',
            'type'     => 'toggle',
            'priority' => 29,
            'default'  => 1,           
        ) );

	Kirki::add_field( 'star-law-firm-lite', array(
			'settings' => 'social_instagram',
			'label'    => __( 'Instagram', 'star-law-firm-lite'),
			'section'  => 'social_settings',
			'type'     => 'url',
			'priority' => 30,
			'default'  => '#',
		) );
	
	

  	/*=================================
		Footer social Section	
  	================================= */


	Kirki::add_section( 'social_settings', array(
		'title'          => __( 'Footer Social Settings', 'star-law-firm-lite' ),
		'description'    => __( 'From Here You Can Manage Some Social Settings' , 'star-law-firm-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 24,
		'capability'     => 'edit_theme_options', 
	) );
		
		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'footerfacebookonoff',
                'label'    => __( 'Facebook Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 25,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'social_facebook',
				'label'    => __( 'Facebook', 'star-law-firm-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 26,
				'default'  => '#',
			) );
		
		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'footertwitteronoff',
                'label'    => __( 'Twitter Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 27,
                'default'  => 1,           
            ) );

		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'social_twitter',
				'label'    => __( 'Twiiter', 'star-law-firm-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 28,
				'default'  => '#',
			) );


		Kirki::add_field( 'star-law-firm-lite', array(
                'settings' => 'footerinstagramonoff',
                'label'    => __( 'Instagram Active/Inactive', 'star-law-firm-lite' ),
                'section'  => 'social_settings',
                'type'     => 'toggle',
                'priority' => 29,
                'default'  => 1,           
            ) );
	
		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'social_instagram',
				'label'    => __( 'Instagram', 'star-law-firm-lite' ),
				'section'  => 'social_settings',
				'type'     => 'url',
				'priority' => 30,
				'default'  => '#',
			) );

			/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Footer Text Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'footer_text', array(
		'title'          => __( 'Footer Copyright Text Setting', 'star-law-firm-lite' ),
		'description'    => __( 'From here you can manage text of footer', 'star-law-firm-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'footer_theme_text',
				'label'    => __( 'Field', 'star-law-firm-lite' ),
				'section'  => 'footer_text',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
			) );	

/*=================================
	Home Page Panel	
  ================================= */

	Kirki::add_panel( 'homepage', array(
		'priority'    => 4,
		'title'       => __( 'Front Page Settings', 'star-law-firm-lite' ),
		'description' => __( 'Manage Front Page Setting from here', 'star-law-firm-lite' ),
	) );
	

	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Banner Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

			Kirki::add_section( 'homepage_banner', array(
				'title'          => __( 'Header Content Setting', 'star-law-firm-lite' ),
				'description'    => __( 'From here you can manage Title and Text of banner', 'star-law-firm-lite' ),
				'panel'          => 'homepage', 
				'priority'       => 31,
				'capability'     => 'edit_theme_options',
			) );

			Kirki::add_field( 'star-law-firm-lite', array(
						'settings' => 'banner_title',
						'label'    => __( 'Heading', 'star-law-firm-lite' ),
						'section'  => 'homepage_banner',
						'type'     => 'textarea',
						'priority' => 31,
						'default'  => '',
					) );
			
				
			Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'banner_text',
				'label'    => __( 'Text', 'star-law-firm-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'textarea',
				'priority' => 32,
				'default'  => '',
			) );

		
			Kirki::add_field( 'star-law-firm-lite', array(
				'type'        => 'repeater',
				'label'       => esc_attr__( 'Repeater Control', 'star-law-firm-lite' ),
				'section'     => 'homepage_banner',
				'settings' => 'homepage_about_section',
				'priority'    => 34,
				
				'row_label' => array(
					'type' => 'text',
					'value' => esc_attr__('', 'star-law-firm-lite' ),
				),

				'choices'     => array(
							'save_as' => 'array',
							),

				'button_label' => esc_attr__('"Add new"', 'star-law-firm-lite' ),

				
				'fields' => array(
				'about_image'  => array(
							'type' => 'image',
							'label'       => esc_attr__( 'Image', 'star-law-firm-lite' ),
							'section'     => 'homepage_banner',
							'priority'    => 35,
							'default'  => '',
						),	

				'about_text'  => array(
						'label'    =>esc_attr__( 'Content', 'star-law-firm-lite' ),
						'description' => esc_attr__( 'This will be the label of content field', 'star-law-firm-lite' ),
						'section'  => 'homepage_banner',
						'type'     => 'textarea',
						'priority' => 36,
						'default'  => '', 
					),

				'about_button_text'  => array(
					'label'    =>esc_attr__( 'Button Text', 'star-law-firm-lite' ),
					'description' => esc_attr__( 'This will be button text', 'star-law-firm-lite' ),
					'section'  => 'homepage_banner',
					'type'     => 'text',
					'priority' => 37,
					'default'  => '', 
				),

				'button_link'  => array(
			            'label'    => esc_attr__( 'Link', 'star-law-firm-lite' ),
			            'section'  => 'homepage_banner',
			            'type'     => 'text',
			            'priority' => 38,
			            'default'  => '#',  
					),
				)
			) );



       /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Capablities Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_capablities', array(
			'title'          => __( 'Capablities Section Setting' , 'star-law-firm-lite' ),
			'description'    => __( 'From here you can manage Home Page Capablities section' , 'star-law-firm-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 47,
			'capability'     => 'edit_theme_options',
		) );

		Kirki::add_field( 'star-law-firm-lite', array(
            'settings' => 'capablitiessectiononoff',
            'label'    => __( 'Section ON/OFF', 'star-law-firm-lite' ),
            'section'  => 'homepage_capablities',
            'type'     => 'toggle',
            'priority' => 48,
            'default'  => 1,           
        ) );

		Kirki::add_field( 'star-law-firm-lite', array(
        'settings' => 'homepage_capablities_bgimage',
        'label'    => __( 'Background Image', 'star-law-firm-lite' ),
        'section'  => 'homepage_capablities',
        'type'     => 'image',
        'priority' => 49,
        'default'  => get_template_directory_uri() . '',
		) );         

  		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'homepage_capablities_title',
				'label'    => __( 'Heading', 'star-law-firm-lite' ),
				'section'  => 'homepage_capablities',
				'type'     => 'textarea',
				'priority' => 50,
				'default'  => __('', 'star-law-firm-lite'), 
			  
			) );
  		
  		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'homepage_capablities_text',
				'label'    => __( 'Content', 'star-law-firm-lite' ),
				'section'  => 'homepage_capablities',
				'type'     => 'textarea',
				'priority' => 51,
				'default'  => __('', 'star-law-firm-lite'), 
			) );

  		Kirki::add_field( 'star-law-firm-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'star-law-firm-lite' ),
	'section'     => 'homepage_capablities',
	'settings' => 'homepage_capablities_section',
	'priority'    => 52,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Capablities', 'star-law-firm-lite' ),
	),

	'choices'     => array(
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'star-law-firm-lite' ),

	
	'fields' => array(
	'capablities_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Image', 'star-law-firm-lite' ),
				'section'     => 'homepage_capablities',
				'priority' => 53,
				'default'  => '',
			),	

	'capablities_text'  => array(
			'label'    =>esc_attr__( 'Content', 'star-law-firm-lite' ),
			'description' => esc_attr__( 'This will be the label of content field', 'star-law-firm-lite' ),
			'section'  => 'homepage_capablities',
			'type'     => 'textarea',
			'priority' => 54,
			'default'  => '', 
		),

	)
) );


  		  	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Testimonials Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_testimonials', array(
			'title'          => __( 'Testimonials Heading Section' , 'star-law-firm-lite' ),
			'description'    => __( 'From here you can change the heading section of testimonials' , 'star-law-firm-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 99,
			'capability'     => 'edit_theme_options',
		) );



  		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'homepage_testimonial_title',
				'label'    => __( 'Heading', 'star-law-firm-lite' ),
				'section'  => 'homepage_testimonials',
				'type'     => 'textarea',
				'priority' => 103,
				'default'  => __('', 'star-law-firm-lite'), 
			  
			) );





  	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Why Choose Us Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_news', array(
			'title'          => __( 'Why Choose Us Section' , 'star-law-firm-lite' ),
			'description'    => __( 'From here you can manage Home Page News section' , 'star-law-firm-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 113,
			'capability'     => 'edit_theme_options',
		) );

		Kirki::add_field( 'star-law-firm-lite', array(
            'settings' => 'newssectiononoff',
            'label'    => __( 'Section ON/OFF', 'star-law-firm-lite' ),
            'section'  => 'homepage_news',
            'type'     => 'toggle',
            'priority' => 114,
            'default'  => 1,           
        ) );

		Kirki::add_field( 'star-law-firm-lite', array(
        'settings' => 'homepage_news_bgimage',
        'label'    => __( 'Background Image', 'star-law-firm-lite' ),
        'section'  => 'homepage_news',
        'type'     => 'image',
        'priority' => 115,
        'default'  => get_template_directory_uri() . '',
		) );         

  		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'homepage_news_title',
				'label'    => __( 'Heading', 'star-law-firm-lite' ),
				'section'  => 'homepage_news',
				'type'     => 'text',
				'priority' => 116,
				'default'  => __('', 'star-law-firm-lite'), 
			  
			) );
  		
  		Kirki::add_field( 'star-law-firm-lite', array(
				'settings' => 'homepage_news_text',
				'label'    => __( 'Content', 'star-law-firm-lite' ),
				'section'  => 'homepage_news',
				'type'     => 'textarea',
				'priority' => 117,
				'default'  => __('', 'star-law-firm-lite'), 
			) );


  	Kirki::add_field( 'star-law-firm-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'star-law-firm-lite' ),
	'section'     => 'homepage_news',
	'settings' => 'homepage_news_section',
	'priority'    => 118,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Why Choose Us', 'star-law-firm-lite' ),
	),

	'choices'     => array(
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'star-law-firm-lite' ),

	
	'fields' => array(
	'news_image'  => array(
				'type' => 'image',
				'label'       => esc_attr__( 'Image', 'star-law-firm-lite' ),
				'section'     => 'homepage_news',
				'priority' => 119,
				'default'  => '',
			),	

	'news_heading'  => array(
			'label'    =>esc_attr__( 'Heading', 'star-law-firm-lite' ),
			'description' => esc_attr__( 'This will be heading', 'star-law-firm-lite' ),
			'section'  => 'homepage_news',
			'type'     => 'textarea',
			'priority' => 120,
			'default'  => '', 
		),

	'news_content'  => array(
			'label'    =>esc_attr__( 'Content', 'star-law-firm-lite' ),
			'description' => esc_attr__( 'This will be the label of content field', 'star-law-firm-lite' ),
			'section'  => 'homepage_news',
			'type'     => 'textarea',
			'priority' => 121,
			'default'  => '', 
		),
	'news_buttontext'  => array(
		'label'    =>esc_attr__( 'Button Text', 'star-law-firm-lite' ),
		'description' => esc_attr__( 'This will be button text', 'star-law-firm-lite' ),
		'section'  => 'homepage_news',
		'type'     => 'textarea',
		'priority' => 122,
		'default'  => '', 
	),
	'news_buttonlink'  => array(
			'label'    =>esc_attr__( 'Button Link', 'star-law-firm-lite' ),
			'description' => esc_attr__( 'This will be button link', 'star-law-firm-lite' ),
			'section'  => 'homepage_news',
			'type'     => 'textarea',
			'priority' => 123,
			'default'  => '', 
		),

	)
) );




add_action( 'customize_register', 'navthemes_move_widget_area' );
function navthemes_move_widget_area () {
  global $wp_customize;

 // sidebar-2 is your sidebar ID
  $footer_widgets_section2 = (object) $wp_customize->get_section( 'sidebar-widgets-testimonials_widgets' );
  // general_settings - Panel ID
  $footer_widgets_section2->priority = 10;
  $footer_widgets_section2->panel = '';

 
     // sidebar-2 is your sidebar ID
  $footer_widgets_section8 = (object) $wp_customize->get_section( 'sidebar-widgets-team_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section8->priority = 8;
  $footer_widgets_section8->panel = '';

   // sidebar-2 is your sidebar ID
  $footer_widgets_section9 = (object) $wp_customize->get_section( 'sidebar-widgets-partners_widget_' );
  // general_settings - Panel ID 
   $footer_widgets_section9->priority = 105;
  $footer_widgets_section9->panel = 'homepage';
  
 // sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-services_widget_' );
  // general_settings - Panel ID 
   $footer_widgets_section6->priority = 9;
  $footer_widgets_section6->panel = '';


// sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section6->priority = 40;
  $footer_widgets_section6->panel = 'homepage';

    // sidebar-2 is your sidebar ID
  $footer_widgets_section5 = (object) $wp_customize->get_section( 'sidebar-widgets-call_action_widget' );
  // general_settings - Panel ID 
   $footer_widgets_section5->priority = 11;
  $footer_widgets_section5->panel = '';
}

// add if other functions available
if(file_exists('add-on.php')) include('add-on.php');
