{if !$location} {var $location = ''} {/if}

{if $wp->isAttachment}

	{if $wp->hasPreviousPost}
	<nav class="nav-single {$location}" role="navigation">
		{capture $prev}{!_x '%s Return to entry', 'previous post' |printf: '<span class="meta-nav">&larr;</span>'}{/capture}
		<span class="nav-previous">{prevPostLink $prev}</span>
	</nav>
	{/if}

{elseif $wp->isSingle}

	{if $wp->hasPreviousPost or $wp->hasNextPost}
	<nav class="nav-single {$location}" role="navigation">
		{if $wp->hasPreviousPost}
			{capture $prev}{!__ '<span class="meta-nav"><!-- --></span><span class="nav-text">Previous</span>'}{/capture}
			<span class="nav-previous">{prevPostLink $prev}</span>
		{else}
			<span class="nolink">
			<span class="nav-previous"><span class="meta-nav"></span><span class="nav-text">{__ 'Previous'}</span></span>
			</span>
		{/if}

		{if $post->hasImage && $location == "pagination-above"}

			{if $wp->isSingular(portfolio-item) || $wp->isSingular(job-offer)}

			{else}
			<div class="entry-thumbnail">
				{if $post->hasImage}
					<div class="entry-thumbnail-wrap">
						<a href="{$post->imageUrl}" class="thumb-link">
							<span class="entry-thumbnail-icon">
								<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}" alt="{__ 'Entry Thumbnail'}">
							</span>
						</a>
					</div>
				{/if}
			</div>
			{/if}
		{/if}

		{if $wp->hasNextPost}
			{capture $next}{!__ '<span class="meta-nav"><!-- --></span><span class="nav-text">Next</span>'}{/capture}
			<span class="nav-next">{nextPostLink $next}</span>
		{else}
			<span class="nolink">
			<span class="nav-next"><span class="meta-nav"></span><span class="nav-text">{__ 'Next'}</span></span>
			</span>
		{/if}
	</nav>
	{else}
		{if $post->hasImage && $location == "pagination-above"}

			{if $wp->isSingular(portfolio-item) || $wp->isSingular(job-offer)}

			{else}
			<div class="entry-thumbnail">
				{if $post->hasImage}
					<div class="entry-thumbnail-wrap">
						<a href="{$post->imageUrl}" class="thumb-link">
							<span class="entry-thumbnail-icon">
								<img src="{imageUrl $post->imageUrl, width => 1000, height => 500, crop => 1}" alt="{__ 'Entry Thumbnail'}">
							</span>
						</a>
					</div>
				{/if}
			</div>
			{/if}
		{/if}
	{/if}

{elseif !$wp->isSingular}

	{if $wp->willPaginate}
	<nav class="nav-pagination" role="navigation">

		{capture $prev}{!__ '%s Newer posts' |printf: '<span class="meta-nav">&larr;</span>'}{/capture}
		{capture $next}{!__ 'Older posts %s' |printf: '<span class="meta-nav">&rarr;</span>'}{/capture}

		<span class="nav-previous">{prevPostsLink $prev}</span>
		{pagination}
		<span class="nav-next">{nextPostsLink $next}</span>
	</nav>
	{/if}

{else}
	{* fallback *}
	{if $wp->willPaginate}
	<nav class="nav-posts {$location}" role="navigation">
		{capture $prev}{!__ '%s Newer posts' |printf: '<span class="meta-nav">&larr;</span>'}{/capture}
		{capture $next}{!__ 'Older posts %s' |printf: '<span class="meta-nav">&rarr;</span>'}{/capture}

		<span class="nav-previous">{prevPostsLink $prev}</span>
		<span class="nav-next">{nextPostsLink $next}</span>
	</nav>
	{/if}
{/if}