<!doctype html>
<!--[if IE 8]>
<html {languageAttributes}  class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass} ie ie8">
<![endif]-->
<!--[if !(IE 7) | !(IE 8)]><!-->
<html {languageAttributes} class="lang-{$currentLang->locale} {$options->layout->custom->pageHtmlClass}">
<!--<![endif]-->
<head>
	<meta charset="{$wp->charset}">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="{$wp->pingbackUrl}">
	{if $options->theme->general->favicon != ""}
		<link href="{$options->theme->general->favicon}" rel="icon" type="image/x-icon" />
	{/if}

	{includePart parts/seo}

	{googleAnalytics $options->theme->google->analyticsTrackingId, $options->theme->google->anonymizeIp}

	{wpHead}

	{!$options->theme->header->customJsCode}
</head>

<body {!$wp->bodyHtmlClass}>
	{* usefull for inline scripts like facebook social plugins scripts, etc... *}
	{doAction ait-html-body-begin}

	<div id="page" class="hfeed page-container">

		{if $options->theme->header->headerType == 'header-two'}
			<header id="masthead" class="site-header" role="banner" data-type="two">
				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<h1 class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></h1>
						{/if}
						<p class="site-description">{$wp->description}</p>

						<div class="site-tools-wrap">
							{includePart parts/languages-switcher}
							{includePart "parts/woocommerce-cart"}
						</div>

					</div>

				</div>

				<div class="site-wrap">
					<div class="grid-main">
						<div class="menu-container">
							<nav class="main-nav" role="navigation">
								<div class="main-nav-wrap">
									<h3 class="menu-toggle">{__ 'Menu'}</h3>
									{menu main}
								</div>
							</nav>

                        <div class="site-tools">

							{includePart parts/social-icons}

						</div>

                        </div>

					</div>
				</div>
			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'header-three'}
			<header id="masthead" class="site-header" role="banner" data-type="three">


				<div class="header-container grid-main">
					<div class="site-logo">
						{if $options->theme->header->logo}
						<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
						{else}
						<h1 class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></h1>
						{/if}
						<div class="table">
							<div class="site-desc-wrap">
								<p class="site-description">{$wp->description}</p>
							</div>
						</div>
					</div>

					<div class="site-search">
						{searchForm}
					</div>

					<div class="site-tools">
						{includePart parts/social-icons}
					</div>
				</div>

				<div class="site-wrap">
					<div class="grid-main">
						<div class="menu-container">
							<nav class="main-nav" role="navigation">
								<div class="main-nav-wrap">
									<h3 class="menu-toggle">{__ 'Menu'}</h3>
									{menu main}
								</div>
							</nav>

						<div class="site-tools-wrap">
							{includePart parts/languages-switcher}
							{includePart "parts/woocommerce-cart"}
						</div>

						</div>

					</div>
				</div>

			</header><!-- #masthead -->
		{elseif $options->theme->header->headerType == 'header-four'}
			<header id="masthead" class="site-header" role="banner" data-type="four">

				<div class="grid-main">
					<div class="site-tools">

						<div class="site-tagline">
							{!$wp->description}
						</div>


						{includePart parts/social-icons}
					</div>
				</div>

				<div class="site-wrap">
					<div class="header-container grid-main">
						<div class="site-logo">
							{if $options->theme->header->logo}
							<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
							{else}
							<h1 class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></h1>
							{/if}
						</div>

						<div class="menu-container">

							<nav class="main-nav" role="navigation">

                             <div class="main-nav-float">

								<div class="main-nav-wrap">
									<h3 class="menu-toggle">{__ 'Menu'}</h3>
									{menu main}
								</div>

								<div class="site-tools-wrap">
									{includePart parts/languages-switcher}
									{includePart "parts/woocommerce-cart"}
								</div>

                             </div>
							</nav>

                        </div>
					</div>
				</div>
			</header><!-- #masthead -->
		{else}
			<header id="masthead" class="site-header" role="banner" data-type="one">
				<div class="grid-main">
					<div class="header-container">
						<div class="site-logo">
							{if $options->theme->header->logo}
							<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
							{else}
							<h1 class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></h1>
							{/if}
							<p class="site-description">{$wp->description}</p>
						</div>

					</div>

					<div class="menu-container">

							<nav class="main-nav" role="navigation">

                                <div class="main-nav-float">

								 {*<a class="assistive-text" href="#content" title="{__ 'Skip to content'}">{__ 'Skip to content'}</a> *}
								<div class="main-nav-wrap">
									<h3 class="menu-toggle">{__ 'Menu'}</h3>
									{menu main}
								</div>

								<div class="site-tools-wrap">
									{includePart parts/languages-switcher}
									{includePart "parts/woocommerce-cart"}
								</div>

                                </div>

							</nav>



				    </div>
                </div>
			</header><!-- #masthead -->
		{/if}

        <div class="sticky-menu menu-container" >
			<div class="grid-main">
				<div class="site-logo">
					{if $options->theme->header->logo}
					<a href="{$homeUrl}" title="{$wp->name}" rel="home"><img src="{$options->theme->header->logo}" alt="logo"></a>
					{else}
					<div class="site-title"><a href="{$homeUrl}" title="{$wp->name}" rel="home">{$wp->name}</a></div>
					{/if}
				</div>
				<nav class="main-nav">
					<!-- wp menu here -->
				</nav>
			</div>
		</div>
