<?php
/**
 * @package   Astroid Framework
 * @author    JoomDev https://www.joomdev.com
 * @copyright Copyright (C) 2009 - 2018 JoomDev.
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */
defined('JPATH_PLATFORM') or die;
jimport('astroid.framework.constants');

/**
 * Form Field class for the Joomla Platform.
 * Supports a generic list of options.
 *
 * @since  11.1
 */
class JFormFieldAstroidpreloaders extends JFormField {

   /**
    * The form field type.
    *
    * @var    string
    * @since  11.1
    */
   protected $type = 'astroidpreloaders';

   /**
    * Method to get the field input markup for a generic list.
    * Use the multiple attribute to enable multiselect.
    *
    * @return  string  The field input markup.
    *
    * @since   3.7.0
    */
   protected function getInput() {
      $selected = AstroidFrameworkConstants::$preloaders['circle'];
      if (empty($this->value)) {
         $this->value = $selected['name'];
      }
      $html = '<div class="astroid-preloader-field d-inline-block">';
      $html .= '<span class="astroid-preloader-field-select"></span>';
      $html .= '<input type="hidden" name="' . $this->name . '" value="' . $this->value . '" />';

      $html .= '<div class="astroid-preloaders-selector">';
      $html .= '<div class="overlay"></div>';
      $html .= '<div class="head">Select Preloader Style<span class="astroid-preloaders-selector-exit-fs"><i class="fa fa-times"></i></span></div>';
      $html .= '<div class="body">';
      $html .= '<div class="">';

      foreach (AstroidFrameworkConstants::$preloaders as $preloader) {
         $html .= '<div class="astroid-preloader-select" data-value="' . $preloader['name'] . '">';
         $html .= $preloader['code'];
         $html .= '</div>';
         if ($this->value == $preloader['name']) {
            $selected = $preloader;
         }
      }
      $html .= '</div>';
      $html .= '</div>';
      $html .= '</div>';
      $html .= '<div class="select-preloader">';
      $html .= $selected['code'];
      $html .= '</div>';
      $html .= '<div class="clearfix"></div></div>';

      return $html;
   }

}
