<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Create a shortcut for params.
$params = $this->item->params;
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
$canEdit = $this->item->params->get('access-edit');
$info    = $params->get('info_block_position', 0);

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (JLanguageAssociations::isEnabled() && $params->get('show_associations'));

?>

<div class="card card-blog shadow-lg mb-5 mb-lg-0">
	<div class="image-wrap position-relative">
		<?php echo JLayoutHelper::render('joomla.content.intro_image_blog', $this->item); ?>
		<a href="<?php echo  JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)); ?>" class="overly position-absolute text-center d-flex justify-content-center align-items-center text-white">
			<i class="fab fa-telegram-plane"></i>
		</a>
		
	</div>
	<div class="card-body">
		<h5 class="card-title">
			<a href="<?php echo  JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)); ?>">
				<?php if (!$params->get('show_intro')) : ?>
					<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
					<?php echo $this->item->event->afterDisplayTitle; ?>
					<?php echo $this->item->title; ?>
				<?php endif; ?>
			</a>
		</h5>
		<sapn class="card-text">
			<?php echo $this->item->event->beforeDisplayContent; ?>
			<?php echo $this->item->introtext; ?>
			<?php echo $this->item->event->afterDisplayContent; ?>
		</span>
		<p class="card-text">
			<?php if ($params->get('show_readmore') && $this->item->readmore) :
				if ($params->get('access-view')) :
					$link = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language));
				else :
					$menu = JFactory::getApplication()->getMenu();
					$active = $menu->getActive();
					$itemId = $active->id;
					$link = new JUri(JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
					$link->setVar('return', base64_encode(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)));
				endif; ?>

				<?php echo JLayoutHelper::render('joomla.content.readmore_blog', array('item' => $this->item, 'params' => $params, 'link' => $link)); ?>

			<?php endif; ?>
		</p>
	</div>
	<div class="card-footer">
		<small class="text-muted">
			 <!-- Blog Info Starts Here -->
		<?php // Todo Not that elegant would be nice to group the params ?>
		<?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
			|| $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category') || $params->get('show_author') || $assocParam); ?>

		<?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
		  <?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
			<?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'above')); ?>
			<?php if ($info == 0 && $params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
				<?php echo JLayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ($useDefList && ($info == 1 || $info == 2)) : ?>
			<?php // Todo: for Joomla4 joomla.content.info_block.block can be changed to joomla.content.info_block ?>
			<?php echo JLayoutHelper::render('joomla.content.info_block.block', array('item' => $this->item, 'params' => $params, 'position' => 'below')); ?>
			<?php if ($params->get('show_tags', 1) && !empty($this->item->tags->itemTags)) : ?>
				<?php echo JLayoutHelper::render('joomla.content.tags', $this->item->tags->itemTags); ?>
			<?php endif; ?>
		<?php endif; ?>
	  <!-- Blog Info Ends Here -->
		</small>
	</div>
</div>