<?php
/*
Plugin Name: Public Opinion Lite theme-specific plugin
Description: Features required by the Public Opinion Lite theme.
Plugin URI: https://www.cssigniter.com/ignite/themes/public-opinion-lite/
Version: 1.0.1
License: GNU General Public License v2 or later
Author: The CSSIgniter Team
Author URI: https://www.cssigniter.com/
License: GNU General Public License v2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain: public-opinion-lite-plugin
*/

if ( ! defined( 'PUBLIC_OPINION_LITE_PLUGIN_VERSION' ) ) {
	define( 'PUBLIC_OPINION_LITE_PLUGIN_VERSION', '1.0.1' );
}

if ( ! defined( 'PUBLIC_OPINION_LITE_PLUGIN_DIR' ) ) {
	define( 'PUBLIC_OPINION_LITE_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'PUBLIC_OPINION_LITE_PLUGIN_DIR_URL' ) ) {
	define( 'PUBLIC_OPINION_LITE_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
}

add_action( 'after_setup_theme', 'public_opinion_lite_plugin_setup' );
function public_opinion_lite_plugin_setup() {
	load_plugin_textdomain( 'public-opinion-lite-plugin', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

}

function public_opinion_lite_plugin_scripts() {

	wp_register_style( 'public-opinion-lite-plugin-footer-style', false );

}
add_action( 'wp_enqueue_scripts', 'public_opinion_lite_plugin_scripts' );


/**
 * Enqueue admin scripts and styles.
 */
function public_opinion_lite_plugin_admin_scripts( $hook ) {

	if ( ! wp_script_is( 'alpha-color-picker', 'enqueued' ) && ! wp_script_is( 'alpha-color-picker', 'registered' ) ) {
		wp_register_style( 'alpha-color-picker', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/base/assets/vendor/alpha-color-picker/alpha-color-picker.css', array(
			'wp-color-picker',
		), '1.0.0' );
		wp_register_script( 'alpha-color-picker', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/base/assets/vendor/alpha-color-picker/alpha-color-picker.js', array(
			'jquery',
			'wp-color-picker',
		), '1.0.0', true );
	}

	wp_register_style( 'public-opinion-lite-plugin-post-meta', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/base/assets/css/post-meta.css', array(
		'alpha-color-picker',
	), PUBLIC_OPINION_LITE_PLUGIN_VERSION );
	wp_register_script( 'public-opinion-lite-plugin-post-meta', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/base/assets/js/post-meta.js', array(
		'media-editor',
		'jquery',
		'jquery-ui-sortable',
		'alpha-color-picker',
	), PUBLIC_OPINION_LITE_PLUGIN_VERSION, true );

	$settings = array(
		'ajaxurl'             => admin_url( 'admin-ajax.php' ),
		'tSelectFile'         => esc_html__( 'Select file', 'public-opinion-lite-plugin' ),
		'tSelectFiles'        => esc_html__( 'Select files', 'public-opinion-lite-plugin' ),
		'tUseThisFile'        => esc_html__( 'Use this file', 'public-opinion-lite-plugin' ),
		'tUseTheseFiles'      => esc_html__( 'Use these files', 'public-opinion-lite-plugin' ),
		'tUpdateGallery'      => esc_html__( 'Update gallery', 'public-opinion-lite-plugin' ),
		'tLoading'            => esc_html__( 'Loading...', 'public-opinion-lite-plugin' ),
		'tPreviewUnavailable' => esc_html__( 'Gallery preview not available.', 'public-opinion-lite-plugin' ),
		'tRemoveImage'        => esc_html__( 'Remove image', 'public-opinion-lite-plugin' ),
		'tRemoveFromGallery'  => esc_html__( 'Remove from gallery', 'public-opinion-lite-plugin' ),
	);
	wp_localize_script( 'public-opinion-lite-plugin-post-meta', 'public_opinion_lite_plugin_PostMeta', $settings );


	wp_register_style( 'public-opinion-lite-repeating-fields', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/assets/css/repeating-fields.css', array(), PUBLIC_OPINION_LITE_PLUGIN_VERSION );
	wp_register_script( 'public-opinion-lite-repeating-fields', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/assets/js/repeating-fields.js', array(
		'jquery',
		'jquery-ui-sortable',
	), PUBLIC_OPINION_LITE_PLUGIN_VERSION, true );

	wp_register_script( 'public-opinion-lite-plugin-term-edit', untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR_URL ) . '/assets/js/term-edit.js', array(
		'jquery',
		'wp-color-picker',
	), PUBLIC_OPINION_LITE_PLUGIN_VERSION, true );



	//
	// Enqueue
	//
	if ( in_array( $hook, array( 'post.php', 'post-new.php' ), true ) ) {
		wp_enqueue_media();
		wp_enqueue_style( 'public-opinion-lite-plugin-post-meta' );
		wp_enqueue_script( 'public-opinion-lite-plugin-post-meta' );

		wp_enqueue_style( 'public-opinion-lite-repeating-fields' );
		wp_enqueue_script( 'public-opinion-lite-repeating-fields' );
	}

	if ( in_array( $hook, array( 'edit-tags.php', 'term.php' ), true ) ) {
		wp_enqueue_media();
		wp_enqueue_script( 'public-opinion-lite-plugin-term-edit' );
		wp_enqueue_style( 'wp-color-picker' );
	}


}
add_action( 'admin_enqueue_scripts', 'public_opinion_lite_plugin_admin_scripts' );


function public_opinion_lite_plugin_get_columns_classes( $columns ) {
	if ( function_exists( 'public_opinion_lite_get_columns_classes' ) ) {
		return public_opinion_lite_get_columns_classes( $columns );
	}

	switch ( intval( $columns ) ) {
		case 1:
			$classes = 'col-12';
			break;
		case 2:
			$classes = 'col-sm-6 col-12';
			break;
		case 3:
			$classes = 'col-lg-4 col-sm-6 col-12';
			break;
		case 4:
		default:
			$classes = 'col-xl-3 col-lg-4 col-sm-6 col-12';
			break;
	}

	// Filter name intentionally same to public_opinion_lite_get_columns_classes()
	return apply_filters( 'public_opinion_lite_get_columns_classes', $classes, $columns );
}

function public_opinion_lite_plugin_get_social_networks() {
	if ( function_exists( 'public_opinion_lite_get_social_networks' ) ) {
		return public_opinion_lite_get_social_networks();
	}

	// Filter name intentionally same to public_opinion_lite_get_social_networks()
	return apply_filters( 'public_opinion_lite_social_networks', array(
		array(
			'name'  => 'facebook',
			'label' => esc_html__( 'Facebook', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-facebook',
		),
		array(
			'name'  => 'twitter',
			'label' => esc_html__( 'Twitter', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-twitter',
		),
		array(
			'name'  => 'instagram',
			'label' => esc_html__( 'Instagram', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-instagram',
		),
		array(
			'name'  => 'snapchat',
			'label' => esc_html__( 'Snapchat', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-snapchat',
		),
		array(
			'name'  => 'bloglovin',
			'label' => esc_html__( 'Bloglovin', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-heart',
		),
		array(
			'name'  => 'pinterest',
			'label' => esc_html__( 'Pinterest', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-pinterest',
		),
		array(
			'name'  => 'youtube',
			'label' => esc_html__( 'YouTube', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-youtube',
		),
		array(
			'name'  => 'vimeo',
			'label' => esc_html__( 'Vimeo', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-vimeo',
		),
		array(
			'name'  => 'gplus',
			'label' => esc_html__( 'Google Plus', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-google-plus',
		),
		array(
			'name'  => 'linkedin',
			'label' => esc_html__( 'LinkedIn', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-linkedin',
		),
		array(
			'name'  => 'tumblr',
			'label' => esc_html__( 'Tumblr', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-tumblr',
		),
		array(
			'name'  => 'flickr',
			'label' => esc_html__( 'Flickr', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-flickr',
		),
		array(
			'name'  => 'dribbble',
			'label' => esc_html__( 'Dribbble', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-dribbble',
		),
		array(
			'name'  => 'wordpress',
			'label' => esc_html__( 'WordPress', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-wordpress',
		),
		array(
			'name'  => '500px',
			'label' => esc_html__( '500px', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-500px',
		),
		array(
			'name'  => 'soundcloud',
			'label' => esc_html__( 'Soundcloud', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-soundcloud',
		),
		array(
			'name'  => 'spotify',
			'label' => esc_html__( 'Spotify', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-spotify',
		),
		array(
			'name'  => 'vine',
			'label' => esc_html__( 'Vine', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-vine',
		),
		array(
			'name'  => 'tripadvisor',
			'label' => esc_html__( 'Trip Advisor', 'public-opinion-lite-plugin' ),
			'icon'  => 'fa-tripadvisor',
		),
	) );
}

function public_opinion_lite_plugin_get_hero_articles_layouts() {
	if ( function_exists( 'public_opinion_lite_get_hero_articles_layouts' ) ) {
		return public_opinion_lite_get_hero_articles_layouts();
	}

	return array();
}

function public_opinion_lite_plugin_get_hero_articles_layout_choices() {
	if ( function_exists( 'public_opinion_lite_get_hero_articles_layout_choices' ) ) {
		return public_opinion_lite_get_hero_articles_layout_choices();
	}

	$choices = array();

	foreach ( public_opinion_lite_plugin_get_hero_articles_layouts() as $key => $choice ) {
		$choices[ $key ] = $choice['title'];
	}

	return apply_filters( 'public_opinion_lite_plugin_hero_articles_layout_choices', $choices );
}

function public_opinion_lite_plugin_sanitize_hero_articles_layout( $value ) {
	if ( function_exists( 'public_opinion_lite_sanitize_hero_articles_layout' ) ) {
		return public_opinion_lite_sanitize_hero_articles_layout( $value );
	}


	$choices = public_opinion_lite_plugin_get_hero_articles_layout_choices();
	if ( array_key_exists( $value, $choices ) ) {
		return $value;
	}

	return '';
}


function public_opinion_lite_plugin_activated() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}

	flush_rewrite_rules();
}
register_activation_hook( __FILE__, 'public_opinion_lite_plugin_activated' );

function public_opinion_lite_plugin_deactivated() {
	if ( ! current_user_can( 'activate_plugins' ) ) {
		return;
	}

	flush_rewrite_rules();
}
register_deactivation_hook( __FILE__, 'public_opinion_lite_plugin_deactivated' );



/**
 * Term meta.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/term-meta.php';

/**
 * Custom fields / post types / taxonomies.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/custom-fields-post.php';
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/custom-fields-page.php';


/**
 * Standard helper functions.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/helpers.php';

/**
 * Standard sanitization functions.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/sanitization.php';

/**
 * Post meta helpers.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/post-meta.php';
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/post-meta-title-subtitle.php';
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/post-meta-hero.php';
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/base/post-meta-sidebar.php';

/**
 * User fields.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/user-meta.php';

/**
 * Theme-specific shortcodes.
 */
require untrailingslashit( PUBLIC_OPINION_LITE_PLUGIN_DIR ) . '/shortcodes.php';
