<?php get_header(); ?>

<?php
	$title = get_theme_mod( 'title_search', __( 'Search results', 'public-opinion-lite' ) );

	global $wp_query;
	$found = intval( $wp_query->found_posts );
	/* translators: %d is the number of search results. */
	$subtitle = esc_html( sprintf( _n( '%d result found.', '%d results found.', $found, 'public-opinion-lite' ), $found ) );
?>

<div class="page-hero">
	<div class="container">
		<div class="row">
			<div class="col-12">
				<div class="page-hero-content">
					<h1 class="page-hero-title"><?php echo esc_html( $title ); ?></h1>
					<?php if ( $subtitle ) : ?>
						<p class="page-hero-subtitle"><?php echo wp_kses( $subtitle, public_opinion_lite_get_allowed_tags( 'guide' ) ); ?></p>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<main class="main">
	<div class="container">
		<div class="row">
			<div class="<?php public_opinion_lite_the_container_classes(); ?>">

				<?php
					if ( have_posts() ) :

						// Disable showing the posts' primary category. We're listing a category anyway.
						$priority = has_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category' );
						if ( $priority > 0 ) {
							remove_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category', $priority );
						}

						?>
						<div class="row row-items">

							<?php while ( have_posts() ) : the_post(); ?>

								<div class="<?php echo esc_attr( public_opinion_lite_get_columns_classes( 1 ) ); ?>">

									<?php get_template_part( 'template-parts/entry-items/media', get_post_format() ); ?>

								</div>

							<?php endwhile; ?>

						</div>
						<?php

						// Re-enable the primary category (if previously disabled).
						if ( $priority > 0 ) {
							add_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category', $priority );
						}


						public_opinion_lite_posts_pagination();

					else :

						get_template_part( 'template-parts/article', 'none' );

					endif;
				?>

			</div>

			<?php get_sidebar(); ?>
		</div>
	</div>
</main>

<?php get_footer();
