<?php
if ( ! class_exists( 'CI_Widget_Home_Featured_Posts' ) ) :
	class CI_Widget_Home_Featured_Posts extends WP_Widget {

		protected $defaults = array(
			'category' => '',
			'layout'   => 'two-posts',
		);

		function __construct() {
			$widget_ops  = array( 'description' => esc_html__( 'Homepage widget. Displays a hero section of featured posts, optionally from a specific category.', 'public-opinion-lite' ) );
			$control_ops = array();
			parent::__construct( 'ci-home-featured-posts', esc_html__( 'Theme (home) - Featured Posts', 'public-opinion-lite' ), $widget_ops, $control_ops );
		}

		function widget( $args, $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$id            = isset( $args['id'] ) ? $args['id'] : '';
			$before_widget = $args['before_widget'];
			$after_widget  = $args['after_widget'];

			$category = $instance['category'];
			$layout   = $instance['layout'];

			echo $before_widget;

			echo do_shortcode( sprintf( '[featured-posts layout="%s" cat_id="%s"]',
				$layout,
				$category
			) );

			echo $after_widget;

		} // widget

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance['category'] = public_opinion_lite_sanitize_intval_or_empty( $new_instance['category'] );
			$instance['layout']   = public_opinion_lite_sanitize_hero_articles_layout( $new_instance['layout'] );

			return $instance;
		} // save

		function form( $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$category = $instance['category'];
			$layout   = $instance['layout'];

			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Category to display the latest posts from (optional):', 'public-opinion-lite' ); ?></label>
				<?php wp_dropdown_categories( array(
					'taxonomy'          => 'category',
					'show_option_none'  => ' ',
					'option_none_value' => '',
					'show_count'        => 1,
					'echo'              => 1,
					'selected'          => $category,
					'hierarchical'      => 1,
					'name'              => $this->get_field_name( 'category' ),
					'id'                => $this->get_field_id( 'category' ),
					'class'             => 'postform widefat',
				) ); ?>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>"><?php esc_html_e( 'Layout:', 'public-opinion-lite' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>">
					<?php foreach ( public_opinion_lite_get_hero_articles_layout_choices() as $key => $value ) : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $layout ); ?>><?php echo esc_html( $value ); ?></option>
					<?php endforeach; ?>
				</select>
			</p>
			<?php

		} // form


	} // class

endif;
