<?php
/*
 * Term Layouts
 */

add_action( 'category_add_form_fields', 'public_opinion_lite_term_meta_layout_add', 10 );
add_action( 'category_edit_form_fields', 'public_opinion_lite_term_meta_layout_edit', 10, 2 );

if ( ! function_exists( 'public_opinion_lite_term_meta_layout_add' ) ) :
function public_opinion_lite_term_meta_layout_add( $taxonomy ) {
	$layouts = public_opinion_lite_plugin_get_hero_articles_layout_choices();

	?>
	<div class="form-field">
		<label for="public-opinion-lite-term-meta-hero-layout"><?php esc_html_e( 'Featured Articles Layout', 'public-opinion-lite-plugin' ); ?></label>
		<select id="public-opinion-lite-term-meta-hero-layout" name="public-opinion-lite-term-meta-hero-layout">
			<option value=""></option>
			<?php foreach ( $layouts as $id => $description ) : ?>
				<option value="<?php echo esc_attr( $id ); ?>"><?php echo wp_kses( $description, 'strip' ); ?></option>
			<?php endforeach; ?>
		</select>
	</div>

	<?php
}
endif;

if ( ! function_exists( 'public_opinion_lite_term_meta_layout_edit' ) ) :
function public_opinion_lite_term_meta_layout_edit( $term, $taxonomy ) {
	$layouts = public_opinion_lite_plugin_get_hero_articles_layout_choices();
	$value   = get_term_meta( $term->term_id, 'hero_layout', true );

	?>
	<tr class="form-field">
		<th scope="row"><label for="public-opinion-lite-term-meta-hero-layout"><?php esc_html_e( 'Featured Articles Layout', 'public-opinion-lite-plugin' ); ?></label></th>
		<td>
			<select id="public-opinion-lite-term-meta-hero-layout" name="public-opinion-lite-term-meta-hero-layout">
				<option value=""></option>
				<?php foreach ( $layouts as $id => $description ) : ?>
					<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $id, $value ); ?>><?php echo wp_kses( $description, 'strip' ); ?></option>
				<?php endforeach; ?>
			</select>
		</td>
	</tr>

	<?php
}
endif;


add_action( 'create_term', 'public_opinion_lite_term_created_edited', 10, 3 );
add_action( 'edit_term', 'public_opinion_lite_term_created_edited', 10, 3 );
if ( ! function_exists( 'public_opinion_lite_term_created_edited' ) ) :
function public_opinion_lite_term_created_edited( $term_id, $tt_id, $taxonomy ) {
	$taxonomies = array(
		'category',
	);

	if ( ! in_array( $taxonomy, $taxonomies, true ) ) {
		return;
	}

	if ( isset( $_POST['public-opinion-lite-term-meta-hero-layout'] ) ) { // WPCS: input var okay.
		update_term_meta( $term_id, 'hero_layout', public_opinion_lite_plugin_sanitize_hero_articles_layout( $_POST['public-opinion-lite-term-meta-hero-layout'] ) ); // WPCS: input var okay.
	}

}
endif;
