<?php
add_shortcode( 'featured-posts', 'public_opinion_lite_plugin_shortcode_featured_posts' );
if ( ! function_exists( 'public_opinion_lite_plugin_shortcode_featured_posts' ) ) :
	function public_opinion_lite_plugin_shortcode_featured_posts( $params, $content = null, $shortcode ) {
		$params = shortcode_atts( array(
			'layout' => 'two-posts', // Any valid index from public_opinion_lite_get_hero_articles_layouts()
			'cat'    => '', // Category slug. Overrides 'cat_id'.
			'cat_id' => '', // Category ID. Optional.
		), $params, $shortcode );

		$layout = $params['layout'];

		$term_id = ! empty( $params['cat_id'] ) ? intval( $params['cat_id'] ) : false;
		if ( ! empty( $params['cat'] ) ) {
			$term_name = sanitize_title( $params['cat'] );
			$term      = get_term_by( 'name', $term_name, 'category' );
			if ( false !== $term && is_object( $term ) ) {
				$term_id = intval( $term->term_id );
			}
			unset( $term );
		}

		$layouts = public_opinion_lite_get_hero_articles_layouts();
		if ( ! array_key_exists( $layout, $layouts ) ) {
			$layout = 1;
		}

		$q = public_opinion_lite_get_hero_articles( $layout, $term_id );

		if ( is_wp_error( $q ) || false === $q || ! $q->have_posts() ) {
			return '';
		}

		ob_start();

		global $wp_query;
		$old_wp_query = $wp_query;
		$wp_query     = $q;

		get_template_part( 'template-parts/hero-articles/' . $layout );

		$wp_query = $old_wp_query;
		wp_reset_postdata();

		$output = ob_get_clean();

		return $output;
	}
endif;

add_shortcode( 'latest-category', 'public_opinion_lite_plugin_shortcode_latest_category' );
if ( ! function_exists( 'public_opinion_lite_plugin_shortcode_latest_category' ) ) :
	function public_opinion_lite_plugin_shortcode_latest_category( $params, $content = null, $shortcode ) {
		$params = shortcode_atts( array(
			'layout' => 1, // Any valid index from public_opinion_lite_get_category_articles_layouts()
			'cat'    => '', // Category slug. Overrides 'cat_id'.
			'cat_id' => '', // Category ID. Optional.
			'type'   => 'latest', // May be 'latest', 'featured'.
			'count'  => '', // Number of posts. Ignored on some layouts.
		), $params, $shortcode );

		$layout = intval( $params['layout'] );

		// Fallback to the user-defined default category.
		$term_id = ! empty( $params['cat_id'] ) ? intval( $params['cat_id'] ) : intval( get_option( 'default_category' ) );

		if ( ! empty( $params['cat'] ) ) {
			$term_name = sanitize_title( $params['cat'] );
			$term      = get_term_by( 'name', $term_name, 'category' );
			if ( false !== $term && is_object( $term ) ) {
				$term_id = intval( $term->term_id );
			}
			unset( $term );
		}

		$term = get_term( $term_id );

		$layouts = public_opinion_lite_get_category_articles_layouts();
		if ( ! array_key_exists( $layout, $layouts ) ) {
			$layout = 1;
		}

		if ( ! in_array( $params['type'], array( 'featured', 'latest' ), true ) ) {
			$params['type'] = 'latest';
		}

		$q = public_opinion_lite_get_category_layout_articles( $layout, $term_id, $params['type'], $params['count'] );

		if ( is_wp_error( $q ) || false === $q || ! $q->have_posts() ) {
			return '';
		}

		$color      = get_term_meta( $term->term_id, 'public_opinion_lite_color', true );
		$style_attr = $color ? sprintf( 'color: %s;', $color ) : '';

		if ( $color ) {
			$css = sprintf( '.category-%1$s .section-category-more a:hover { color: %2$s; }',
				$term_id,
				$color
			);

			wp_enqueue_style( 'public-opinion-lite-plugin-footer-style' );
			wp_add_inline_style( 'public-opinion-lite-plugin-footer-style', $css );
		}

		// Disable showing the posts' primary category. We're listing a category anyway.
		$priority = has_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category' );
		if ( $priority > 0 ) {
			remove_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category', $priority );
		}

		ob_start();

		global $wp_query;
		$old_wp_query = $wp_query;
		$wp_query     = $q;

		?>
		<div class="section-category category-<?php echo esc_attr( $term->term_id ); ?>">
			<div class="section-category-header">
				<h3 class="section-category-title">
					<span class="section-category-name" style="<?php echo esc_attr( $style_attr ); ?>">
						<span><?php echo esc_html( $term->name ); ?></span>
					</span>

					<span class="section-category-more">
						<a href="<?php echo esc_url( get_term_link( $term ) ); ?>"><?php esc_html_e( 'View more articles', 'public-opinion-lite-plugin' ); ?></a>
					</span>
				</h3>
			</div>

			<?php get_template_part( 'template-parts/category-articles/layout', $layout ); ?>

		</div>
		<?php

		$wp_query = $old_wp_query;
		wp_reset_postdata();

		$output = ob_get_clean();

		// Re-enable the primary category (if previously disabled).
		if ( $priority > 0 ) {
			add_action( 'public_opinion_lite_the_entry_item_top_meta', 'public_opinion_lite_the_entry_item_category', $priority );
		}


		return $output;
	}
endif;

add_shortcode( 'current-date', 'public_opinion_lite_plugin_shortcode_current_date' );
if ( ! function_exists( 'public_opinion_lite_plugin_shortcode_current_date' ) ) :
	function public_opinion_lite_plugin_shortcode_current_date( $params, $content = null, $shortcode ) {
		$params = shortcode_atts( array(
			'format' => get_option( 'date_format' ),
		), $params, $shortcode );

		return date_i18n( $params['format'] );
	}
endif;
