<?php
add_action( 'admin_init', 'public_opinion_lite_plugin_cpt_post_add_metaboxes' );
add_action( 'save_post', 'public_opinion_lite_plugin_cpt_post_update_meta' );

if ( ! function_exists( 'public_opinion_lite_plugin_cpt_post_add_metaboxes' ) ) :
	function public_opinion_lite_plugin_cpt_post_add_metaboxes() {
		add_meta_box( 'public-opinion-lite-plugin-sidebar', esc_html__( 'Sidebar', 'public-opinion-lite-plugin' ), 'public_opinion_lite_plugin_add_post_sidebar_meta_box', 'post', 'normal', 'high' );
		add_meta_box( 'public-opinion-lite-plugin-post-info', esc_html__( 'Post Information', 'public-opinion-lite-plugin' ), 'public_opinion_lite_plugin_add_post_info_meta_box', 'post', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_cpt_post_update_meta' ) ) :
	function public_opinion_lite_plugin_cpt_post_update_meta( $post_id ) {

		if ( ! public_opinion_lite_plugin_can_save_meta( 'post' ) ) {
			return;
		}

		public_opinion_lite_plugin_sanitize_metabox_tab_sidebar( $post_id );

		update_post_meta( $post_id, 'public_opinion_lite_post_source_text', sanitize_text_field( $_POST['public_opinion_lite_post_source_text'] ) );
		update_post_meta( $post_id, 'public_opinion_lite_post_source_url', esc_url_raw( $_POST['public_opinion_lite_post_source_url'] ) );
		update_post_meta( $post_id, 'public_opinion_lite_post_via_text', sanitize_text_field( $_POST['public_opinion_lite_post_via_text'] ) );
		update_post_meta( $post_id, 'public_opinion_lite_post_via_url', esc_url_raw( $_POST['public_opinion_lite_post_via_url'] ) );
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_add_post_sidebar_meta_box' ) ) :
	function public_opinion_lite_plugin_add_post_sidebar_meta_box( $object, $box ) {
		public_opinion_lite_plugin_prepare_metabox( 'post' );

		?><div class="ci-cf-wrap"><?php

			public_opinion_lite_plugin_print_metabox_tab_sidebar( $object, $box );

		?></div><?php
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_add_post_info_meta_box' ) ) :
	function public_opinion_lite_plugin_add_post_info_meta_box( $object, $box ) {
		public_opinion_lite_plugin_prepare_metabox( 'post' );

		?><div class="ci-cf-wrap"><?php

			public_opinion_lite_plugin_metabox_open_tab( esc_html__( 'Source', 'public-opinion-lite-plugin' ) );

				public_opinion_lite_plugin_metabox_guide( array(
					wp_kses( __( 'If you are reposting a news article, you need to properly attribute it. Use the <em>Source</em> fields to specify the original news source. Use the <em>Via</em> fields to specify the website / news outlet that you got the news from (if different from source).', 'public-opinion-lite-plugin' ), public_opinion_lite_plugin_get_allowed_tags( 'guide' ) ),
					esc_html__( 'In case the URLs are left empty, only the texts will be printed.', 'public-opinion-lite-plugin' ),
				), array( 'type' => 'p' ) );
				public_opinion_lite_plugin_metabox_input( 'public_opinion_lite_post_source_text', esc_html__( 'Source Text:', 'public-opinion-lite-plugin' ) );
				public_opinion_lite_plugin_metabox_input( 'public_opinion_lite_post_source_url', esc_html__( 'Source URL:', 'public-opinion-lite-plugin' ), array( 'esc_func' => 'esc_url' ) );
				public_opinion_lite_plugin_metabox_input( 'public_opinion_lite_post_via_text', esc_html__( 'Via Text:', 'public-opinion-lite-plugin' ) );
				public_opinion_lite_plugin_metabox_input( 'public_opinion_lite_post_via_url', esc_html__( 'Via URL:', 'public-opinion-lite-plugin' ), array( 'esc_func' => 'esc_url' ) );

			public_opinion_lite_plugin_metabox_close_tab();

		?></div><?php

	}
endif;
