<?php
function public_opinion_lite_customize_register( $wp_customize ) {

	// Make the header partials call public_opinion_lite_header() instead of public_opinion_lite_base_header()
	$wp_customize->selective_refresh->get_partial( 'theme_header_layout' )->render_callback = 'public_opinion_lite_header';
	$wp_customize->selective_refresh->get_partial( 'theme_header_top_bar' )->render_callback = 'public_opinion_lite_header';


	//
	// Header - Primary Menu Bar
	//
	$wp_customize->add_setting( 'theme_header_primary_menu_center', array(
		'transport'         => 'postMessage',
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'theme_header_primary_menu_center', array(
		'type'    => 'checkbox',
		'section' => 'theme_header_primary_menu',
		'label'   => esc_html__( 'Centered menu', 'public-opinion-lite' ),
	) );

	$wp_customize->selective_refresh->get_partial( 'theme_header_layout' )->settings[] = 'theme_header_primary_menu_center';

	$wp_customize->add_setting( 'theme_header_primary_menu_equal_width', array(
		'transport'         => 'postMessage',
		'default'           => 0,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'theme_header_primary_menu_equal_width', array(
		'type'    => 'checkbox',
		'section' => 'theme_header_primary_menu',
		'label'   => esc_html__( 'Equal width menu items', 'public-opinion-lite' ),
	) );

	$wp_customize->selective_refresh->get_partial( 'theme_header_layout' )->settings[] = 'theme_header_primary_menu_equal_width';



	//
	// Blog - Hero
	//
	$wp_customize->add_section( 'theme_hero_options', array(
		'title'       => esc_html_x( 'Featured articles', 'customizer section title', 'public-opinion-lite' ),
		'panel'       => 'theme_blog',
		'description' => esc_html__( 'Customize how the featured articles will behave.', 'public-opinion-lite' ),
		'priority'    => 10,
	) );
	$wp_customize->add_setting( 'theme_hero_tag', array(
		'default'           => 'featured',
		'sanitize_callback' => 'sanitize_title',
	) );
	$wp_customize->add_control( 'theme_hero_tag', array(
		'type'        => 'text',
		'section'     => 'theme_hero_options',
		'label'       => esc_html__( 'Tag slug', 'public-opinion-lite' ),
		'description' => esc_html__( 'Featured sections throughout your website will only show articles that include this tag. The selected tag will be automatically hidden from tag lists.', 'public-opinion-lite' ),
	) );


	//
	// Blog - Post
	//
	$wp_customize->add_setting( 'post_show_score_rating', array(
		'default'           => 1,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'post_show_score_rating', array(
		'type'    => 'checkbox',
		'section' => 'theme_post_options',
		'label'   => esc_html__( 'Show score / rating', 'public-opinion-lite' ),
	) );

	$wp_customize->add_setting( 'post_show_navigation', array(
		'default'           => 1,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'post_show_navigation', array(
		'type'    => 'checkbox',
		'section' => 'theme_post_options',
		'label'   => esc_html__( 'Show previous/next post links', 'public-opinion-lite' ),
	) );


	//
	// Blog - Archive
	//
	$wp_customize->add_setting( 'theme_archive_exclude_pages_from_search', array(
		'default'           => 1,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'theme_archive_exclude_pages_from_search', array(
		'type'    => 'checkbox',
		'section' => 'theme_archive_options',
		'label'   => esc_html__( 'Exclude pages from search results', 'public-opinion-lite' ),
	) );


	//
	// Theme Upgrade
	//
	$wp_customize->add_section( 'theme_upgrade', array(
		'title' => esc_html_x( 'Upgrade to Pro', 'customizer section title', 'public-opinion-lite' ),
	) );

	$wp_customize->add_control( new Public_Opinion_Lite_Customize_Static_Text_Control( $wp_customize, 'upgrade_text', array(
		'settings'    => array(),
		'section'     => 'theme_upgrade',
		'label'       => esc_html__( 'Public Opinion Pro', 'public-opinion-lite' ),
		'description' => array(
			esc_html__( 'Do you enjoy Public Opinion Lite? Upgrade to Pro now and get:', 'public-opinion-lite' ),
			'<ul>' .
				'<li>' . esc_html__( 'Sticky menu', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'News ticker', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'Weather support', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'Boxed layout', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'Reviews system', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'WooCommerce support', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'More feature post layouts', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'More category widget layouts', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'Multiple archive layouts', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'Video post format support', 'public-opinion-lite' ) . '</li>' .
				'<li>' . esc_html__( 'More Customizer options', 'public-opinion-lite' ) . '</li>' .
			'</ul>',
			'<a href="https://www.cssigniter.com/themes/public-opinion?utm_source=customizer&utm_medium=banner&utm_campaign=public-opinion" class="customizer-link customizer-upgrade">' . esc_html__( 'Upgrade To Pro', 'public-opinion-lite' ) . '</a>',
			'<a href="https://www.cssigniter.com/docs/public-opinion-lite/" class="customizer-link customizer-documentation">' . esc_html__( 'Documentation', 'public-opinion-lite' ) . '</a>',
		),
	) ) );

	//
	// Global Color Addongs
	//
	$wp_customize->add_setting( 'site_date_label_bg', array(
		'transport'         => 'postMessage',
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	) );
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'site_date_label_bg', array(
		'section' => 'theme_colors_global',
		'label'   => esc_html__( 'Post date label background', 'public-opinion-lite' ),
	) ) );
}
add_action( 'customize_register', 'public_opinion_lite_customize_register' );


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function public_opinion_lite_customize_preview_js() {
	$theme = wp_get_theme();

	wp_enqueue_script( 'public-opinion-lite-customizer-preview', get_template_directory_uri() . '/js/admin/customizer-preview.js', array( 'customize-preview' ), $theme->get( 'Version' ), true );
}
add_action( 'customize_preview_init', 'public_opinion_lite_customize_preview_js' );


/**
 * Enqueues JS/CSS for theme-specific Customizer controls.
 */
function public_opinion_lite_customize_controls_js() {
	$theme = wp_get_theme();

	wp_enqueue_style( 'public-opinion-lite-customizer-controls', get_template_directory_uri() . '/css/admin/customizer-controls.css', array(), $theme->get( 'Version' ) );

	wp_enqueue_script( 'public-opinion-lite-customizer-controls', get_template_directory_uri() . '/js/admin/customizer-controls.js', array(
		'jquery',
		'suggest',
	), $theme->get( 'Version' ), true );

	$params = array(
		'documentation_text' => esc_html__( 'Documentation', 'public-opinion-lite' ),
		'upgrade_text'       => esc_html__( 'Upgrade to Pro', 'public-opinion-lite' ),
	);
	wp_localize_script( 'public-opinion-lite-customizer-controls', 'public_opinion_lite_customizer', $params );


}
add_action( 'customize_controls_enqueue_scripts', 'public_opinion_lite_customize_controls_js' );
