<?php
	if ( ! function_exists( 'public_opinion_lite_get_customizer_css' ) ) :
		/**
		 * Generates CSS based on per-theme customizer settings.
		 *
		 * @return string
		 */
		function public_opinion_lite_get_customizer_css() {
			ob_start();
			//
			// Top Bar Colors
			//
			$top_bar_bg = get_theme_mod( 'header_top_bar_bg_color', '' );

			if ( ! empty( $top_bar_bg ) ) {
				?>
				.head-intro-inner {
					border-bottom-width: 0;
				}
				<?php
			}

			$top_bar_color = get_theme_mod( 'header_top_bar_text_color', '' );

			if ( ! empty( $top_bar_color ) ) {
				?>
				.head-nav-inline a {
					color: <?php echo sanitize_hex_color( $top_bar_color ); ?>;
				}
				<?php
			}

			//
			// Primary menu bar colors
			//
			$menu_bar_bg = get_theme_mod( 'header_primary_menu_bg_color', '' );

			if ( ! empty( $menu_bar_bg ) ) {
				?>
				.nav.is-stuck {
					background-color: <?php echo sanitize_hex_color( $menu_bar_bg ); ?>;
				}
				<?php
			}

			//
			// Global Colors
			//
			$body_bg = get_theme_mod( 'background_color' );

			if ( ! empty( $body_bg ) && empty( $menu_bar_bg ) ) {
				?>
				.nav.is-stuck {
					background-color: #<?php echo $body_bg; ?>;
				}
				<?php
			}

			$site_accent_color = get_theme_mod( 'site_accent_color' );

			if ( ! empty( $site_accent_color ) ) {
				?>
				a,
				.entry-title a:hover,
				.social-icon:hover,
				.text-theme,
				.section-category-name,
				.entry-meta-top-wrap,
				.entry-content a,
				.entry-content blockquote,
				.entry-fields,
				.entry-rating-scores {
					color: <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}

				.news-ticker-title {
					background-color: <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}

				a:hover {
					color: <?php echo sanitize_hex_color( public_opinion_lite_color_luminance( $site_accent_color, .1 ) ); ?>;
				}

				a:focus {
					outline: 1px dotted <?php echo sanitize_hex_color( $site_accent_color ); ?>;
				}
				<?php
			}

			$site_text_color = get_theme_mod( 'site_text_color' );

			if ( ! empty( $site_text_color ) ) {
				$site_text_color_dark = public_opinion_lite_color_luminance( $site_text_color, -0.3 );
				$site_text_color_light = public_opinion_lite_color_luminance( $site_text_color, 0.3 );
				?>
				body,
				blockquote cite,
				.instagram-pics li a,
				.section-subtitle a,
				.navigation a,
				.navigation .page-numbers,
				.page-links .page-number,
				.widget_meta li a,
				.widget_pages li a,
				.widget_categories li a,
				.widget_archive li a,
				.widget_nav_menu li a,
				.entry-tags a,
				.tag-cloud-link,
				.btn-transparent,
				.entry-author-name a,
				.entry-navigation-title,
				.entry-author-title a,
				.entry-fields span,
				.news-ticker-item a {
					color: <?php echo sanitize_hex_color( $site_text_color ); ?>;
				}

				.entry-author-subtitle,
				.entry-prev > span,
				.entry-next > span {
					color: <?php echo sanitize_hex_color( $site_text_color_light ); ?>;
				}

				.navigation a,
				.navigation .page-numbers,
				.page-links .page-number,
				.entry-tags a,
				.tag-cloud-link,
				.btn-transparent {
					border-color: <?php echo sanitize_hex_color( $site_text_color_dark ); ?>;
				}

				h1, h2, h3, h4, h5, h6,
				.comment-author .fn,
				.entry-title a,
				.navigation a:hover,
				.navigation .current,
				.page-links .page-number:hover,
				.social-icon,
				.ci-contact-widget-item i,
				.widget_meta li a:hover,
				.widget_pages li a:hover,
				.widget_categories li a:hover,
				.widget_archive li a:hover,
				.widget_nav_menu li a:hover,
				.entry-tags a:hover,
				.tag-cloud-link:hover,
				.btn-transparent:hover {
					color: <?php echo sanitize_hex_color( $site_text_color_dark ); ?>;
				}

				.navigation a:hover,
				.navigation .current,
				.page-links .page-number:hover,
				.entry-tags a:hover,
				.tag-cloud-link:hover,
				.btn-transparent:hover {
					border-color: <?php echo sanitize_hex_color( $site_text_color_dark ); ?>;
				}
				<?php
			}

			$site_border_color = get_theme_mod( 'site_border_color' );

			if ( ! empty( $site_border_color ) ) {
				?>
				.no-comments,
				select,
				.widget select,
				.ci-schedule-widget-table tr,
				.widget_recent_comments li,
				.widget_rss li,
				.widget_recent_entries li,
				select,
				.footer-info-inner,
				.footer-inner,
				.head-main-ad > a,
				.head-intro-inner,
				.head-intro-info,
				.head-intro-info-module,
				.head-search:not(.only-child),
				.head-search-form,
				.page-hero-content,
				.section-category-header,
				.entry-item,
				.entry-section,
				.news-ticker,
				.header .list-social-icons,
				.nav,
				.navigation-main ul,
				.navigation-main > li > a,
				.navigation-main > li > a::before,
				.navigation-main > li:hover > a::before,
				.navigation-main > li > a:focus::before,
				.navigation-main > .current-menu-item > a::before,
				.navigation-main > .current-menu-parent > a::before,
				.navigation-main > .current-menu-ancestor > a ::before,
				.widget-title,
				input,
				textarea,
				input:hover,
				textarea:hover,
				input:focus,
				textarea:focus {
					border-color: <?php echo sanitize_hex_color( $site_border_color ); ?>;
				}

				.section-category-title,
				.section-category-title::after,
				.section-category-title::before {
					background-color: <?php echo sanitize_hex_color( $site_border_color ); ?>;
				}
				<?php
			}

			$btn_bg_color = get_theme_mod( 'site_button_bg_color', '' );

			if ( ! empty( $btn_bg_color ) ) {
				?>
				.btn-skewed::before,
				.btn-skewed::after {
					background-color: <?php echo sanitize_hex_color( $btn_bg_color ); ?>;
				}
				<?php
			}

			$btn_bg_color_hover = get_theme_mod( 'site_button_hover_bg_color', '' );

			if ( ! empty( $btn_bg_color_hover ) ) {
				?>
				.btn-skewed:hover::before,
				.btn-skewed:hover::after {
					background-color: <?php echo sanitize_hex_color( $btn_bg_color_hover ); ?>;
				}
				<?php
			}

			$btn_border_color = get_theme_mod( 'site_button_border_color', '' );

			if ( ! empty( $btn_border_color ) ) {
				?>
				.btn,
				.button,
				.comment-reply-link,
				input[type="submit"],
				input[type="reset"],
				button {
					border: 1px solid <?php echo sanitize_hex_color( $btn_border_color ); ?>;
				}

				.btn-skewed {
					border: 0;
				}
				<?php
			}

			$site_date_label_bg = get_theme_mod( 'site_date_label_bg', '' );

			if ( ! empty( $site_date_label_bg ) ) {
				?>
				.entry-meta-top-wrap,
				.entry-meta-top-wrap::after,
				.entry-meta-top-wrap::before {
					background-color: <?php echo sanitize_hex_color( $site_date_label_bg ); ?>;
				}
				<?php
			}

			//
			// Sidebar colors
			//

			$sidebar_text_color = get_theme_mod( 'sidebar_text_color', '' );

			if ( ! empty( $sidebar_text_color ) ) {
				?>
				.sidebar .entry-time {
					color: <?php echo sanitize_hex_color( $sidebar_text_color ); ?>;
					opacity: .6;
				}

				.sidebar .entry-time {
					opacity: .6;
				}
				<?php
			}

			$sidebar_border_color = get_theme_mod( 'sidebar_border_color', '' );

			if ( ! empty( $sidebar_border_color ) ) {
				?>
				.sidebar .widget-title,
				.sidebar .entry-item {
					border-color: <?php echo sanitize_hex_color( $sidebar_border_color ); ?>;
				}
				<?php
			}

			//
			// Footer colors
			//

			$footer_bg_color = get_theme_mod( 'footer_bg_color', '' );

			if ( ! empty( $footer_bg_color ) ) {
				?>
				.footer-inner {
					border-top: 0;
				}
				<?php
			}

			$footer_bottom_bg_color = get_theme_mod( 'footer_bottom_bg_color', '' );

			if ( ! empty( $footer_bottom_bg_color ) ) {
				?>
				.footer-info-inner {
					border-top: 0;
				}
				<?php
			}

			$css = ob_get_clean();
			return apply_filters( 'public_opinion_lite_customizer_css', $css );
		}
	endif;
