<?php
/**
 * Template Name: Front page
 */
get_header(); ?>

<?php
	$layout   = get_post_meta( get_queried_object_id(), 'public_opinion_lite_front_featured_layout', true );
	$category = get_post_meta( get_queried_object_id(), 'public_opinion_lite_front_featured_category', true );
	$q        = public_opinion_lite_get_hero_articles( $layout, $category );
?>
<?php if ( false !== $q && $q->have_posts() ) : ?>
	<div class="container">
		<div class="row">
			<div class="col-12">

				<?php
					global $wp_query;
					$old_wp_query = $wp_query;
					$wp_query     = $q;

					get_template_part( 'template-parts/hero-articles/' . $layout );

					$wp_query = $old_wp_query;
				?>

			</div>
		</div>
	</div>
<?php endif; ?>


<main class="main">
	<div class="container">
		<div class="row">

			<div class="<?php public_opinion_lite_the_container_classes(); ?>">

				<?php dynamic_sidebar( 'frontpage' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>
	</div>
</main>

<?php get_footer();

