<?php
	$previous_post = get_adjacent_post( false, '', true );
	$next_post     = get_adjacent_post( false, '', false );
?>
<?php if ( $previous_post || $next_post ) : ?>

	<div class="entry-section">
		<div class="row">
			<div class="col-xl-10 offset-xl-1 col-12">

				<div class="entry-navigation">
					<?php if ( $previous_post ) : ?>
						<a href="<?php echo esc_url( get_permalink( $previous_post ) ); ?>" class="entry-prev">
							<span><?php esc_html_e( 'Previous Article', 'public-opinion-lite' ); ?></span>
							<p class="entry-navigation-title"><?php echo get_the_title( $previous_post ); ?></p>
						</a>
					<?php endif; ?>

					<?php if ( $next_post ) : ?>
						<a href="<?php echo esc_url( get_permalink( $next_post ) ); ?>" class="entry-next">
							<span><?php esc_html_e( 'Next Article', 'public-opinion-lite' ); ?></span>
							<p class="entry-navigation-title"><?php echo get_the_title( $next_post ); ?></p>
						</a>
					<?php endif; ?>
				</div>

			</div>
		</div>
	</div>

<?php endif;
