<?php get_header(); ?>

<main class="main">

	<div class="container">
		<div class="row">

			<div class="<?php public_opinion_lite_the_container_classes(); ?>">

				<?php while ( have_posts() ) : the_post(); ?>

					<article id="entry-<?php the_ID(); ?>" <?php post_class( 'entry' ); ?>>

						<?php public_opinion_lite_the_post_header(); ?>

						<?php if ( has_excerpt() ) : ?>
							<div class="entry-excerpt">
								<?php the_excerpt(); ?>
							</div>
						<?php endif; ?>

						<?php public_opinion_lite_the_post_thumbnail(); ?>

						<div class="row">
							<div class="col-xl-11 offset-xl-1 col-12">
								<div class="entry-content">
									<?php the_content(); ?>
								</div>

								<?php wp_link_pages(); ?>

								<?php
									$source_text = get_post_meta( get_the_ID(), 'public_opinion_lite_post_source_text', true );
									$source_url  = get_post_meta( get_the_ID(), 'public_opinion_lite_post_source_url', true );
									$via_text    = get_post_meta( get_the_ID(), 'public_opinion_lite_post_via_text', true );
									$via_url     = get_post_meta( get_the_ID(), 'public_opinion_lite_post_via_url', true );
								?>

								<?php if ( ! empty( $source_text ) || ! empty( $via_text ) || ( has_tag() && get_theme_mod( 'post_show_tags', 1 ) ) ) : ?>
									<ul class="entry-fields">

										<?php if ( ! empty( $source_text ) ) : ?>
											<li>
												<span><?php esc_html_e( 'Source:', 'public-opinion-lite' ); ?></span>
												<?php if ( ! empty( $source_url ) ) : ?>
													<a href="<?php echo esc_url( $source_url ); ?>"><?php echo esc_html( $source_text ); ?></a>
												<?php else : ?>
													<?php echo esc_html( $source_text ); ?>
												<?php endif; ?>
											</li>
										<?php endif; ?>

										<?php if ( ! empty( $via_text ) ) : ?>
											<li>
												<span><?php esc_html_e( 'Via:', 'public-opinion-lite' ); ?></span>
												<?php if ( ! empty( $via_url ) ) : ?>
													<a href="<?php echo esc_url( $via_url ); ?>"><?php echo esc_html( $via_text ); ?></a>
												<?php else : ?>
													<?php echo esc_html( $via_text ); ?>
												<?php endif; ?>
											</li>
										<?php endif; ?>

										<?php if ( get_theme_mod( 'post_show_tags', 1 ) ) {
											$before = '<li><span>' . esc_html__( 'Tags:', 'public-opinion-lite' ) . '</span> ';
											$after  = '</li>';
											the_tags( $before, ', ', $after );
										} ?>
									</ul>
								<?php endif; ?>
							</div>
						</div>

					</article>

					<?php if ( get_theme_mod( 'post_show_navigation', 1 ) ) {
						get_template_part( 'template-parts/navigation', get_post_type() );
					} ?>

					<?php if ( get_theme_mod( 'post_show_authorbox', 1 ) ) : ?>
						<div class="entry-section">
							<div class="row">
								<div class="col-xl-11 offset-xl-1 col-12">

									<?php public_opinion_lite_the_post_author_box(); ?>

								</div>
							</div>
						</div>
					<?php endif; ?>

					<?php if ( get_theme_mod( 'post_show_related', 1 ) ) {
						get_template_part( 'template-parts/related', get_post_type() );
					} ?>

					<?php if ( get_theme_mod( 'post_show_comments', 1 ) ) {
						comments_template();
					} ?>

				<?php endwhile; ?>

			</div>

			<?php get_sidebar(); ?>

		</div>
	</div>

</main>

<?php get_footer();
