<?php
	namespace Elementor;

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	/**
	 * Enqueue elements plus icons (elementor)
	 */
	function public_opinion_lite_add_ep_icon() {
		$theme = wp_get_theme();

		wp_enqueue_style( 'ep-icon', get_template_directory_uri() . '/css/admin/ep-icon/css/ep-icon.css', array(), $theme->get( 'Version' ) );
	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'Elementor\public_opinion_lite_add_ep_icon' );


	function public_opinion_lite_post_categories() {
		$post_categories = get_categories();
		$public_opinion_lite_pc[]   = '';

		foreach ( $post_categories as $key => $pc ) {
			$public_opinion_lite_pc[ $pc->cat_ID ] = $pc->name;
		}

		return $public_opinion_lite_pc;
	}

	add_action( 'elementor/init','Elementor\public_opinion_lite_elements_init' );

	function public_opinion_lite_elements_init() {
		Plugin::instance()->elements_manager->add_category(
			'public-opinion-lite-elements',
			[
				'title' => __( 'Public Opinion Lite Elements', 'public-opinion-lite' ),
				'icon'  => 'font',
			],
			1
		);
	}

	add_action( 'elementor/widgets/widgets_registered', 'Elementor\public_opinion_lite_add_elements' );
	function public_opinion_lite_add_elements() {
		class Widget_Featured_Category extends Widget_Base {

			public function get_name() {
				return 'cat_feat_posts';
			}

			public function get_title() {
				return __( 'Category Featured Posts', 'public-opinion-lite' );
			}

			public function get_icon() {
				return 'ep-icon ep-icon-desktop';
			}

			public function get_categories() {
				return [ 'public-opinion-lite-elements' ];
			}

			protected function _register_controls() {
				$this->start_controls_section(
					'section_title',
					[
						'label' => __( 'Category Featured Posts', 'public-opinion-lite' ),
					]
				);

				$this->add_control(
					'html_msg',
					[
						'type'            => Controls_Manager::RAW_HTML,
						'raw'             => __( 'Displays a number of featured (or latest) posts from a specific category.', 'public-opinion-lite' ),
						'content_classes' => 'ci-description',
					]
				);

				$this->add_control(
					'po_post_category',
					[
						'label'   => __( 'Category', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SELECT,
						'default' => '',
						'options' => public_opinion_lite_post_categories(),
					]
				);

				$this->add_control(
					'po_post_type',
					[
						'label'   => __( 'Type of posts', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SELECT,
						'default' => 'latest',
						'options' => [
							'featured' => __( 'Featured', 'public-opinion-lite' ),
							'latest'   => __( 'Latest', 'public-opinion-lite' ),
						],
					]
				);

				$this->add_control(
					'po_layout',
					[
						'label'   => __( 'Layout:', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SELECT,
						'options' => public_opinion_lite_get_category_articles_layout_choices(),
						'default' => 2,
					]
				);

				$this->add_control(
					'po_count',
					[
						'label'   => __( 'Number of posts to show:', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SLIDER,
						'default' => [
							'size' => 1,
						],
						'range'   => [
							'min'  => 1,
							'max'  => 250,
							'step' => 1,
						],
					]
				);

				$this->add_control(
					'view',
					[
						'label'   => __( 'View', 'public-opinion-lite' ),
						'type'    => Controls_Manager::HIDDEN,
						'default' => 'traditional',
					]
				);

				$this->end_controls_section();

			}

			protected function render() {
				$settings = $this->get_settings();

				$layout   = $settings['po_layout'];
				$category = $settings['po_post_category'];
				$type     = $settings['po_post_type'];
				$count    = $settings['po_count']['size'];

				echo do_shortcode( sprintf( '[latest-category layout="%s" cat_id="%s" type="%s" count="%s"]',
					$layout,
					$category,
					$type,
					$count
				) );

			}

		}
		Plugin::instance()->widgets_manager->register_widget_type( new Widget_Featured_Category() );

		class Widget_Featured_Posts extends Widget_Base {

			public function get_name() {
				return 'cat_feat_cat_posts';
			}

			public function get_title() {
				return __( 'Featured Posts', 'public-opinion-lite' );
			}

			public function get_icon() {
				return 'ep-icon ep-icon-desktop';
			}

			public function get_categories() {
				return [ 'public-opinion-lite-elements' ];
			}

			protected function _register_controls() {
				$this->start_controls_section(
					'section_title',
					[
						'label' => __( 'Featured Posts', 'public-opinion-lite' ),
					]
				);

				$this->add_control(
					'html_msg',
					[
						'type'            => Controls_Manager::RAW_HTML,
						'raw'             => __( 'Displays a hero section of featured posts, optionally from a specific category.', 'public-opinion-lite' ),
						'content_classes' => 'ci-description',
					]
				);

				$this->add_control(
					'po_hero_post_category',
					[
						'label'   => __( 'Category', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SELECT,
						'default' => '',
						'options' => public_opinion_lite_post_categories(),
					]
				);

				$this->add_control(
					'po_hero_layout',
					[
						'label'   => __( 'Layout:', 'public-opinion-lite' ),
						'type'    => Controls_Manager::SELECT,
						'options' => public_opinion_lite_get_hero_articles_layout_choices(),
						'default' => 'two-posts',
					]
				);

				$this->add_control(
					'view',
					[
						'label'   => __( 'View', 'public-opinion-lite' ),
						'type'    => Controls_Manager::HIDDEN,
						'default' => 'traditional',
					]
				);

				$this->end_controls_section();

			}

			protected function render() {
				$settings = $this->get_settings();

				$layout   = $settings['po_hero_layout'];
				$category = $settings['po_hero_post_category'];

				echo do_shortcode( sprintf( '[featured-posts layout="%s" cat_id="%s"]',
					$layout,
					$category
				) );

			}

		}
		Plugin::instance()->widgets_manager->register_widget_type( new Widget_Featured_Posts() );
	}
