<?php
/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function public_opinion_lite_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'public_opinion_lite_pingback_header' );


add_filter( 'excerpt_length', 'public_opinion_lite_base_excerpt_length' );
function public_opinion_lite_base_excerpt_length( $length ) {
	return get_theme_mod( 'excerpt_length', 55 );
}

add_filter( 'the_content', 'public_opinion_lite_lightbox_rel', 12 );
add_filter( 'get_comment_text', 'public_opinion_lite_lightbox_rel' );
if ( ! function_exists( 'public_opinion_lite_lightbox_rel' ) ) :
	function public_opinion_lite_lightbox_rel( $content ) {
		if ( get_theme_mod( 'theme_lightbox', 1 ) ) {
			global $post;
			$pattern     = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
			$replacement = '<a$1href=$2$3.$4$5 data-lightbox="gal[' . $post->ID . ']"$6>$7</a>';
			$content     = preg_replace( $pattern, $replacement, $content );
		}

		return $content;
	}
endif;

add_filter( 'the_title', 'public_opinion_lite_base_replace_the_title', 10, 2 );
if ( ! function_exists( 'public_opinion_lite_base_replace_the_title' ) ) :
	function public_opinion_lite_base_replace_the_title( $title, $id ) {
		if ( is_admin() ) {
			return $title;
		}

		$alt_title = get_post_meta( $id, 'title', true );

		if ( $alt_title ) {
			$title = $alt_title;
		}

		return $title;
	}
endif;

add_action( 'wp', 'public_opinion_lite_base_woocommerce_shop_title' );
if ( ! function_exists( 'public_opinion_lite_base_woocommerce_shop_title' ) ) :
	// This function needs to be called on 'wp' or later, as public_opinion_lite_get_hero_data() utilizes WC conditional tags.
	// If a need arises to call earlier, then the shop's page ID must be passed explicitly to public_opinion_lite_get_hero_data().
	function public_opinion_lite_base_woocommerce_shop_title() {
		$hero = public_opinion_lite_get_hero_data();
		if ( $hero['page_title_hide'] ) {
			add_filter( 'woocommerce_show_page_title', '__return_false' );
			remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
		}
	}
endif;


// Handle the dismissible sample content notice.
add_action( 'admin_notices', 'public_opinion_lite_admin_notice_sample_content' );
add_action( 'wp_ajax_public_opinion_lite_dismiss_sample_content', 'public_opinion_lite_ajax_dismiss_sample_content' );
function public_opinion_lite_admin_notice_sample_content() {

	$dismissed = get_theme_mod( 'dismissed_sample_content', false );

	if ( ! current_user_can( 'manage_options' ) || $dismissed ) {
		return;
	}

	$sample_content_url = apply_filters( 'public_opinion_lite_sample_content_url',
		sprintf( 'https://www.cssigniter.com/sample_content/%s.zip', PUBLIC_OPINION_LITE_NAME ),
		'https://www.cssigniter.com/sample_content/',
		PUBLIC_OPINION_LITE_NAME
	);

	if ( empty( $sample_content_url ) ) {
		return;
	}

	?>
	<div class="notice notice-info is-dismissible">
		<div class="public-opinion-lite-sample-content-notice">
			<p>
				<?php
					/* translators: %s is a URL. */
					echo wp_kses( sprintf( __( 'It looks like the theme was just installed. <a href="%s" target="_blank">Download the sample content</a> to get things moving.', 'public-opinion-lite' ), esc_url( $sample_content_url ) ),
						public_opinion_lite_get_allowed_tags( 'guide' )
					);
				?>
			</p>
		</div>
	</div>
	<?php

	$theme = wp_get_theme();

	wp_enqueue_script( 'public-opinion-lite-sample-content', get_template_directory_uri() . '/base/assets/js/sample-content.js', array(), $theme->get( 'Version' ), true );

	$settings = array(
		'ajaxurl'       => admin_url( 'admin-ajax.php' ),
		'dismiss_nonce' => wp_create_nonce( 'public-opinion-lite-dismiss-sample-content' ),
	);
	wp_localize_script( 'public-opinion-lite-sample-content', 'public_opinion_lite_SampleContent', $settings );
}

function public_opinion_lite_ajax_dismiss_sample_content() {
	check_ajax_referer( 'public-opinion-lite-dismiss-sample-content', 'nonce' );

	if ( current_user_can( 'manage_options' ) && ! empty( $_POST['dismissed'] ) && $_POST['dismissed'] == true ) {
		set_theme_mod( 'dismissed_sample_content', true );
		wp_send_json_success( 'OK' );
	} else {
		wp_send_json_error( 'BAD' );
	}
}
