<?php
	add_action( 'show_user_profile', 'public_opinion_lite_plugin_show_extra_profile_fields' );
	add_action( 'edit_user_profile', 'public_opinion_lite_plugin_show_extra_profile_fields' );

	function public_opinion_lite_plugin_show_extra_profile_fields( $user ) {
		wp_nonce_field( 'public_opinion_lite_plugin_show_extra_profile_fields_nonce', '_public_opinion_lite_plugin_show_extra_profile_fields_nonce' );

		$networks = public_opinion_lite_plugin_get_social_networks();
		?>
		<h3><?php esc_html_e( 'Author Information', 'public-opinion-lite-plugin' ); ?></h3>

		<table class="form-table">
			<tr>
				<th><label for="user_subtitle"><?php esc_html_e( 'Subtitle', 'public-opinion-lite-plugin' ); ?></label></th>

				<td>
					<input type="text" name="user_subtitle" id="user_subtitle"
						value="<?php echo esc_attr( get_user_meta( $user->ID, 'user_subtitle', true ) ); ?>"
						class="regular-text"/><br/>
					<span class="description"><?php esc_html_e( "The author subtitle is displayed on the author box, along with the author's name, below each article.", 'public-opinion-lite-plugin' ); ?></span>
				</td>
			</tr>
		</table>

		<h3><?php esc_html_e( 'Author Social Networks', 'public-opinion-lite-plugin' ); ?></h3>

		<table class="form-table">
			<?php foreach ( $networks as $network ) : ?>
				<tr>
					<th><label for="user_<?php echo esc_attr( $network['name'] ); ?>"><?php echo wp_kses( $network['label'], public_opinion_lite_plugin_get_allowed_tags() ); ?></label></th>

					<td>
						<input type="text" name="user_<?php echo esc_attr( $network['name'] ); ?>" id="user_<?php echo esc_attr( $network['name'] ); ?>"
							value="<?php echo esc_attr( get_user_meta( $user->ID, 'user_' . $network['name'], true ) ); ?>"
							class="regular-text"/><br/>
						<span class="description">
							<?php
								/* translators: %s is a social network's name, e.g. "Your Facebook profile URL" */
								wp_kses( sprintf( __( 'Your %s profile URL', 'public-opinion-lite-plugin' ), $network['label'] ), public_opinion_lite_plugin_get_allowed_tags() );
							?>
						</span>
					</td>
				</tr>
			<?php endforeach; ?>
		</table>

		<?php
	}

	add_action( 'personal_options_update', 'public_opinion_lite_plugin_save_extra_profile_fields' );
	add_action( 'edit_user_profile_update', 'public_opinion_lite_plugin_save_extra_profile_fields' );

	function public_opinion_lite_plugin_save_extra_profile_fields( $user_id ) {
		if ( isset( $_POST['_public_opinion_lite_plugin_show_extra_profile_fields_nonce'] ) && wp_verify_nonce( $_POST['_public_opinion_lite_plugin_show_extra_profile_fields_nonce'], 'public_opinion_lite_plugin_show_extra_profile_fields_nonce' ) ) { // Input vars okay.

			if ( ! current_user_can( 'edit_user', $user_id ) ) {
				return false;
			}

			update_user_meta( $user_id, 'user_subtitle', sanitize_text_field( $_POST['user_subtitle'] ) ); // Input var okay.

			$networks = public_opinion_lite_plugin_get_social_networks();

			foreach ( $networks as $network ) {
				if ( isset( $_POST[ 'user_' . $network['name'] ] ) ) { // Input var okay.
					update_user_meta( $user_id, 'user_' . $network['name'], esc_url_raw( $_POST[ 'user_' . $network['name'] ] ) ); // Input var okay/
				}
			}

		}
	}
