<article class="no-results not-found entry-item">

	<div class="entry-item-content">

		<header class="entry-header">
			<h1 class="entry-title"><?php esc_html_e( 'Nothing Found', 'public-opinion-lite' ); ?></h1>
		</header>

		<div class="entry-content">
			<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

				<p><?php printf( wp_kses( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'public-opinion-lite' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

			<?php elseif ( is_search() ) : ?>

				<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'public-opinion-lite' ); ?></p>
				<?php get_search_form(); ?>

			<?php else : ?>

				<p><?php esc_html_e( "It seems we can't find what you're looking for. Perhaps searching can help.", 'public-opinion-lite' ); ?></p>
				<?php get_search_form(); ?>

			<?php endif; ?>
		</div>

	</div>

</article>
