<?php
function public_opinion_lite_plugin_sanitize_metabox_tab_sidebar( $post_id ) {
	// Ignore phpcs issues. nonce validation happens inside public_opinion_lite_plugin_can_save_meta(), from the caller of this function.
	// @codingStandardsIgnoreStart
	update_post_meta( $post_id, 'public_opinion_lite_sidebar', public_opinion_lite_plugin_sanitize_sidebar( $_POST['public_opinion_lite_sidebar'] ) );
	// @codingStandardsIgnoreEnd
}

function public_opinion_lite_plugin_print_metabox_tab_sidebar( $object, $box ) {

	public_opinion_lite_plugin_metabox_open_tab( esc_html__( 'Sidebar', 'public-opinion-lite-plugin' ) );

		$options = public_opinion_lite_plugin_get_sidebar_choices();
		foreach ( $options as $key => $value ) {
			public_opinion_lite_plugin_metabox_radio( 'public_opinion_lite_sidebar', "sidebar-$key", $key, $value, array( 'default' => apply_filters( 'public_opinion_lite_plugin_sanitize_sidebar_default', 'right' ) ) );
		}

	public_opinion_lite_plugin_metabox_close_tab();
}

function public_opinion_lite_plugin_get_sidebar_choices() {
	return apply_filters( 'public_opinion_lite_plugin_sidebar_choices', array(
		'left'  => esc_html__( 'Left sidebar', 'public-opinion-lite-plugin' ),
		'right' => esc_html__( 'Right sidebar', 'public-opinion-lite-plugin' ),
		'none'  => esc_html__( 'No sidebar', 'public-opinion-lite-plugin' ),
	) );
}

function public_opinion_lite_plugin_sanitize_sidebar( $value ) {
	$choices = public_opinion_lite_plugin_get_sidebar_choices();
	if ( array_key_exists( $value, $choices ) ) {
		return $value;
	}

	return apply_filters( 'public_opinion_lite_plugin_sanitize_sidebar_default', 'right' );
}
