<?php
	$related   = public_opinion_lite_get_related_posts( get_the_ID(), apply_filters( 'public_opinion_lite_related_count', 2, get_post_type() ) );
	$columns   = apply_filters( 'public_opinion_lite_related_columns', 2, get_post_type() );
	$title     = get_theme_mod( 'title_post_related_title', __( 'Related articles', 'public-opinion-lite' ) );
	$subtitle  = get_theme_mod( 'title_post_related_subtitle' );
	$post_type = get_post_type();

	do_action( "public_opinion_lite_before_related_{$post_type}", $related, $post_type, $title, $subtitle );

	if ( $related->have_posts() ) : ?>
		<section class="entry-section entry-section-related">
			<div class="row">
				<div class="col-xl-11 offset-xl-1 col-12">
					<?php if ( $title || $subtitle ) : ?>
						<div class="section-heading">
							<h3 class="section-title"><?php echo esc_html( $title ); ?></h3>

							<?php if ( $subtitle ) : ?>
								<p class="section-subtitle"><?php echo esc_html( $subtitle ); ?></p>
							<?php endif; ?>
						</div>
					<?php endif; ?>

					<div class="row row-items row-items-no-underline">
						<?php while ( $related->have_posts() ) : $related->the_post(); ?>
							<div class="<?php echo esc_attr( public_opinion_lite_get_columns_classes( $columns ) ); ?>">
								<?php get_template_part( 'template-parts/article', get_post_type() ); ?>
							</div>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
					</div>
				</div>
			</div>
		</section>
	<?php endif;

	do_action( "public_opinion_lite_after_related_{$post_type}", $related, $post_type, $title, $subtitle );
