/**
 * Base Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Base Theme Customizer preview reload changes asynchronously.
 *
 * https://developer.wordpress.org/themes/customize-api/tools-for-improved-user-experience/#using-postmessage-for-improved-setting-previewing
 */

(function ($) {
	function createStyleSheet(settingName, styles) {
		var $styleElement;

		style = '<style class="' + settingName + '">';
		style += styles.reduce(function (rules, style) {
			rules += style.selectors + '{' + style.property + ':' + style.value + ';} ';
			return rules;
		}, '');
		style += '</style>';

		$styleElement = $('.' + settingName);

		if ($styleElement.length) {
			$styleElement.replaceWith(style);
		} else {
			$('head').append(style);
		}
	}

	//
	// Top bar colors
	//
	wp.customize('header_top_bar_bg_color', function (value) {
		value.bind(function (to) {
			if (to) {
				$('.head-intro-inner').css('border-bottom-width', 0);
			} else {
				$('.head-intro-inner').css('border-bottom-width', 1);
			}
		});
	});

	//
	// Top bar colors
	//
	wp.customize('header_top_bar_text_color', function (value) {
		value.bind(function (to) {
			$('.head-nav-inline a').css('color', to);
		});
	});

	//
	// Theme global colors
	//
	wp.customize('site_accent_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_accent_color', [
				{
					property: 'color',
					value: to,
					selectors: 'a,' +
					'.entry-title a:hover,' +
					'.social-icon:hover,' +
					'.text-theme,' +
					'.section-category-name,' +
					'.entry-meta-top-wrap,' +
					'.entry-content a,' +
					'.entry-content blockquote,' +
					'.entry-fields,' +
					'.entry-rating-scores'
				}
			]);
		});
	});

	wp.customize('site_text_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_text_color', [
				{
					property: 'color',
					value: to,
					selectors: 'body,' +
					'blockquote cite,' +
					'.instagram-pics li a,' +
					'.section-subtitle a,' +
					'.navigation a,' +
					'.navigation .page-numbers,' +
					'.page-links .page-number,' +
					'.widget_meta li a,' +
					'.widget_pages li a,' +
					'.widget_categories li a,' +
					'.widget_archive li a,' +
					'.widget_nav_menu li a,' +
					'.entry-tags a,' +
					'.tag-cloud-link,' +
					'.btn-transparent,' +
					'.entry-author-name a,' +
					'.entry-navigation-title,' +
					'.entry-author-title a,' +
					'.entry-fields span'+
					'.entry-author-subtitle,' +
					'.entry-prev > span,' +
					'.entry-next > span,' +
					'.news-ticker-item a'
				},
				{
					property: 'border-color',
					value: to,
					selectors: '.navigation a,' +
					'.navigation .page-numbers,' +
					'.page-links .page-number,' +
					'.entry-tags a,' +
					'.tag-cloud-link,' +
					'.btn-transparent'
				},
				{
					property: 'color',
					value: to,
					selectors: 'h1, h2, h3, h4, h5, h6,.comment-author .fn,.entry-title a,.filter-active,.item-media-content,.navigation a,.navigation .page-numbers,.social-icon,.ci-contact-widget-item i,.widget_meta li a:hover,.widget_pages li a:hover,.widget_categories li a:hover,.widget_archive li a:hover,.widget_nav_menu li a:hover,.entry-tags a:hover,.tag-cloud-link:hover,.btn-transparent:hover'
				},
				{
					property: 'border-color',
					value: to,
					selectors: '.filter-active,.navigation a,.navigation .page-numbers,.entry-tags a:hover,.tag-cloud-link:hover,.btn-transparent:hover'
				}
			]);
		});
	});

	wp.customize('site_border_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_border_color', [
				{
					property: 'border-color',
					value: to,
					selectors: '.no-comments,' +
					'select,' +
					'.widget select,' +
					'.ci-schedule-widget-table tr,' +
					'.widget_recent_comments li,' +
					'.widget_rss li,' +
					'.widget_recent_entries li,' +
					'select,' +
					'.footer-info-inner,' +
					'.footer-inner,' +
					'.head-main-ad > a,' +
					'.head-intro-inner,' +
					'.head-intro-info,' +
					'.head-intro-info-module,' +
					'.head-search:not(.only-child),' +
					'.head-search-form,' +
					'.page-hero-content,' +
					'.section-category-header,' +
					'.entry-item,' +
					'.entry-section,' +
					'.news-ticker,' +
					'.header .list-social-icons,' +
					'.nav,' +
					'.navigation-main ul,' +
					'.navigation-main > li > a,' +
					'.navigation-main > li > a::before,' +
					'.navigation-main > li:hover > a::before,' +
					'.navigation-main > li > a:focus::before,' +
					'.navigation-main > .current-menu-item > a::before,' +
					'.navigation-main > .current-menu-parent > a::before,' +
					'.navigation-main > .current-menu-ancestor > a ::before,' +
					'.widget-title,' +
					'input,' +
					'textarea,' +
					'input:hover,' +
					'textarea:hover,' +
					'input:focus,' +
					'textarea:focus'
				},
				{
					property: 'background-color',
					value: to,
					selectors: '.section-category-title,' +
					'.section-category-title::after,' +
					'.section-category-title::before',
				}
			]);
		});
	});

	wp.customize('site_button_bg_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_button_bg_color', [
				{
					property: 'background-color',
					value: to,
					selectors: '.btn-skewed::before, .btn-skewed::after',
				}
			]);
		});
	});

	wp.customize('site_button_hover_bg_color', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_button_hover_bg_color', [
				{
					property: 'background-color',
					value: to,
					selectors: '.btn-skewed:hover::before, .btn-skewed:hover::after',
				}
			]);
		});
	});

	wp.customize('site_button_border_color', function (value) {
		value.bind(function (to) {
			$('.btn,' +
				'.button,' +
				'.comment-reply-link,' +
				'input[type="submit"],' +
				'input[type="reset"],' +
				'button ').css({
				'border-width': '1px',
				'border-style': 'solid',
				'border-color': to,
			});

			$('.btn-skewed').css('border', 0);
		});
	});

	wp.customize('site_date_label_bg', function (value) {
		value.bind(function (to) {
			createStyleSheet('site_date_label_bg', [
				{
					property: 'background-color',
					value: to,
					selectors: '.entry-meta-top-wrap,' +
					'.entry-meta-top-wrap::after,' +
					'.entry-meta-top-wrap::before',
				}
			]);
		});
	});

	//
	// Sidebar colors
	//
	wp.customize('sidebar_border_color', function (value) {
		value.bind(function (to) {
			$('.sidebar .widget-title,' +
				'.sidebar .entry-item').css('border-color', to);
		});
	});
	
	//
	// Footer colors
	//
	wp.customize('footer_bg_color', function (value) {
		value.bind(function (to) {
			if (to) {
				$('.footer-inner').css('border-top-width', 0);
			} else {
				$('.footer-inner').css('border-top-width', 1);
			}
		});
	});

	wp.customize('footer_bottom_bg_color', function (value) {
		value.bind(function (to) {
			if (to) {
				$('.footer-info-inner').css('border-top-width', 0);
			} else {
				$('.footer-info-inner').css('border-top-width', 1);
			}
		});
	});
})(jQuery);
