<?php
/**
 * Theme-specific template tags
 */

add_action( 'public_opinion_lite_head_intro_info', 'public_opinion_lite_head_intro_info_text', 10 );
add_action( 'public_opinion_lite_head_intro_info', 'public_opinion_lite_head_intro_menu', 20 );

add_action( 'public_opinion_lite_head_intro_addons', 'public_opinion_lite_base_head_intro_addons_social', 10 );
add_action( 'public_opinion_lite_head_intro_addons', 'public_opinion_lite_base_head_intro_addons_lang_select', 20 );
add_action( 'public_opinion_lite_head_intro_addons', 'public_opinion_lite_base_head_intro_addons_search', 30 );


function public_opinion_lite_header() {
	do_action( 'public_opinion_lite_before_header' );

	?>
	<header class="<?php public_opinion_lite_the_header_classes(); ?>">

		<?php if ( get_theme_mod( 'header_top_bar_text_1' ) ||
		           get_theme_mod( 'header_top_bar_text_2' ) ||
		           get_theme_mod( 'theme_header_top_bar_show_social_icons', 1 ) ||
		           get_theme_mod( 'theme_header_top_bar_show_search', 1 ) ||
		           has_nav_menu( 'menu-top' )
		) : ?>

			<?php do_action( 'public_opinion_lite_before_head_intro' ); ?>

			<div class="head-intro">
				<div class="container">
					<div class="row">
						<div class="col-12">

							<div class="head-intro-inner">
								<div class="row align-items-center">

									<div class="col-lg-8 col-12">
										<div class="head-intro-info">
											<?php
												/**
												 * public_opinion_lite_head_intro_info hook.
												 *
												 * @hooked public_opinion_lite_head_intro_info_text - 10
												 * @hooked public_opinion_lite_head_intro_menu - 20
												 */
												do_action( 'public_opinion_lite_head_intro_info' );
											?>
										</div>
									</div>

									<div class="col-lg-4 col-12">
										<div class="head-intro-addons">
											<?php
												/**
												 * public_opinion_lite_head_intro_addons hook.
												 *
												 * @hooked public_opinion_lite_base_head_intro_addons_social - 10
												 * @hooked public_opinion_lite_base_head_intro_addons_lang_select - 20
												 * @hooked public_opinion_lite_base_head_intro_addons_search - 30
												 */
												do_action( 'public_opinion_lite_head_intro_addons' );
											?>
										</div>
									</div>

								</div>
							</div>

						</div>
					</div>
				</div>
			</div>

			<?php do_action( 'public_opinion_lite_after_head_intro' ); ?>

		<?php endif; ?>

		<?php
			$centered_menu = get_theme_mod( 'theme_header_primary_menu_center', 0 ) ? 'text-lg-center' : '';
			$nav_classes   = apply_filters( 'public_opinion_lite_primary_menu_nav_classes', array(
				'nav',
				$centered_menu,
			) );
			$nav_classes = array_filter( $nav_classes );
		?>
		<?php do_action( 'public_opinion_lite_before_head_mast' ); ?>

		<div class="head-mast">
			<div class="container">
				<div class="row align-items-center">

					<div class="col-lg-5 col-md-6 col-8">
						<?php public_opinion_lite_the_site_identity(); ?>
					</div>

					<div class="col-lg-7 text-right head-main-ad">
						<?php dynamic_sidebar( 'ad-header' ); ?>
					</div>

					<div class="col-lg-12 col-md-6 col-4" style="order: 1">
						<nav class="<?php echo esc_attr( implode( ' ', $nav_classes ) ); ?>">
							<?php
								$equal_width = get_theme_mod( 'theme_header_primary_menu_equal_width', 0 ) ? 'nav-space-between' : '';

								ob_start();
								wp_nav_menu( array(
									'theme_location' => 'menu-1',
									'container'      => '',
									'menu_id'        => 'header-menu-1',
									'menu_class'     => implode( ' ', array( 'navigation-main', $equal_width ) ),
								) );
								$menu = trim( ob_get_flush() );
							?>
						</nav>
						<?php if ( ! empty( $menu ) ) : ?>
							<a href="#mobilemenu" class="mobile-nav-trigger"><i class="fa fa-navicon"></i> <?php esc_html_e( 'Menu', 'public-opinion-lite' ); ?></a>
						<?php endif; ?>
					</div>

				</div>
			</div>
		</div>

		<?php do_action( 'public_opinion_lite_after_head_mast' ); ?>

	</header>
	<?php

	do_action( 'public_opinion_lite_after_header' );
}

function public_opinion_lite_head_intro_info_text() {
	if ( get_theme_mod( 'header_top_bar_text_1' ) ) {
		?><div class="head-intro-info-module"><?php echo do_shortcode( wp_kses_post( get_theme_mod( 'header_top_bar_text_1' ) ) ); ?></div><?php
	}

	if ( get_theme_mod( 'header_top_bar_text_2' ) ) {
		?><div class="head-intro-info-module"><?php echo do_shortcode( wp_kses_post( get_theme_mod( 'header_top_bar_text_2' ) ) ); ?></div><?php
	}
}

function public_opinion_lite_head_intro_menu() {
	if ( has_nav_menu( 'menu-top' ) ) {
		?>
		<div class="head-intro-info-module">
			<?php
				wp_nav_menu( array(
					'theme_location' => 'menu-top',
					'container'      => '',
					'menu_class'     => 'head-nav-inline',
					'fallback_cb'    => '',
					'depth'          => 1,
				) );
			?>
		</div>
		<?php
	}
}

function public_opinion_lite_the_entry_item_thumbnail( $size = false ) {
	if ( ! $size ) {
		$size = 'post-thumbnail';
	}

	if ( ! has_post_thumbnail() || ! get_theme_mod( 'post_show_featured', 1 ) ) {
		return;
	}

	do_action( 'public_opinion_lite_before_the_entry_item_thumbnail' );

	if ( is_singular() && get_the_ID() === get_queried_object_id() && is_main_query() && in_the_loop() ) {
		?>
		<figure class="entry-thumb">
			<a class="public-opinion-lite-lightbox" href="<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'large' ) ); ?>">
				<?php the_post_thumbnail( $size ); ?>
			</a>
		</figure>
		<?php
	} else {
		?>
		<figure class="entry-item-thumb">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( $size ); ?>
			</a>
		</figure>
		<?php
	}

	do_action( 'public_opinion_lite_after_the_entry_item_thumbnail' );
}

function public_opinion_lite_the_entry_item_author() {
	if ( 'post' !== get_post_type() ) {
		return;
	}

	if ( is_author() ) {
		return;
	}

	if ( get_theme_mod( 'post_show_author', 1 ) ) {
		?>
		<div class="entry-author">
			<?php
				$author      = apply_filters( 'public_opinion_lite_the_entry_item_author_name', get_the_author() );
				$author_html = sprintf( '<span class="entry-author-name"><a href="%1$s">%2$s</a></span>',
					esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
					wp_kses( $author, public_opinion_lite_get_allowed_tags() )
				);

				/* translators: %s is the author's name. */
				echo wp_kses( sprintf( __( '<span class="entry-author-by">by</span> %s', 'public-opinion-lite' ), $author_html ), public_opinion_lite_get_allowed_tags() );
			?>
		</div>
		<?php
	}
}


function public_opinion_lite_the_entry_item_top_meta() {
	if ( 'post' !== get_post_type() ) {
		return;
	}

	?>
	<div class="entry-meta-top">
		<?php
			$color      = public_opinion_lite_get_the_post_category_color();
			$style_attr = $color ? sprintf( 'color: %s;', $color ) : '';
		?>
		<div class="entry-meta-top-wrap" style="<?php echo esc_attr( $style_attr ); ?>">
			<?php
				/**
				 * public_opinion_lite_the_entry_item_top_meta hook.
				 *
				 * @hooked public_opinion_lite_the_entry_item_category - 10
				 * @hooked public_opinion_lite_the_entry_item_time - 20
				 * @hooked public_opinion_lite_the_entry_item_meta_info_open - 30
				 * @hooked public_opinion_lite_the_entry_item_comments_number - 40
				 * @hooked public_opinion_lite_the_entry_item_meta_info_close - 60
				 */
				do_action( 'public_opinion_lite_the_entry_item_top_meta' );
			?>
		</div>
	</div>
	<?php
}

function public_opinion_lite_the_entry_item_category() {

	if ( is_singular( 'post' ) && ! get_theme_mod( 'post_show_categories', 1 ) ) {
		return;
	}

	$category = public_opinion_lite_get_primary_post_category();

	if ( ! empty( $category ) && is_object( $category ) ) {
		?>
		<span class="entry-meta-category">
			<span><a href="<?php echo esc_url( get_term_link( $category->term_id ) ); ?>"><?php echo esc_html( $category->name ); ?></a></span>
		</span>
		<?php
	}
}

function public_opinion_lite_get_primary_post_category( $post = null, $taxonomy = 'category' ) {
	if ( empty( $post ) ) {
		$post = get_post();
	}

	$term  = false;
	$terms = get_the_terms( $post, $taxonomy );

	if ( ! empty( $terms ) ) {
		$term = current( $terms );
	}

	$term = apply_filters( 'public_opinion_lite_get_primary_post_category', $term, $post->ID, $terms );

	return $term;
}

function public_opinion_lite_the_entry_item_time() {
	if ( ! get_theme_mod( 'post_show_date', 1 ) ) {
		return;
	}

	?><time class="entry-time" datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>"><?php

	$now      = time();
	$the_time = get_the_time( 'U' );
	$diff     = (int) abs( $now - $the_time );

	if ( $diff < DAY_IN_SECONDS ) {
		printf( _x( '%s ago', '%s = human-readable time difference', 'public-opinion-lite' ), human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) );
	} else {
		echo get_the_date();
	}

	?></time><?php
}

function public_opinion_lite_the_entry_item_comments_number() {
	if ( ! get_theme_mod( 'post_show_comments', 1 ) ) {
		return;
	}

	?>
	<span class="entry-meta-comment-no">
		<a href="<?php comments_link(); ?>">
			<?php echo esc_html( get_comments_number() ); ?>
			<i class="fa fa-comments-o"></i>
		</a>
	</span>
	<?php
}


function public_opinion_lite_the_entry_item_meta_info_open() {
	?><span class="entry-meta-info"><?php
}

function public_opinion_lite_the_entry_item_meta_info_close() {
	?></span><?php
}



function public_opinion_lite_footer() {
	$sidebars           = array( 'footer-1', 'footer-2', 'footer-3', 'footer-4' );
	$classes            = public_opinion_lite_footer_widget_area_classes( get_theme_mod( 'footer_layout', public_opinion_lite_footer_layout_default() ) );
	$has_active_sidebar = false;
	foreach ( $sidebars as $sidebar ) {
		if ( is_active_sidebar( $sidebar ) && $classes[ $sidebar ]['active'] ) {
			$has_active_sidebar = true;
			break;
		}
	}

	do_action( 'public_opinion_lite_before_footer' );

	?>
	<footer class="<?php public_opinion_lite_the_footer_classes(); ?>">
		<?php if ( $has_active_sidebar ) : ?>
			<div class="footer-widgets">
				<div class="container">
					<div class="row">

						<div class="col-12">
							<div class="footer-inner">
								<div class="row">

									<?php foreach ( $sidebars as $sidebar ) : ?>
										<?php if ( $classes[ $sidebar ]['active'] ) : ?>
											<div class="<?php echo esc_attr( $classes[ $sidebar ]['class'] ); ?>">
												<?php dynamic_sidebar( $sidebar ); ?>
											</div>
										<?php endif; ?>
									<?php endforeach; ?>

								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php public_opinion_lite_footer_bottom_bar(); ?>
	</footer>
	<?php

	do_action( 'public_opinion_lite_after_footer' );
}

function public_opinion_lite_footer_bottom_bar() {
	if ( ! get_theme_mod( 'footer_show_bottom_bar', 1 ) ) {
		return;
	}

	do_action( 'public_opinion_lite_before_footer_info' );

	?>
	<div class="footer-info">
		<div class="container">

			<div class="row">
				<div class="col-12">
					<div class="footer-info-inner">


						<div class="row align-items-center">
							<div class="col-lg-6 col-12">
								<?php $credits = get_theme_mod( 'footer_text', public_opinion_lite_get_default_footer_text() ); ?>
								<?php if ( $credits || is_customize_preview() ) : ?>
									<p class="footer-copy text-lg-left text-center"><?php echo public_opinion_lite_sanitize_footer_text( $credits ); ?></p>
								<?php endif; ?>
							</div>

							<div class="col-lg-6 col-12">
								<?php if ( get_theme_mod( 'footer_show_social_icons', 1 ) ) : ?>
									<div class="footer-info-addons text-lg-right text-center">
										<?php public_opinion_lite_the_social_icons(); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>

					</div>
				</div>
			</div>

		</div>
	</div>
	<?php

	do_action( 'public_opinion_lite_after_footer_info' );

}
