<?php
/**
 * Standard Customizer Sections and Settings
 */

function public_opinion_lite_base_customize_register( $wp_customize ) {

	// Partial for various settings that affect the customizer styles, but can't have a dedicated icon, e.g. 'limit_logo_size'
	$wp_customize->selective_refresh->add_partial( 'theme_base_style', array(
		'selector'            => '#public-opinion-lite-base-style-inline-css',
		'render_callback'     => 'public_opinion_lite_get_all_customizer_css',
		'settings'            => array(),
		'container_inclusive' => false,
	) );


	//
	// Header
	//
	if ( apply_filters( 'public_opinion_lite_customizable_header', true ) ) {
		$wp_customize->add_panel( 'theme_header', array(
			'title'    => esc_html_x( 'Header', 'customizer section title', 'public-opinion-lite' ),
			'priority' => 10, // Before site_identity, 20
		) );

		$wp_customize->add_section( 'theme_header_style', array(
			'title'    => esc_html_x( 'Header style', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_header',
			'priority' => 10,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-header-style.php' );

		$wp_customize->add_section( 'theme_header_top_bar', array(
			'title'    => esc_html_x( 'Top menu bar', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_header',
			'priority' => 20,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-header-top-bar.php' );

		$wp_customize->add_section( 'theme_header_primary_menu', array(
			'title'    => esc_html_x( 'Primary menu bar', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_header',
			'priority' => 30,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-header-primary-menu.php' );
	} // filter public_opinion_lite_customizable_header

	//
	// Blog
	//
	$wp_customize->add_panel( 'theme_blog', array(
		'title'    => esc_html_x( 'Blog settings', 'customizer section title', 'public-opinion-lite' ),
		'priority' => 30, // After site_identity, 20
	) );

	$wp_customize->add_section( 'theme_archive_options', array(
		'title'       => esc_html_x( 'Archive options', 'customizer section title', 'public-opinion-lite' ),
		'panel'       => 'theme_blog',
		'description' => esc_html__( 'Customize the default archive pages, such as the blog, category, tag, date archives, etc.', 'public-opinion-lite' ),
		'priority'    => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-archive-options.php' );

	$wp_customize->add_section( 'theme_post_options', array(
		'title'    => esc_html_x( 'Post options', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_blog',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-post-options.php' );


	//
	// Colors
	//
	$wp_customize->add_panel( 'theme_colors', array(
		'title'    => esc_html_x( 'Colors', 'customizer section title', 'public-opinion-lite' ),
		'priority' => 30,
	) );

	if ( apply_filters( 'public_opinion_lite_customizable_header', true ) ) {
		$wp_customize->add_section( 'theme_colors_header_top_bar', array(
			'title'    => esc_html_x( 'Header top bar', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_colors',
			'priority' => 10,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-colors-header-top-bar.php' );

		$wp_customize->add_section( 'theme_colors_primary_menu_bar', array(
			'title'    => esc_html_x( 'Primary menu bar', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_colors',
			'priority' => 20,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-colors-primary-menu-bar.php' );
	} // filter public_opinion_lite_customizable_header

	if ( get_theme_support( 'public-opinion-lite-hero' ) ) {
		$wp_customize->add_section( 'theme_colors_hero', array(
			'title'    => esc_html_x( 'Hero', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_colors',
			'priority' => 30,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-colors-hero.php' );
	}

	$wp_customize->add_section( 'theme_colors_global', array(
		'title'    => esc_html_x( 'Global', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_colors',
		'priority' => 40,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-colors-global.php' );

	$wp_customize->add_section( 'theme_colors_sidebar', array(
		'title'    => esc_html_x( 'Sidebar', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_colors',
		'priority' => 50,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-colors-sidebar.php' );

	if ( apply_filters( 'public_opinion_lite_customizable_footer', true ) ) {
		$wp_customize->add_section( 'theme_colors_footer', array(
			'title'    => esc_html_x( 'Footer', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_colors',
			'priority' => 60,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-colors-footer.php' );
	} // filter public_opinion_lite_customizable_footer


	//
	// Typography
	//
	$wp_customize->add_panel( 'theme_typography', array(
		'title'    => esc_html_x( 'Typography', 'customizer section title', 'public-opinion-lite' ),
		'priority' => 70,
	) );

	$wp_customize->add_section( 'theme_typography_content', array(
		'title'    => esc_html_x( 'Content', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_typography',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-typography-content.php' );

	$wp_customize->add_section( 'theme_typography_widgets', array(
		'title'    => esc_html_x( 'Widgets', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_typography',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-typography-widgets.php' );


	//
	// Social
	//
	$wp_customize->add_section( 'theme_social', array(
		'title'       => esc_html_x( 'Social Networks', 'customizer section title', 'public-opinion-lite' ),
		'description' => esc_html__( 'Enter your social network URLs. Leaving a URL empty will hide its respective icon.', 'public-opinion-lite' ),
		'priority'    => 80,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-social.php' );


	//
	// Footer
	//
	if ( apply_filters( 'public_opinion_lite_customizable_footer', true ) ) {
		$wp_customize->add_panel( 'theme_footer', array(
			'title'    => esc_html_x( 'Footer', 'customizer section title', 'public-opinion-lite' ),
			'priority' => 90,
		) );

		$wp_customize->add_section( 'theme_footer_style', array(
			'title'    => esc_html_x( 'Footer style', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_footer',
			'priority' => 10,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-footer-style.php' );

		$wp_customize->add_section( 'theme_footer_bottom_bar', array(
			'title'    => esc_html_x( 'Bottom bar', 'customizer section title', 'public-opinion-lite' ),
			'panel'    => 'theme_footer',
			'priority' => 20,
		) );
		require_once get_theme_file_path( 'base/customizer/theme-footer-bottom-bar.php' );
	} // filter public_opinion_lite_customizable_footer


	//
	// Titles
	//
	$wp_customize->add_panel( 'theme_titles', array(
		'title'    => esc_html_x( 'Titles', 'customizer section title', 'public-opinion-lite' ),
		'priority' => 100,
	) );

	$wp_customize->add_section( 'theme_titles_general', array(
		'title'    => esc_html_x( 'General', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_titles',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-titles-general.php' );

	$wp_customize->add_section( 'theme_titles_post', array(
		'title'    => esc_html_x( 'Posts', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_titles',
		'priority' => 20,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-titles-post.php' );


	//
	// Other
	//
	$wp_customize->add_panel( 'theme_other', array(
		'title'                    => esc_html_x( 'Other', 'customizer section title', 'public-opinion-lite' ),
		'description'              => esc_html__( 'Other options affecting the whole site.', 'public-opinion-lite' ),
		'auto_expand_sole_section' => true,
		'priority'                 => 110,
	) );

	$wp_customize->add_section( 'theme_other_sample_content', array(
		'title'    => esc_html_x( 'Sample Content', 'customizer section title', 'public-opinion-lite' ),
		'panel'    => 'theme_other',
		'priority' => 10,
	) );
	require_once get_theme_file_path( 'base/customizer/theme-other-sample-content.php' );


	//
	// Site identity
	//
	require_once get_theme_file_path( 'base/customizer/site-identity.php' );

}
add_action( 'customize_register', 'public_opinion_lite_base_customize_register' );



add_action( 'customize_register', 'public_opinion_lite_base_customize_register_custom_controls', 9 );
/**
 * Registers custom Customizer controls.
 *
 * @param WP_Customize_Manager $wp_customize Reference to the customizer's manager object.
 */
function public_opinion_lite_base_customize_register_custom_controls( $wp_customize ) {
	require get_template_directory() . '/base/customizer-controls/static-text/static-text.php';
	require get_template_directory() . '/base/customizer-controls/alpha-color-picker/alpha-color-picker.php';
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function public_opinion_lite_base_customize_preview_js() {
	$theme = wp_get_theme();

	wp_enqueue_script( 'public-opinion-lite-base-customizer-preview', get_template_directory_uri() . '/base/assets/js/customizer-preview.js', array( 'customize-preview' ), $theme->get( 'Version' ), true );
	wp_enqueue_style( 'public-opinion-lite-base-customizer-preview', get_template_directory_uri() . '/base/assets/css/customizer-preview.css', array( 'customize-preview' ), $theme->get( 'Version' ) );
}
add_action( 'customize_preview_init', 'public_opinion_lite_base_customize_preview_js' );

function public_opinion_lite_base_customize_controls_js() {
	$theme = wp_get_theme();

	wp_enqueue_style( 'alpha-color-picker-customizer', get_template_directory_uri() . '/base/customizer-controls/alpha-color-picker/alpha-color-picker.css', array(
		'wp-color-picker',
	), '1.0.0' );
	wp_enqueue_script( 'alpha-color-picker-customizer', get_template_directory_uri() . '/base/customizer-controls/alpha-color-picker/alpha-color-picker.js', array(
		'jquery',
		'wp-color-picker',
	), '1.0.0', true );

	wp_enqueue_script( 'public-opinion-lite-base-customizer-controls', get_template_directory_uri() . '/base/assets/js/customizer-controls.js', array(), $theme->get( 'Version' ), true );
}
add_action( 'customize_controls_enqueue_scripts', 'public_opinion_lite_base_customize_controls_js' );
