<?php
	if ( apply_filters( 'public_opinion_lite_customizable_blog_archive_options', true ) ) {
		$wp_customize->add_setting( 'archive_sidebar', array(
			'default'           => 1,
			'sanitize_callback' => 'absint',
		) );
		$wp_customize->add_control( 'archive_sidebar', array(
			'type'    => 'checkbox',
			'section' => 'theme_archive_options',
			'label'   => esc_html__( 'Show sidebar', 'public-opinion-lite' ),
		) );
	} // filter public_opinion_lite_customizable_blog_archive_options

	// This is better left without a partial, as excerpt may appear anywhere (and with any wrapper).
	$wp_customize->add_setting( 'excerpt_length', array(
		'default'           => 55,
		'sanitize_callback' => 'absint',
	) );
	$wp_customize->add_control( 'excerpt_length', array(
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'step' => 1,
		),
		'section'     => 'theme_archive_options',
		'label'       => esc_html__( 'Automatically generated excerpt length (in words)', 'public-opinion-lite' ),
	) );


	$wp_customize->add_setting( 'pagination_method', array(
		'transport'         => 'postMessage',
		'default'           => public_opinion_lite_pagination_method_default(),
		'sanitize_callback' => 'public_opinion_lite_sanitize_pagination_method',
	) );
	$wp_customize->add_control( 'pagination_method', array(
		'type'    => 'select',
		'section' => 'theme_archive_options',
		'label'   => esc_html__( 'Pagination method', 'public-opinion-lite' ),
		'choices' => array(
			'numbers' => esc_html_x( 'Numbered links', 'pagination method', 'public-opinion-lite' ),
			'text'    => esc_html_x( '"Previous - Next" links', 'pagination method', 'public-opinion-lite' ),
		),
	) );

	$wp_customize->selective_refresh->add_partial( 'pagination_method', array(
		'selector'        => 'nav.navigation',
		'render_callback' => 'public_opinion_lite_base_customize_preview_pagination',
		'container_inclusive' => true,
	) );
