<?php
if ( ! class_exists( 'CI_Widget_Home_Category_Featured_Posts' ) ) :
	class CI_Widget_Home_Category_Featured_Posts extends WP_Widget {

		protected $defaults = array(
			'category' => '',
			'type'     => 'latest',
			'layout'   => 1,
			'count'    => 4,
		);

		function __construct() {
			$widget_ops  = array( 'description' => esc_html__( 'Homepage widget. Displays a number of featured (or latest) posts from a specific category.', 'public-opinion-lite' ) );
			$control_ops = array();
			parent::__construct( 'ci-home-category-featured-posts', esc_html__( 'Theme (home) - Category Featured Posts', 'public-opinion-lite' ), $widget_ops, $control_ops );
		}

		function widget( $args, $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$id            = isset( $args['id'] ) ? $args['id'] : '';
			$before_widget = $args['before_widget'];
			$after_widget  = $args['after_widget'];

			$category = $instance['category'];
			$type     = $instance['type'];
			$layout   = $instance['layout'];
			$count    = $instance['count'];

			echo $before_widget;

			echo do_shortcode( sprintf( '[latest-category layout="%s" cat_id="%s" type="%s" count="%s"]',
				$layout,
				$category,
				$type,
				$count
			) );

			echo $after_widget;

		} // widget

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance['category'] = public_opinion_lite_sanitize_intval_or_empty( $new_instance['category'] );
			$instance['type']     = in_array( $new_instance['type'], array( 'featured', 'latest' ), true ) ? $new_instance['type'] : $this->defaults['type'];
			$instance['layout']   = public_opinion_lite_sanitize_category_articles_layout( $new_instance['layout'] );
			$instance['count']    = public_opinion_lite_sanitize_intval_or_empty( $new_instance['count'] );

			return $instance;
		} // save

		function form( $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$category = $instance['category'];
			$type     = $instance['type'];
			$layout   = $instance['layout'];
			$count    = $instance['count'];

			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Category to display the latest posts from (required):', 'public-opinion-lite' ); ?></label>
				<?php wp_dropdown_categories( array(
					'taxonomy'     => 'category',
					'show_count'   => 1,
					'echo'         => 1,
					'selected'     => $category,
					'hierarchical' => 1,
					'name'         => $this->get_field_name( 'category' ),
					'id'           => $this->get_field_id( 'category' ),
					'class'        => 'postform widefat',
				) ); ?>
			</p>

			<p>
				<?php
					$choices = array(
						'featured' => __( 'Featured', 'public-opinion-lite' ),
						'latest'   => __( 'Latest', 'public-opinion-lite' ),
					);
				?>
				<label for="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>"><?php esc_html_e( 'Type of posts:', 'public-opinion-lite' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'type' ) ); ?>">
					<?php foreach ( $choices as $key => $value ) : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $type ); ?>><?php echo esc_html( $value ); ?></option>
					<?php endforeach; ?>
				</select>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>"><?php esc_html_e( 'Layout:', 'public-opinion-lite' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'layout' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'layout' ) ); ?>">
					<?php foreach ( public_opinion_lite_get_category_articles_layout_choices() as $key => $value ) : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $layout ); ?>><?php echo esc_html( $value ); ?></option>
					<?php endforeach; ?>
				</select>
			</p>

			<p><label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'public-opinion-lite' ); ?></label><input id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $count ); ?>" class="widefat"/></p>
			<p><small><?php esc_html_e( 'Layouts that mention a number of posts, will ignore this value.', 'public-opinion-lite' ); ?></small></p>

			<?php

		} // form


	} // class

endif;
