<?php
if ( ! class_exists( 'CI_Widget_Featured_Posts' ) ) :
	class CI_Widget_Featured_Posts extends WP_Widget {

		protected $defaults = array(
			'title'    => '',
			'category' => '',
			'type'     => 'featured',
			'count'    => 3,
		);

		function __construct() {
			$widget_ops  = array( 'description' => esc_html__( 'Displays featured or latest posts, optionally from a specific category.', 'public-opinion-lite' ) );
			$control_ops = array();
			parent::__construct( 'ci-featured-posts', esc_html__( 'Theme - Featured Posts', 'public-opinion-lite' ), $widget_ops, $control_ops );
		}

		function widget( $args, $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$id            = isset( $args['id'] ) ? $args['id'] : '';
			$before_widget = $args['before_widget'];
			$after_widget  = $args['after_widget'];

			$title    = apply_filters( 'widget_title', empty( $instance['title'] ) ? '' : $instance['title'], $instance, $this->id_base );
			$category = $instance['category'];
			$type     = $instance['type'];
			$count    = $instance['count'];

			if ( 0 === $count ) {
				return;
			}

			$q_args = array(
				'post_type'           => 'post',
				'ignore_sticky_posts' => true,
				'orderby'             => 'date',
				'order'               => 'DESC',
				'posts_per_page'      => $count,
			);

			if ( intval( $category ) > 0 ) {
				$q_args['cat'] = intval( $category );
			}

			if ( 'featured' === $type ) {
				$featured_tag = get_theme_mod( 'theme_hero_tag', 'featured' );

				if ( $featured_tag ) {
					$q_args['tag'] = $featured_tag;
				}
			}

			$q = new WP_Query( $q_args );

			echo $before_widget;

			if ( ! empty( $title ) ) {
				echo $args['before_title'] . $title . $args['after_title'];
			}

			while ( $q->have_posts() ) {
				$q->the_post();

				get_template_part( 'template-parts/widgets/sidebar-item', get_post_type() );
			}
			wp_reset_postdata();

			echo $after_widget;

		} // widget

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;

			$instance['title']    = sanitize_text_field( $new_instance['title'] );
			$instance['category'] = public_opinion_lite_sanitize_intval_or_empty( $new_instance['category'] );
			$instance['type']     = in_array( $new_instance['type'], array( 'featured', 'latest' ), true ) ? $new_instance['type'] : $this->defaults['type'];
			$instance['count']    = absint( $new_instance['count'] );

			return $instance;
		} // save

		function form( $instance ) {
			$instance = wp_parse_args( (array) $instance, $this->defaults );

			$title    = $instance['title'];
			$category = $instance['category'];
			$type     = $instance['type'];
			$count    = $instance['count'];

			?>

			<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'public-opinion-lite' ); ?></label><input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" class="widefat"/></p>

			<?php $choices = array(
				'featured' => __( 'Featured posts', 'public-opinion-lite' ),
				'latest'   => __( 'Latest posts', 'public-opinion-lite' ),
			); ?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>"><?php esc_html_e( 'Type:', 'public-opinion-lite' ); ?></label>
				<select id="<?php echo esc_attr( $this->get_field_id( 'type' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'type' ) ); ?>">
					<?php foreach ( $choices  as $key => $value ) : ?>
						<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $type ); ?>><?php echo esc_html( $value ); ?></option>
					<?php endforeach; ?>
				</select>
			</p>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Category to display the latest posts from (optional):', 'public-opinion-lite' ); ?></label>
				<?php wp_dropdown_categories( array(
					'taxonomy'          => 'category',
					'show_option_none'  => ' ',
					'option_none_value' => '',
					'show_count'        => 1,
					'echo'              => 1,
					'selected'          => $category,
					'hierarchical'      => 1,
					'name'              => $this->get_field_name( 'category' ),
					'id'                => $this->get_field_id( 'category' ),
					'class'             => 'postform widefat',
				) ); ?>
			</p>

			<p><label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Number of posts to show:', 'public-opinion-lite' ); ?></label><input id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $count ); ?>" class="widefat"/></p>
			<?php

		} // form


	} // class

endif;
