<?php
add_action( 'admin_init', 'public_opinion_lite_plugin_cpt_page_add_metaboxes' );
add_action( 'save_post', 'public_opinion_lite_plugin_cpt_page_update_meta' );

if ( ! function_exists( 'public_opinion_lite_plugin_cpt_page_add_metaboxes' ) ) :
	function public_opinion_lite_plugin_cpt_page_add_metaboxes() {
		add_meta_box( 'public-opinion-lite-plugin-sidebar', esc_html__( 'Sidebar', 'public-opinion-lite-plugin' ), 'public_opinion_lite_plugin_add_page_sidebar_meta_box', 'page', 'normal', 'high' );
		add_meta_box( 'public-opinion-lite-plugin-tpl-front-page', esc_html__( 'Front Page Options', 'public-opinion-lite-plugin' ), 'public_opinion_lite_plugin_add_page_front_page_meta_box', 'page', 'normal', 'high' );
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_cpt_page_update_meta' ) ) :
	function public_opinion_lite_plugin_cpt_page_update_meta( $post_id ) {

		if ( ! public_opinion_lite_plugin_can_save_meta( 'page' ) ) {
			return;
		}

		public_opinion_lite_plugin_sanitize_metabox_tab_sidebar( $post_id );

		update_post_meta( $post_id, 'public_opinion_lite_front_featured_layout', public_opinion_lite_plugin_sanitize_hero_articles_layout( $_POST['public_opinion_lite_front_featured_layout'] ) );
		update_post_meta( $post_id, 'public_opinion_lite_front_featured_category', public_opinion_lite_plugin_sanitize_intval_or_empty( $_POST['public_opinion_lite_front_featured_category'] ) );
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_add_page_sidebar_meta_box' ) ) :
	function public_opinion_lite_plugin_add_page_sidebar_meta_box( $object, $box ) {
		public_opinion_lite_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php

			public_opinion_lite_plugin_print_metabox_tab_sidebar( $object, $box );

		?></div><?php

		public_opinion_lite_plugin_bind_metabox_to_page_template( 'public-opinion-lite-plugin-sidebar', 'default', 'public_opinion_lite_sidebar_metabox_tpl' );
	}
endif;

if ( ! function_exists( 'public_opinion_lite_plugin_add_page_front_page_meta_box' ) ) :
	function public_opinion_lite_plugin_add_page_front_page_meta_box( $object, $box ) {
		public_opinion_lite_plugin_prepare_metabox( 'page' );

		?><div class="ci-cf-wrap"><?php


			public_opinion_lite_plugin_metabox_open_tab( esc_html__( 'Featured posts', 'public-opinion-lite-plugin' ) );

				public_opinion_lite_plugin_metabox_guide(
					wp_kses(
						sprintf(
							/* translators: %s is a post tag. */
							__( 'Featured posts appear on top of the homepage. These are posts tagged with the <em>%s</em> tag. You may optionally restrict the posts shown to a specific category, otherwise featured posts from all categories will be shown.', 'public-opinion-lite-plugin' ),
							get_theme_mod( 'theme_hero_tag', 'featured' )
						),
						public_opinion_lite_plugin_get_allowed_tags( 'guide' )
					)
				);

				$choices = array_merge( array(
					'' => esc_html__( 'Disabled', 'public-opinion-lite-plugin' ),
				), public_opinion_lite_plugin_get_hero_articles_layout_choices() );

				public_opinion_lite_plugin_metabox_dropdown( 'public_opinion_lite_front_featured_layout', $choices, esc_html__( 'Featured Posts Layout:', 'public-opinion-lite-plugin' ) );

				?>
				<p class="ci-field-group ci-field-dropdown">
					<label for="public_opinion_lite_front_featured_category"><?php esc_html_e( 'Featured Post Category:', 'public-opinion-lite-plugin' ); ?></label>
					<?php
						wp_dropdown_categories( array(
							'taxonomy'          => 'category',
							'show_option_none'  => ' ',
							'option_none_value' => '',
							'show_count'        => 1,
							'echo'              => 1,
							'selected'          => get_post_meta( $object->ID, 'public_opinion_lite_front_featured_category', true ),
							'hierarchical'      => 1,
							'name'              => 'public_opinion_lite_front_featured_category',
							'id'                => 'public_opinion_lite_front_featured_category',
							'class'             => 'postform',
						) );
					?>
				</p>
				<?php

			public_opinion_lite_plugin_metabox_close_tab();

		?></div><?php

		public_opinion_lite_plugin_bind_metabox_to_page_template( 'public-opinion-lite-plugin-tpl-front-page', 'templates/front-page.php', 'public_opinion_lite_front_page_metabox_tpl' );
	}
endif;
