<div class="blog_container grid">
	{if $blog.image && $config->get('listing_show_image',1)}
	<div class="blog-image">
		<img class="img-responsive" src="{$blog.preview_url}" title="{$blog.title}"/>
	</div>
	{/if}
	<div class="blog-inner">
		{if $config->get('listing_show_title','1')}
		<h4><a href="{$blog.link|escape:'html':'UTF-8'}" title="{$blog.title}">{$blog.title}</a></h4>
		{/if}

		{if $config->get('listing_show_description','1')}
			<div class="blog-shortinfo">
				{$blog.description|strip_tags:'UTF-8'|truncate:110:'...'}
			</div>
		{/if}
		<div class="blog-group-button clearfix">
					{if $config->get('listing_show_readmore',1)}
						<div class="readmore pull-left">
								<a href="{$blog.link|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}"><i class="icon icon-arrow-circle-right"></i><span>{l s='Read more' mod='leoblog'}</span>
								</a>
						</div>
					{/if}
					<div class="blog-meta pull-right">
						{if $config->get('listing_show_author','1')&&!empty($blog.author)}
						<span class="blog-author">
							<span class="icon icon-pencil-square-o"></span><!-- {l s='Posted By' mod='leoblog'}:  -->
							<a href="{$blog.author_link|escape:'html':'UTF-8'}" title="{$blog.author}">{$blog.author}</a> 
						</span>
						{/if}
						
						{if $config->get('listing_show_category','1')}
						<span class="blog-cat"> 
							<span class="icon icon-list"> </span><!-- {l s='In' mod='leoblog'}  -->
							<a href="{$blog.category_link|escape:'html':'UTF-8'}" title="{$blog.category_title|escape:'html':'UTF-8'}">{$blog.category_title}</a>
						</span>
						{/if}
						
						{if $config->get('listing_show_created','1')}
						<span class="blog-created">
							<span class="icon icon-calendar-o"></span> 
							{strtotime($blog.date_add)|date_format:"%D"}
						</span>
						{/if}
						
						{if isset($blog.comment_count)&&$config->get('listing_show_counter','1')}	
						<span class="blog-ctncomment">
							<span class="icon icon-comment"></span><!-- {l s='Comment' mod='leoblog'}:-->{$blog.comment_count}
						</span>
						{/if}

						{if $config->get('listing_show_hit','1')}	
						<span class="blog-hit">
							<span class="icon icon-heart"></span><!-- {l s='Hit' mod='leoblog'}:-->
							{$blog.hits}
						</span>
						{/if}
					</div>
		</div>
	</div>
</div>