{*
* Pts Prestashop Theme Framework for Prestashop 1.6.x
*
* @package   pspagebuilder
* @version   5.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
<div class="blog_container grid clearfix">	
	{if $item.image && $show_image}
		<div class="blog-image">
			<a href="{$item.link|escape:'html':'UTF-8'}" title="{$item.title|escape:'html':'UTF-8'}" class="link">
				<img src="{$item.preview_url|escape:'html':'UTF-8'}" alt="{$item.title|escape:'html':'UTF-8'}" class="img-responsive"/>
			</a>
		</div>
	{/if}
	<div class="blog-inner">
		{if $show_title}
			<h5 class="clearfix blog-title">
				<a href="{$item.link|escape:'html':'UTF-8'}" title="{$item.title|escape:'html':'UTF-8'}">{$item.title|escape:'html':'UTF-8'}</a>
			</h5>
		{/if}
		{if $show_description}
			<div class="blog-shortinfo">
				{$item.description|strip_tags|truncate:145|escape:'html':'UTF-8'}
			</div>
		{/if}
		<div class="blog-group-button clearfix">
			{if $show_readmore}
				<div class="readmore pull-left">
					<a href="{$item.link|escape:'html':'UTF-8'}" title="{$item.title|escape:'html':'UTF-8'}" class="btn-link"><i class="icon icon-arrow-circle-right"></i><span>{l s='Read more' mod='pspagebuilder'}</span></a>
				</div>
			{/if}
			<div class="blog-meta pull-right">
				<span class="blog-author">
					<span class="icon icon-pencil-square-o"></span><!-- {l s='Posted By' mod='leoblog'}:  -->
					<a href="{$item.author_link|escape:'html':'UTF-8'}" title="{$item.author}">{$item.author}</a> 
				</span>												
				{if $show_category}
					<span class="blog-cat"> <i class="icon icon-list"></i> <!-- {l s='In' mod='pspagebuilder'} -->
						 <a href="{$item.category_link|escape:'html':'UTF-8'}" title="{$item.category_title|escape:'html':'UTF-8'}">{$item.category_title|escape:'html':'UTF-8'}</a>
					</span>
				{/if}
				{if $show_dateadd}
					<span class="blog-created"><i class="icon icon-calendar-o"> </i>
						{strtotime($item.date_add)|escape:'html':'UTF-8'|date_format:"%D"}
					</span>
				{/if}
				{if $show_comment}<span class="blog-ctncomment">
					<i class="icon icon-comment"></i> <!-- {l s='Comment' mod='pspagebuilder'}: -->{$item.comment_count|escape:'html':'UTF-8'}</span>
				{/if}
			</div>
		</div>
	</div>
</div>