{*
* Pts Prestashop Theme Framework for Prestashop 1.6.x
*
* @package   pspagebuilder
* @version   5.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}
{if isset($images)}
	{if isset($columns)}
		{if $columns == 5}
			{assign var='nbItemsPerLine' value=5} 
		{else}
			{assign var='nbItemsPerLine' value=12/$columns}
		{/if}
	{else}
		{assign var='columns' value=4}
		{assign var='nbItemsPerLine' value=4}
	{/if}

	{assign var='nbItemsPerLineDesktop' value=4}
	{assign var='nbItemsPerLineTablet' value=3}
	{assign var='nbItemsPerLineMobile' value=2}
	<div class="widget-gallery {$addition_cls|escape:'html':'UTF-8'} {if isset($stylecls)&&$stylecls}block-{$stylecls|escape:'html':'UTF-8'}{/if}">
		{if isset($widget_heading)&&!empty($widget_heading)}
		<h4 class="title_block">
			{$widget_heading|escape:'html':'UTF-8'}
		</h4>
		{/if}
		{if isset($description)&&!empty($description)}
		<div class="description">
			{$description|escape:'html':'UTF-8'}
		</div>
		{/if}
		<div class="widget-inner block_content clearfix">
				<div class="owl-wrapper images-list nopadding clearfix">	
					{foreach from=$images item=image name=image}
					 		<div class="effect-img col-lg-{if $nbItemsPerLine==5}cus-{/if}{$nbItemsPerLine|escape:'html':'UTF-8'} col-md-{if $nbItemsPerLineDesktop==5}cus-{/if}{12/$nbItemsPerLineDesktop|escape:'html':'UTF-8'} col-sm-{12/$nbItemsPerLineTablet|escape:'html':'UTF-8'} col-xs-{12/$nbItemsPerLineMobile|escape:'html':'UTF-8'} col-xs-cus-12 {if $smarty.foreach.products.iteration%(12/$nbItemsPerLine) == 1} first-in-line{/if}{if $smarty.foreach.products.iteration%(12/$nbItemsPerLineTablet) == 1} first-item-of-tablet-line{/if} {if $smarty.foreach.products.iteration%(12/$nbItemsPerLineMobile) == 1} first-item-of-mobile-line{/if} ">
								<div class="image-item out-bottom">
									<div class="effect-hover">
									 	{if $ispopup}
									 		<a href="{$image.imageurl|escape:'htmlall':'UTF-8'}" class="pts-popup fancybox" title="{l s='Large Image' mod='pspagebuilder'}"><span class="icon icon-expand"></span></a>
									 	{/if}
									 	{if $links}
									 		<a href="{$links|escape:'htmlall':'UTF-8'}" class="pts-btnlink" title="{l s='View more' mod='pspagebuilder'}"><span class="icon icon-paper-plane-o"></span></a>
								 		{/if}
								 	</div>
							 		<span class="img-animation"><img src="{$image.thumbnailurl|escape:'html':'UTF-8'}" alt="" /></span>									
								</div>
							</div>
					{/foreach}
				</div>	
		</div>
	</div>
	<script type="text/javascript">
				(function($){
				var nodes = document.querySelectorAll('.widget-gallery .image-item'),
				_nodes = [].slice.call(nodes, 0);
				var getDirection = function (ev, obj) {
				    // the width and height of the current div
					var w = $(obj).width(),
						h = $(obj).height(),
						// calculate the x and y to get an angle to the center of the div from that x and y.
						// gets the x value relative to the center of the DIV and "normalize" it
						x = ( ev.pageX - $(obj).offset().left - ( w/2 )) * ( w > h ? ( h/w ) : 1 ),
						y = ( ev.pageY - $(obj).offset().top  - ( h/2 )) * ( h > w ? ( w/h ) : 1 ),
						// the angle and the direction from where the mouse came in/went out clockwise (TRBL=0123);
						// first calculate the angle of the point,
						// add 180 deg to get rid of the negative values
						// divide by 90 to get the quadrant
						// add 3 and do a modulo by 4  to shift the quadrants to a proper clockwise TRBL (top/right/bottom/left) **/
						direction = Math.round( ( ( ( Math.atan2(y, x) * (180 / Math.PI) ) + 180 ) / 90 ) + 3 ) % 4;
					return direction;
				};
				var addClass = function ( ev, obj, state ) {
				    var direction = getDirection( ev, obj ),
				        class_suffix = "";
				    obj.className = "";
				    switch ( direction ) {
				        case 0 : class_suffix = '-top';    break;
				        case 1 : class_suffix = '-right';  break;
				        case 2 : class_suffix = '-bottom'; break;
				        case 3 : class_suffix = '-left';   break;
				    }
				    obj.classList.add( state + class_suffix );
				};
				// bind events
				_nodes.forEach(function (el) {
				    el.addEventListener('mouseenter', function (ev) {
				        addClass( ev, this, 'in' );
				    }, false);
				    el.addEventListener('mouseleave', function (ev) {
				        addClass( ev, this, 'out' );
				    }, false);
				});
			})(jQuery);
			</script>

			{/if}	
