{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
{include file="$tpl_dir./errors.tpl"}
{if isset($category)}
    {if $category->id AND $category->active}
        {if isset($subcategories)}
            <div class="categories clearfix">
                <h1 class="page-heading{if (isset($subcategories) && !$products) || (isset($subcategories) && $products) || !isset($subcategories) && $products} product-listing{/if}">{$category->name|escape:'html':'UTF-8'}{if isset($categoryNameComplement)}&nbsp;{$categoryNameComplement|escape:'html':'UTF-8'}{/if}
                    {include file="$tpl_dir./category-count.tpl"}
                </h1>
                    <div class="row">
                        <div class="col-xs-12 col-sm-5 col-md-5">
                            {if $scenes || $category->description || $category->id_image}
                                <div class="content_scene_cat">
                                    {if $scenes}
                                        <div class="content_scene">
                                            <!-- Scenes -->
                                            {include file="$tpl_dir./scenes.tpl" scenes=$scenes}
                                            {if $category->description}
                                                <div class="cat_desc rte">
                                                    {if Tools::strlen($category->description) > 350}
                                                        <div id="category_description_short">{$description_short}</div>
                                                        <div id="category_description_full" class="unvisible">{$category->description}</div>
                                                        <a href="{$link->getCategoryLink($category->id_category, $category->link_rewrite)|escape:'html':'UTF-8'}" class="lnk_more">{l s='More'}</a>
                                                    {else}
                                                        <div>{$category->description}</div>
                                                    {/if}
                                                </div>
                                            {/if}
                                        </div>
                                    {else}
                                        <!-- Category image -->
                                        <div class="content_scene_cat_bg">
                                            <img class="img-responsive" src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category_default')|escape:'html':'UTF-8'}"  itemprop="image" />
                                        </div>                   
                                    {/if}
                                </div>
                            {/if}
                            <div class="category-info">
                                {if $category->description}
                                   <div class="cat_desc">
                                       {if strlen($category->description) > 350}
                                           <div id="category_description_short">{$description_short}</div>
                                            <div id="category_description_full" class="unvisible rte">{$category->description}</div>                         
                                          
                                       {else}
                                           <div class="rte">{$category->description}</div>
                                       {/if}
                                   </div>
                               {/if}
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-7 col-md-7">
                            {if isset($subcategories)}
                                {if (isset($display_subcategories) && $display_subcategories eq 1) || !isset($display_subcategories) }
                                    <div class="block block-borderbox">
                                        <h4 class="title_block">{l s='subcategories'}</h4>
                                    <!-- Subcategories -->
                                        <div id="subcategories" class="block_content box-content">
                                            <!-- <div class="subcategory-heading">{l s='Subcategories :'}</div> -->
                                            <ul class="list-unstyled row">
                                                {foreach from=$subcategories item=subcategory}
                                                    <li class="col-xs-cus-12 col-xs-6 col-sm-4 col-md-4">
                                                        <div class="subcategory-container">
                                                            <div class="subcategory-image">
                                                                <a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'html':'UTF-8'}" title="{$subcategory.name|escape:'html':'UTF-8'}" class="img">
                                                                {if $subcategory.id_image}
                                                                    <img class="replace-2x" src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'category_default')|escape:'html':'UTF-8'}" alt="{$subcategory.name|escape:'html':'UTF-8'}" />
                                                                {else}
                                                                    <img class="replace-2x" src="{$img_cat_dir}{$lang_iso}-default-category_default.jpg" alt="{$subcategory.name|escape:'html':'UTF-8'}" />
                                                                {/if}
                                                                </a>
                                                            </div>
                                                            <h4><a class="subcategory-name" href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'html':'UTF-8'}">{$subcategory.name|truncate:25:'...'|escape:'html':'UTF-8'|truncate:350}</a></h4>
                                                        </div>
                                                    </li>
                                                {/foreach}
                                            </ul>
                                        </div>
                                    </div>
                                {/if}
                            {/if}
                        </div>
                    </div>
            </div>
        {/if}
        {if $products}
            <div class="content_sortPagiBar product-filter clearfix">
                <div class="row">
                    <div class="sortPagiBar col-lg-6 col-md-6 col-sm-6 col-xs-8">
                        {include file="./product-sort.tpl"}
                    </div>
                    <div class="hidden-xs hidden-sm col-md-3  col-lg-4">{include file="./nbr-product-page.tpl"}</div><!-- error pagination -->
                    <div class="top-pagination-content col-lg-2 col-md-3 col-sm-6 col-xs-4">
                            {include file="./product-compare.tpl"}
                    </div>
                </div>
            </div>
            {include file="./product-list.tpl" products=$products}
            <div class="bottom-pagination-content content_sortPagiBar clearfix">
                 {include file="./pagination.tpl" paginationId='bottom'}
            </div>
        {/if}
    {elseif $category->id}
        <p class="alert alert-warning">{l s='This category is currently unavailable.'}</p>
    {/if}
{/if}