{*
* Pts Prestashop Theme Framework for Prestashop 1.6.x
*
* @package   pspagebuilder
* @version   5.0
* @author    http://www.prestabrain.com
* @copyright Copyright (C) October 2013 prestabrain.com <@emai:prestabrain@gmail.com>
*               <info@prestabrain.com>.All rights reserved.
* @license   GNU General Public License version 2
*}

{if !empty($products)}
	<div class="product-block" >
		<div class="product-container row" itemscope="" itemtype="https://schema.org/Product">
			<div class="product-image-container image col-xs-cus-12 col-xs-5 col-sm-5 col-md-5">
				<a class="img product_img_link"	href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url">
					<img class="replace-2x img-responsive" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'home_default')|escape:'html':'UTF-8'}" alt="{if !empty($product.legend)}{$product.legend|escape:'html':'UTF-8'}{else}{$product.name|escape:'html':'UTF-8'}{/if}" />
					{if isset($iteration)}<span class="hidden count">{$iteration}</span>{/if}
				</a>
						
			</div>
			<div class="col-xs-cus-12 col-xs-7 col-sm-7 col-md-7">
                <div class="product-content">
                    <h4 class="name media-heading" itemprop="name">
                       {if isset($product.pack_quantity) && $product.pack_quantity}{$product.pack_quantity|intval|cat:' x '}{/if}
							<a href="{$product.link|escape:'html':'UTF-8'}" title="{$product.name|escape:'html':'UTF-8'}" itemprop="url" >
								{$product.name|truncate:45:'...'|escape:'html':'UTF-8'}
							</a>
                    </h4>
                    <div class="product-desc description" itemprop="description">
						{$product.description_short|strip_tags:'UTF-8'|truncate:200:'...'|escape:'html':'UTF-8'}
					</div>
                    {if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
						<div itemprop="offers" itemscope="" itemtype="https://schema.org/Offer" class="content_price price">
							{if isset($product.show_price) && $product.show_price && !isset($restricted_country_mode)}
								<span itemprop="price" class="product-price {if isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}new-price {/if}">
									{if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
								</span>
								{if isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}
									<span class="old-price">
										{displayWtPrice p=$product.price_without_reduction}
									</span>
									
								{/if}
								<meta itemprop="priceCurrency" content="{$priceDisplay}" />								
							{/if}
						</div>
					{/if}
                    <!-- {hook h='displayProductListReviews' product=$product} -->
                    <!-- <p class="product-description description">{$product.description_short|strip_tags:'UTF-8'|truncate:75:'...'}</p> -->
                </div>
            </div>
						
		</div><!-- .product-container> -->
	</div>				
{/if}
