<?php

 /**
 * Enable support for Post Thumbnails on posts and pages.
 *
 */
    add_theme_support('post-thumbnails');
    /* Set the image size by cropping the image */
    add_image_size( 'portfoliolite-standard-thumb', 800, 450, true );
    add_image_size( 'portfoliolite-portfolio-thumbnail', 350, 260, true );
    add_image_size( 'portfoliolite-custom-two-grid-thumb', 660, 350, true );
    add_image_size( 'portfoliolite-custom-three-grid-thumb', 350, 260, true );
    add_image_size( 'portfoliolite-custom-four-grid-thumb', 321, 238, true );
    
function portfoliolite_grid_thumb($grid_layout, $thumb_crop=true){
    if($thumb_crop):
switch($grid_layout){
        case 'two-grid':
             the_post_thumbnail('portfoliolite-custom-two-grid-thumb');
            break;
        case 'standard-layout':
             the_post_thumbnail('portfoliolite-custom-three-grid-thumb');
            break;
        case 'four-grid':
             the_post_thumbnail('portfoliolite-custom-four-grid-thumb');
            break;
        
        
}   
else:
switch($grid_layout){
        case 'two-grid':
            echo portfoliolite_post_image(660, 350);
            break;
        case 'standard-layout':
            echo portfoliolite_post_image(350, 260);
            break;
        case 'four-grid':
             echo portfoliolite_post_image(321, 238);
            break;
                
}  
endif;
}
if ( ! function_exists( 'portfoliolite_the_custom_logo' ) ) :
/*
 * Displays the optional custom logo.
 * Does nothing if the custom logo is not available.
 */
function portfoliolite_the_custom_logo() {
    if ( function_exists( 'the_custom_logo' ) ) {
        the_custom_logo();
    }
}
endif;


/*
 * Custom header menu
*/
add_action( 'after_setup_theme', 'register_theme_menu' );
function register_theme_menu() {
register_nav_menus( 
array(
        'home-menu'     => __( 'Front Menu', 'portfoliolite' ),
        'frontpage-menu' => __( 'Main Menu', 'portfoliolite' ),
    ) );
}
function portfoliolite_nav_menu(){
        wp_nav_menu( array('theme_location' => 'home-menu', 
        'container' => false, 
        'menu_class' => 'menu', 
        'menu_id'         => 'menu',
        'fallback_cb'     => 'portfoliolite_wp_page_menu'));
}
function portfoliolite_front_nav_menu(){
        wp_nav_menu( array('theme_location' => 'frontpage-menu', 
        'container' => false, 
        'menu_class' => 'menu', 
        'menu_id'         => 'menu',
        'fallback_cb'     => 'portfoliolite_wp_page_menu'));
    }
function portfoliolite_wp_page_menu(){
    echo '<ul class="menu" id="menu">';
    wp_list_pages(array('title_li' => ''));
    echo '</ul>';
}

// full thumb get post content
function portfoliolite_full_post_image(){
$img_source = '';
global $post;
$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);

    if (isset($matches [1] [0])) {
        $img_source = $matches [1] [0];
    }
     if($img_source!=''){
         $permalink = get_permalink($post->ID);
        print "<a href='$permalink'><img src='$img_source' class='postimg' alt='Post Image'/></a>";
        }
}
// post content image thumbnail
function portfoliolite_post_image($width, $height) {
    $w = $width;
    $h = $height;
    global $post;
    //This is required to set to Null
    $img_source = '';
    $permalink = get_permalink($post->ID);
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);

    if (isset($matches [1] [0])) {
        $img_source = $matches [1] [0];
    }
    if($img_source!=''){
    $img_path = th_image_resize($img_source, $w, $h);
    if (!empty($img_path['url'])) {
        print "<a href='$permalink'><img src='$img_path[url]' class='postimg' alt='Post Image'/></a>";
    }
  }
}
/*
 * Display navigation to next/previous post when applicable.
 * @since ThemeHunk 1.0
 */
if ( ! function_exists( 'portfoliolite_post_nav' ) ) :
function portfoliolite_post_nav() {
    // Don't print empty markup if there's nowhere to navigate.
    ?>
    <nav class="navigation post-navigation" role="navigation">
        <div class="nav-links">
           <?php
              the_post_navigation( array(
                'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( '%title', 'portfoliolite' ) . '</span> ' ,
                'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( '%title', 'portfoliolite' )));
                //%title
            ?>
        </div><!-- .nav-links -->
    </nav><!-- .navigation -->
    <?php
}
endif;
// portfolio function
add_action( 'init', 'portfoliolite_gallery_post_type' );
function portfoliolite_gallery_post_type() {
register_post_type( 'portfolio',
      array(
      'labels' => array(
      'name' => __( 'Portfolio Gallery','portfoliolite' ),
      'singular_name' => __( 'Portfolio Gallery','portfoliolite' ),
      'supports' => array( 'title', 'editor', 'thumbnail' ),
      'taxonomy' => array('category')
      ),
      'public' => true,
      'has_archive' => true,
      'supports' => array('title','editor','author','thumbnail')
      )
  );
}
//add category
add_action('init', 'portfoliolite_add_default_category');
function portfoliolite_add_default_category() {
register_taxonomy_for_object_type('category', 'portfolio');
}
/**
 * Display breadcrumb post/page.
 */
function portfoliolite_breadcrumb() {
 
     /* === OPTIONS === */
    $text['home']     = 'Home'; // text for the 'Home' link
    $text['category'] = 'Archive by Category "%s"'; // text for a category page
    $text['search']   = 'Search Results for "%s" Query'; // text for a search results page
    $text['tag']      = 'Posts Tagged "%s"'; // text for a tag page
    $text['author']   = 'Articles Posted by %s'; // text for an author page
    $text['404']      = 'Error 404'; // text for the 404 page
 
    $show_current   = 1; // 1 - show current post/page/category title in breadcrumbs, 0 - don't show
    $show_on_home   = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
    $show_home_link = 1; // 1 - show the 'Home' link, 0 - don't show
    $show_title     = 1; // 1 - show the title for the links, 0 - don't show
    $delimiter      = ' &raquo; '; // delimiter between crumbs
    $before         = '<span class="current">'; // tag before the current crumb
    $after          = '</span>'; // tag after the current crumb
    /* === END OF OPTIONS === */
    global $post;
    $home_link    = home_url('/');
    $link_before  = '<span typeof="v:Breadcrumb">';
    $link_after   = '</span>';
    $link_attr    = ' rel="v:url" property="v:title"';
    $link         = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
    $parent_id    = $parent_id_2 = $post->post_parent;
    $frontpage_id = get_option('page_on_front');
    if (is_home() || is_front_page()) {
    if ($show_on_home == 1) echo '<div class="breadcrumbs"><a href="' . $home_link . '">' . $text['home'] . '</a></div>';
    } else {
        echo '<div class="breadcrumbs" >';
        if ($show_home_link == 1) {
            echo '<a href="' . $home_link . '" rel="v:url" property="v:title">' . $text['home'] . '</a>';
            if ($frontpage_id == 0 || $parent_id != $frontpage_id) echo $delimiter;
        }
        if ( is_category() ) {
            $this_cat = get_category(get_query_var('cat'), false);
            if ($this_cat->parent != 0) {
                $cats = get_category_parents($this_cat->parent, TRUE, $delimiter);
                if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
                $cats = str_replace('</a>', '</a>' . $link_after, $cats);
                if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
                echo $cats;
            }
            if ($show_current == 1) {
                echo $before . sprintf($text['category'], single_cat_title('', false)) . $after;
            }
 
        } elseif ( is_search() ) {
            echo $before . sprintf($text['search'], get_search_query()) . $after;
 
        } elseif ( is_day() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')) . $delimiter;
            echo $before . get_the_time('d') . $after;
 
        } elseif ( is_month() ) {
            echo sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')) . $delimiter;
            echo $before . get_the_time('F') . $after;
 
        } elseif ( is_year() ) {
            echo $before . get_the_time('Y') . $after;
 
        } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                printf($link, $home_link . '/' . $slug['slug'] . '/', $post_type->labels->singular_name);
                if ($show_current == 1) {
                    echo $delimiter . $before . get_the_title() . $after;
                }
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, $delimiter);
                if ($show_current == 0) $cats = preg_replace("#^(.+)$delimiter$#", "$1", $cats);
                $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
                $cats = str_replace('</a>', '</a>' . $link_after, $cats);
                if ($show_title == 0) $cats = preg_replace('/ title="(.*?)"/', '', $cats);
                echo $cats;
                if ($show_current == 1) echo $before . get_the_title() . $after;
            }
 
        } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            $post_type = get_post_type_object(get_post_type());
            echo $before . $post_type->labels->singular_name . $after;
 
        } elseif ( is_attachment() ) {
            $parent = get_post($parent_id);
            $cat = get_the_category($parent->ID); $cat = $cat[0];
            $cats = get_category_parents($cat, TRUE, $delimiter);
            $cats = str_replace('<a', $link_before . '<a' . $link_attr, $cats);
            $cats = str_replace('</a>', '</a>' . $link_after, $cats);
            if ($show_title == 0){ 
                $cats = preg_replace('/ title="(.*?)"/', '', $cats);
            }
            echo $cats;
            printf($link, get_permalink($parent), $parent->post_title);
            if ($show_current == 1) echo $delimiter . $before . get_the_title() . $after;
 
        } elseif ( is_page() && !$parent_id ) {
            if ($show_current == 1) echo $before . get_the_title() . $after;
 
        } elseif ( is_page() && $parent_id ) {
            if ($parent_id != $frontpage_id) {
                $breadcrumbs = array();
                while ($parent_id) {
                    $page = get_page($parent_id);
                    if ($parent_id != $frontpage_id) {
                        $breadcrumbs[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
                    }
                    $parent_id = $page->post_parent;
                }
                $breadcrumbs = array_reverse($breadcrumbs);
                for ($i = 0; $i < count($breadcrumbs); $i++) {
                    echo $breadcrumbs[$i];
                    if ($i != count($breadcrumbs)-1) {
                        echo $delimiter;
                    }
                }
            }
            if ($show_current == 1) {
                if ($show_home_link == 1 || ($parent_id_2 != 0 && $parent_id_2 != $frontpage_id)) {echo $delimiter;}
                echo $before . get_the_title() . $after;
            }
 
        } elseif ( is_tag() ) {
            echo $before . sprintf($text['tag'], single_tag_title('', false)) . $after;
 
        } elseif ( is_author() ) {
            global $author;
            $userdata = get_userdata($author);
            echo $before . sprintf($text['author'], $userdata->display_name) . $after;
 
        } elseif ( is_404() ) {
            echo $before . $text['404'] . $after;
        }
 
        if ( get_query_var('paged') ) {
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) {echo ' (';}
            echo __('Page','portfoliolite') . ' ' . get_query_var('paged');
            if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ){ echo ')';}
        }
      echo '</div><!-- .breadcrumbs -->';
    }
}
/**
 * custom post excerpt
 */
function portfoliolite_get_th_custom_excerpt(){
$excerpt = get_the_content();
$excerpt = preg_replace(" (\[.*?\])",'',$excerpt);
$excerpt = strip_shortcodes($excerpt);
$excerpt = strip_tags($excerpt);
$excerpt = substr($excerpt, 0, 100);
$excerpt = substr($excerpt, 0, strripos($excerpt, " "));
$excerpt = trim(preg_replace( '/\s+/', ' ', $excerpt));
//$return =  '<p>'.$excerpt.'</p><span class="read-more"><a href="'.get_permalink().'" >Read More</a></span>';
return '<p>'.$excerpt.'</p>';
}

// related post
function portfoliolite_get_related_sigle_post() {
global $post;
$args = array(
               'category__in' => wp_get_post_categories($post->ID),
               'post__not_in' => array($post->ID),
               'post_status' => array('publish'),                         
               'meta_key' => '_thumbnail_id',
               'posts_per_page' => 3,
            );
    $my_query = new WP_Query($args);
    if ($my_query->have_posts()) {
    while ($my_query->have_posts()) : $my_query->the_post();
    ?>
    <li class="sl-related-thumbnail">
        <div class="sl-related-thumbnail-size">
            <?php
                if ((function_exists('has_post_thumbnail')) && (has_post_thumbnail())) {
                ?>
                <a href="<?php esc_url(the_permalink()); ?>"><?php the_post_thumbnail('custom-releted-post-thumb',array('class' => "postimg listing-thumbnail")); ?></a>
                            <?php
                        } else {
                            ?><a href="<?php esc_url(the_permalink()); ?>"><?php portfoliolite_post_image(358, 205); ?></a>
                        <?php } ?>
                        </div>
                    <h3><a href="<?php esc_url(the_permalink()); ?>"><?php the_title(); ?></a></h3>
                </li>
                <?php
            endwhile;
        }
    wp_reset_query(); // to use the original query again
}

/*auto width and height removed*/
 add_filter( 'post_thumbnail_html', 'portfoliolite_remove_thumbnail_dimensions', 10, 3 );
function portfoliolite_remove_thumbnail_dimensions( $html, $post_id, $post_image_id ) {
   $html = preg_replace( '/(width|height)=\"\d*\"\s/', "", $html );
   return $html;
}
function portfoliolite_get_my_url() {
    if ( ! preg_match( '/<a\s[^>]*?href=[\'"](.+?)[\'"]/is', get_the_content(), $matches ) ){
        return false;
    }
    return esc_url_raw( $matches[1] );
}
/*Number of comment*/
function portfoliolite_comment_number(){
comments_popup_link(__('No Comment','portfoliolite'), __('1 Comment','portfoliolite'), __('% Comments','portfoliolite')); 
 }
/*
* dynamic social link
*/
function portfoliolite_social_links(){
?>
    <ul>
<?php if($f_link = get_theme_mod('f_link')) : ?><li class="social-social"><a target='_blank' href="<?php echo $f_link; ?>" ><i class='fa fa-facebook'></i></a></li><?php endif; ?>
<?php if($t_link = get_theme_mod('t_link')) : ?><li class="social-social"><a target='_blank' href="<?php echo $t_link; ?>" ><i class='fa fa-twitter'></i></a></li><?php endif; ?>
<?php if($g_link = get_theme_mod('g_link')) : ?><li class="social-social"><a target='_blank' href="<?php echo $g_link; ?>" ><i class='fa fa-google-plus'></i></a></li><?php endif; ?>
<?php if($l_link = get_theme_mod('l_link')) : ?><li class="social-social"><a target='_blank' href="<?php echo $l_link; ?>" ><i class='fa fa-linkedin'></i></a></li><?php endif; ?>
<?php if($p_link = get_theme_mod('p_link')) : ?><li class="social-social"><a target='_blank' href="<?php echo $p_link; ?>" ><i class='fa fa-pinterest'></i></a></li><?php endif; ?>
    </ul>
<?php
  }
/*
 *   Mobile device detection
 */
if( !function_exists('portfoliolite_mobile_user_agent_switch') ){
    function portfoliolite_mobile_user_agent_switch(){
        $device = '';
        
        if( stristr($_SERVER['HTTP_USER_AGENT'],'ipad') ) {
            $device = "ipad";
        } else if( stristr($_SERVER['HTTP_USER_AGENT'],'iphone') || strstr($_SERVER['HTTP_USER_AGENT'],'iphone') ) {
            $device = "iphone";
        } else if( stristr($_SERVER['HTTP_USER_AGENT'],'blackberry') ) {
            $device = "blackberry";
        } else if( stristr($_SERVER['HTTP_USER_AGENT'],'android') ) {
            $device = "android";
        }

        if( $device ) {
            return $device; 
        }else{
            return false;
        }
    }
}
function portfoliolite_get_category_list($perpage = 8){ 
$args = array(
  'type'                     => 'portfolio',
  'child_of'                 => 0,
  'parent'                   => '',
  'orderby'                  => 'name',
  'order'                    => 'ASC',
  'hide_empty'               => 1,
  'exclude'                  => '',
  'include'                  => get_theme_mod('our_port_category',0),
  );
$cats = get_categories($args);
$i=1;
    $categlist = '<li><button id="filters" class="pl-portfolio active is-checked" data-filter="*">'.__("All","portfoliolite").'</button></li>';
foreach ($cats as $cat){
    $categlist .= '<li><button class="pl-portfolio filter'.$i.'" data-filter=".' . $cat->slug . '" post_count="'.$cat->count.'">' . $cat->name . '</button></li>'; 
    $i++;
} 
 $return = '<ul class="portfolio-navi" plcatlist="'.$i.'" portfoliolite_perpage = "'.$perpage.'" >';
 $return .= $categlist;
 $return .= '</ul>';
 return $return;
}
function portfoliolite_portfolio_ajax(){
          $layout = get_theme_mod('dynamic_grid','');
          $loop = new WP_Query( array(
          'suppress_filters' => true,
          'post_type' => 'portfolio',
          'category_name' => $_POST['cate_slug'],
          'posts_per_page' => 3,
          'paged'     => $_POST['post_page'],
          'meta_query' => array(array( 'key' => '_thumbnail_id')),
          ));
          if ($loop->have_posts()) {
          $i = 0;
          while ($loop->have_posts()) : $loop->the_post();
          $postCats = get_the_category();
          $liscats = '';
          foreach ($postCats as $cats){
          $liscats .= $cats->slug .' ';
          }
          echo '<li class="element-item post '.$liscats.'" data-category="transition">'?>
            <div class="portfolio-image">
              <figure class="protfolio-img-efc">
              <?php if ( $layout =='four-Masnory' || $layout =='three-Masnory' ){ ?>
                 <?php if ( has_post_thumbnail() ) : ?>
                  <a href="<?php esc_url(the_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                  <?php the_post_thumbnail(); ?>
                 </a>
                 <?php endif; ?>
                <?php }else{?>
                <?php if ((function_exists('has_post_thumbnail')) && (has_post_thumbnail())) { ?>
                <a href="<?php esc_url(the_permalink()); ?>">
                  <?php the_post_thumbnail('portfoliolite-portfolio-thumbnail'); ?>
                </a>
                <?php } } ?>
                <figcaption>
                <a href="<?php esc_url(the_permalink()); ?>"><h3><?php the_title(); ?></h3></a>
                <p><?php the_category(', '); ?></p>
                </figcaption>
              </figure>
            </div>
          </li>
<?php 
    endwhile; 
}else{
    echo '1';
}
wp_reset_postdata();
die();
}
add_action('wp_ajax_nopriv_portfoliolite_portfolio_ajax', 'portfoliolite_portfolio_ajax'); // load more
add_action('wp_ajax_portfoliolite_portfolio_ajax', 'portfoliolite_portfolio_ajax');
function portfoliolite_page_thumb(){
return wp_get_attachment_url(get_post_thumbnail_id());
}

?>