<?php
     //  =============================
     //  = Default Theme Customizer Settings  =
     //  @ portfoliolite Theme
     //  =============================
/*theme customizer*/
function portfoliolite_customize_register( $wp_customize ) {
   $cats = array();
   $cats[0] = 'All Categories';
   foreach ( get_categories() as $categories => $category ){
   $cats[$category->term_id] = $category->name;
 }
include_once( plugin_dir_path(__FILE__)  . '/color-picker/alpha-color-picker.php' );
$palette = array(
        'rgba(255, 0, 0, 0.7)',
        'rgba(54, 0, 170, 0.8)',
        '#FFCC00',
        'rgba( 20, 20, 20, 0.8 )',
        '#666666',
        '#F5f5f5',
        '#2B4267'
    );
     //  =============================
     //  = Genral Settings     =
     //  =============================
$wp_customize->get_section('title_tagline')->title = esc_html__('General Settings', 'portfoliolite');
   $wp_customize->get_section('title_tagline')->priority = 3;
   //Menu Options
    $wp_customize->add_setting('title_disable', array(
        'default'           => 'enable',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('title_disable', array(
    'label'    => __('Display Site Title & Tagline', 'portfoliolite'),
    'section'  => 'title_tagline',
    'settings' => 'title_disable',
    'type'       => 'checkbox',
    'choices'    => array(
    'enable' => 'Display Site Title & Tagline',
        ),
    ));
    
    $wp_customize->add_section('section_settings', array(
        'title'    => __('Home Page Section Settings', 'portfoliolite'),
        'priority' => 3,
    ));
 // section ordering
$wp_customize->add_setting('section_sorting', array(
        'default'        =>array('section_portfolio','section_resume','section_team',
        'section_testimonial','section_blog','section_news','section_pricing',),
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_checkbox_explode',
    ));
    $wp_customize->add_control(new PORTFOLIOLITE_Customize_Sort_List(
            $wp_customize,'section_sorting', array(
        'settings' => 'section_sorting',
        'label'   => __( 'Section Order Option', 'portfoliolite' ),
        'section' => 'section_settings',
        'choices' => array(
                    'section_portfolio'        => __( '1 Our portfolio Section', 'portfoliolite' ),
                    'section_resume'           => __( '2 Our Resume Section',  'portfoliolite' ),
                    'section_team'             => __( '3 Our Team Section',  'portfoliolite' ),
                    'section_testimonial'      => __( '4 Our Testimonial Section', 'portfoliolite' ),
                    'section_blog'             => __( '5 Our Blog Section', 'portfoliolite' ),
                    'section_news'             => __( '6 News Letter Section', 'portfoliolite' ),

                    'section_pricing'          => __( '7 Our Price Section', 'portfoliolite' ),
            )
        ) 
    )
);
  //= Choose Post Meta  =
    $wp_customize->add_setting('section_animation', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control( 'section_animation', array(
        'settings' => 'section_animation',
        'label'   => __('Animation On/Off Option','portfoliolite'),
        'section' => 'section_settings',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));
//header-area add
 $wp_customize->add_section('header_area', array(
        'title'    => __('Header Settings', 'portfoliolite'),
        'priority' => 3,
    ));
$wp_customize->add_setting('header_fxd', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));
$wp_customize->add_control( 'header_fxd', array(
        'settings' => 'header_fxd',
        'label'   => __('Header','portfoliolite'),
        'type'    => 'radio',
        'section' => 'header_area',
        'choices'    => array(
            'on'        =>'Sticky',
            'off'      => 'Static',
        ),
    ));
        //  ============================= //
        //  S1 = TOP-about-me sections  =
        //  ============================= //
 $wp_customize->add_panel( 'parallax_panel', array(
    'priority'       => 4,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Top Section', 'portfoliolite'),
    'description'    => '',
) );

// START BACKGROUND SLIDER IMAGE
//slider speed
  $wp_customize->add_section('section_slider', array(
        'title'    => __('Background Images', 'portfoliolite'),
        'priority' => 2,
         'panel'  => 'parallax_panel',
    ));  
 
     
// parallax/on/off
$wp_customize->add_setting('top_parallax', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control( 'top_parallax', array(
        'settings' => 'top_parallax',
        'label'   => __('Parallax On/Off Option','portfoliolite'),
        'section' => 'section_slider',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));

//first slider image
    $wp_customize->add_setting('first_slider_image', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_upload',
    ));
   $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize, 'first_slider_image', array(
        'label'    => __('First Image Upload', 'portfoliolite'),
        'section'  => 'section_slider',
        'settings' => 'first_slider_image',
    )));
$wp_customize->add_setting('ovrly_color',
            array(
            'default'     => 'rgba(41, 41, 41, 0.68);',
            'type'        => 'theme_mod',
            'capability'  => 'edit_theme_options',
            
        ) );

    $wp_customize->add_control( new Customize_Alpha_Color_Control($wp_customize,
            'ovrly_color',
            array(
                'label'     => __('Image Overlay', 'portfoliolite' ),
                'section'   => 'section_slider',
                'settings'  => 'ovrly_color',
                'palette'   => $palette
            )
        )
    );

//END BACKGROUND SLIDER IMAGE 
//About-me heading and subheading
    $wp_customize->add_section('parallax_heading_option', array(
        'title'    => __('Typewriter & Caption Settings', 'portfoliolite'),
        'priority' => 5,
        'panel'  => 'parallax_panel',
    ));
// typerspeed
$wp_customize->add_setting('typer_speed', array(
        'default'           => __('100','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
    $wp_customize->add_control('typer_speed', array(
        'label'    => __('Typewriter Speed', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'typer_speed',
         'type'       => 'text',
    ));
    $wp_customize->add_setting('parallax_heading', array(
        'default'           => __('I am Wordpress Developer','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
   $wp_customize->add_control('parallax_heading', array(
        'label'    => __(' Main Heading', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_heading',
         'type'       => 'text',
    )); 
//one
    $wp_customize->add_setting('parallax_subheading_one', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
    $wp_customize->add_control('parallax_subheading_one', array(
        'label'    => __('Typewriter Text 1', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_subheading_one',
         'type'       => 'text',
    ));
//two
$wp_customize->add_setting('parallax_subheading_two', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
$wp_customize->add_control('parallax_subheading_two', array(
        'label'    => __('Typewriter Text 2', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_subheading_two',
         'type'       => 'text',
    ));
    
// button1
 $wp_customize->add_setting('parallax_button_text1', array(
        'default'           => __('Show Profile','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
   $wp_customize->add_control('parallax_button_text1', array(
        'label'    => __('Button text', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_button_text1',
         'type'       => 'text',
    ));
$wp_customize->add_setting('parallax_button_link1', array(
        'default'           => '#',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ));
   $wp_customize->add_control('parallax_button_link1', array(
        'label'    => __('Button Link1', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_button_link1',
         'type'       => 'text',
    ));
//button2
$wp_customize->add_setting('parallax_button_text2', array(
        'default'           => __('Read More','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
   $wp_customize->add_control('parallax_button_text2', array(
        'label'    => __('Button text2', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_button_text2',
         'type'       => 'text',
    ));
$wp_customize->add_setting('parallax_button_link2', array(
        'default'           => '#',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
    ));
   $wp_customize->add_control('parallax_button_link2', array(
        'label'    => __('Button Link2', 'portfoliolite'),
        'section'  => 'parallax_heading_option',
        'settings' => 'parallax_button_link2',
         'type'       => 'text',
));

//-------------------End Parallax Panel----------------------------//
// start portfoliolite //
$wp_customize->add_panel( 'home_portfo', array(
    'priority'       => 4,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Portfolio Section', 'portfoliolite'),
    'description'    => '',
));
$wp_customize->add_section('our_port_settings', array(
        'title'    => __('Portfolio Settings', 'portfoliolite'),
        'priority' => 3,
        'panel'  => 'home_portfo',
    ));
//choose container-width
$wp_customize->add_setting('dynamic_wdth', array(
        'default'        => 'normal',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',
    ));
    $wp_customize->add_control( 'dynamic_wdth', array(
        'settings' => 'dynamic_wdth',
        'label'   => __('Choose Container Width','portfoliolite'),
        'section' => 'our_port_settings',
        'type'    => 'select',
        'choices'    => array(
        'normal'                 => __('Normal','portfoliolite'),
        'full-width'             => __('Full Width','portfoliolite'),
            
        ),
    ));
//= Choose Grid Layout  =
     $wp_customize->add_setting('dynamic_grid', array(
        'default'        => 'standard-layout',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',
    ));
    $wp_customize->add_control( 'dynamic_grid', array(
        'settings' => 'dynamic_grid',
        'label'   => __('Choose Portfolio Layout','portfoliolite'),
        'section' => 'our_port_settings',
        'type'    => 'select',
        'choices'    => array(
            
            'two-grid'               => __('Two Grid','portfoliolite'),
            'standard-layout'        => __('Three Grid','portfoliolite'),
            'four-grid'              => __('Four Grid','portfoliolite'),
            
        ),
    ));

$wp_customize->add_setting('our_port_default_images', array(
        'default'           => 9,
        'sanitize_callback' => 'portfoliolite_sanitize_int',
       
));
   $wp_customize->add_control('our_port_default_images', array(
        'label'    => __('Number of Portfolio Images To Show', 'portfoliolite'),
        'section'  => 'our_port_settings',
        'settings' => 'our_port_default_images',
        'type'     => 'number',
    )); 

   $wp_customize->add_setting('our_port_category', array(
        'default'           =>array(0),
        'sanitize_callback' => 'portfoliolite_checkbox_explode'
    ));
    $wp_customize->add_control(new PORTFOLIOLITE_Customize_Control_Checkbox_Multiple(
            $wp_customize,'our_port_category', array(
        'settings' => 'our_port_category',
        'label'   => __( 'Check Category To Display', 'portfoliolite' ),
        'section' => 'our_port_settings',
        'choices' => $cats
        ) 
    )
);

$wp_customize->add_section('our_port_heading_option', array(
        'title'    => __('Heading & Subheading Option', 'portfoliolite'),
        'priority' => 1,
        'panel'  => 'home_portfo',
    ));

    $wp_customize->add_setting('our_port_heading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
       
    ));
   $wp_customize->add_control('our_port_heading', array(
        'label'    => __('Main Heading', 'portfoliolite'),
        'section'  => 'our_port_heading_option',
        'settings' => 'our_port_heading',
         'type'       => 'text',
    )); 

    $wp_customize->add_setting('our_port_subheading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea', 
    ));
    $wp_customize->add_control('our_port_subheading', array(
        'label'    => __('Sub Heading', 'portfoliolite'),
        'section'  => 'our_port_heading_option',
        'settings' => 'our_port_subheading',
         'type'       => 'textarea',
    ));   

// end portfoliolite //  
// Resume section start
//  ============================= //
//  S2 = Heading and Button sections  =
//  ============================= //
$wp_customize->add_panel( 'our_resume_panel', array(
    'priority'       => 5,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Resume Section', 'portfoliolite'),
    'description'    => '',
) );
$wp_customize->add_section('ribbon_sittings', array(
        'title'    => __('Resume Settings', 'portfoliolite'),
        'priority' => 1,
        'panel'    =>'our_resume_panel'
));
$wp_customize->add_setting('resume_heading', array(
        'default'           => '',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea'
    ));
   $wp_customize->add_control('resume_heading', array(
        'label'    => __('Main Heading', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_heading',
         'type'       => 'text',
    ));
// button1
   $wp_customize->add_setting('iframe_disable', array(
        'default'           => 'enable',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('iframe_disable', array(
        'label'    => __('Displaying Popup Resume', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'iframe_disable',
        'type'       => 'checkbox',
        'choices'    => array(
        'enable' => 'Displaying in Iframe',
        ),
    ));
   $wp_customize->add_setting('resume_button_icon', array(
        'default'           => 'fa fa-eye',
        'sanitize_callback' => 'sanitize_text_field'
    ));
   $wp_customize->add_control('resume_button_icon', array(
        'label'    => __('Button1 Icon', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_icon',
         'type'       => 'text',
    ));
    $wp_customize->add_setting('resume_button_text', array(
        'default'           => 'view',
        'sanitize_callback' => 'sanitize_text_field'
    ));
   $wp_customize->add_control('resume_button_text', array(
        'label'    => __('Button1 Text', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_text',
         'type'       => 'text',
    ));
    $wp_customize->add_setting('resume_button_link', array(
        'default'           => '#',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
     
    ));
    $wp_customize->add_control('resume_button_link', array(
        'label'    => __('Button1 Link', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_link',
         'type'       => 'text',
    )); 

// button2
$wp_customize->add_setting('resume_button_icon2', array(
        'default'           => 'fa fa-download',
        'sanitize_callback' => 'sanitize_text_field'
    ));
   $wp_customize->add_control('resume_button_icon2', array(
        'label'    => __('Button2 Icon', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_icon2',
         'type'       => 'text',
    ));
    $wp_customize->add_setting('resume_button_text2', array(
        'default'           => 'Download',
        'sanitize_callback' => 'sanitize_text_field'
    ));
   $wp_customize->add_control('resume_button_text2', array(
        'label'    => __('Button2 Text', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_text2',
         'type'       => 'text',
    ));
    $wp_customize->add_setting('resume_button_link2', array(
        'default'           => '#',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw',
        
    ));
    $wp_customize->add_control('resume_button_link2', array(
        'label'    => __('Button2 Link', 'portfoliolite'),
        'section'  => 'ribbon_sittings',
        'settings' => 'resume_button_link2',
         'type'       => 'text',
    ));
// image 
$wp_customize->add_section('resume_image', array(
        'title'    => __('Background Settings', 'portfoliolite'),
        'priority' => 3,
        'panel'    =>'our_resume_panel'
    ));
    
//bg-images
$wp_customize->add_setting('resume_bg_image', array(
        'default'        => get_template_directory_uri().'/images/2.jpg',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize, 'resume_bg_image', array(
        'label'    => __('Upload Background Image', 'portfoliolite'),
        'section'  => 'resume_image',
        'settings' => 'resume_bg_image',
)));
 // parallax/on/off
$wp_customize->add_setting('resu_parallax', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control( 'resu_parallax', array(
        'settings' => 'resu_parallax',
        'label'   => __('Parallax On/Off Option','portfoliolite'),
        'section' => 'resume_image',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));
$wp_customize->add_setting(
 'resume_img_overly_color',
array(
            'default'     => 'rgba(41, 41, 41, 0.5);',
            'type'        => 'theme_mod',
            'capability'  => 'edit_theme_options',
 ) );

$wp_customize->add_control(
        new Customize_Alpha_Color_Control($wp_customize,
            'resume_img_overly_color',
            array(
                'label'     => __('Background Color', 'portfoliolite' ),
                'description'=>__('Image Overlay & Background Color Change','portfoliolite'),
                'section'   => 'resume_image',
                'settings'  => 'resume_img_overly_color',
                'palette'   => $palette
            )
        )
    ); 
// upload resume    
$wp_customize->add_section('resume_upload', array(
        'title'    => __('Upload Resume', 'portfoliolite'),
        'priority' => 2,
        'panel'    =>'our_resume_panel'
    ));
 $wp_customize->add_setting('resume_upld', array(
        'default'        => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize, 'resume_upld', array(
        'label'    => __('Upload Resume', 'portfoliolite'),
        'section'  => 'resume_upload',
        'settings' => 'resume_upld',
)));
//color option
$wp_customize->add_section('resume_color_optn', array(
    'title'    => __('Color Options', 'portfoliolite'),
    'priority' => 4,
    'panel'  => 'our_resume_panel',
    ));

//title
$wp_customize->add_setting('resume_title_color', array(
        'default'        => '#fff',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'resume_title_color', array(
        'label'      => __('Title Color', 'portfoliolite' ),
        'section'    => 'resume_color_optn',
        'settings'   => 'resume_title_color',
    ) ) 
    );
// view button
$wp_customize->add_setting('button1_color', array(
        'default'        => '#1FCFD5;',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'button1_color', array(
        'label'      => __('Button Color', 'portfoliolite' ),
        'section'    => 'resume_color_optn',
        'settings'   => 'button1_color',
    ) ) 
    );
    //  =============================
    //  =S6 Testimonial Settings       =
    //  =============================

$wp_customize->add_panel( 'home_testimonial', array(
    'priority'       => 6,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Testimonial Section', 'portfoliolite'),
    'description'    => '',
));
$wp_customize->add_section('testimonial_background', array(
        'title'    => __('Background Settings', 'portfoliolite'),
        'priority' => 1,
        'panel'    =>'home_testimonial'
    ));
    
//images
$wp_customize->add_setting('testimonial_bg_image', array(
        'default'        => get_template_directory_uri().'/images/2.jpg',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize, 'testimonial_bg_image', array(
        'label'    => __('Upload Background Image', 'portfoliolite'),
        'section'  => 'testimonial_background',
        'settings' => 'testimonial_bg_image',
)));
// parallax/on/off
$wp_customize->add_setting('testi_parallax', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control( 'testi_parallax', array(
        'settings' => 'testi_parallax',
        'label'   => __('Parallax On/Off Option','portfoliolite'),
        'section' => 'testimonial_background',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));
$wp_customize->add_setting(
 'testimonial_img_overly_color',
array(
            'default'     => 'rgba(41, 41, 41, 0.5)',
            'type'        => 'theme_mod',
            'capability'  => 'edit_theme_options',
 ) );

$wp_customize->add_control(
        new Customize_Alpha_Color_Control($wp_customize,
            'testimonial_img_overly_color',
              array(
                'label'     => __('Background Color', 'portfoliolite' ),
                'description'=>__('Image Overlay & Background Color Change','portfoliolite'),
                'section'   => 'testimonial_background',
                'settings'  => 'testimonial_img_overly_color',
                'palette'   => $palette
            )
        )
    );
//-------------------End testimonial Section Panel----------------------------//
//--------------------Start team section------------------------------//

        //  =  Our TEAM sections  =//
        //  ============================= //
 $wp_customize->add_panel( 'our_team_panel', array(
    'priority'       => 7,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Team Section', 'portfoliolite'),
    'description'    => '',
) );


// Our team heading and subheading
    $wp_customize->add_section('our_team_heading_option', array(
        'title'    => __('Heading & Subheading Option', 'portfoliolite'),
        'priority' => 1,
         'panel'  => 'our_team_panel',
    ));

    $wp_customize->add_setting('our_team_heading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
       
    ));
   $wp_customize->add_control('our_team_heading', array(
        'label'    => __('Main Heading', 'portfoliolite'),
        'section'  => 'our_team_heading_option',
        'settings' => 'our_team_heading',
         'type'       => 'text',
    )); 

    $wp_customize->add_setting('our_team_subheading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
    $wp_customize->add_control('our_team_subheading', array(
        'label'    => __('Sub Heading', 'portfoliolite'),
        'section'  => 'our_team_heading_option',
        'settings' => 'our_team_subheading',
         'type'       => 'textarea',
    ));   
//--------------------End team section------------------------------//
//-------------------- start price section------------------------------//
$wp_customize->add_panel( 'our_price_panel', array(
    'priority'       => 10,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => __('Price Section', 'portfoliolite'),
    'description'    => '',
) );

//  Our team heading and subheading
    $wp_customize->add_section('our_price_heading_option', array(
        'title'    => __('Heading & Subheading Option', 'portfoliolite'),
        'priority' => 1,
         'panel'  => 'our_price_panel',
    ));

    $wp_customize->add_setting('our_price_heading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
    ));
    $wp_customize->add_control('our_price_heading', array(
        'label'    => __('Main Heading', 'portfoliolite'),
        'section'  => 'our_price_heading_option',
        'settings' => 'our_price_heading',
        'type'     => 'text',
    )); 
    $wp_customize->add_setting('our_price_subheading', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
    ));
    $wp_customize->add_control('our_price_subheading', array(
        'label'    => __('Sub Heading', 'portfoliolite'),
        'section'  => 'our_price_heading_option',
        'settings' => 'our_price_subheading',
         'type'    => 'textarea',
    ));   
//---------------------end price section---------------------------------//

    //  =============================
    //S7  = News letter Settings       =
    //  =============================

    $wp_customize->add_panel( 'lead_panel', array(
        'priority'       => 8,
        'capability'     => 'edit_theme_options',
        'theme_supports' => '',
        'title'          => __('News Letter', 'portfoliolite'),
        'description'    => '',
    ));

 $wp_customize->add_section('news_background', array(
        'title'    => __('Background Settings', 'portfoliolite'),
        'priority' => 2,
        'panel'    =>'lead_panel'
    ));
    
//images
$wp_customize->add_setting('news_bg_image', array(
        'default'        => get_template_directory_uri().'/images/2.jpg',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize, 'news_bg_image', array(
        'label'    => __('Upload Background Image', 'portfoliolite'),
        'section'  => 'news_background',
        'settings' => 'news_bg_image',
)));
// parallax/on/off
$wp_customize->add_setting('nws_parallax', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control( 'nws_parallax', array(
        'settings' => 'nws_parallax',
        'label'   => __('Parallax On/Off Option','portfoliolite'),
        'section' => 'news_background',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));
$wp_customize->add_setting(
 'news_img_overly_color',
array(
            'default'     => 'rgba(41, 41, 41, 0.5);',
            'type'        => 'theme_mod',
            'capability'  => 'edit_theme_options',
 ) );

$wp_customize->add_control(
        new Customize_Alpha_Color_Control($wp_customize,
            'news_img_overly_color',
              array(
                'label'     => __('Background Color', 'portfoliolite' ),
                'description'=>__('Image Overlay & Background Color Change','portfoliolite'),
                'section'   => 'news_background',
                'settings'  => 'news_img_overly_color',
                'palette'   => $palette
            )
        )
    );
// lead form settings
    $wp_customize->add_section( 'lead_form', array(
     'title'          => __( 'News Letter Settings', 'portfoliolite' ),
     'panel'  => 'lead_panel',
     'priority' => 1,
    ));
//heading-text    
    $wp_customize->add_setting('cf_head_', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
    ));
    $wp_customize->add_control('cf_head_', array(
        'label'    => __('News Letter Title', 'portfoliolite'),
        'section'  => 'lead_form',
        'settings' => 'cf_head_',
         'type'       => 'text',
    ));

    $wp_customize->add_setting('cf_button_text_', array(
        'default'           => __('SUBSCRIBE','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('cf_button_text_', array(
        'label'    => __('Button Text', 'portfoliolite'),
        'section'  => 'lead_form',
        'settings' => 'cf_button_text_',
         'type'       => 'text',
    ));
   $wp_customize->add_setting('cf_button_icon_', array(
        'default'           => __('fa fa-envelope-o','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('cf_button_icon_', array(
        'label'    => __('Button Icon', 'portfoliolite'),
        'section'  => 'lead_form',
        'settings' => 'cf_button_icon_',
         'type'       => 'text',
    ));
 $wp_customize->add_setting('contactus_shortcode', array(
            'default'           => '[lead-form form-id=1 title=Contact Us]',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'portfoliolite_sanitize_textarea'
            ));
        $wp_customize->add_control('contactus_shortcode', array(
            'label'    => __('Contact Us Shortcode', 'portfoliolite'),
            'description' =>__('Lead Form Builder Plugin Shortcode Insert.','portfoliolite'),
            'section'  => 'lead_form',
            'settings' => 'contactus_shortcode',
             'type'       => 'textarea',
            ));
//color option  
$wp_customize->add_section( 'color_opt_news', array(
     'title'          => __( 'Color Options', 'portfoliolite' ),
     'panel'  => 'lead_panel'
    ));
$wp_customize->add_setting('news_title_color', array(
        'default'        => '#fff',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'news_title_color', array(
        'label'      => __('Text Color', 'portfoliolite' ),
        'section'    => 'color_opt_news',
        'settings'   => 'news_title_color',
    ) ) 
    );
$wp_customize->add_setting('news_button_color', array(
        'default'        => '#1FCFD5;',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'news_button_color', array(
        'label'      => __('Button Color', 'portfoliolite' ),
        'section'    => 'color_opt_news',
        'settings'   => 'news_button_color',
    ) ) 
);
$wp_customize->add_setting('news_button_hvr_color', array(
        'default'        => '#fff',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control($wp_customize,'news_button_hvr_color', array(
        'label'      => __('Button Hover Color', 'portfoliolite' ),
        'section'    => 'color_opt_news',
        'settings'   => 'news_button_hvr_color',
    ) ) 
);

//-------------------End News Letter Panel----------------------------//    
//------------------- start footer contact detail---------------------//
 $wp_customize->add_panel( 'cnt_panel', array(
        'priority'       => 13,
        'capability'     => 'edit_theme_options',
        'theme_supports' => '',
        'title'          => __('Contact Section', 'portfoliolite'),
        'description'    => '',
    ));

 $wp_customize->add_section('cnt_background', array(
        'title'    => __('Background Settings', 'portfoliolite'),
        'priority' => 2,
        'panel'    =>'cnt_panel'
    ));
    
//images
$wp_customize->add_setting('cnt_bg_image', array(
        'default'        => get_template_directory_uri().'/images/2.jpg',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control(
        $wp_customize, 'cnt_bg_image', array(
        'label'    => __('Upload Background Image', 'portfoliolite'),
        'section'  => 'cnt_background',
        'settings' => 'cnt_bg_image',
))); 

// parallax/on/off
$wp_customize->add_setting('cnt_parallax', array(
        'default'        =>'on',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control( 'cnt_parallax', array(
        'settings' => 'cnt_parallax',
        'label'   => __('Parallax On/Off Option','portfoliolite'),
        'section' => 'cnt_background',
        'type'    => 'radio',
        'choices'    => array(
            'on'        => 'On',
            'off'      => 'Off',
        ),
    ));
$wp_customize->add_setting(
 'cnt_img_overly_color',
array(
            'default'     => 'rgba(41, 41, 41, 0.5);',
            'type'        => 'theme_mod',
            'capability'  => 'edit_theme_options',
 ) );
$wp_customize->add_control(
        new Customize_Alpha_Color_Control($wp_customize,
            'cnt_img_overly_color',
              array(
                'label'     => __('Background Color', 'portfoliolite' ),
                'description'=>__('Image Overlay & Background Color Change','portfoliolite'),
                'section'   => 'cnt_background',
                'settings'  => 'cnt_img_overly_color',
                'palette'   => $palette
            )
        )
    );
$wp_customize->add_section( 'cnt_bg', array(
     'title'          => __( 'Contact Settings', 'portfoliolite' ),
     'panel'  => 'cnt_panel',
     'priority'       => 1,
    ));
 //email   
$wp_customize->add_setting('eml_icon_', array(
        'default'           => __('fa fa-envelope-o','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('eml_icon_', array(
        'label'       => __('Email Detail', 'portfoliolite'),
        'section'     => 'cnt_bg',
        'settings'    => 'eml_icon_',
        'type'        => 'text',
        'description' => __('Fontawesome-Icon','portfoliolite'),
    ));
$wp_customize->add_setting('eml_txt_', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('eml_txt_', array(
        'label'    => __('', 'portfoliolite'),
        'section'  => 'cnt_bg',
        'settings' => 'eml_txt_',
         'type'       => 'text',
         'description' => __('Email-Address','portfoliolite'),
    ));
//address
$wp_customize->add_setting('add_icon_', array(
        'default'           => __('fa fa-map-marker','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('add_icon_', array(
        'label'    => __('Address Detail', 'portfoliolite'),
        'section'  => 'cnt_bg',
        'settings' => 'add_icon_',
         'type'       => 'text',
         'description' => __('Fontawesome-Icon','portfoliolite'),
    ));
$wp_customize->add_setting('add_txt_', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('add_txt_', array(
        'label'    => __('', 'portfoliolite'),
        'section'  => 'cnt_bg',
        'settings' => 'add_txt_',
         'type'       => 'textarea',
         'description' => __('Address','portfoliolite'),
    ));
//mobile
$wp_customize->add_setting('mob_icon_', array(
        'default'           => __('fa fa-mobile','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
    $wp_customize->add_control('mob_icon_', array(
        'label'    => __('Contact Detail', 'portfoliolite'),
        'section'  => 'cnt_bg',
        'settings' => 'mob_icon_',
         'type'       => 'text',
         'description' => __('Fontawesome-Icon','portfoliolite'),
    ));
$wp_customize->add_setting('mob_txt_', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
         
    ));
$wp_customize->add_control('mob_txt_', array(
        'label'    => __('', 'portfoliolite'),
        'section'  => 'cnt_bg',
        'settings' => 'mob_txt_',
         'type'       => 'text',
         'description' => __('Contact Number','portfoliolite'),
    ));


//------------------- End footer contact detail---------------------//
//  ============================= //
//  S5 = blog sections  =
//  ============================= //
// blog page setting   
// end blog page setting

 $wp_customize->add_panel( 'blog_panel', array(
        'priority'       => 12,
        'capability'     => 'edit_theme_options',
        'theme_supports' => '',
        'title'          => __('Recent Post Section', 'portfoliolite'),
        'description'    => '',
    )); 
 $wp_customize->add_section( 'blog_head_desc', array(
     'title'          => __( 'Post Settings','portfoliolite' ),
     'priority'       => 1,
     'panel'          =>'blog_panel',
) ); 
 $wp_customize->add_setting('blog_head_', array(
        'default'           => __('Latest News & Blogs','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
    $wp_customize->add_control('blog_head_', array(
        'label'    => __('Heading', 'portfoliolite'),
        'section'  => 'blog_head_desc',
        'settings' => 'blog_head_',
         'type'       => 'text',
    ));

     $wp_customize->add_setting('blog_desc_', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
        
    ));
    $wp_customize->add_control('blog_desc_', array(
        'label'    => __('Sub Heading', 'portfoliolite'),
        'section'  => 'blog_head_desc',
        'settings' => 'blog_desc_',
         'type'       => 'textarea',
    ));
   
     $wp_customize->add_setting('slider_cate', array(
        'default'        => 1,
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',
    ));
    $wp_customize->add_control('slider_cate', array(
        'settings' => 'slider_cate',
        'label'   => __('Post Category','portfoliolite'),
        'section' => 'blog_head_desc',
        'type' => 'select',
        'choices' => $cats,
    ) );
    // $wp_customize->add_setting('slider_count', array(
    //     'default'        => 3,
    //     'capability'     => 'edit_theme_options',
    //     'sanitize_callback' => 'esc_attr',
    // ));
    // $wp_customize->add_control('slider_count', array(
    //     'settings'  => 'slider_count',
    //     'label'     => __('Number of post','portfoliolite'),
    //     'section'   => 'blog_head_desc',
    //     'type'      => 'number',
    //    'input_attrs' => array('min' => 1,'max' => 3)

    // ) );
//-------------------End blog  Panel----------------------------//
 //  =============================
//  =S9 Custom Css      =
//  =============================
// custom color
    $wp_customize->get_section('colors')->title = esc_html__('Style Settings', 'portfoliolite');
    $wp_customize->get_section('colors')->priority = 31;

  $wp_customize->add_setting('theme_color', array(
        'default'        => '#1FCFD5;',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( 
    new WP_Customize_Color_Control(
    $wp_customize, 
    'theme_color', array(
        'label'      => __( 'Theme Color', 'portfoliolite' ),
        'section'    => 'colors',
        'settings'   => 'theme_color',
    ) ) 
);
if( get_bloginfo( 'version' ) < '4.7'):
   $wp_customize->add_setting('custom_css_text', array(
        'default'        => '',
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea'
    ));
    $wp_customize->add_control('custom_css_text', array(
        'settings' => 'custom_css_text',
        'label'     => 'Custom Css',
        'section' => 'colors',
        'type'    => 'textarea',
    ) );
endif;
//footer
$wp_customize->add_panel( 'footr_panel', array(
        'priority'       => 30,
        'capability'     => 'edit_theme_options',
        'theme_supports' => '',
        'title'          => __('Footer Settings', 'portfoliolite'),
        'description'    => '',
    )); 
$wp_customize->add_section( 'foothd_delt', array(
     'title'          => __( 'Footer Logo', 'portfoliolite' ),
     'panel'  => 'footr_panel',
     'priority'       => 2,
    ));
$wp_customize->add_setting('thm_txt_', array(
        'default'           => __('','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
         
    ));
$wp_customize->add_control('thm_txt_', array(
        'label'    => __('Heading', 'portfoliolite'),
        'section'  => 'foothd_delt',
        'settings' => 'thm_txt_',
         'type'       => 'text',
        
));  
$wp_customize->add_setting('thm_txt_link', array(
        'default'           => __('#','portfoliolite'),
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea',
         
    ));
$wp_customize->add_control('thm_txt_link', array(
        'label'    => __('Link', 'portfoliolite'),
        'section'  => 'foothd_delt',
        'settings' => 'thm_txt_link',
         'type'       => 'text',
        
));  
$wp_customize->add_section( 'copy_right_txt', array(
         'title'          => __( 'Copyright Text', 'portfoliolite' ),
         'priority'       => 2,
         'panel'  => 'footr_panel',
    ) );
    $wp_customize->add_setting('copyright_textbox', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'portfoliolite_sanitize_textarea'
    ));
    $wp_customize->add_control('copyright_textbox', array(
        'label'    => __('Footer Text', 'portfoliolite'),
        'section'  => 'copy_right_txt',
        'settings' => 'copyright_textbox',
         'type'       => 'textarea',
    ));
 // selective-refresh option added
$wp_customize->selective_refresh->add_partial( 'blogname', array(
        'selector' => '.logo h1 a',
        'render_callback' => function() {
            bloginfo( 'name' );
        },
) );
$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
        'selector' => '.logo p',
        'render_callback' => function() {
            bloginfo( 'description' );
        },
) );
// slider
$wp_customize->selective_refresh->add_partial('parallax_heading', array(
        'selector' => '.slider-caption .portfolio-desc h1',
) );
$wp_customize->selective_refresh->add_partial('parallax_subheading_one', array(
        'selector' => '.slider-caption .portfolio-desc p',
) );
$wp_customize->selective_refresh->add_partial('parallax_button_text1', array(
        'selector' => '.slider-caption a.shw-btn',
) );
$wp_customize->selective_refresh->add_partial('parallax_button_text2', array(
        'selector' => '.slider-caption a.exp-btn',
) );
// portfolio
$wp_customize->selective_refresh->add_partial('our_port_heading', array(
        'selector' => '#portfolio-mywork-section h2.main-heading',
) );
$wp_customize->selective_refresh->add_partial('our_port_subheading', array(
        'selector' => '#portfolio-mywork-section p.sub-heading',
) );
// resume
$wp_customize->selective_refresh->add_partial('resume_heading', array(
        'selector' => '#resume-ribbon h2.main-heading',
) );
$wp_customize->selective_refresh->add_partial('resume_button_text', array(
        'selector' => '#resume-ribbon li.view-resume-c a',
) );
$wp_customize->selective_refresh->add_partial('resume_button_text2', array(
        'selector' => '#resume-ribbon li.download-resume-c a',
) );

// team
$wp_customize->selective_refresh->add_partial('our_team_heading', array(
        'selector' => '#team-info h2.main-heading',
) );
$wp_customize->selective_refresh->add_partial('our_team_subheading', array(
        'selector' => '#team-info p.sub-heading',
) );
// news-letter
$wp_customize->selective_refresh->add_partial('cf_head_', array(
        'selector' => '#new-letter .new-letter-block h3',
) );
$wp_customize->selective_refresh->add_partial('cf_button_text_', array(
        'selector' => '#new-letter #Link i.fa',
) );
// price
$wp_customize->selective_refresh->add_partial('our_price_heading', array(
        'selector' => '#price-package h2.main-heading',
) );
$wp_customize->selective_refresh->add_partial('our_price_subheading', array(
        'selector' => '#price-package p.sub-heading',
) );

// post
$wp_customize->selective_refresh->add_partial('blog_head_', array(
        'selector' => '#latest-post h2.main-heading',
) );
$wp_customize->selective_refresh->add_partial('blog_desc_', array(
        'selector' => '#latest-post p.sub-heading',
) );
//contact
$wp_customize->selective_refresh->add_partial('eml_txt_', array(
        'selector' => '#contact-info .email .contact-title',
) );
$wp_customize->selective_refresh->add_partial('add_txt_', array(
        'selector' => '#contact-info .adderess .contact-title',
) );
$wp_customize->selective_refresh->add_partial('mob_txt_', array(
        'selector' => '#contact-info .mobile .contact-title',
) );
// footer
$wp_customize->selective_refresh->add_partial('thm_txt_', array(
        'selector' => '.company-social a',
) );
$wp_customize->selective_refresh->add_partial('copyright_textbox', array(
        'selector' => '.copyright-section P',
) );   
}
add_action('customize_register','portfoliolite_customize_register');
?>