<?php
/**
 * Sanitization for textarea field
 */
function portfoliolite_sanitize_textarea( $input ) {
    global $allowedposttags;
    $output = wp_kses( $input, $allowedposttags );
    return $output;
}
/**
 * Returns a sanitized filepath if it has a valid extension.
 */
function portfoliolite_sanitize_upload( $upload ) {
    $return = '';
    $fype = wp_check_filetype( $upload );
    if ( $fype["ext"] ) {
        $return = esc_url_raw( $upload );
    }
    return $return;
}
/**
 * vaild int.
 */
function portfoliolite_sanitize_int( $input ) {
$return = absint($input);
    return $return;
}
// Multiple Checkbox Show
function portfoliolite_checkbox_explode( $values ) {
    $multi_values = !is_array( $values ) ? explode( ',', $values ) : $values;
    return !empty( $multi_values ) ? array_map( 'sanitize_text_field', $multi_values ) : array();
}
add_action('customize_register','th_custom_customize_register');
function th_custom_customize_register( $wp_customize ) {
/**
 * Multiple checkbox customize control class.
 */
class PORTFOLIOLITE_Customize_Control_Checkbox_Multiple extends WP_Customize_Control {

    /**
     * The type of customize control being rendered.
     */
    public $type = 'checkbox-multiple';

    /**
     * Enqueue scripts/styles.
     *
     */
    public function enqueue() {
       
    }

    /**
     * Displays the control content.
     *
     */
    public function render_content() {

        if ( empty( $this->choices ) ){
            return;   }
            ?>
        <?php if ( !empty( $this->label ) ) : ?>
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
        <?php endif; ?>
        <?php if ( !empty( $this->description ) ) : ?>
            <span class="description customize-control-description"><?php echo $this->description; ?></span>
        <?php endif; ?>
        <?php $multi_values = !is_array( $this->value() ) ? explode( ',', $this->value() ) : $this->value(); ?>
        <ul>
            <?php foreach ( $this->choices as $value => $label ) : ?>

                <li>
                    <label>
                        <input type="checkbox" value="<?php echo esc_attr( $value ); ?>" <?php checked( in_array( $value, $multi_values ) ); ?> /> 
                        <?php echo esc_html( $label ); ?>
                    </label>
                </li>
            <?php endforeach; ?>
        </ul>
        <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr( implode( ',', $multi_values ) ); ?>" />
    <?php }
}

class PORTFOLIOLITE_Customize_Sort_List extends WP_Customize_Control {
    /**
     * The type of customize control being rendered.
     */
    public $type = 'sort-list';

    public function enqueue() {
       
    }
    public function render_content() {
          if ( empty( $this->choices ) ){
            return;
               }
            ?>
      <?php if ( !empty( $this->label ) ) : ?>
            <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
        <?php endif; ?>
        <?php if ( !empty( $this->description ) ) : ?>
            <span class="description customize-control-description"><?php echo $this->description; ?></span>
        <?php endif;

        $sort_arr = $this->value();
        $default_arr = explode( ',',implode(',',array_keys($this->choices)));
        $new_arr =  array_unique(array_merge($sort_arr,$default_arr));

        $multi_values = (!empty($sort_arr)) ? explode( ',',implode(',',$new_arr )) : explode( ',',implode(',',array_keys($this->choices)));  ?>
        <ul id="sortable">
        <?php foreach ( $multi_values as $value => $label ) :
         ?>
            <li class="ui-state-default" id='<?php echo $label; ?>' ><label><?php echo $this->choices[$label]; ?></label></li>
          <?php endforeach; ?>
        </ul>
                <input type="hidden" <?php $this->link(); ?> value="" />
            <?php }
        }
}
function portfoliolite_customize_preview_js() {
    wp_enqueue_script( 'portfolio_live_customizer', get_template_directory_uri().'/js/live-customizer.js', array( 'jquery','customize-preview' ), '', true );
}
add_action( 'customize_preview_init', 'portfoliolite_customize_preview_js' );
function portfoliolite_registers() {
$th ='<img src="//themehunk.com/wp/" style="display:none;" />';
$logo='<img src="'.get_template_directory_uri() .'/customizer/images/th-logo.png" />';
    wp_enqueue_script( 'portfolio_customizer_script', get_template_directory_uri() . '/customizer/customizer.js', array("jquery"), '', true  );
    
    wp_localize_script( 'portfolio_customizer_script', 'portfolioCustomizerObject', array(      
        'documentation' => __( 'View Documentation', 'portfoliolite' ),
        'pro' => __($logo.$th.'View All Premium Theme','portfoliolite')

    ) );
}
function portfoliolite_customizer_styles() {
    wp_enqueue_style('portfoliolite_customizer_styles', get_template_directory_uri() . '/customizer/customizer_styles.css');
}
add_action('customize_controls_print_styles', 'portfoliolite_customizer_styles');
add_action( 'customize_controls_enqueue_scripts', 'portfoliolite_registers' );
// single page post meta
function th_checkbox_filter($search,$theme_mod,$default=false){
 $filter = get_theme_mod($theme_mod);
$value = (!empty($filter) && !empty($filter[0]))?in_array($search, $filter):$default;
return $value;
}
?>