<?php
ob_start();
/**
 *portfoliolite function Page
 */
if ( ! isset( $content_width ) ) {
  $content_width = 1170;
}
function portfoliolite_setup() {
load_theme_textdomain('portfoliolite', get_template_directory() . '/languages');
add_theme_support( 'title-tag' );
add_theme_support( 'custom-logo', array(
    'height'      => 60,
    'width'       => 225,
    'flex-height' => true,
  ) ); 
// Add RSS feed links to <head> for posts and comments.
add_theme_support( 'automatic-feed-links' );
 /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.

     */
    add_theme_support( 'html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ) );
// custom header
    add_theme_support( 'custom-header' );

}
add_action( 'after_setup_theme', 'portfoliolite_setup' );
require_once( get_template_directory() . '/inc/include.php' );
/**
 * Enqueue scripts and styles for the front end.
 */
function portfoliolite_scripts() {
  // Add Genericons font, used in the main stylesheet.
$section_animation = get_theme_mod('section_animation','on');
if($section_animation=='on'){
wp_enqueue_style( 'animate', get_template_directory_uri() . '/css/animate.css', array(), '1.0.0' );}
wp_enqueue_style( 'menu', get_template_directory_uri() . '/css/menu-css.css', array(), '1.0.0' );
wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '1.0.0' );
 wp_enqueue_style('portfoliolite-style', get_stylesheet_uri());
// js include
if($section_animation=='on'){
wp_enqueue_script( 'animate', get_template_directory_uri() . '/js/wow.js', array( 'jquery' ), '', true );
   }
wp_enqueue_script( 'easy', get_template_directory_uri() . '/js/easy.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'flexslider', get_template_directory_uri() . '/js/jquery.flexslider.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'bxslider', get_template_directory_uri() . '/js/jquery.bxslider.min.js', array( 'jquery' ), '', true );    
wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/isotope.pkgd.min.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'typer', get_template_directory_uri() . '/js/jquery.typer.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'loader', get_template_directory_uri() . '/js/modernizr-2.6.2.min.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'fancybox', get_template_directory_uri() . '/js/fancybox.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'parallax', get_template_directory_uri() . '/js/skrollr.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'parallaximgload', get_template_directory_uri() . '/js/imagesloaded.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'portfoliolite-custom', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ), '', true );
wp_localize_script( 'portfoliolite-ajax', 'frontendajax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
  // Comment reply
  if (is_singular() && get_option('thread_comments')){
    wp_enqueue_script('comment-reply');
  }
}
add_action( 'wp_enqueue_scripts', 'portfoliolite_scripts' );
// add scroll class
function portfoliolite_add_menuclass($ulclass) {
   return preg_replace('/<a /', '<a class="page-scroll"', $ulclass);
}
add_filter('wp_nav_menu','portfoliolite_add_menuclass');
// home page post meta
function portfoliolite_home_post_meta($search,$default=false){
 $home_post_meta = get_theme_mod('home_post_meta');
$value = (!empty($home_post_meta) && !empty($home_post_meta[0]))?in_array($search, $home_post_meta):$default;
return $value;
}
// single page post meta
function portfoliolite_single_post_meta($search,$default=false){
 $home_post_meta = get_theme_mod('single_post_meta');
$value = (!empty($home_post_meta) && !empty($home_post_meta[0]))?in_array($search, $home_post_meta):$default;
return $value;
}
global $grid_layout;
$grid_layout = get_theme_mod('dynamic_grid','standard-layout');
// Override theme default specification for product # per row
function loop_columns() {
return 3; // 3 products per row
}
add_filter('loop_shop_columns', 'loop_columns', 999);
ob_get_clean();
?>