<?php
/**
 * This file is responsible for the post's rendering on the pages.
 * @version:1.0
 */
?> 

 <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>  itemscope="" itemtype="http://schema.org/BlogPosting">
  
  <div class="post_block">
  
	<div class="entry-content">
    <header class="header">
    
        <figure>
            <?php
            // Post thumbnail.
            the_post_thumbnail();
        ?>
        </figure>
         
   	<?php
			if ( !is_single() ) :
				the_title( sprintf( '<h2 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark" itemprop="url">', esc_url( get_permalink() ) ), '</a></h2>' );
			else:
				the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' );
			endif;	
		?>
    
  	  <div class="clearfix"></div>
  		
		<?php navthemes_entry_meta(); ?>
         
          
   </header>
   
		<?php
			if ( is_single() ) :
		 
			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue reading %s', 'plumbing-lite' ),
				the_title( '<span class="screen-reader-text">', '</span>', false )
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'plumbing-lite' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'plumbing-lite' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		
    else:
			the_excerpt();
	
	endif;
	?>
 	 
    
    <div class="clearboth"></div> 
 	<div class="border"></div>  
    
     
 	
		<?php
						if ( !is_single() ) :?>
							<footer class="entry-footer">
		            <a href="<?php the_permalink(); ?>" class="btn btn-default btn_font_16"><?php _e('Read More', 'plumbing-lite')?></a>
		            </footer><!-- .entry-footer -->
		            <?php endif; ?>
	
      
      
  	</div><!-- .entry-content -->
    
    
 </div>
 	<div class="clearboth"></div> 
 </article><!-- #post-## -->
    
 
      <?php
		if(is_single()) {
			comments_template();
			comment_form();
		}
    ?> 
                                        
 