<?php
/**
	This File handles Customizer Options
	* @version:1.0
*/

//include_once( 'admin/kirki/kirki.php' );


// Early exit if Kirki is not installed
if ( ! class_exists( 'Kirki' ) ) {
	return;
}



/**
 * Configuration sample for the Kirki Customizer.
 */
function navthemes_configuration() {

	$args = array(
		'logo_image'   => 'http://navthemes.com/branding/inthemes/logo.png',
		'url_path' => get_stylesheet_directory_uri() . '/admin/kirki/'
   );

	return $args;

}

add_filter( 'kirki/config', 'navthemes_configuration' );

/*=================================
	Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 10
* General settings    - 11-26
* Banner              - 33-38
* Services            - 39-45
* About               - 46-50
* Features            - 51-62
* Our Team            - 63-82
* Gallery             - 83-87
* Achivements         - 88-102
* Testimonials        - 103-110
* Featured Works      - 111-118
* Blog                -  119-120
* Partners            - 121-125
* Call To Action      - 126-128
* Conatct             - 130-134
* Google Map          - 135-141
* Footer Social Links - 150-160 
* Front Page Modules  - 161-162
================================= */


/*=================================
	Panels Priorities-

* NavThemes Branding  - 1 
* Sample Content      - 2
* General Settings    - 3
* Front Page          - 4
* Contact page        - 5
* Footer Social Links - 6
================================= */

/*=================================
	Config	
  ================================= */

Kirki::add_config( 'plumbing-lite', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
 	
) );

$theme = wp_get_theme();

 /*------------------------------------------
     NavThemes Branding
     ------------------------------------------*/

     $theme = wp_get_theme();
	 $theme_version = $theme->get( 'Version' );
	 $theme_name = $theme->get( 'Name' );
 
  Kirki::add_section( 'NavThemes_Support', array(
			'title'          => __( 'NavThemes Support', 'navthemes' ),
			'description'    => sprintf('You are using Free version of %s Theme, Check out Paid version, which comes with many exciting features in the package.', __($theme->Name, 'navthemes','plumbing-lite') ),
			'priority'       => 1,
	) );
			
		Kirki::add_field( 'navthemes', array(
		'type'        => 'custom',
		'settings'     => 'navthemes_support',
		'section'     => 'NavThemes_Support',
		'default'     => sprintf('<div id="navthemes_branding"><h1>Get Premium Version of %s for Just $59</h1>
			<div class="navthemes-links">
			<ul>

				<li><a target="_blank" href="%s"><a href="https://www.navthemes.com/wp-themes/plumbing-pro-wordpress-theme/">Check out All Features of Paid version</a></li>
				
				<li><a target="_blank" href="%s"><a href="http://demo.navthemes.com/?demo=plumbing-pro&c=DszUSQP8K">View Demo</a></li>
			</ul> 
		</div>
		</div>', __($theme->Name, 'navthemes','plumbing-lite'), $theme->get( 'ThemeURI' ), $theme->get( 'ThemeURI' ) ),
		'priority'    => 10,
	) );    
	

	/*------------------------------------------
    Maintenance Service
    ------------------------------------------*/


 Kirki::add_section( 'NavThemes_Maintenance_Service', array(
            'title'          => __( 'Maintenance Service', 'navthemes' ),
            'description'    => sprintf( '<h1> Managing WordPress Site is a hassle ? Let us handle that.

</h1>', __($theme->Name, 'navthemes','plumbing-lite') ),
            'priority'       => 2,
    ) );
            

        Kirki::add_field( 'navthemes', array(
        'type'        => 'custom',
        'settings'     => 'navThemes_maintenance_service',
        'section'     => 'NavThemes_Maintenance_Service',
        'default'     => sprintf( '<div id="navthemes_maintenance">
        <div class="themeisle-upsell"> 
        <h1>**Key Features**</h1>
            <h3>FREE Lightning Fast Hosting <span class="color_span" ><br>This is a Google Ranking factor. </span></h3>
            <h3>FREE SSL Certificate   <span class="color_span"> <br>This is a Google Ranking factor. </span></h3> 
            <h3>24/7 Uptime monitoring</h3>
            <h3>Access All NavThemes Premium WordPress Themes and Plugins</h3>
            <h3>Free Migration Service to our hosting</h3>
            <h3>Free CDN Service</h3>
            <h3>Unlimited Website Edits</h3>
            <h3>Hack/Malware Removal</h3>
            <h3>Weekly Website Report</h3>
            <div class="navthemes-links">
            <ul>
            <li>

            <a target="_blank" href="http://navthemes.com/wordpress-management-service/?utm_source=plumbing-lite&utm_medium=lite-wordpress-theme&utm_campaign=customizer&utm_term=maintenance-service" class="button button-primary button_70">Starting at just $39/Month</a>
          </li>

                
            </ul>
            </div>
        </div>
        </div>', __($theme->Name, 'navthemes','plumbing-lite'), 'https://www.navthemes.com/free-wordpress-theme/Plumbing-lite-wordpress-theme/'),
        'priority'    => 11,
    ) );





/*=================================
		Sample Content	
	  ================================= */
	
	Kirki::add_section( 'required_settings', array(
		'title'          => __( 'Sample Content', 'plumbing-lite' ), 
		'priority'       => 3,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'plumbing-lite', array(
				'section'  => 'required_settings',
				'type'     => 'custom',
				'priority' => 10,
				'default'  =>sprintf('<div><h3>Once you have installed and activated all recommended plugins, to setup your theme look like demo Follow these steps.
					<ol>
						<li>Download <a target="_blank" href="%s">this</a> file</li>
						<li>Import this file in customizer, Check <a target="_blank" href="%s">instructions</a> here.</li>
						<li>Once imported, publish it.</li>
					</ol>
					</h3>
		</div>
		<div id="navthemes_maintenance">
		 <a target="_blank" href="https://docs.navthemes.com/docs/plumbing" class="button button-primary button_70">Documentation</a>
		 </div>', 'http://docs.navthemes.com/download/618/', 'http://docs.navthemes.com/docs/plumbing/sample-content/' ),
		'priority'    => 10,
	) );    


/*--------------------------------------------------------------------------
  --------------------------------------------------------------------------
			General Settings
--------------------------------------------------------------------------
--------------------------------------------------------------------------*/
			
		
	Kirki::add_panel( 'general_settings', array(
		'priority'    => 4,
		'title'       => __( 'General Settings', 'plumbing-lite' ),
		'description' => __( 'Manage General Setting from here', 'plumbing-lite' ),
	) );
	
	/*=================================
		General Section	
  	================================= */
		
	Kirki::add_section( 'general_settings', array(
		'title'          => __( 'General Settings', 'plumbing-lite' ),
		'description'    => __( 'From Here You Can Manage Some General Settings' , 'plumbing-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 11,
		'capability'     => 'edit_theme_options', 
	) );
  
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'inner_page_bg_image',
				'label'    => __( 'Inner Pages Title Background image', 'plumbing-lite' ),
				'section'  => 'general_settings',
				'type'     => 'image',
				'priority' => 12,
				'default'  => get_template_directory_uri() . '/assets/images/slider-1.jpg',
				//'active_callback' => 'is_not_front_page', 
			 
			) );

	Kirki::add_field( 'plumbing-lite', array(
			'settings' => 'top_top',
			'label'    => __( 'Show Top Button', 'plumbing-lite' ),
			'section'  => 'general_settings',
			'type'     => 'toggle',
			'priority' => 13,
			'default'  => 1,
			 
		 
		) );				


	
		Kirki::add_section( 'logo_settings', array(
			'title'          => __( 'Logo Settings', 'plumbing-lite' ),
			'description'    => __( 'From Here You Can Manage Manage Settings' , 'plumbing-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 19,
			'capability'     => 'edit_theme_options', 
		) );
	
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'logo',
				'label'    => __( 'Logo', 'plumbing-lite' ),
				'section'  => 'logo_settings',
				'type'     => 'image',
				'priority' => 20,
				'default'  => '',
			 
			) );

 

/*----------------------------------
			Menu Settings
		*----------------------------------*/
			
		Kirki::add_section( 'menu_settings', array(
			'title'          => __( 'Menu Settings', 'plumbing-lite' ),
			'description'    => __( 'From Here You Can Manage Menu Settings' , 'plumbing-lite' ),
			'panel'          => 'general_settings', 
			'priority'       => 21,
			'capability'     => 'edit_theme_options', 
		) );
		
		Kirki::add_field( 'plumbing-lite', array(
			'settings' => 'nav_menu_name',
			'label'    => __( 'Choose a Menu', 'plumbing-lite' ),
			'section'  => 'menu_settings',
			'type'     => 'select',
			'priority' => 22,
			'choices'  => plumbing_lite_nav_menus(),
		) );	
		
		
				
/*----------------------------------
		Menu Settings
	*----------------------------------*/
		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'onepagemenuonoff',
                'label'    => __( 'One Page Menu ON/OFF', 'plumbing-lite' ),
                'section'  => 'menu_settings',
                'type'     => 'toggle',
                'priority' => 10,
                'default'  => 1,           
            ) );
 	
		Kirki::add_field( 'plumbing-lite', array(
		'settings' => 'nav_menu_position_pro_message',
		'label'    => '',
		'section'  => 'menu_settings',
		'type'     => 'custom',
		'priority' => 9,
		'default'     => '',
	) );
			
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'nav_menu_position',
				'label'    => __( 'Choose Menu Position', 'plumbing-lite' ),
				'section'  => 'menu_settings',
				'type'     => 'select',
				'priority' => 9,
				'default'  => 'after',
				'choices'     => array(
					'after'   => esc_attr__( 'After', 'plumbing-lite' ),
					'before' => esc_attr__( 'Before', 'plumbing-lite' ), 
				),
	 		) );		
		
 	Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'floatmenu',
				'label'    => __( 'Float menu ? ', 'plumbing-lite' ),
				'section'  => 'menu_settings',
				'type'     => 'toggle',
				'priority' => 10,
				'default'  => 1
	 		) );	



/*=================================
	Home Page Panel	
  ================================= */

	Kirki::add_panel( 'homepage', array(
		'priority'    => 4,
		'title'       => __( 'Front Page Settings', 'plumbing-lite' ),
		'description' => __( 'Manage Front Page Setting from here', 'plumbing-lite' ),
	) );


		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Footer Text Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'footer_text', array(
		'title'          => __( 'Footer Copyright Text Setting', 'plumbing-lite' ),
		'description'    => __( 'From here you can manage text of footer', 'plumbing-lite' ),
		'panel'          => 'general_settings', 
		'priority'       => 41,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'footer_theme_text',
				'label'    => __( 'Field', 'plumbing-lite' ),
				'section'  => 'footer_text',
				'type'     => 'textarea',
				'priority' => 42,
				'default'  => '',
			) );	
	

		/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Banner Section
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

	Kirki::add_section( 'homepage_banner', array(
		'title'          => __( 'Banner', 'plumbing-lite' ),
		'description'    => __( 'From here you can manage background image, Title and Text of banner', 'plumbing-lite' ),
		'panel'          => 'homepage', 
		'priority'       => 1,
		'capability'     => 'edit_theme_options',
	) );

	Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'banner_title',
				'label'    => __( 'Banner Heading', 'plumbing-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 31,
				'default'  => 'We Are Experts',
			) );
			
				
			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'banner_text1',
				'label'    => __( 'Banner Sub Heading', 'plumbing-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 32,
				'default'  => 'QUICK SERVICE, QUALITY WORK & BE HAPPY...',
				
			) );
	 		
	 		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'banner_text2',
				'label'    => __( 'Banner Tag Line', 'plumbing-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 33,
				'default'  => '',
				
			) );
			Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepagebuttonbanneronoff',
                'label'    => __( 'Button ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_banner',
                'type'     => 'toggle',
                'priority' => 34,
                'default'  => 1,           
            ) );
	 	Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'button_text',
				'label'    => __( 'Button Text', 'plumbing-lite' ),
				'section'  => 'homepage_banner',
				'type'     => 'text',
				'priority' => 35,
				'default'  => 'OUR SERVICES',
				
			) );
	 	Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'button_link',
                'label'    => __( 'Button Link', 'plumbing-lite' ),
                'section'  => 'homepage_banner',
                'type'     => 'text',
                'priority' => 36,
                'default'  => '#services', 
            ) );
		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepagebannerimageonoff',
                'label'    => __( 'Banner image ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_banner',
                'type'     => 'toggle',
                'priority' => 37,
                'default'  => 1,           
            ) );
			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'banner_image',
				'label'    => __( 'Banner Image', 'plumbing-lite' ),
				'section'  => 'homepage_banner',
				'type'        => 'image',
				'priority' => 38,
				'default'  => get_template_directory_uri() . '/assets/images/2.jpg',
			) );
			


	/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Services Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_services', array(
			'title'          => __( 'Services Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page services section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 2,
			'capability'     => 'edit_theme_options',
		) );

		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'servicesectiononoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_services',
                'type'     => 'toggle',
                'priority' => 39,
                'default'  => 1,           
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_services_title',
				'label'    => __( 'Services Title', 'plumbing-lite' ),
				'section'  => 'homepage_services',
				'type'     => 'text',
				'priority' => 40,
				'default'  => __('Our Services', 'plumbing-lite'), 
			  
			) );

			Kirki::add_field( 'plumbing-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'plumbing-lite' ),
	'section'     => 'homepage_services',
	'settings' => 'homepage_services_',
	'priority'    => 41,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('homepageservices', 'plumbing-lite' ),
	),
	'choices'     => array(
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'plumbing-lite' ),

	
	'fields' => array(
		'service_image'  => array(
				'type' => 'image',
				'settings'    => 'service_image_setting_array',
				'label'       => esc_attr__( 'Service Image', 'plumbing-lite' ),
				'section'     => 'homepage_services',
				'priority'    => 42,
				'default'  => '',
				
			),	
		'service_name'  => array(
				'settings' => 'homepage_service_name',
				'label'    =>esc_attr__( 'Service Name', 'plumbing-lite' ),
				'description' => esc_attr__( 'This will be the label of service name field', 'plumbing-lite' ),
				'section'  => 'homepage_services',
				'type'     => 'text',
				'priority' => 43,
				'default'  => '', 
			),
		'service_description'  => array(
				'settings' => 'homepage_service_description',
				'label'    =>esc_attr__( 'Service Description', 'plumbing-lite' ),
				'description' => esc_attr__( 'This will be the label of service description', 'plumbing-lite' ),
				'section'  => 'homepage_services',
				'type'     => 'text',
				'priority' => 44,
				'default'  => '', 
			),
	)
) );	
		

/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Our Gallery Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_gallery', array(
			'title'          => __( 'Gallery Section' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page gallery section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 5,
			'capability'     => 'edit_theme_options',
		) );
		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'galleryonoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_gallery',
                'type'     => 'toggle',
                'priority' => 44,
                'default'  => 1,           
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_gallery_title',
				'label'    => __( 'Gallery Heading', 'plumbing-lite' ),
				'section'  => 'homepage_gallery',
				'type'     => 'text',
				'priority' => 45,
				'default'  => __('Our Gallery', 'plumbing-lite'), 
			));

  		Kirki::add_field( 'plumbing-lite', array(
				'type'        => 'repeater',
				'label'       => esc_attr__( 'Gallery Name', 'plumbing-lite' ),
				'section'     => 'homepage_gallery',
				'settings' => 'homepage_gallery_name',
				'priority'    => 46,
				
				'row_label' => array(
					'type' => 'text',
					'value' => esc_attr__('Gallery Name', 'plumbing-lite' ),
				),
				'choices'     => array(
							'save_as' => 'array',
							),

				'button_label' => esc_attr__('"Add new Name"', 'plumbing-lite' ),

				
				'fields' => array(
					'gallery_name'  => array(
							'type' => 'text',
							'settings'    => 'galleryname_setting_array',
							'label'       => esc_attr__( 'galleryname', 'plumbing-lite' ),
							'section'     => 'homepage_gallery',
							'priority'    => 47,
							'default'  => '',
							
						),	
				)
			) );
  	
  		
  		Kirki::add_field( 'plumbing-lite', array(
				'type'        => 'repeater',
				'label'       => esc_attr__( 'Gallery Images', 'plumbing-lite' ),
				'section'     => 'homepage_gallery',
				'settings' => 'homepage_gallery_',
				'priority'    => 48,
				
				'row_label' => array(
					'type' => 'text',
					'value' => esc_attr__('gallery', 'plumbing-lite' ),
				),
				'choices'     => array(
							'save_as' => 'array',
							),

				'button_label' => esc_attr__('"Add new image"', 'plumbing-lite' ),

				
				'fields' => array(
					'gallery_image'  => array(
							'type' => 'image',
							'settings'    => 'galleryimage_setting_array',
							'label'       => esc_attr__( 'galleryimages', 'plumbing-lite' ),
							'section'     => 'homepage_gallery',
							'priority'    => 49,
							'default'  => '',
							
						),	
				)
			) );



/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Achievements Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_achievments', array(
			'title'          => __( 'Achievements Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page achievments section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 6,
			'capability'     => 'edit_theme_options',
		) );
		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'achieveonoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_achievments',
                'type'     => 'toggle',
                'priority' => 50,
                'default'  => 1,           
            ) );
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_achievments_background_image',
				'label'    => __( 'Background Image', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'        => 'image',
				'priority' => 38,
				'default'  => get_template_directory_uri() . '',
			) );
			

		

  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_achievments_title',
				'label'    => __( 'Achievments Heading', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'text',
				'priority' => 51,
				'default'  => __('Our Achievments', 'plumbing-lite'), 
			));

		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepage_achieve_icon_1',
                'label'    => __( 'Icon 1', 'plumbing-lite' ),
                'section'  => 'homepage_achievments',
                'type'     => 'fontawesome',
                'priority' => 52,
                'default'  => 'fa fa-connectdevelop',
             
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_achievments_title1',
				'label'    => __( 'Achievments Figure 1', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'text',
				'priority' => 53,
				'default'  => __('800', 'plumbing-lite'), 
			));

			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage__achievmentstext1',
				'label'    => __( 'Achievment Description 1', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'textarea',
				'priority' => 54,
				'default'  => 'Project completed', 
			 
			) );

		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepage_achieve_icon_2',
                'label'    => __( 'Icon 2', 'plumbing-lite' ),
                'section'  => 'homepage_achievments',
                'type'     => 'fontawesome',
                'priority' => 55,
                'default'  => 'fa fa-home',
             
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'hhomepage_achievments_title2',
				'label'    => __( 'Achievments Figure 2', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'text',
				'priority' => 56,
				'default'  => __('230', 'plumbing-lite'), 
			));

			
			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage__achievmentstext2',
				'label'    => __( 'Achievment Description 2', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'textarea',
				'priority' => 57,
				'default'  => 'House renovations', 
			 
			) );

		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepage_achieve_icon_3',
                'label'    => __( 'Icon 3', 'plumbing-lite' ),
                'section'  => 'homepage_achievments',
                'type'     => 'fontawesome',
                'priority' => 58,
                'default'  => 'fa fa-child',
             
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'hhomepage_achievments_title3',
				'label'    => __( 'Achievments Figure 3', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'text',
				'priority' => 59,
				'default'  => __('1390', 'plumbing-lite'), 
			));

			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage__achievmentstext3',
				'label'    => __( 'Achievment Description 3', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'textarea',
				'priority' => 60,
				'default'  => 'Workers Emloyed', 
			 
			) );

		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'homepage_achieve_icon_4',
                'label'    => __( 'Icon 4', 'plumbing-lite' ),
                'section'  => 'homepage_achievments',
                'type'     => 'fontawesome',
                'priority' => 60,
                'default'  => 'fa fa-trophy',
             
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'hhomepage_achievments_title4',
				'label'    => __( 'Achievments Figure 4', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'text',
				'priority' => 61,
				'default'  => __('125', 'plumbing-lite'), 
			));
			Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage__achievmentstext4',
				'label'    => __( 'Achievment Description 4', 'plumbing-lite' ),
				'section'  => 'homepage_achievments',
				'type'     => 'textarea',
				'priority' => 62,
				'default'  => 'Awards Won', 
			 
			) );


  /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page testimonial Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
	Kirki::add_section( 'homepage_testimonial', array(
			'title'          => __( 'Testimonial Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page Testimonial section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 9,
			'capability'     => 'edit_theme_options',
		) );
	Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'testimonialsonoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_testimonial',
                'type'     => 'toggle',
                'priority' => 63,
                'default'  => 1,           
            ) );
	Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_testimonial_title',
				'label'    => __( 'Testimonial Heading', 'plumbing-lite' ),
				'section'  => 'homepage_testimonial',
				'type'     => 'text',
				'priority' => 64,
				'default'  => __('Testimonials', 'plumbing-lite'), 
			  
			) );

	


/*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Featured Work Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_featured', array(
			'title'          => __( 'Featured Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page featured work section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 8,
			'capability'     => 'edit_theme_options',
		) );
		Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'workonoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_featured',
                'type'     => 'toggle',
                'priority' => 65,
                'default'  => 1,           
            ) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_featured_title',
				'label'    => __( 'Featured Heading', 'plumbing-lite' ),
				'section'  => 'homepage_featured',
				'type'     => 'text',
				'priority' => 66,
				'default'  => __('Our Featured Work', 'plumbing-lite'), 
			));

  			Kirki::add_field( 'plumbing-lite', array(
	'type'        => 'repeater',
	'label'       => esc_attr__( 'Repeater Control', 'plumbing-lite' ),
	'section'     => 'homepage_featured',
	'settings' => 'homepage_work_',
	'priority'    => 67,
	
	'row_label' => array(
		'type' => 'text',
		'value' => esc_attr__('Work', 'plumbing-lite' ),
	),
	'choices'     => array(
				'save_as' => 'array',
				),

	'button_label' => esc_attr__('"Add new"', 'plumbing-lite' ),

	
	'fields' => array(
		'work_image'  => array(
				'type' => 'image',
				'settings'    => 'work_image_setting_array',
				'label'       => esc_attr__( 'Work Image', 'plumbing-lite' ),
				'section'     => 'homepage_featured',
				'priority' => 68,
				'default'  => '',
				
			),	
		'work_field'  => array(
				'settings' => 'work_text',
				'label'    =>esc_attr__( 'Work Field', 'plumbing-lite' ),
				'description' => esc_attr__( 'This will be the label of work field', 'plumbing-lite' ),
				'section'  => 'homepage_featured',
				'type'     => 'text',
				'priority' => 69,
				'default'  => '', 
			),
		'work_link'  => array(
				'settings' => 'work_text',
				'label'    =>esc_attr__( 'Project Link', 'plumbing-lite' ),
				'description' => esc_attr__( 'This will be the project link', 'plumbing-lite' ),
				'section'  => 'homepage_featured',
				'type'     => 'text',
				'priority' => 70,
				'default'  => '#', 
			),
		'work_button'  => array(
				'settings' => 'work_button',
				'label'    =>esc_attr__( 'Work Button', 'plumbing-lite' ),
				'description' => esc_attr__( 'This will be the label of button', 'plumbing-lite' ),
				'section'  => 'homepage_featured',
				'type'     => 'text',
				'priority' => 71,
				'default'  => 'View Project', 
			),
	)
) );
Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'repeater',
			'label'       => esc_attr__( 'Pop Up Modal Content', 'plumbing-lite' ),
			'section'     => 'homepage_featured',
			'settings' => 'homepage_work_Module',
			'priority'    => 72,
			
			'row_label' => array(
				'type' => 'text',
				'value' => esc_attr__('Work', 'plumbing-lite' ),
			),
			'choices'     => array(
						'save_as' => 'array',
						),

			'button_label' => esc_attr__('"Add new Modal"', 'plumbing-lite' ),

			
			'fields' => array(

				'module_name'  => array(
						'settings' => 'work_text',
						'label'    =>esc_attr__( 'Modal Name', 'plumbing-lite' ),
						'description' => esc_attr__( 'This will be the label of Module Name', 'plumbing-lite' ),
						'section'  => 'homepage_featured',
						'type'     => 'text',
						'priority' => 73,
						'default'  => '', 
					),

				'module_text'  => array(
						'settings' => 'module_text',
						'label'    =>esc_attr__( 'Modal Content', 'plumbing-lite' ),
						'description' => esc_attr__( 'This will be the module content', 'plumbing-lite' ),
						'section'  => 'homepage_featured',
						'type'     => 'textarea',
						'priority' => 74,
						'default'  => '', 
					),
				'close_button'  => array(
						'settings' => 'close_button',
						'label'    =>esc_attr__( 'Close Button', 'plumbing-lite' ),
						'description' => esc_attr__( 'This will be the label of button', 'plumbing-lite' ),
						'section'  => 'homepage_featured',
						'type'     => 'text',
						'priority' => 75,
						'default'  => 'Close', 
					),
				)
		) );

			 /*--------------------------------------------------------------------------
	         --------------------------------------------------------------------------
				Blog page	
	           --------------------------------------------------------------------------
	         --------------------------------------------------------------------------*/
				Kirki::add_section( 'blog_page', array(
						'title'          => __( 'Blog Heading' , 'plumbing-lite' ),
						'description'    => __( 'From here you can manage Home Page Partners section' , 'plumbing-lite' ),
						'panel'          => 'homepage', 
						'priority'       => 10,
						'capability'     => 'edit_theme_options',
					) );


				Kirki::add_field( 'plumbing-lite', array(
						'settings' => 'homepage_blog_title',
						'label'    => __( 'Blog Heading', 'plumbing-lite' ),
						'section'  => 'blog_page',
						'type'     => 'text',
						'priority' => 76,
						'default'  => __('Our Partners', 'plumbing-lite'), 
					  
							) );
		 /*--------------------------------------------------------------------------
			  --------------------------------------------------------------------------
						Home Page Partners Section	
			--------------------------------------------------------------------------
			--------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_partners', array(
			'title'          => __( 'Partners Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page Partners section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 8,
			'capability'     => 'edit_theme_options',
		) );

	   Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'partneronoff',
                'label'    => __( 'Section ON/OFF', 'plumbing-lite' ),
                'section'  => 'homepage_partners',
                'type'     => 'toggle',
                'priority' => 77,
                'default'  => 1,           
            ) );

  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_partners_title',
				'label'    => __( 'Partners Heading', 'plumbing-lite' ),
				'section'  => 'homepage_partners',
				'type'     => 'text',
				'priority' => 78,
				'default'  => __('Our Partners', 'plumbing-lite'), 
			  
			) );

	
 	 /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Booknow Section	
	 --------------------------------------------------------------------------
	 --------------------------------------------------------------------------*/
			
		Kirki::add_section( 'homepage_booknow', array(
			'title'          => __( ' Call To Action' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page Booknow section' , 'plumbing-lite' ),
			'panel'          => 'homepage', 
			'priority'       => 10,
			'capability'     => 'edit_theme_options',
		) );
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_booknow_text1',
				'label'    => __( 'Call To Action Tag Line ', 'plumbing-lite' ),
				'section'  => 'homepage_booknow',
				'type'     => 'textarea',
				'priority' => 79,
				'default'  => 'Book now if you need build your dream house.', 
			 
			) );
		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_booknow_text2',
				'label'    => __( 'Call To Action Description', 'plumbing-lite' ),
				'section'  => 'homepage_booknow',
				'type'     => 'textarea',
				'priority' => 80,
				'default'  => '', 
			 
			) );

     /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page Contact Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/
			Kirki::add_panel( 'contactsection_', array(
    'priority'    => 11,
    'title'       => __( 'Contact Section Settings', 'plumbing-lite' ),
    'description' => __( 'Manage footer Contact from here', 'plumbing-lite' ),
    ) );
		Kirki::add_section( 'homepage_contact', array(
			'title'          => __( 'Contact Setting' , 'plumbing-lite' ),
			'description'    => __( 'From here you can manage Home Page Contact section' , 'plumbing-lite' ),
			'panel'          => 'contactsection_', 
			'priority'       => 10,
			'capability'     => 'edit_theme_options',
		) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_contact_title',
				'label'    => __( 'Contact Heading', 'plumbing-lite' ),
				'section'  => 'homepage_contact',
				'type'     => 'text',
				'priority' => 82,
				'default'  => __('contact us', 'plumbing-lite'), 
			  
			) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_contact_text1',
				'label'    => __( 'Contact Subheading', 'plumbing-lite' ),
				'section'  => 'homepage_contact',
				'type'     => 'textarea',
				'priority' => 83,
				'default'  => 'Fill The form', 
			 
			) );

  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'contactform_code',
				'label'    => __( 'Contact7 Code', 'plumbing-lite' ),
				'section'  => 'homepage_contact',
				'type'     => 'text',
				'priority' => 84,
				'default'  => 'Copy the contact7 code here to display a contact form.', 
			 
			) );
  		Kirki::add_field( 'plumbing-lite', array(
				'settings' => 'homepage_contact_text3',
				'label'    => __( 'Contact Address', 'plumbing-lite' ),
				'section'  => 'homepage_contact',
				'type'     => 'textarea',
				'priority' => 85,
				'default'  => '366 William Street, Lutherville Timonium, MD 21093', 
			 
			) );

  		/*------------------------------------------
		Google Map Section	
  	------------------------------------------*/
	

	Kirki::add_section( 'homepage_googlemap', array(
		'title'          => __( 'Google Map Settings', 'plumbing-lite' ),
		'description'    => __( 'From here you can manage Google Map', 'plumbing-lite' ),
		'panel'          => 'contactsection_', 
		'priority'       => 11,
		'capability'     => 'edit_theme_options',
		'theme_supports' => '', // Rarely needed.
	) );
 	
	/*------------------------------------------
		Add Fields to Google Map Section
	------------------------------------------*/
	 	
		// Switch
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'switch',
			'settings'    => 'google_map_active',
			'label'       => __( 'Google Map Active', 'plumbing-lite' ),
			'description' => __( 'You Can On/Off Google Map from here', 'plumbing-lite' ),
			'section'     => 'homepage_googlemap',
			'default'     => '1',
			'priority'    => 12,
		) );

		// Help
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'custom',
			'settings'    => 'latlong_help',
			'default'     => '<strong>You Can find your Latitude and Long from here <a target="_blank" href="http://www.latlong.net/">http://www.latlong.net/</a> <br/> <br/> You need to get an Google map Api key in order to use map. You can get one from <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" > here </a> <strong>',
			'section'     => 'homepage_googlemap',
			'priority'    => 86,
		) );
		
		// Lat
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'text',
			'settings'    => 'map_key',
			'description'    => __( 'You need to get an Google map Api key in order to use map.', 'plumbing-lite' ),
			'label'       => __( 'Your Google Map Key', 'plumbing-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 87,
			'default' 	  => ''
		) );
					
		// Lat
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'text',
			'settings'    => 'map_lat',
			'label'       => __( 'Your Latitude', 'plumbing-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 88,
			'default' 	  => 27.175015
		) );
		
		// Long
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'text',
			'settings'    => 'map_long',
			'label'       => __( 'Your Longitude', 'plumbing-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 89,
			'default' 	  => 78.042155
		) );
						

		// Long
		Kirki::add_field( 'plumbing-lite', array(
			'type'        => 'number',
			'settings'    => 'map_zoom',
			'label'       => __( 'Map Zoom', 'plumbing-lite' ),
			'section'     => 'homepage_googlemap',
			'priority'    => 90,
			'default' 	  => 12,
			'choices'     => array(
				'min'  => 0,
				'max'  => 30,
				'step' => 1,
			),
		) );


    /*--------------------------------------------------------------------------
	  --------------------------------------------------------------------------
				Home Page footer social link Section	
	--------------------------------------------------------------------------
	--------------------------------------------------------------------------*/

  		Kirki::add_panel( 'homepage_social_setting', array(
    'priority'    => 6,
    'title'       => __( 'Social Settings', 'plumbing-lite' ),
    'description' => __( 'Manage footer Setting from here', 'plumbing-lite' ),
) );

Kirki::add_section( 'Social_link', array(
        'title'          => __( 'Social Link Setting', 'plumbing-lite' ),
        'description'    => __( 'From here you can manage social link section', 'plumbing-lite' ),
        'panel'          => 'homepage_social_setting', 
        'priority'       => 91,
        'capability'     => 'edit_theme_options',
        'theme_supports' => '', // Rarely needed.
    ) );

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'rss_link',
                'label'    => __( 'RSS Link', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'textarea',
                'priority' => 92,
                'default'  => '#', 
            ) );

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'facebook_link',
                'label'    => __( 'Facebook Link', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'text',
                'priority' => 93,
                'default'  => '#', 
            ) );
			
Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'twitterlink',
                'label'    => __( 'Twitter Link', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'text',
                'priority' => 94,
                'default'  => '#', 
            ) );
			
Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'googlelink',
                'label'    => __( 'Google Link', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'text',
                'priority' => 95,
                'default'  => '#', 
            ) ); 
			
			
Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'linkedin_link',
                'label'    => __( 'Linkedin Link', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'text',
                'priority' => 96,
                'default'  => '#', 
            ) ); 

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'rss_link_on_off',
                'label'    => __( 'RSS Icon: ON/OFF', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'toggle',
                'priority' => 97,
                'default'  => 1,           
            ) );

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'facebook_link_on_off',
                'label'    => __( 'Facebook Icon: ON/OFF', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'toggle',
                'priority' => 98,
                'default'  => 1,           
            ) );	
			
			
Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'twitter_link_on_off',
                'label'    => __( 'Twitter Icon: ON/OFF', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'toggle',
                'priority' => 99,
                'default'  => 1,           
            ) );

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'google_link_on_off',
                'label'    => __( 'Google Icon: ON/OFF', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'toggle',
                'priority' => 100,
                'default'  => 1,           
            ) );

Kirki::add_field( 'plumbing-lite', array(
                'settings' => 'linkedin_link_on_off',
                'label'    => __( 'Linkedin Icon: ON/OFF', 'plumbing-lite' ),
                'section'  => 'Social_link',
                'type'     => 'toggle',
                'priority' => 101,
                'default'  => 1,           
            ) );
		

add_action( 'customize_register', 'navthemes_move_widget_area' );
function navthemes_move_widget_area () {
  global $wp_customize;

  // sidebar-2 is your sidebar ID
  $footer_widgets_section2 = (object) $wp_customize->get_section( 'sidebar-widgets-testimonials_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section2->panel = 'homepage';
  $footer_widgets_section2->priority = 8;

 
     // sidebar-2 is your sidebar ID
  $footer_widgets_section8 = (object) $wp_customize->get_section( 'sidebar-widgets-team_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section8->panel = 'homepage';
    $footer_widgets_section8->priority = 5;

   // sidebar-2 is your sidebar ID
  $footer_widgets_section9 = (object) $wp_customize->get_section( 'sidebar-widgets-partners_widget_' );
  // general_settings - Panel ID 
  $footer_widgets_section9->panel = 'homepage';
  $footer_widgets_section9->priority = 9;
  
 // sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-services_widget_solutions' );
  // general_settings - Panel ID 
  $footer_widgets_section6->panel = 'homepage';


// sidebar-2 is your sidebar ID
  $footer_widgets_section6 = (object) $wp_customize->get_section( 'sidebar-widgets-about_widgets' );
  // general_settings - Panel ID 
  $footer_widgets_section6->panel = 'homepage';
  $footer_widgets_section6->priority = 3;
}

// add if other functions available
if(file_exists('add-on.php')) include('add-on.php');
		