<?php
/**
 * NavThemes Custom Functions
 * @version:1.0
 *
 */
 		

 /**
 * Checks if string exists in array.
 *
 * @version Plumbing-lite 1.0
 *
 * @param string $str Classes for the body element.
 * 			array $arr
 * @return Boolean.
 */

	function contains($str, array $arr)
	{
		foreach($arr as $a) {
			if (stripos($str,$a) !== false) return true;
		}
		return false;
	}
	

 /**
 * Set up post entry meta..
 *
 * @version Plumbing-lite 1.0
 *
 */
   
   if ( ! function_exists( 'navthemes_entry_meta' ) ) :
 
	function navthemes_entry_meta() {
	
	// Translators: used between list items, there is a space after the comma.
	$categories_list = get_the_category_list() ? '<span class="category" itemprop="articleSection"><i class="fa fa-bookmark"></i>'. get_the_category_list( __( ', ', 'navthemes' ) ) . "</span>" : '' ;
  

	$date = sprintf( '<span class="date"><i class="fa fa-clock-o"></i> <a href="%1$s" title="%2$s" rel="bookmark"><time itemprop="datePublished" datetime="%3$s">%4$s</time></a></span>',
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() )
	);

	$author = sprintf( '<span itemprop="author"><i class="fa fa-user"></i> <span class="author"><a href="%1$s" title="%2$s" rel="">%3$s</a></span></span>',
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_attr( sprintf( __( 'View all posts by %s', 'navthemes' ), get_the_author() ) ),
		get_the_author()
	);
	
	$comment_number = get_comments_number();
	$comment_number = sprintf( _n( '1 Comment', '%s Comments', $comment_number, 'navthemes' ), $comment_number );
	$comment_number =  sprintf( ' <span class="comments" itemprop="interactionCount"> <i class="fa fa-comment"></i><a href="%1$s" title="%2$s" rel="comments">%2$s</a></span>',
		get_comments_link(),
		$comment_number
	);

  
  	// Translators: used between list items, there is a space after the comma.
	$tag_list = '<span class="tags"> <i class="fa fa-tags"></i> '. get_the_tag_list( '', __( ', ', 'navthemes' ) ). '</span>';

	$utility_text = __( ' %1$s %3$s %4$s %5$s %2$s ', 'navthemes' );	

	// echo $utility_text;

  	// Translators: 1 is category, 2 is tag, 3 is the date, 4 is the author's name and 5 is comments.
	echo $categories_list ;
	echo $date ;
	echo $author ;
	echo $comment_number ;
	echo $tag_list ;
 }

endif;
 

	/* ----------------------------------------------------------------------------------- */
	/* Add Footer
	/* ----------------------------------------------------------------------------------- */

	function navthemes_footer(){
				echo '<div class="top_btn">
					  <a class="cd-top" href="#0"></a>
								</div>';
				
	}
	
	add_action('wp_footer','navthemes_footer');
	

	/* ----------------------------------------------------------------------------------- */
	/* Pagination
	/* ----------------------------------------------------------------------------------- */
	
	function navthemes_number_post_nav() {

		 if( is_singular() )
       	 return;

		global $wp_query;
	
		/** Stop execution if there's only 1 page */
		if( $wp_query->max_num_pages <= 1 )
			return;
	
		$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
		$max   = intval( $wp_query->max_num_pages );
	
		/**	Add current page to the array */
		if ( $paged >= 1 )
			$links[] = $paged;
	
		/**	Add the pages around the current page to the array */
		if ( $paged >= 3 ) {
			$links[] = $paged - 1;
			$links[] = $paged - 2;
		}
	
		if ( ( $paged + 2 ) <= $max ) {
			$links[] = $paged + 2;
			$links[] = $paged + 1;
		}
	
		echo '<div class="text-center"><ul class="pagination">' . "\n";
	
		/**	Previous Post Link */
		if ( get_previous_posts_link() )
			printf( '<li>%s</li>' . "\n", get_previous_posts_link() );
	
		/**	Link to first page, plus ellipses if necessary */
		if ( ! in_array( 1, $links ) ) {
			$class = 1 == $paged ? ' class="active"' : '';
	
			printf( '<li><a href="%s" %s>%s</a></li>' . "\n", esc_url( get_pagenum_link( 1 ) ), $class, '1' );
		}
	
		/**	Link to current page, plus 2 pages in either direction if necessary */
		sort( $links );
		foreach ( (array) $links as $link ) {
			$class = $paged == $link ? ' class="active"' : '';
			printf( '<li><a href="%s" %s>%s</a></li>' . "\n", esc_url( get_pagenum_link( $link ) ), $class, $link );
		}
	
		/**	Link to last page, plus ellipses if necessary */
		if ( ! in_array( $max, $links ) ) {
			$class = $paged == $max ? ' class="active"' : '';
			printf( '<li><a href="%s" %s>%s</a></li>' . "\n", esc_url( get_pagenum_link( $max ) ), $class, $max );
		}
	
		/**	Next Post Link */
		if ( get_next_posts_link() )
			printf( '<li>%s</li>' . "\n", get_next_posts_link() );
	
		echo '</ul></div>' . "\n";

		}

	/**
	 * Get Words from a string.
	 *
	 * @version Plumbing-lite 1.0
	 *
	 * @param string $content 
	 * 		  integer $word_count
	 *		  string $suffix=''
	 */
	
	function navthemes_get_words($content,$word_count=10,$suffix=''){
		$pieces = explode(" ", $content);
		echo $first_part = implode(" ", array_splice($pieces, 0, $word_count)) . $suffix ;
		
	}
 
 	
	if ( ! function_exists( 'navthemes_post_thumbnail' ) ) :
	/**
	 * Display an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 *
	 */
	function navthemes_post_thumbnail($image = null ) {
		if ( post_password_required() || is_attachment() ) {
			return;
		}
		
	  if(has_post_thumbnail()):		
		
		if ( is_singular() && $image == null) :
		?>
	
		<div class="post-thumbnail">
			<?php the_post_thumbnail( 'large'); ?>
		</div>

		<!-- .post-thumbnail -->
			
		<?php elseif ($image != null) : ?>
        	
		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
			<?php
				the_post_thumbnail( $image , array( 'alt' => get_the_title() ) );
			?>
		</a>
            
        <?php else : ?>
	
		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
			<?php
				the_post_thumbnail( 'post-thumbnail', array( 'alt' => get_the_title() ) );
			?>
		</a>
	
		<?php endif; // End is_singular()
	    
          endif; // !has post thumbnails	
		}
	endif;
	
	
	function navthemes_post_thumbnails_cond($image){
		if ( has_post_thumbnail() ) {
			the_post_thumbnail($image);
		}
		else {
			echo '<img src="' . get_template_directory_uri() . '/images/no-image.jpg" />';
		}
	}

	/**
	 * Get post thumbnails source.
	 *
	 * @version Plumbing-lite 1.0
	 *
	 * @param string $image 
	 * @return array $url
	 */

	function navthemes_post_thumbnails_cond_src($image){
		global $post;
		if ( has_post_thumbnail() ) {
			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), $image );
		 	return $url = $thumb['0']; 
		}
	}
 
 	 /**
	 * MENU.
	 *
	 * @version Plumbing-lite 1.0
	 *
	 * @param  $item_output,$item ,$depth,$args
	 * @return array $item_output
	 */

 function navthemes_nav_description( $item_output, $item, $depth, $args ) {
 //	print_r($item_output);
$item_output = str_replace( '>' . $args->link_before . $item->title, ' itemprop="url" >' . $args->link_before. '<span itemprop="name">' . $item->title . '</span>', $item_output );
	
	return $item_output;
}

add_filter( 'walker_nav_menu_start_el', 'navthemes_nav_description', 10, 4 );

    
function navthemes_filter_front_page_template( $template ) {
    return is_home() ? '' : $template;
}
add_filter( 'frontpage_template', 'navthemes_filter_front_page_template' );

