<?php
/**
 * This file is responsible for the rendering of the header of the theme.
 * @version:1.0
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0"/>
    <?php
    
    wp_head();
    ?>
</head>
<body <?php body_class(); ?>">

<!-- Header_Area -->
 <?php if ( true == get_theme_mod( 'floatmenu', true ) ) : ?>
      <nav class="navbar navbar-default header_aera affix-top" id="main_navbar">
         <?php elseif(false == get_theme_mod( 'floatmenu', false)): ?>
          <nav  id="navbarstatic" class="navbar navbar-default header_aera" id="main_navbar">
            <?php endif; ?>
         <div class="container">
            <!-- End searchForm -->
            <!-- Brand and toggle get grouped for better mobile display -->
            <div class="col-md-4 p0">
               <div class="navbar-header">
                  <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#min_navbar">
                  <span class="sr-only"><?php _e('Toggle navigation', 'plumbing-lite'); ?></span>
                  <span class="icon-bar"></span>
                  <span class="icon-bar"></span>
                  <span class="icon-bar"></span>
                  </button>
                  <!-- Site logo -->
                  <a class="navbar-brand logo-quick" href="<?php echo site_url(); ?>"> 
                    <?php if(get_theme_mod('logo')){ 
                      $logo= (get_theme_mod('logo'));  
                    ?> 
                      <img height="50"  alt="<?php bloginfo('name'); ?>" src="<?php echo $logo; ?>">
                    <?php } else { bloginfo('name'); } ?>
                  </a>
               </div>
            </div>
            <!-- Collect the nav links, forms, and other content for toggling -->
            <?php
            $layout = maybe_unserialize( get_theme_mod( 'onepage_modules', array('services', 'team' , 'gallery', 'testimonials', 'work', 'blog') ) );  
          
          $menu_args = array(
                        'menu' => get_theme_mod('nav_menu_name'),
                        'container' => false,
                        'items_wrap'=> '%3$s',
                        'fallback_cb'    => '__return_false',
                       );

            $modules = array( 
    
                  'services' =>array(
                    'show' => get_theme_mod('showin_menu_welcome', 1), 
                    'text' => get_theme_mod('welcome_menu_title', 'Services'),
                    'link' => '#services'
                  ), 
                  
                  'team' =>array(
                    'show' => get_theme_mod('showin_menu_pages', 1), 
                    'text' => get_theme_mod('pages_menu_title', 'Team'),
                    'link' => '#team'
                  ), 
   
                  'gallery' =>array(
                    'show' => get_theme_mod('showin_menu_portfolio', 1), 
                    'text' => get_theme_mod('portfolio_menu_title', 'Gallery'),
                    'link' => '#gallery'
                  ), 
                  
                  'testimonials' =>array(
                    'show' => get_theme_mod('showin_menu_team', 1), 
                    'text' => get_theme_mod('team_menu_title', 'Testimonials'),
                    'link' => '#testimonials'
                  ),
    
                  'work' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Work'), 
                    'link' => '#works'
                  ),

                  'blog' =>array(
                    'show' => get_theme_mod('showin_menu_statistics', 1), 
                    'text' => get_theme_mod('statistics_menu_title', 'Blog'), 
                    'link' => '#blog'
                  ),
            );
          ?>
            <div class="col-md-8 p0">
               <div class="collapse navbar-collapse" id="min_navbar">
                  <ul itemscope itemtype="https://schema.org/SiteNavigationElement" class="nav navbar-nav navbar-right">

                    <?php  if(get_option('show_on_front')=='posts'): 
 
                          //check menu is empty or not
                          if ( get_theme_mod('nav_menu_name') )
                            {
                               wp_nav_menu( $menu_args );

                            }
                            else{
                             if (current_user_can('update_core')) : echo ( sprintf('<h5 class="menuwarning">Menu Doesn\'t exists, please set a <a href="%s"> menu. </a></h5>', site_url().'/wp-admin/nav-menus.php') ); endif;
                          }

                        
                      else: 
                      // lets show one page menus     

                  if (get_theme_mod('nav_menu_position') == 'before') {
                    if (get_theme_mod('nav_menu_name') != 'none') {
                        
                        wp_nav_menu( $menu_args );
                   
                    
                    }
                  }

                  if(get_theme_mod('onepagemenuonoff')):

                  if ( ! empty( $layout ) ) : 
                ?>
                <?php
                  foreach ($layout as $checked_value) {
                  if( array_key_exists ($checked_value,$modules) ){
                  if ($modules[$checked_value]['show']) {
                ?>
                     <li class="dropdown submenu">
                        <a itemprop="url" class="dropdown-toggle  js-scroll-trigger" href="<?php echo (!is_front_page() ? get_site_url().'/' : '') . $modules[$checked_value]['link']; ?>">
                      <span itemprop="name"><?php echo $modules[$checked_value]['text']; ?></span>
                </a>
              </li>
                <?php
                      }
                    }
                  } 
                ?>
                <?php 
                    endif; // if not empty sorter
                  endif; // if one page switch

                  if (get_theme_mod('nav_menu_position') == 'after') {
                    if (get_theme_mod('nav_menu_name') != 'none') {
                            wp_nav_menu( $menu_args );
                    }
                  }
                ?>
                     </li>
                   <li class="dropdown submenu">
                 <a href="#Contacts" class="dropdown-toggle  js-scroll-trigger" data-toggle="dropdown"><?php _e('Contact', 'plumbing-lite'); ?></a>
              </li> 
              
              <?php endif; ?>

                  </ul>

               </div>
               <!-- /.navbar-collapse -->
            </div>
         </div>
         <!-- /.container -->
      </nav>
      <!-- End Header_Area -->